/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.dagger;

import android.content.Context;
import android.location.LocationManager;
import com.stripe.jvmcore.dagger.ForApplication;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.introspection.LocationServicesValidator;
import com.stripe.stripeterminal.internal.common.validators.PermissionsValidator;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lcom/stripe/stripeterminal/dagger/PermissionsModule;", "", "()V", "provideLocationServicesValidator", "Lcom/stripe/stripeterminal/internal/common/introspection/LocationServicesValidator;", "context", "Landroid/content/Context;", "providePermissionsValidator", "Lcom/stripe/stripeterminal/internal/common/validators/PermissionsValidator;", "core_publish"})
public final class PermissionsModule {
    @Provides
    @Singleton
    @NotNull
    public final LocationServicesValidator provideLocationServicesValidator(@ForApplication @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new LocationServicesValidator(context){
            @Nullable
            private final LocationManager locationManager;
            {
                this.locationManager = (LocationManager)$context.getSystemService("location");
            }

            public void validateLocationServices() {
                LocationManager locationManager = this.locationManager;
                if (locationManager != null) {
                    LocationManager it = locationManager;
                    boolean bl = false;
                    if (it.isProviderEnabled("gps") || it.isProviderEnabled("network")) {
                        return;
                    }
                }
                throw new TerminalException(TerminalException.TerminalErrorCode.LOCATION_SERVICES_DISABLED, "Location services must be enabled to use Terminal", null, null, 12, null);
            }
        };
    }

    @Provides
    @NotNull
    public final PermissionsValidator providePermissionsValidator(@ForApplication @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new PermissionsValidator(context);
    }
}

