/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.external.models;

import com.stripe.stripeterminal.external.InternalApi;
import com.stripe.stripeterminal.external.models.EmvBlob;
import com.stripe.stripeterminal.external.models.RoutingPriority;
import com.stripe.stripeterminal.external.models.SimulatedCardType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B'\b\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J\u000e\u0010\u0017\u001a\u00020\u0006H\u00c0\u0003\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\fH\u00c0\u0003\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\fH\u00c0\u0003\u00a2\u0006\u0002\b\u001cJ1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\u001e\u0010\u001e\u001a\u00020\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0007J\u0013\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\fH\u00d6\u0001J\t\u0010'\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\r\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\n\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lcom/stripe/stripeterminal/external/models/SimulatedCard;", "", "cardType", "Lcom/stripe/stripeterminal/external/models/SimulatedCardType;", "(Lcom/stripe/stripeterminal/external/models/SimulatedCardType;)V", "testCardNumber", "", "(Ljava/lang/String;)V", "emvBlob", "Lcom/stripe/stripeterminal/external/models/EmvBlob;", "pan", "expMonth", "", "expYear", "(Lcom/stripe/stripeterminal/external/models/EmvBlob;Ljava/lang/String;II)V", "getEmvBlob", "()Lcom/stripe/stripeterminal/external/models/EmvBlob;", "getExpMonth$external_publish", "()I", "getExpYear$external_publish", "getPan$external_publish", "()Ljava/lang/String;", "component1", "component2", "component2$external_publish", "component3", "component3$external_publish", "component4", "component4$external_publish", "copy", "emvForSimulatedCard", "computedPriority", "", "Lcom/stripe/stripeterminal/external/models/RoutingPriority;", "isScaRecollection", "", "equals", "other", "hashCode", "toString", "external_publish"})
public final class SimulatedCard {
    @NotNull
    private final EmvBlob emvBlob;
    @NotNull
    private final String pan;
    private final int expMonth;
    private final int expYear;

    public SimulatedCard(@NotNull EmvBlob emvBlob, @NotNull String pan, int expMonth, int expYear) {
        Intrinsics.checkNotNullParameter((Object)emvBlob, (String)"emvBlob");
        Intrinsics.checkNotNullParameter((Object)pan, (String)"pan");
        this.emvBlob = emvBlob;
        this.pan = pan;
        this.expMonth = expMonth;
        this.expYear = expYear;
    }

    @NotNull
    public final EmvBlob getEmvBlob() {
        return this.emvBlob;
    }

    @NotNull
    public final String getPan$external_publish() {
        return this.pan;
    }

    public final int getExpMonth$external_publish() {
        return this.expMonth;
    }

    public final int getExpYear$external_publish() {
        return this.expYear;
    }

    public SimulatedCard(@NotNull SimulatedCardType cardType) {
        Intrinsics.checkNotNullParameter((Object)((Object)cardType), (String)"cardType");
        this(EmvBlob.Companion.fromCardType(cardType), cardType.getCardNumber(), cardType.getExpMonth(), cardType.getExpYear());
    }

    public SimulatedCard(@NotNull String testCardNumber) {
        Intrinsics.checkNotNullParameter((Object)testCardNumber, (String)"testCardNumber");
        this(EmvBlob.Companion.fromTestCardNumber(testCardNumber), testCardNumber, 12, 30);
    }

    @InternalApi
    @NotNull
    public final EmvBlob emvForSimulatedCard(@NotNull List<? extends RoutingPriority> computedPriority, boolean isScaRecollection) {
        Intrinsics.checkNotNullParameter(computedPriority, (String)"computedPriority");
        return EmvBlob.Companion.generateEmvData$external_publish(this.pan, this.expMonth, this.expYear, computedPriority, isScaRecollection);
    }

    @NotNull
    public final EmvBlob component1() {
        return this.emvBlob;
    }

    @NotNull
    public final String component2$external_publish() {
        return this.pan;
    }

    public final int component3$external_publish() {
        return this.expMonth;
    }

    public final int component4$external_publish() {
        return this.expYear;
    }

    @NotNull
    public final SimulatedCard copy(@NotNull EmvBlob emvBlob, @NotNull String pan, int expMonth, int expYear) {
        Intrinsics.checkNotNullParameter((Object)emvBlob, (String)"emvBlob");
        Intrinsics.checkNotNullParameter((Object)pan, (String)"pan");
        return new SimulatedCard(emvBlob, pan, expMonth, expYear);
    }

    public static /* synthetic */ SimulatedCard copy$default(SimulatedCard simulatedCard, EmvBlob emvBlob, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            emvBlob = simulatedCard.emvBlob;
        }
        if ((n3 & 2) != 0) {
            string = simulatedCard.pan;
        }
        if ((n3 & 4) != 0) {
            n = simulatedCard.expMonth;
        }
        if ((n3 & 8) != 0) {
            n2 = simulatedCard.expYear;
        }
        return simulatedCard.copy(emvBlob, string, n, n2);
    }

    @NotNull
    public String toString() {
        return "SimulatedCard(emvBlob=" + this.emvBlob + ", pan=" + this.pan + ", expMonth=" + this.expMonth + ", expYear=" + this.expYear + ')';
    }

    public int hashCode() {
        int result = this.emvBlob.hashCode();
        result = result * 31 + this.pan.hashCode();
        result = result * 31 + Integer.hashCode(this.expMonth);
        result = result * 31 + Integer.hashCode(this.expYear);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimulatedCard)) {
            return false;
        }
        SimulatedCard simulatedCard = (SimulatedCard)other;
        if (!Intrinsics.areEqual((Object)this.emvBlob, (Object)simulatedCard.emvBlob)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pan, (Object)simulatedCard.pan)) {
            return false;
        }
        if (this.expMonth != simulatedCard.expMonth) {
            return false;
        }
        return this.expYear == simulatedCard.expYear;
    }
}

