/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.aidlrpc;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.stripe.core.aidlrpc.AidlRpcListener;
import com.stripe.core.aidlrpc.AidlRpcUpdateListener;

public interface AidlRpc
extends IInterface {
    public void makeRequest(byte[] var1, AidlRpcListener var2) throws RemoteException;

    public void setUpdateListener(String var1, AidlRpcUpdateListener var2) throws RemoteException;

    public void clearUpdateListener(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements AidlRpc {
        private static final String DESCRIPTOR = "com.stripe.core.aidlrpc.AidlRpc";
        static final int TRANSACTION_makeRequest = 1;
        static final int TRANSACTION_setUpdateListener = 2;
        static final int TRANSACTION_clearUpdateListener = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static AidlRpc asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof AidlRpc) {
                return (AidlRpc)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    AidlRpcListener _arg1 = AidlRpcListener.Stub.asInterface(data.readStrongBinder());
                    this.makeRequest(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    AidlRpcUpdateListener _arg1 = AidlRpcUpdateListener.Stub.asInterface(data.readStrongBinder());
                    this.setUpdateListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.clearUpdateListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(AidlRpc impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static AidlRpc getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements AidlRpc {
            private IBinder mRemote;
            public static AidlRpc sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void makeRequest(byte[] request, AidlRpcListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(request);
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().makeRequest(request, listener2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUpdateListener(String service, AidlRpcUpdateListener updateListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(service);
                    _data.writeStrongBinder(updateListener != null ? updateListener.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setUpdateListener(service, updateListener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearUpdateListener(String service) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(service);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearUpdateListener(service);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements AidlRpc {
        @Override
        public void makeRequest(byte[] request, AidlRpcListener listener2) throws RemoteException {
        }

        @Override
        public void setUpdateListener(String service, AidlRpcUpdateListener updateListener) throws RemoteException {
        }

        @Override
        public void clearUpdateListener(String service) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

