/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.aidlrpcclient;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import com.squareup.wire.Message;
import com.stripe.core.aidlrpc.AidlRpc;
import com.stripe.core.aidlrpc.AidlRpcErrorCode;
import com.stripe.core.aidlrpc.AidlRpcException;
import com.stripe.core.aidlrpc.AidlRpcListener;
import com.stripe.core.aidlrpc.AidlRpcUpdateListener;
import com.stripe.core.aidlrpcclient.AidlServiceConnection;
import com.stripe.jvmcore.crpcclient.CrpcClient;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.proto.model.common.DeviceInfo;
import com.stripe.proto.model.common.VersionInfoPb;
import com.stripe.proto.net.rpc.base.RpcRequest;
import com.stripe.wirecrpc.AidlWireClient;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J0\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u000e\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00102\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u000eH\u0016J\u001c\u0010#\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u000e0%H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stripe/core/aidlrpcclient/AidlRpcClient;", "Lcom/stripe/wirecrpc/AidlWireClient;", "context", "Landroid/content/Context;", "crpcRequestContextProvider", "Lcom/stripe/jvmcore/crpcclient/CrpcClient$CrpcRequestContextProvider;", "aidlServiceConnection", "Lcom/stripe/core/aidlrpcclient/AidlServiceConnection;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Landroid/content/Context;Lcom/stripe/jvmcore/crpcclient/CrpcClient$CrpcRequestContextProvider;Lcom/stripe/core/aidlrpcclient/AidlServiceConnection;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "requestId", "", "bindToService", "", "action", "", "packageName", "className", "clearUpdateListener", "service", "makeRequest", "method", "message", "Lcom/squareup/wire/Message;", "listener", "Lcom/stripe/core/aidlrpc/AidlRpcListener;", "onAidlError", "errorCode", "Lcom/stripe/core/aidlrpc/AidlRpcErrorCode;", "cause", "", "setUpdateListener", "Lcom/stripe/core/aidlrpc/AidlRpcUpdateListener;", "unbindFromService", "withAidlService", "block", "Lkotlin/Function1;", "Lcom/stripe/core/aidlrpc/AidlRpc;", "aidlrpcclient_release"})
@SourceDebugExtension(value={"SMAP\nAidlRpcClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AidlRpcClient.kt\ncom/stripe/core/aidlrpcclient/AidlRpcClient\n+ 2 Log.kt\ncom/stripe/jvmcore/logging/terminal/log/Log$Companion\n*L\n1#1,142:1\n193#2:143\n*S KotlinDebug\n*F\n+ 1 AidlRpcClient.kt\ncom/stripe/core/aidlrpcclient/AidlRpcClient\n*L\n27#1:143\n*E\n"})
public final class AidlRpcClient
implements AidlWireClient {
    @NotNull
    private final Context context;
    @NotNull
    private final CrpcClient.CrpcRequestContextProvider crpcRequestContextProvider;
    @NotNull
    private final AidlServiceConnection aidlServiceConnection;
    @NotNull
    private final Log logger;
    private long requestId;

    public AidlRpcClient(@NotNull Context context, @NotNull CrpcClient.CrpcRequestContextProvider crpcRequestContextProvider, @NotNull AidlServiceConnection aidlServiceConnection2, @NotNull Log logger2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)crpcRequestContextProvider, (String)"crpcRequestContextProvider");
        Intrinsics.checkNotNullParameter((Object)aidlServiceConnection2, (String)"aidlServiceConnection");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.context = context;
        this.crpcRequestContextProvider = crpcRequestContextProvider;
        this.aidlServiceConnection = aidlServiceConnection2;
        this.logger = logger2;
    }

    public /* synthetic */ AidlRpcClient(Context context, CrpcClient.CrpcRequestContextProvider crpcRequestContextProvider, AidlServiceConnection aidlServiceConnection2, Log log, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            Log.Companion this_$iv = Log.Companion;
            boolean $i$f$getLogger = false;
            log = this_$iv.getLogger(AidlRpcClient.class);
        }
        this(context, crpcRequestContextProvider, aidlServiceConnection2, log);
    }

    @Override
    public void bindToService(@NotNull String action, @NotNull String packageName, @NotNull String className) throws AidlRpcException {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action", (Object)action), TuplesKt.to((Object)"packageName", (Object)packageName), TuplesKt.to((Object)"className", (Object)className)};
        this.logger.d("bindToService", pairArray);
        try {
            boolean bl;
            Intent intent = new Intent(action).setClassName(packageName, className);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(action).setClassN\u2026e(packageName, className)");
            Intent serviceIntent = intent;
            boolean it = bl = this.context.bindService(serviceIntent, (ServiceConnection)this.aidlServiceConnection, 1);
            boolean bl2 = false;
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"success", (Object)it)};
            this.logger.d("Context::bindService completed", pairArray2);
            boolean success = bl;
            if (!success) {
                AidlRpcClient.onAidlError$default(this, AidlRpcErrorCode.CONNECTION_FAILURE, "Failure to connect to service " + packageName + '.' + className, null, 4, null);
            }
        }
        catch (SecurityException exception) {
            this.onAidlError(AidlRpcErrorCode.CONNECTION_FAILURE, "Failure to connect to service " + packageName + '.' + className, exception);
        }
        try {
            this.aidlServiceConnection.waitForServiceConnected();
        }
        catch (Exception e2) {
            this.onAidlError(AidlRpcErrorCode.UNEXPECTED_DISCONNECT, "Service never connected", e2);
        }
    }

    @Override
    public void unbindFromService() throws AidlRpcException {
        this.logger.d("unbindFromService", new Pair[0]);
        this.aidlServiceConnection.disconnectFromService();
        this.context.unbindService((ServiceConnection)this.aidlServiceConnection);
    }

    @Override
    public void makeRequest(@NotNull String service, @NotNull String method, @NotNull Message<?, ?> message, @NotNull AidlRpcListener listener2) throws AidlRpcException {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"service", (Object)service), TuplesKt.to((Object)"method", (Object)method), TuplesKt.to((Object)"requestId", (Object)this.requestId)};
        this.logger.d("makeRequest", pairArray);
        this.withAidlService((Function1<? super AidlRpc, Unit>)((Function1)new Function1<AidlRpc, Unit>(this, message, service, method, listener2){
            final /* synthetic */ AidlRpcClient this$0;
            final /* synthetic */ Message<?, ?> $message;
            final /* synthetic */ String $service;
            final /* synthetic */ String $method;
            final /* synthetic */ AidlRpcListener $listener;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$service = $service;
                this.$method = $method;
                this.$listener = $listener;
                super(1);
            }

            public final void invoke(@NotNull AidlRpc it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AidlRpcClient aidlRpcClient = this.this$0;
                long l2 = AidlRpcClient.access$getRequestId$p(aidlRpcClient);
                AidlRpcClient.access$setRequestId$p(aidlRpcClient, l2 + 1L);
                long l3 = l2;
                aidlRpcClient = this.$message.encodeByteString();
                String string = AidlRpcClient.access$getCrpcRequestContextProvider$p(this.this$0).getSessionToken();
                String string2 = AidlRpcClient.access$getCrpcRequestContextProvider$p(this.this$0).getLocalIp();
                DeviceInfo deviceInfo = AidlRpcClient.access$getCrpcRequestContextProvider$p(this.this$0).getDeviceInfo();
                VersionInfoPb versionInfoPb = AidlRpcClient.access$getCrpcRequestContextProvider$p(this.this$0).getVersionInfo();
                RpcRequest rpcRequest = new RpcRequest(l3, this.$service, this.$method, (ByteString)aidlRpcClient, 0L, null, string2, string, null, versionInfoPb, deviceInfo, 0L, null, 6448, null);
                it.makeRequest(rpcRequest.encode(), this.$listener);
            }
        }));
    }

    @Override
    public void setUpdateListener(@NotNull String service, @NotNull AidlRpcUpdateListener listener2) throws AidlRpcException {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.withAidlService((Function1<? super AidlRpc, Unit>)((Function1)new Function1<AidlRpc, Unit>(service, listener2){
            final /* synthetic */ String $service;
            final /* synthetic */ AidlRpcUpdateListener $listener;
            {
                this.$service = $service;
                this.$listener = $listener;
                super(1);
            }

            public final void invoke(@NotNull AidlRpc it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setUpdateListener(this.$service, this.$listener);
            }
        }));
    }

    @Override
    public void clearUpdateListener(@NotNull String service) throws AidlRpcException {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.withAidlService((Function1<? super AidlRpc, Unit>)((Function1)new Function1<AidlRpc, Unit>(service){
            final /* synthetic */ String $service;
            {
                this.$service = $service;
                super(1);
            }

            public final void invoke(@NotNull AidlRpc it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.clearUpdateListener(this.$service);
            }
        }));
    }

    private final void withAidlService(Function1<? super AidlRpc, Unit> block) throws AidlRpcException {
        block4: {
            Unit unit;
            AidlRpc aidlRpc = this.aidlServiceConnection.getAidlService$aidlrpcclient_release();
            if (aidlRpc != null) {
                AidlRpc it = aidlRpc;
                boolean bl = false;
                try {
                    block.invoke((Object)it);
                }
                catch (RemoteException e2) {
                    this.onAidlError(AidlRpcErrorCode.REQUEST_FAILURE, "Failed to send request to AIDL server", e2);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block4;
            AidlRpcClient.onAidlError$default(this, AidlRpcErrorCode.UNEXPECTED_DISCONNECT, "AIDL server is not connected", null, 4, null);
        }
    }

    private final void onAidlError(AidlRpcErrorCode errorCode, String message, Throwable cause) throws AidlRpcException {
        AidlRpcException aidlRpcException;
        AidlRpcException it = aidlRpcException = new AidlRpcException(errorCode, message, cause);
        boolean bl = false;
        this.logger.e("AIDL RPC error", it, new Pair[0]);
        throw (Throwable)aidlRpcException;
    }

    static /* synthetic */ void onAidlError$default(AidlRpcClient aidlRpcClient, AidlRpcErrorCode aidlRpcErrorCode, String string, Throwable throwable, int n2, Object object) throws AidlRpcException {
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        aidlRpcClient.onAidlError(aidlRpcErrorCode, string, throwable);
    }

    public static final /* synthetic */ long access$getRequestId$p(AidlRpcClient $this) {
        return $this.requestId;
    }

    public static final /* synthetic */ void access$setRequestId$p(AidlRpcClient $this, long l2) {
        $this.requestId = l2;
    }

    public static final /* synthetic */ CrpcClient.CrpcRequestContextProvider access$getCrpcRequestContextProvider$p(AidlRpcClient $this) {
        return $this.crpcRequestContextProvider;
    }
}

