/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.aidlrpcserver;

import android.os.RemoteException;
import com.stripe.core.aidlrpc.AidlRpcListener;
import com.stripe.core.aidlrpc.AidlRpcUpdateListener;
import com.stripe.core.aidlrpcserver.AidlRequestException;
import com.stripe.core.aidlrpcserver.AidlRpcCallbackHandler;
import com.stripe.core.aidlrpcserver.AidlRpcCallbackHandlerFactory;
import com.stripe.core.aidlrpcserver.AidlRpcRawMessageHandler;
import com.stripe.core.aidlrpcserver.AidlRpcRequestHandler;
import com.stripe.core.aidlrpcserver.AidlRpcUtils;
import com.stripe.core.aidlrpcserver.RequestHandlerObserver;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.proto.net.rpc.base.ApplicationEC;
import com.stripe.proto.net.rpc.base.RpcEC;
import com.stripe.proto.net.rpc.base.RpcRequest;
import com.stripe.proto.net.rpc.base.RpcResponse;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\"\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0019H\u0002J\u0014\u0010\u0018\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c*\u00020\u001a2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/core/aidlrpcserver/AidlRpcRawMessageHandlerImpl;", "Lcom/stripe/core/aidlrpcserver/AidlRpcRawMessageHandler;", "aidlRpcRequestHandler", "Lcom/stripe/core/aidlrpcserver/AidlRpcRequestHandler;", "callbackFactory", "Lcom/stripe/core/aidlrpcserver/AidlRpcCallbackHandlerFactory;", "observer", "Lcom/stripe/core/aidlrpcserver/RequestHandlerObserver;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Lcom/stripe/core/aidlrpcserver/AidlRpcRequestHandler;Lcom/stripe/core/aidlrpcserver/AidlRpcCallbackHandlerFactory;Lcom/stripe/core/aidlrpcserver/RequestHandlerObserver;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "clearUpdateListener", "", "callingPackageName", "", "service", "makeRequest", "request", "", "listener", "Lcom/stripe/core/aidlrpc/AidlRpcListener;", "setUpdateListener", "updateListener", "Lcom/stripe/core/aidlrpc/AidlRpcUpdateListener;", "normalize", "Lcom/stripe/proto/net/rpc/base/RpcRequest;", "Lcom/stripe/proto/net/rpc/base/RpcResponse;", "toResult", "Lcom/stripe/core/aidlrpcserver/AidlRpcRawMessageHandlerImpl$RpcProcessingResult;", "failureCause", "", "RpcProcessingResult", "aidlrpcserver_release"})
public final class AidlRpcRawMessageHandlerImpl
implements AidlRpcRawMessageHandler {
    @NotNull
    private final AidlRpcRequestHandler aidlRpcRequestHandler;
    @NotNull
    private final AidlRpcCallbackHandlerFactory callbackFactory;
    @NotNull
    private final RequestHandlerObserver observer;
    @NotNull
    private final Log logger;

    public AidlRpcRawMessageHandlerImpl(@NotNull AidlRpcRequestHandler aidlRpcRequestHandler, @NotNull AidlRpcCallbackHandlerFactory callbackFactory, @NotNull RequestHandlerObserver observer, @NotNull Log logger2) {
        Intrinsics.checkNotNullParameter((Object)aidlRpcRequestHandler, (String)"aidlRpcRequestHandler");
        Intrinsics.checkNotNullParameter((Object)callbackFactory, (String)"callbackFactory");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.aidlRpcRequestHandler = aidlRpcRequestHandler;
        this.callbackFactory = callbackFactory;
        this.observer = observer;
        this.logger = logger2;
    }

    @Override
    public void makeRequest(@Nullable String callingPackageName, @NotNull byte[] request, @NotNull AidlRpcListener listener2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        RequestHandlerObserver.Metric metric = this.observer.onReceived(callingPackageName);
        try {
            object = this.normalize((RpcRequest)((Object)RpcRequest.ADAPTER.decode(request)));
        }
        catch (Throwable t2) {
            metric.onPreProcessingFailure("deserialization");
            this.logger.e(t2);
            listener2.onComplete(new RpcResponse(0L, RpcEC.RPC_OK, ApplicationEC.INVALID_REQUEST, "Failed to parse request with error: " + t2.getMessage(), null, null, 49, null).encode());
            return;
        }
        RpcRequest rpcRequest = object;
        metric.onStart(rpcRequest);
        try {
            object = AidlRpcRawMessageHandlerImpl.toResult$default(this, this.normalize(this.aidlRpcRequestHandler.handleRequest(callingPackageName, rpcRequest), rpcRequest), null, 1, null);
        }
        catch (AidlRequestException e2) {
            this.logger.e(e2);
            object = AidlRpcRawMessageHandlerImpl.toResult$default(this, new RpcResponse(rpcRequest.id, RpcEC.RPC_OK, ApplicationEC.SERVER_ERROR, "An unexpected error has occurred: " + e2.getMessage(), null, null, 48, null), null, 1, null);
        }
        catch (Throwable t3) {
            this.logger.e(t3);
            object = this.toResult(new RpcResponse(rpcRequest.id, RpcEC.RPC_OK, ApplicationEC.SERVER_ERROR, "An unknown error has occurred: " + t3.getMessage(), null, null, 48, null), t3);
        }
        Object result2 = object;
        boolean bl = false;
        RpcProcessingResult.Failure failure = result2 instanceof RpcProcessingResult.Failure ? (RpcProcessingResult.Failure)result2 : null;
        metric.onComplete(rpcRequest, ((RpcProcessingResult)result2).getResponse(), failure != null ? failure.getCause() : null);
        result2 = object;
        boolean bl2 = false;
        try {
            listener2.onComplete(((RpcProcessingResult)result2).getResponse().encode());
        }
        catch (RemoteException e3) {
            this.logger.e(e3);
        }
        catch (Throwable t4) {
            this.logger.e(t4);
        }
    }

    @Override
    public void setUpdateListener(@Nullable String callingPackageName, @NotNull String service, @NotNull AidlRpcUpdateListener updateListener) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)updateListener, (String)"updateListener");
        try {
            AidlRpcCallbackHandler handler2 = this.callbackFactory.create(service, (Function1<? super byte[], byte[]>)((Function1)new Function1<byte[], byte[]>((Object)updateListener){

                public final byte[] invoke(byte[] p0) {
                    return ((AidlRpcUpdateListener)this.receiver).onUpdate(p0);
                }
            }));
            AidlRpcCallbackHandler observedHandler2 = new AidlRpcCallbackHandler(this, callingPackageName, handler2){
                final /* synthetic */ AidlRpcRawMessageHandlerImpl this$0;
                final /* synthetic */ String $callingPackageName;
                final /* synthetic */ AidlRpcCallbackHandler $handler;
                {
                    this.this$0 = $receiver;
                    this.$callingPackageName = $callingPackageName;
                    this.$handler = $handler;
                }

                @NotNull
                public RpcResponse handleCallback(@NotNull RpcRequest request) {
                    RpcProcessingResult rpcProcessingResult;
                    Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
                    RequestHandlerObserver.Metric metric = AidlRpcRawMessageHandlerImpl.access$getObserver$p(this.this$0).onCallbackStart(this.$callingPackageName);
                    RpcRequest normalizedRequest = AidlRpcRawMessageHandlerImpl.access$normalize(this.this$0, request);
                    metric.onStart(normalizedRequest);
                    try {
                        rpcProcessingResult = AidlRpcRawMessageHandlerImpl.toResult$default(this.this$0, AidlRpcRawMessageHandlerImpl.access$normalize(this.this$0, this.$handler.handleCallback(request), normalizedRequest), null, 1, null);
                    }
                    catch (RemoteException e2) {
                        AidlRpcRawMessageHandlerImpl.access$getLogger$p(this.this$0).e(e2);
                        rpcProcessingResult = AidlRpcRawMessageHandlerImpl.toResult$default(this.this$0, new RpcResponse(request.id, RpcEC.RPC_ERROR, null, "Failed to make AIDL request with error: " + e2.getMessage(), null, null, 52, null), null, 1, null);
                    }
                    catch (Throwable t2) {
                        AidlRpcRawMessageHandlerImpl.access$getLogger$p(this.this$0).e(t2);
                        rpcProcessingResult = AidlRpcRawMessageHandlerImpl.access$toResult(this.this$0, new RpcResponse(request.id, RpcEC.RPC_OK, ApplicationEC.SERVER_ERROR, "An unknown error has occurred: " + t2.getMessage(), null, null, 48, null), t2);
                    }
                    RpcProcessingResult it = rpcProcessingResult;
                    boolean bl = false;
                    RpcProcessingResult.Failure failure = it instanceof RpcProcessingResult.Failure ? (RpcProcessingResult.Failure)it : null;
                    metric.onComplete(normalizedRequest, it.getResponse(), failure != null ? failure.getCause() : null);
                    return rpcProcessingResult.getResponse();
                }
            };
            this.aidlRpcRequestHandler.setCallbackHandler(callingPackageName, service, observedHandler2);
        }
        catch (Exception e2) {
            this.logger.e("failed to set update listener", e2, new Pair[0]);
        }
    }

    @Override
    public void clearUpdateListener(@Nullable String callingPackageName, @NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        try {
            this.aidlRpcRequestHandler.clearCallbackHandler(callingPackageName, service);
        }
        catch (Exception e2) {
            this.logger.e("failed to clear update listener", e2, new Pair[0]);
        }
    }

    private final RpcRequest normalize(RpcRequest $this$normalize) {
        return $this$normalize.id != 0L ? $this$normalize : RpcRequest.copy$default($this$normalize, AidlRpcUtils.Companion.requestId(), null, null, null, 0L, null, null, null, null, null, null, 0L, null, 8190, null);
    }

    private final RpcResponse normalize(RpcResponse $this$normalize, RpcRequest request) {
        return $this$normalize.request_id != 0L ? $this$normalize : RpcResponse.copy$default($this$normalize, request.id, null, null, null, null, null, 62, null);
    }

    private final RpcProcessingResult toResult(RpcResponse $this$toResult, Throwable failureCause) {
        return failureCause == null ? (RpcProcessingResult)new RpcProcessingResult.Success($this$toResult) : (RpcProcessingResult)new RpcProcessingResult.Failure($this$toResult, failureCause);
    }

    static /* synthetic */ RpcProcessingResult toResult$default(AidlRpcRawMessageHandlerImpl aidlRpcRawMessageHandlerImpl, RpcResponse rpcResponse, Throwable throwable, int n2, Object object) {
        if ((n2 & 1) != 0) {
            throwable = null;
        }
        return aidlRpcRawMessageHandlerImpl.toResult(rpcResponse, throwable);
    }

    public static final /* synthetic */ RequestHandlerObserver access$getObserver$p(AidlRpcRawMessageHandlerImpl $this) {
        return $this.observer;
    }

    public static final /* synthetic */ RpcRequest access$normalize(AidlRpcRawMessageHandlerImpl $this, RpcRequest $receiver) {
        return $this.normalize($receiver);
    }

    public static final /* synthetic */ RpcResponse access$normalize(AidlRpcRawMessageHandlerImpl $this, RpcResponse $receiver, RpcRequest request) {
        return $this.normalize($receiver, request);
    }

    public static final /* synthetic */ Log access$getLogger$p(AidlRpcRawMessageHandlerImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ RpcProcessingResult access$toResult(AidlRpcRawMessageHandlerImpl $this, RpcResponse $receiver, Throwable failureCause) {
        return $this.toResult($receiver, failureCause);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/core/aidlrpcserver/AidlRpcRawMessageHandlerImpl$RpcProcessingResult;", "", "()V", "response", "Lcom/stripe/proto/net/rpc/base/RpcResponse;", "getResponse", "()Lcom/stripe/proto/net/rpc/base/RpcResponse;", "Failure", "Success", "Lcom/stripe/core/aidlrpcserver/AidlRpcRawMessageHandlerImpl$RpcProcessingResult$Failure;", "Lcom/stripe/core/aidlrpcserver/AidlRpcRawMessageHandlerImpl$RpcProcessingResult$Success;", "aidlrpcserver_release"})
    private static abstract class RpcProcessingResult {
        private RpcProcessingResult() {
        }

        @NotNull
        public abstract RpcResponse getResponse();

        public /* synthetic */ RpcProcessingResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/stripe/core/aidlrpcserver/AidlRpcRawMessageHandlerImpl$RpcProcessingResult$Failure;", "Lcom/stripe/core/aidlrpcserver/AidlRpcRawMessageHandlerImpl$RpcProcessingResult;", "response", "Lcom/stripe/proto/net/rpc/base/RpcResponse;", "cause", "", "(Lcom/stripe/proto/net/rpc/base/RpcResponse;Ljava/lang/Throwable;)V", "getCause", "()Ljava/lang/Throwable;", "getResponse", "()Lcom/stripe/proto/net/rpc/base/RpcResponse;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aidlrpcserver_release"})
        public static final class Failure
        extends RpcProcessingResult {
            @NotNull
            private final RpcResponse response;
            @NotNull
            private final Throwable cause;

            public Failure(@NotNull RpcResponse response, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)((Object)response), (String)"response");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                super(null);
                this.response = response;
                this.cause = cause;
            }

            @Override
            @NotNull
            public RpcResponse getResponse() {
                return this.response;
            }

            @NotNull
            public final Throwable getCause() {
                return this.cause;
            }

            @NotNull
            public final RpcResponse component1() {
                return this.response;
            }

            @NotNull
            public final Throwable component2() {
                return this.cause;
            }

            @NotNull
            public final Failure copy(@NotNull RpcResponse response, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)((Object)response), (String)"response");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                return new Failure(response, cause);
            }

            public static /* synthetic */ Failure copy$default(Failure failure, RpcResponse rpcResponse, Throwable throwable, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    rpcResponse = failure.response;
                }
                if ((n2 & 2) != 0) {
                    throwable = failure.cause;
                }
                return failure.copy(rpcResponse, throwable);
            }

            @NotNull
            public String toString() {
                return "Failure(response=" + (Object)((Object)this.response) + ", cause=" + this.cause + ')';
            }

            public int hashCode() {
                int result2 = this.response.hashCode();
                result2 = result2 * 31 + this.cause.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failure)) {
                    return false;
                }
                Failure failure = (Failure)other;
                if (!Intrinsics.areEqual((Object)((Object)this.response), (Object)((Object)failure.response))) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.cause, (Object)failure.cause);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/core/aidlrpcserver/AidlRpcRawMessageHandlerImpl$RpcProcessingResult$Success;", "Lcom/stripe/core/aidlrpcserver/AidlRpcRawMessageHandlerImpl$RpcProcessingResult;", "response", "Lcom/stripe/proto/net/rpc/base/RpcResponse;", "(Lcom/stripe/proto/net/rpc/base/RpcResponse;)V", "getResponse", "()Lcom/stripe/proto/net/rpc/base/RpcResponse;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aidlrpcserver_release"})
        public static final class Success
        extends RpcProcessingResult {
            @NotNull
            private final RpcResponse response;

            public Success(@NotNull RpcResponse response) {
                Intrinsics.checkNotNullParameter((Object)((Object)response), (String)"response");
                super(null);
                this.response = response;
            }

            @Override
            @NotNull
            public RpcResponse getResponse() {
                return this.response;
            }

            @NotNull
            public final RpcResponse component1() {
                return this.response;
            }

            @NotNull
            public final Success copy(@NotNull RpcResponse response) {
                Intrinsics.checkNotNullParameter((Object)((Object)response), (String)"response");
                return new Success(response);
            }

            public static /* synthetic */ Success copy$default(Success success, RpcResponse rpcResponse, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    rpcResponse = success.response;
                }
                return success.copy(rpcResponse);
            }

            @NotNull
            public String toString() {
                return "Success(response=" + (Object)((Object)this.response) + ')';
            }

            public int hashCode() {
                return this.response.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)((Object)this.response), (Object)((Object)success.response));
            }
        }
    }
}

