/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.aidlrpcserver;

import com.stripe.core.aidlrpcserver.AidlRequestContextKt;
import com.stripe.core.aidlrpcserver.AidlRpcCallbackHandler;
import com.stripe.core.aidlrpcserver.AidlRpcMessageHandler;
import com.stripe.core.aidlrpcserver.AidlRpcRequestHandler;
import com.stripe.core.aidlrpcserver.AidlRpcUtils;
import com.stripe.core.aidlrpcserver.ServiceHandlerMapper;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.proto.net.rpc.base.RpcRequest;
import com.stripe.proto.net.rpc.base.RpcResponse;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001a\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/core/aidlrpcserver/AidlRpcRequestRouter;", "Lcom/stripe/core/aidlrpcserver/AidlRpcRequestHandler;", "handlerMapper", "Lcom/stripe/core/aidlrpcserver/ServiceHandlerMapper;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Lcom/stripe/core/aidlrpcserver/ServiceHandlerMapper;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "clearCallbackHandler", "", "callingPackageName", "", "service", "handleRequest", "Lcom/stripe/proto/net/rpc/base/RpcResponse;", "rpcRequest", "Lcom/stripe/proto/net/rpc/base/RpcRequest;", "setCallbackHandler", "handler", "Lcom/stripe/core/aidlrpcserver/AidlRpcCallbackHandler;", "aidlrpcserver_release"})
public final class AidlRpcRequestRouter
implements AidlRpcRequestHandler {
    @NotNull
    private final ServiceHandlerMapper handlerMapper;
    @NotNull
    private final Log logger;

    public AidlRpcRequestRouter(@NotNull ServiceHandlerMapper handlerMapper, @NotNull Log logger2) {
        Intrinsics.checkNotNullParameter((Object)handlerMapper, (String)"handlerMapper");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.handlerMapper = handlerMapper;
        this.logger = logger2;
    }

    @Override
    @NotNull
    public RpcResponse handleRequest(@Nullable String callingPackageName, @NotNull RpcRequest rpcRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)rpcRequest), (String)"rpcRequest");
        AidlRpcMessageHandler messageHandler = this.handlerMapper.messageHandlerFromServiceName(rpcRequest.service);
        return messageHandler.handleMessage(rpcRequest.method, AidlRequestContextKt.aidlRequestContextFromRpcRequest(callingPackageName, rpcRequest), rpcRequest.content.toByteArray());
    }

    @Override
    public void setCallbackHandler(@Nullable String callingPackageName, @NotNull String service, @NotNull AidlRpcCallbackHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"callingPackage", (Object)callingPackageName), TuplesKt.to((Object)"service", (Object)service)};
        this.logger.d("setting update listener", pairArray);
        this.handlerMapper.messageHandlerFromServiceName(service).setUpdateListener(new AidlRpcMessageHandler.Listener(service, handler2){
            final /* synthetic */ String $service;
            final /* synthetic */ AidlRpcCallbackHandler $handler;
            {
                this.$service = $service;
                this.$handler = $handler;
            }

            @NotNull
            public RpcResponse onUpdate(@NotNull String method, @NotNull byte[] content) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                RpcRequest request = new RpcRequest(AidlRpcUtils.Companion.requestId(), this.$service, method, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])content, (int)0, (int)0, (int)3, null), 0L, null, null, null, null, null, null, 0L, null, 8176, null);
                return this.$handler.handleCallback(request);
            }
        });
    }

    @Override
    public void clearCallbackHandler(@Nullable String callingPackageName, @NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"callingPackage", (Object)callingPackageName), TuplesKt.to((Object)"service", (Object)service)};
        this.logger.d("clearing update listener", pairArray);
        this.handlerMapper.messageHandlerFromServiceName(service).clearUpdateListener();
    }
}

