/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.aidlrpcserver;

import com.stripe.core.aidlrpcserver.AidlRpcApplicationTrace;
import com.stripe.core.aidlrpcserver.RequestHandlerObserver;
import com.stripe.core.rpc.server.observability.RpcRequestObserver;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.ApplicationTraceResult;
import com.stripe.proto.net.rpc.base.ApplicationEC;
import com.stripe.proto.net.rpc.base.RpcEC;
import com.stripe.proto.net.rpc.base.RpcRequest;
import com.stripe.proto.net.rpc.base.RpcResponse;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u0015\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/core/aidlrpcserver/AidlServiceLogger;", "Lcom/stripe/core/aidlrpcserver/RequestHandlerObserver;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "rpcRequestObserver", "Lcom/stripe/core/rpc/server/observability/RpcRequestObserver;", "identifierPrefix", "", "(Lcom/stripe/jvmcore/logging/terminal/log/Log;Lcom/stripe/core/rpc/server/observability/RpcRequestObserver;Ljava/lang/String;)V", "applicationTraceResultFrom", "Lcom/stripe/jvmcore/loggingmodels/ApplicationTraceResult;", "rpcResponse", "Lcom/stripe/proto/net/rpc/base/RpcResponse;", "failure", "", "identifierFromRequestId", "requestId", "", "onCallbackStart", "Lcom/stripe/core/aidlrpcserver/RequestHandlerObserver$Metric;", "callingPackageName", "onReceived", "AidlServerMetric", "aidlrpcserver_release"})
public final class AidlServiceLogger
implements RequestHandlerObserver {
    @NotNull
    private final Log logger;
    @NotNull
    private final RpcRequestObserver rpcRequestObserver;
    @NotNull
    private final String identifierPrefix;

    public AidlServiceLogger(@NotNull Log logger2, @NotNull RpcRequestObserver rpcRequestObserver, @NotNull String identifierPrefix) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)rpcRequestObserver, (String)"rpcRequestObserver");
        Intrinsics.checkNotNullParameter((Object)identifierPrefix, (String)"identifierPrefix");
        this.logger = logger2;
        this.rpcRequestObserver = rpcRequestObserver;
        this.identifierPrefix = identifierPrefix;
    }

    private final String identifierFromRequestId(long requestId) {
        return this.identifierPrefix + '-' + requestId;
    }

    @Override
    @NotNull
    public RequestHandlerObserver.Metric onReceived(@Nullable String callingPackageName) {
        return new AidlServerMetric("request", callingPackageName);
    }

    @Override
    @NotNull
    public RequestHandlerObserver.Metric onCallbackStart(@Nullable String callingPackageName) {
        return new AidlServerMetric("callback", callingPackageName);
    }

    private final ApplicationTraceResult applicationTraceResultFrom(RpcResponse rpcResponse, Throwable failure) {
        RpcEC rpcEc = rpcResponse.rpc_error_code;
        ApplicationEC appEc = rpcResponse.app_error_code;
        return failure != null ? ApplicationTraceResult.Companion.failure(failure) : (rpcEc != RpcEC.RPC_OK && rpcEc != RpcEC.RPC_EC_INVALID || appEc != ApplicationEC.OK && appEc != ApplicationEC.APPLICATION_EC_INVALID ? ApplicationTraceResult.Companion.failure(rpcResponse.error) : ApplicationTraceResult.Companion.success());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/core/aidlrpcserver/AidlServiceLogger$AidlServerMetric;", "Lcom/stripe/core/aidlrpcserver/RequestHandlerObserver$Metric;", "type", "", "callingPackageName", "(Lcom/stripe/core/aidlrpcserver/AidlServiceLogger;Ljava/lang/String;Ljava/lang/String;)V", "rpcMetric", "Lcom/stripe/core/rpc/server/observability/RpcRequestObserver$Metric;", "onComplete", "", "rpcRequest", "Lcom/stripe/proto/net/rpc/base/RpcRequest;", "rpcResponse", "Lcom/stripe/proto/net/rpc/base/RpcResponse;", "failure", "", "onPreProcessingFailure", "step", "onStart", "aidlrpcserver_release"})
    private final class AidlServerMetric
    implements RequestHandlerObserver.Metric {
        @NotNull
        private final String type;
        @Nullable
        private final String callingPackageName;
        @NotNull
        private final RpcRequestObserver.Metric rpcMetric;

        public AidlServerMetric(@Nullable String type, String callingPackageName) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.type = type;
            this.callingPackageName = callingPackageName;
            this.rpcMetric = AidlServiceLogger.this.rpcRequestObserver.onRequestStarted(AidlServiceLogger.this.identifierPrefix);
        }

        @Override
        public void onPreProcessingFailure(@NotNull String step) {
            Intrinsics.checkNotNullParameter((Object)step, (String)"step");
            this.rpcMetric.onPreProcessingFailure(step);
        }

        @Override
        public void onStart(@NotNull RpcRequest rpcRequest) {
            Intrinsics.checkNotNullParameter((Object)((Object)rpcRequest), (String)"rpcRequest");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)String.valueOf(rpcRequest.id)), TuplesKt.to((Object)"service", (Object)rpcRequest.service), TuplesKt.to((Object)"method", (Object)rpcRequest.method), TuplesKt.to((Object)"from", (Object)this.callingPackageName)};
            AidlServiceLogger.this.logger.d("handling " + this.type, pairArray);
            AidlServiceLogger.this.logger.startOperation(new AidlRpcApplicationTrace(rpcRequest.service, rpcRequest.method), AidlServiceLogger.this.identifierFromRequestId(rpcRequest.id));
        }

        @Override
        public void onComplete(@NotNull RpcRequest rpcRequest, @NotNull RpcResponse rpcResponse, @Nullable Throwable failure) {
            Intrinsics.checkNotNullParameter((Object)((Object)rpcRequest), (String)"rpcRequest");
            Intrinsics.checkNotNullParameter((Object)((Object)rpcResponse), (String)"rpcResponse");
            AidlServiceLogger.this.logger.endOperation(AidlServiceLogger.this.applicationTraceResultFrom(rpcResponse, failure), AidlServiceLogger.this.identifierFromRequestId(rpcRequest.id));
            this.rpcMetric.onRpcResponse(rpcRequest, rpcResponse, failure);
        }
    }
}

