/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos;

import android.bluetooth.BluetoothDevice;
import android.graphics.Rect;
import com.stripe.bbpos.bbdevice.BBDeviceController;
import com.stripe.bbpos.bbdevice.ota.BBDeviceOTAController;
import com.stripe.bbpos.sdk.AmountInputType;
import com.stripe.bbpos.sdk.CheckCardMode;
import com.stripe.bbpos.sdk.ContactlessOnlinePinOption;
import com.stripe.bbpos.sdk.DomesticDebitPriority;
import com.stripe.bbpos.sdk.EncryptionMethod;
import com.stripe.bbpos.sdk.FixedAmountTips;
import com.stripe.bbpos.sdk.OtherAmountOption;
import com.stripe.bbpos.sdk.PercentageTips;
import com.stripe.bbpos.sdk.QuickChipOption;
import com.stripe.bbpos.sdk.TransactionType;
import com.stripe.core.bbpos.hardware.ReaderInfoHelper;
import com.stripe.core.bbpos.hardware.api.DeviceControllerWrapper;
import com.stripe.core.bbpos.hardware.api.TippingOption;
import com.stripe.core.bbpos.mappers.AmountInputTypeMapperKt;
import com.stripe.core.bbpos.mappers.CheckCardModeMapperKt;
import com.stripe.core.bbpos.mappers.ContactlessOnlinePinOptionMapperKt;
import com.stripe.core.bbpos.mappers.CurrencyCodeMapperKt;
import com.stripe.core.bbpos.mappers.DeviceInfoMapperKt;
import com.stripe.core.bbpos.mappers.DomesticDebitPriorityMapperKt;
import com.stripe.core.bbpos.mappers.EncryptionMethodMapperKt;
import com.stripe.core.bbpos.mappers.OtherAmountOptionMapperKt;
import com.stripe.core.bbpos.mappers.QuickChipOptionMapperKt;
import com.stripe.core.bbpos.mappers.TransactionTypeMapperKt;
import com.stripe.core.hardware.dagger.BluetoothUsbPinPadReaders;
import com.stripe.jvmcore.logging.terminal.log.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u007f2\u00020\u0001:\u0001\u007fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0017J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J(\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016J\u0016\u0010#\u001a\u00020\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0%H\u0016J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u001fH\u0016J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001fH\u0016J\u00c8\u0001\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020,2\u0006\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020,2\u0006\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020,2\u0006\u0010=\u001a\u00020,2\u0006\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020,2\u0006\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020,2\u0006\u0010C\u001a\u00020,H\u0016J\u0010\u0010D\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u000eH\u0016J\u0010\u0010F\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u000eH\u0016J\u0010\u0010H\u001a\u00020\u00062\u0006\u0010I\u001a\u00020,H\u0016J\u0012\u0010J\u001a\u00020\u00062\b\u0010K\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010L\u001a\u00020\u00062\u0006\u0010M\u001a\u00020,H\u0016Jp\u0010N\u001a\u00020\u00062\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020P2\u0006\u0010R\u001a\u00020P2\u0006\u0010S\u001a\u00020P2\u0006\u0010T\u001a\u00020P2\u0006\u0010U\u001a\u00020P2\u0006\u0010V\u001a\u00020P2\u0006\u0010W\u001a\u00020P2\u0006\u0010X\u001a\u00020P2\u0006\u0010Y\u001a\u00020P2\u0006\u0010Z\u001a\u00020P2\u0006\u0010[\u001a\u00020P2\u0006\u0010\\\u001a\u00020PH\u0016J \u0010]\u001a\u00020\u00062\u000e\u0010^\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010%2\u0006\u0010_\u001a\u00020\u000eH\u0016J\u0086\u0001\u0010`\u001a\u00020\u00062\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\f2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020,2\u0006\u0010g\u001a\u00020\u000e2\u0006\u0010h\u001a\u00020\u000e2\u0006\u0010i\u001a\u00020\u001f2\u0006\u0010j\u001a\u00020\u001f2\u0006\u0010k\u001a\u00020\u000e2\u0006\u0010l\u001a\u00020\u000e2\u0006\u0010m\u001a\u00020\u000e2\u0006\u0010n\u001a\u00020\u000e2\b\u0010o\u001a\u0004\u0018\u00010\u001f2\b\u0010p\u001a\u0004\u0018\u00010q2\b\u0010r\u001a\u0004\u0018\u00010sH\u0016J\b\u0010t\u001a\u00020\u0006H\u0016J\b\u0010u\u001a\u00020\u0006H\u0016J\b\u0010v\u001a\u00020\u0006H\u0016J\u0010\u0010w\u001a\u00020\u00062\u0006\u0010^\u001a\u00020\u001fH\u0016J\b\u0010x\u001a\u00020\u0006H\u0016J\b\u0010y\u001a\u00020\u0006H\u0016J\u001c\u0010z\u001a\u00020\u00062\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0{H\u0016J\u001c\u0010|\u001a\u00020\u00062\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020}0{H\u0016J\u0010\u0010~\u001a\u00020\u00062\u0006\u0010K\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0080\u0001"}, d2={"Lcom/stripe/core/bbpos/BbposDeviceControllerImpl;", "Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;", "controller", "Lcom/bbpos/bbdevice/BBDeviceController;", "(Lcom/bbpos/bbdevice/BBDeviceController;)V", "cancelCheckCard", "", "cancelPinEntry", "cancelSelectAccountType", "cancelSelectApplication", "checkCard", "mode", "Lcom/stripe/bbpos/sdk/CheckCardMode;", "timeout", "", "connectBt", "bluetoothDevice", "Landroid/bluetooth/BluetoothDevice;", "disableInputAmount", "disconnectBt", "disconnectSerial", "enableInputAmount", "setAmountTimeout", "amountInputType", "Lcom/stripe/bbpos/sdk/AmountInputType;", "otherAmountOption", "Lcom/stripe/bbpos/sdk/OtherAmountOption;", "tippingOption", "Lcom/stripe/core/bbpos/hardware/api/TippingOption;", "encryptDataWithSettings", "data", "", "encryptionMethod", "Lcom/stripe/bbpos/sdk/EncryptionMethod;", "getDeviceInfo", "getDeviceInfoByKeys", "keys", "", "initSession", "vendorToken", "readAid", "appIndex", "readTerminalSetting", "acquirerIdentifier", "", "terminalCountryCode", "transactionCurrencyCode", "transactionCurrencyExponent", "merchantNameAndLocation", "merchantIdentifier", "terminalIdentification", "terminalCapabilities", "terminalType", "additionalTerminalCapabilities", "normalModeTimeout", "standbyModeTimeout", "bluetoothDiscoveryTimeout", "msrPinEntryTimeout", "firmwareFallbackEnabled", "customBluetoothNamePrefix", "customBluetoothSerialSuffix", "firmwareForceChipEnabled", "iccTransactionBeepEnabled", "keypadEventBeepEnabled", "spocModeEnabled", "domesticDebitAidList", "visaDynamicReaderLimit", "buzzerSoundEnabled", "selectAccountType", "type", "selectApplication", "index", "sendFinalConfirmResult", "confirm", "sendOnlineProcessResult", "tlv", "setDebugLogEnabled", "enabled", "setPinPadButtons", "zero", "Landroid/graphics/Rect;", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "backspace", "cancel", "enter", "startBtScan", "deviceName", "scanTimeout", "startEmv", "transactionType", "Lcom/stripe/bbpos/sdk/TransactionType;", "checkCardMode", "quickChipOption", "Lcom/stripe/bbpos/sdk/QuickChipOption;", "disableQuickChip", "currencyCode", "currencyExponent", "amount", "terminalTime", "checkCardTimeout", "selectApplicationTimeout", "selectAccountTypeTimeout", "onlineProcessTimeout", "terminalCapabilitiesOverride", "domesticDebitPriority", "Lcom/stripe/bbpos/sdk/DomesticDebitPriority;", "contactlessOnlinePinOption", "Lcom/stripe/bbpos/sdk/ContactlessOnlinePinOption;", "startPinEntry", "startSerial", "startUsb", "startUsbWithDeviceName", "stopBtScan", "stopUsb", "updateAid", "", "updateDisplaySettings", "", "updateTerminalSettings", "Companion", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nBbposDeviceControllerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposDeviceControllerImpl.kt\ncom/stripe/core/bbpos/BbposDeviceControllerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,562:1\n1#2:563\n37#3,2:564\n37#3,2:566\n37#3,2:568\n*S KotlinDebug\n*F\n+ 1 BbposDeviceControllerImpl.kt\ncom/stripe/core/bbpos/BbposDeviceControllerImpl\n*L\n320#1:564,2\n468#1:566,2\n489#1:568,2\n*E\n"})
public final class BbposDeviceControllerImpl
implements DeviceControllerWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BBDeviceController controller;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(BbposDeviceControllerImpl.class);
    @NotNull
    public static final String TRANSACTION_TYPE_PARAM_NAME = "transactionType";
    @NotNull
    public static final String CHECK_CARD_MODE_PARAM_NAME = "checkCardMode";
    @NotNull
    public static final String CURRENCY_CHARACTERS_PARAM_NAME = "currencyCharacters";
    @NotNull
    public static final String CURRENCY_CODE_PARAM_NAME = "currencyCode";
    @NotNull
    public static final String CURRENCY_EXPONENT_PARAM_NAME = "currencyExponent";
    @NotNull
    public static final String AMOUNT_PARAM_NAME = "amount";
    @NotNull
    public static final String CHECK_CARD_TIMEOUT_PARAM_NAME = "checkCardTimeout";
    @NotNull
    public static final String SELECT_APPLICATION_TIMEOUT_PARAM_NAME = "selectApplicationTimeout";
    @NotNull
    public static final String SELECT_ACCOUNT_TYPE_PARAM_NAME = "selectAccountTypeTimeout";
    @NotNull
    public static final String ONLINE_PROCESS_TIMEOUT_PARAM_NAME = "onlineProcessTimeout";
    @NotNull
    public static final String TERMINAL_TIME_PARAM_NAME = "terminalTime";
    @NotNull
    public static final String QUICK_CHIP_OPTION_PARAM_NAME = "quickChipOption";
    @NotNull
    public static final String DISABLE_QUICK_CHIP_PARAM_NAME = "disableQuickChip";
    @NotNull
    public static final String IS_MERCHANT_CHOICE_ROUTING_PARAM_NAME = "isMerchantChoiceRouting";
    @NotNull
    public static final String TERMINAL_CAPABILITIES_PARAM_NAME = "terminalCapabilities";
    @NotNull
    public static final String DOMESTIC_DEBIT_PRIORITY_PARAM_NAME = "domesticDebitPriority";
    @NotNull
    public static final String CONTACTLESS_ONLINE_PIN_OPTION_PARAM_NAME = "contactlessOnlinePINOption";

    public BbposDeviceControllerImpl(@NotNull BBDeviceController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = controller;
    }

    @Override
    public void cancelCheckCard() {
        LOGGER.d("cancelCheckCard", new Pair[0]);
        this.controller.cancelCheckCard();
    }

    @Override
    public void cancelPinEntry() {
        LOGGER.d("cancelPinEntry", new Pair[0]);
        this.controller.cancelPinEntry();
    }

    @Override
    public void cancelSelectAccountType() {
        LOGGER.d("cancelSelectAccountType", new Pair[0]);
        this.controller.cancelSelectAccountType();
    }

    @Override
    public void cancelSelectApplication() {
        LOGGER.d("cancelSelectApplication", new Pair[0]);
        this.controller.cancelSelectApplication();
    }

    @Override
    public void checkCard(@NotNull CheckCardMode mode, int timeout) {
        Map options;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        LOGGER.d("checkCard", new Pair[0]);
        Map map2 = options = (Map)new LinkedHashMap();
        String string = CHECK_CARD_MODE_PARAM_NAME;
        BBDeviceController.CheckCardMode checkCardMode = CheckCardModeMapperKt.convert(mode);
        if (checkCardMode == null) {
            throw new IllegalArgumentException("Invalid CheckCardMode");
        }
        Object object = checkCardMode;
        map2.put(string, object);
        object = timeout;
        options.put(CHECK_CARD_TIMEOUT_PARAM_NAME, object);
        this.controller.checkCard(new Hashtable<String, Object>(options));
    }

    @Override
    public void connectBt(@NotNull BluetoothDevice bluetoothDevice) {
        Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"bluetoothDevice");
        LOGGER.d("connectBT", new Pair[0]);
        this.controller.connectBT(bluetoothDevice);
    }

    @Override
    public void disconnectBt() {
        LOGGER.d("disconnectBT", new Pair[0]);
        this.controller.disconnectBT();
    }

    @Override
    public void disconnectSerial() {
        LOGGER.d("disconnectSerial", new Pair[0]);
        this.controller.stopSerial();
    }

    @Override
    public void getDeviceInfo() {
        LOGGER.d("getDeviceInfo", new Pair[0]);
        this.getDeviceInfoByKeys(CollectionsKt.plus((Collection)DeviceInfoMapperKt.getDeviceInfoFields(), (Iterable)ReaderInfoHelper.INSTANCE.getRawReaderInfoFields()));
    }

    @Override
    public void getDeviceInfoByKeys(@NotNull List<String> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.controller.getDeviceInfo(new ArrayList<String>((Collection)keys));
    }

    @Override
    public void readAid(@NotNull String appIndex) {
        Intrinsics.checkNotNullParameter((Object)appIndex, (String)"appIndex");
        LOGGER.d("readAID", new Pair[0]);
        this.controller.readAID(appIndex);
    }

    @Override
    public void readTerminalSetting(boolean acquirerIdentifier, boolean terminalCountryCode, boolean transactionCurrencyCode, boolean transactionCurrencyExponent, boolean merchantNameAndLocation, boolean merchantIdentifier, boolean terminalIdentification, boolean terminalCapabilities, boolean terminalType, boolean additionalTerminalCapabilities, boolean normalModeTimeout, boolean standbyModeTimeout, boolean bluetoothDiscoveryTimeout, boolean msrPinEntryTimeout, boolean firmwareFallbackEnabled, boolean customBluetoothNamePrefix, boolean customBluetoothSerialSuffix, boolean firmwareForceChipEnabled, boolean iccTransactionBeepEnabled, boolean keypadEventBeepEnabled, boolean spocModeEnabled, boolean domesticDebitAidList, boolean visaDynamicReaderLimit, boolean buzzerSoundEnabled) {
        String string;
        LOGGER.d("readTerminalSetting", new Pair[0]);
        Object[] objectArray = new String[24];
        String string2 = string = "9F01";
        int n2 = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = acquirerIdentifier;
        objectArray2[n2] = bl2 ? string : null;
        String it = string = "9F1A";
        n2 = 1;
        objectArray2 = objectArray;
        boolean bl3 = false;
        bl2 = terminalCountryCode;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "5F2A";
        n2 = 2;
        objectArray2 = objectArray;
        boolean bl4 = false;
        bl2 = transactionCurrencyCode;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "5F36";
        n2 = 3;
        objectArray2 = objectArray;
        boolean bl5 = false;
        bl2 = transactionCurrencyExponent;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "9F4E";
        n2 = 4;
        objectArray2 = objectArray;
        boolean bl6 = false;
        bl2 = merchantNameAndLocation;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "9F16";
        n2 = 5;
        objectArray2 = objectArray;
        boolean bl7 = false;
        bl2 = merchantIdentifier;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "9F1C";
        n2 = 6;
        objectArray2 = objectArray;
        boolean bl8 = false;
        bl2 = terminalIdentification;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "9F33";
        n2 = 7;
        objectArray2 = objectArray;
        boolean bl9 = false;
        bl2 = terminalCapabilities;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "9F35";
        n2 = 8;
        objectArray2 = objectArray;
        boolean bl10 = false;
        bl2 = terminalType;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "9F40";
        n2 = 9;
        objectArray2 = objectArray;
        boolean bl11 = false;
        bl2 = additionalTerminalCapabilities;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF8370";
        n2 = 10;
        objectArray2 = objectArray;
        boolean bl12 = false;
        bl2 = normalModeTimeout;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF8367";
        n2 = 11;
        objectArray2 = objectArray;
        boolean bl13 = false;
        bl2 = standbyModeTimeout;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF837B";
        n2 = 12;
        objectArray2 = objectArray;
        boolean bl14 = false;
        bl2 = bluetoothDiscoveryTimeout;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF8403";
        n2 = 13;
        objectArray2 = objectArray;
        boolean bl15 = false;
        bl2 = msrPinEntryTimeout;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF8407";
        n2 = 14;
        objectArray2 = objectArray;
        boolean bl16 = false;
        bl2 = firmwareFallbackEnabled;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF8408";
        n2 = 15;
        objectArray2 = objectArray;
        boolean bl17 = false;
        bl2 = customBluetoothNamePrefix;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF8409";
        n2 = 16;
        objectArray2 = objectArray;
        boolean bl18 = false;
        bl2 = customBluetoothSerialSuffix;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF840D";
        n2 = 17;
        objectArray2 = objectArray;
        boolean bl19 = false;
        bl2 = firmwareForceChipEnabled;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF8421";
        n2 = 18;
        objectArray2 = objectArray;
        boolean bl20 = false;
        bl2 = iccTransactionBeepEnabled;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF842C";
        n2 = 19;
        objectArray2 = objectArray;
        boolean bl21 = false;
        bl2 = keypadEventBeepEnabled;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF866B";
        n2 = 20;
        objectArray2 = objectArray;
        boolean bl22 = false;
        bl2 = spocModeEnabled;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF8926";
        n2 = 21;
        objectArray2 = objectArray;
        boolean bl23 = false;
        bl2 = domesticDebitAidList;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DFDF09";
        n2 = 22;
        objectArray2 = objectArray;
        boolean bl24 = false;
        bl2 = visaDynamicReaderLimit;
        objectArray2[n2] = bl2 ? string : null;
        it = string = "DF8424";
        n2 = 23;
        objectArray2 = objectArray;
        boolean bl25 = false;
        bl2 = buzzerSoundEnabled;
        objectArray2[n2] = bl2 ? string : null;
        String dol = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        this.controller.readTerminalSetting(dol);
    }

    @Override
    public void selectApplication(int index) {
        LOGGER.d("selectApplication", new Pair[0]);
        this.controller.selectApplication(index);
    }

    @Override
    public void selectAccountType(int type) {
        LOGGER.d("selectAccountType", new Pair[0]);
        this.controller.selectAccountType(type);
    }

    @Override
    public void sendFinalConfirmResult(boolean confirm) {
        LOGGER.d("sendFinalConfirmResult", new Pair[0]);
        this.controller.sendFinalConfirmResult(confirm);
    }

    @Override
    public void sendOnlineProcessResult(@Nullable String tlv) {
        LOGGER.d("sendOnlineProcessResult", new Pair[0]);
        this.controller.sendOnlineProcessResult(tlv);
    }

    @Override
    public void setPinPadButtons(@NotNull Rect zero, @NotNull Rect one, @NotNull Rect two, @NotNull Rect three, @NotNull Rect four, @NotNull Rect five, @NotNull Rect six, @NotNull Rect seven, @NotNull Rect eight, @NotNull Rect nine, @NotNull Rect backspace, @NotNull Rect cancel2, @NotNull Rect enter) {
        Intrinsics.checkNotNullParameter((Object)zero, (String)"zero");
        Intrinsics.checkNotNullParameter((Object)one, (String)"one");
        Intrinsics.checkNotNullParameter((Object)two, (String)"two");
        Intrinsics.checkNotNullParameter((Object)three, (String)"three");
        Intrinsics.checkNotNullParameter((Object)four, (String)"four");
        Intrinsics.checkNotNullParameter((Object)five, (String)"five");
        Intrinsics.checkNotNullParameter((Object)six, (String)"six");
        Intrinsics.checkNotNullParameter((Object)seven, (String)"seven");
        Intrinsics.checkNotNullParameter((Object)eight, (String)"eight");
        Intrinsics.checkNotNullParameter((Object)nine, (String)"nine");
        Intrinsics.checkNotNullParameter((Object)backspace, (String)"backspace");
        Intrinsics.checkNotNullParameter((Object)cancel2, (String)"cancel");
        Intrinsics.checkNotNullParameter((Object)enter, (String)"enter");
        LOGGER.d("setPinPadButtons", new Pair[0]);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"key0", (Object)zero), TuplesKt.to((Object)"key1", (Object)one), TuplesKt.to((Object)"key2", (Object)two), TuplesKt.to((Object)"key3", (Object)three), TuplesKt.to((Object)"key4", (Object)four), TuplesKt.to((Object)"key5", (Object)five), TuplesKt.to((Object)"key6", (Object)six), TuplesKt.to((Object)"key7", (Object)seven), TuplesKt.to((Object)"key8", (Object)eight), TuplesKt.to((Object)"key9", (Object)nine), TuplesKt.to((Object)"backspace", (Object)backspace), TuplesKt.to((Object)"cancel", (Object)cancel2), TuplesKt.to((Object)"enter", (Object)enter)};
        Map pinButtons = MapsKt.mutableMapOf((Pair[])pairArray);
        this.controller.setPinPadButtons(new Hashtable<String, Rect>(pinButtons));
    }

    @Override
    public void encryptDataWithSettings(@NotNull String data, @NotNull EncryptionMethod encryptionMethod) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionMethod), (String)"encryptionMethod");
        LOGGER.d("encryptDataWithSettings", new Pair[0]);
        Map settings = new LinkedHashMap();
        settings.put("data", data);
        Map map2 = settings;
        String string = "encryptionMethod";
        BBDeviceController.EncryptionMethod encryptionMethod2 = EncryptionMethodMapperKt.convert(encryptionMethod);
        if (encryptionMethod2 == null) {
            throw new IllegalArgumentException("Invalid Encryption Method");
        }
        BBDeviceController.EncryptionMethod encryptionMethod3 = encryptionMethod2;
        map2.put(string, encryptionMethod3);
        this.controller.encryptDataWithSettings(new Hashtable<String, Object>(settings));
    }

    @Override
    public void setDebugLogEnabled(boolean enabled) {
        BBDeviceController.setDebugLogEnabled(enabled);
        BBDeviceOTAController.setDebugLogEnabled(enabled);
    }

    @Override
    public void startBtScan(@Nullable List<String> deviceName, int scanTimeout) {
        String[] stringArray;
        LOGGER.d("startBTScan", new Pair[0]);
        List<String> list = deviceName;
        if (list != null) {
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            stringArray = null;
        }
        this.controller.startBTScan(stringArray, scanTimeout);
    }

    @Override
    public void startEmv(@NotNull TransactionType transactionType, @NotNull CheckCardMode checkCardMode, @NotNull QuickChipOption quickChipOption, boolean disableQuickChip, int currencyCode, int currencyExponent, @NotNull String amount, @NotNull String terminalTime, int checkCardTimeout, int selectApplicationTimeout, int selectAccountTypeTimeout, int onlineProcessTimeout, @Nullable String terminalCapabilitiesOverride, @Nullable DomesticDebitPriority domesticDebitPriority, @Nullable ContactlessOnlinePinOption contactlessOnlinePinOption) {
        Object object;
        Integer n2;
        Map data;
        Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)TRANSACTION_TYPE_PARAM_NAME);
        Intrinsics.checkNotNullParameter((Object)((Object)checkCardMode), (String)CHECK_CARD_MODE_PARAM_NAME);
        Intrinsics.checkNotNullParameter((Object)((Object)quickChipOption), (String)QUICK_CHIP_OPTION_PARAM_NAME);
        Intrinsics.checkNotNullParameter((Object)amount, (String)AMOUNT_PARAM_NAME);
        Intrinsics.checkNotNullParameter((Object)terminalTime, (String)TERMINAL_TIME_PARAM_NAME);
        LOGGER.d("startEmv", new Pair[0]);
        Map map2 = data = (Map)new LinkedHashMap();
        String string = TRANSACTION_TYPE_PARAM_NAME;
        BBDeviceController.TransactionType transactionType2 = TransactionTypeMapperKt.convert(transactionType);
        if (transactionType2 == null) {
            throw new IllegalArgumentException("Invalid TransactionType");
        }
        Object object2 = transactionType2;
        map2.put(string, object2);
        map2 = data;
        string = CHECK_CARD_MODE_PARAM_NAME;
        BBDeviceController.CheckCardMode checkCardMode2 = CheckCardModeMapperKt.convert(checkCardMode);
        if (checkCardMode2 == null) {
            throw new IllegalArgumentException("Invalid CheckCardMode");
        }
        object2 = checkCardMode2;
        map2.put(string, object2);
        data.put(CURRENCY_CHARACTERS_PARAM_NAME, CurrencyCodeMapperKt.convert(currencyCode));
        data.put(CURRENCY_CODE_PARAM_NAME, String.valueOf(currencyCode));
        object2 = currencyExponent;
        data.put(CURRENCY_EXPONENT_PARAM_NAME, object2);
        data.put(AMOUNT_PARAM_NAME, amount);
        object2 = checkCardTimeout;
        data.put(CHECK_CARD_TIMEOUT_PARAM_NAME, object2);
        object2 = selectApplicationTimeout;
        data.put(SELECT_APPLICATION_TIMEOUT_PARAM_NAME, object2);
        object2 = selectAccountTypeTimeout;
        data.put(SELECT_ACCOUNT_TYPE_PARAM_NAME, object2);
        object2 = onlineProcessTimeout;
        data.put(ONLINE_PROCESS_TIMEOUT_PARAM_NAME, object2);
        data.put(TERMINAL_TIME_PARAM_NAME, terminalTime);
        String string2 = terminalCapabilitiesOverride;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            data.put(TERMINAL_CAPABILITIES_PARAM_NAME, it);
        }
        Integer n3 = QuickChipOptionMapperKt.convert(quickChipOption);
        if (n3 != null) {
            int it = ((Number)n3).intValue();
            boolean bl = false;
            n2 = it;
            data.put(QUICK_CHIP_OPTION_PARAM_NAME, n2);
        }
        Boolean it = disableQuickChip;
        data.put(DISABLE_QUICK_CHIP_PARAM_NAME, it);
        Object object3 = domesticDebitPriority;
        if (object3 != null && (object3 = DomesticDebitPriorityMapperKt.convert(object3)) != null) {
            int it2 = ((Number)object3).intValue();
            boolean bl = false;
            n2 = it2;
            data.put(DOMESTIC_DEBIT_PRIORITY_PARAM_NAME, n2);
        }
        if ((object = contactlessOnlinePinOption) != null && (object = ContactlessOnlinePinOptionMapperKt.convert(object)) != null) {
            int it3 = ((Number)object).intValue();
            boolean bl = false;
            n2 = it3;
            data.put(CONTACTLESS_ONLINE_PIN_OPTION_PARAM_NAME, n2);
        }
        this.controller.startEmv(new Hashtable<String, Object>(data));
    }

    @Override
    public void startSerial() {
        LOGGER.d("startSerial", new Pair[0]);
        this.controller.startSerial();
    }

    @Override
    public void startPinEntry() {
        LOGGER.d("startPinEntry", new Pair[0]);
        this.controller.startPinEntry(new Hashtable<String, Object>());
    }

    @Override
    public void initSession(@NotNull String vendorToken) {
        Intrinsics.checkNotNullParameter((Object)vendorToken, (String)"vendorToken");
        LOGGER.d("initSession", new Pair[0]);
        this.controller.initSession(vendorToken);
    }

    @Override
    public void startUsb() {
        LOGGER.d("startUsb", new Pair[0]);
        this.controller.startUsb();
    }

    @Override
    public void startUsbWithDeviceName(@NotNull String deviceName) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        LOGGER.d("startUsbWithDeviceName", new Pair[0]);
        this.controller.startUsbWithDeviceName(deviceName);
    }

    @Override
    public void stopBtScan() {
        LOGGER.d("stopBTScan", new Pair[0]);
        this.controller.stopBTScan();
    }

    @Override
    public void stopUsb() {
        LOGGER.d("stopUsb", new Pair[0]);
        this.controller.stopUsb();
    }

    @Override
    public void updateAid(@NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        LOGGER.d("updateAID", new Pair[0]);
        this.controller.updateAID(new Hashtable<String, String>(data));
    }

    @Override
    public void updateDisplaySettings(@NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        LOGGER.d("updateDisplaySettings", new Pair[0]);
        this.controller.updateDisplaySettings(new Hashtable<String, Object>(data));
    }

    @Override
    public void updateTerminalSettings(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
        LOGGER.d("updateTerminalSettings", new Pair[0]);
        this.controller.updateTerminalSettings(tlv);
    }

    @Override
    @BluetoothUsbPinPadReaders
    public void enableInputAmount(int setAmountTimeout, @NotNull AmountInputType amountInputType, @NotNull OtherAmountOption otherAmountOption, @NotNull TippingOption tippingOption) {
        Intrinsics.checkNotNullParameter((Object)((Object)amountInputType), (String)"amountInputType");
        Intrinsics.checkNotNullParameter((Object)((Object)otherAmountOption), (String)"otherAmountOption");
        Intrinsics.checkNotNullParameter((Object)tippingOption, (String)"tippingOption");
        Map parameters = new LinkedHashMap();
        Object object = setAmountTimeout;
        parameters.put("setAmountTimeout", object);
        Object object2 = parameters;
        String string = "amountInputType";
        BBDeviceController.AmountInputType amountInputType2 = AmountInputTypeMapperKt.convert(amountInputType);
        if (amountInputType2 == null) {
            throw new IllegalArgumentException("Invalid AmountInputType");
        }
        object = amountInputType2;
        object2.put(string, object);
        object2 = parameters;
        string = "otherAmountOption";
        BBDeviceController.OtherAmountOption otherAmountOption2 = OtherAmountOptionMapperKt.convert(otherAmountOption);
        if (otherAmountOption2 == null) {
            throw new IllegalArgumentException("Invalid OtherAmountOption");
        }
        object = otherAmountOption2;
        object2.put(string, object);
        object2 = tippingOption;
        if (object2 instanceof TippingOption.Percentage) {
            PercentageTips $this$enableInputAmount_u24lambda_u2428 = ((TippingOption.Percentage)tippingOption).unbox-impl();
            boolean bl = false;
            parameters.put(AMOUNT_PARAM_NAME, $this$enableInputAmount_u24lambda_u2428.amount);
            parameters.put(CURRENCY_CODE_PARAM_NAME, String.valueOf($this$enableInputAmount_u24lambda_u2428.currencyCode));
            parameters.put(CURRENCY_EXPONENT_PARAM_NAME, $this$enableInputAmount_u24lambda_u2428.currencyExponent);
            parameters.put(CURRENCY_CHARACTERS_PARAM_NAME, CurrencyCodeMapperKt.convert($this$enableInputAmount_u24lambda_u2428.currencyCode));
            Map map2 = parameters;
            String string2 = "tipsPercentageOptions";
            String[] $this$toTypedArray$iv = (String[])$this$enableInputAmount_u24lambda_u2428.tipsPercentageOptions;
            boolean $i$f$toTypedArray = false;
            String[] thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = thisCollection$iv.toArray(new String[0]);
            map2.put(string2, $this$toTypedArray$iv);
            LOGGER.i("enableInputAmount parameters. setAmountTimeout=" + parameters.get("setAmountTimeout") + ", amountInputType=" + (Object)((Object)amountInputType) + ", otherAmountOption=" + (Object)((Object)otherAmountOption) + ", amount=" + parameters.get(AMOUNT_PARAM_NAME) + ", currencyCode=" + parameters.get(CURRENCY_CODE_PARAM_NAME) + ", currencyExponent=" + parameters.get(CURRENCY_EXPONENT_PARAM_NAME) + ", tipsPercentageOptions=" + $this$enableInputAmount_u24lambda_u2428.tipsPercentageOptions + ',', new Pair[0]);
        } else if (object2 instanceof TippingOption.FixedAmount) {
            FixedAmountTips $this$enableInputAmount_u24lambda_u2429 = ((TippingOption.FixedAmount)tippingOption).unbox-impl();
            boolean bl = false;
            parameters.put(AMOUNT_PARAM_NAME, $this$enableInputAmount_u24lambda_u2429.amount);
            parameters.put(CURRENCY_CODE_PARAM_NAME, String.valueOf($this$enableInputAmount_u24lambda_u2429.currencyCode));
            parameters.put(CURRENCY_EXPONENT_PARAM_NAME, $this$enableInputAmount_u24lambda_u2429.currencyExponent);
            parameters.put(CURRENCY_CHARACTERS_PARAM_NAME, CurrencyCodeMapperKt.convert($this$enableInputAmount_u24lambda_u2429.currencyCode));
            Map map3 = parameters;
            String string3 = "tipsAmountOptions";
            Collection $this$toTypedArray$iv = $this$enableInputAmount_u24lambda_u2429.tipsAmountOptions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            map3.put(string3, stringArray);
            LOGGER.i("enableInputAmount parameters. setAmountTimeout=" + parameters.get("setAmountTimeout") + ", amountInputType=" + (Object)((Object)amountInputType) + ", otherAmountOption=" + (Object)((Object)otherAmountOption) + ", amount=" + parameters.get(AMOUNT_PARAM_NAME) + ", currencyCode=" + parameters.get(CURRENCY_CODE_PARAM_NAME) + ", currencyExponent=" + parameters.get(CURRENCY_EXPONENT_PARAM_NAME) + ", tipsAmountOptions=" + $this$enableInputAmount_u24lambda_u2429.tipsAmountOptions + ',', new Pair[0]);
        } else if (object2 instanceof TippingOption.None) {
            LOGGER.i("enableInputAmount parameters. setAmountTimeout=" + parameters.get("setAmountTimeout") + ", amountInputType=" + (Object)((Object)amountInputType) + ", otherAmountOption=" + (Object)((Object)otherAmountOption) + ", ", new Pair[0]);
        }
        this.controller.enableInputAmount(new Hashtable<String, Object>(parameters));
    }

    @Override
    @BluetoothUsbPinPadReaders
    public void disableInputAmount() {
        LOGGER.d("disableInputAmount", new Pair[0]);
        this.controller.disableInputAmount();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/core/bbpos/BbposDeviceControllerImpl$Companion;", "", "()V", "AMOUNT_PARAM_NAME", "", "CHECK_CARD_MODE_PARAM_NAME", "CHECK_CARD_TIMEOUT_PARAM_NAME", "CONTACTLESS_ONLINE_PIN_OPTION_PARAM_NAME", "CURRENCY_CHARACTERS_PARAM_NAME", "CURRENCY_CODE_PARAM_NAME", "CURRENCY_EXPONENT_PARAM_NAME", "DISABLE_QUICK_CHIP_PARAM_NAME", "DOMESTIC_DEBIT_PRIORITY_PARAM_NAME", "IS_MERCHANT_CHOICE_ROUTING_PARAM_NAME", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "ONLINE_PROCESS_TIMEOUT_PARAM_NAME", "QUICK_CHIP_OPTION_PARAM_NAME", "SELECT_ACCOUNT_TYPE_PARAM_NAME", "SELECT_APPLICATION_TIMEOUT_PARAM_NAME", "TERMINAL_CAPABILITIES_PARAM_NAME", "TERMINAL_TIME_PARAM_NAME", "TRANSACTION_TYPE_PARAM_NAME", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

