/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos;

import com.google.common.util.concurrent.SettableFuture;
import com.stripe.bbpos.bbdevice.ota.BBDeviceControllerNotSetException;
import com.stripe.bbpos.bbdevice.ota.BBDeviceNotConnectedException;
import com.stripe.bbpos.bbdevice.ota.BBDeviceOTAController;
import com.stripe.bbpos.bbdevice.ota.NoInternetConnectionException;
import com.stripe.bbpos.bbdevice.ota.OTAServerURLNotSetException;
import com.stripe.core.bbpos.BbposDeviceOtaController;
import com.stripe.core.bbpos.BbposOtaListener;
import com.stripe.core.hardware.updates.ReaderUpdateController;
import com.stripe.core.hardware.updates.ReaderUpdateException;
import com.stripe.core.hardware.updates.ReaderUpdateListener;
import com.stripe.core.stripeterminal.log.AndroidLog;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J8\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0002J\u0014\u0010\u0015\u001a\u00020\u000b2\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0016J\u001c\u0010\u001b\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u001c\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0016J\u0006\u0010\u001d\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/stripe/core/bbpos/BbposReaderUpdateController;", "Lcom/stripe/core/hardware/updates/ReaderUpdateController;", "otaController", "Lcom/stripe/core/bbpos/BbposDeviceOtaController;", "listener", "Lcom/stripe/core/hardware/updates/ReaderUpdateListener;", "otaListener", "Lcom/stripe/core/bbpos/BbposOtaListener;", "(Lcom/stripe/core/bbpos/BbposDeviceOtaController;Lcom/stripe/core/hardware/updates/ReaderUpdateListener;Lcom/stripe/core/bbpos/BbposOtaListener;)V", "targetVersionFuture", "Lcom/google/common/util/concurrent/SettableFuture;", "", "cancel", "checkForUpdates", "createSetTargetVersionData", "Ljava/util/Hashtable;", "", "", "keyProfile", "configVersion", "firmwareVersion", "handleException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "installConfig", "updateHex", "installFirmware", "installKeys", "onSetTargetVersion", "Companion", "sdk_release"})
public final class BbposReaderUpdateController
implements ReaderUpdateController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BbposDeviceOtaController otaController;
    @NotNull
    private final ReaderUpdateListener listener;
    @Nullable
    private SettableFuture<Unit> targetVersionFuture;
    @NotNull
    private static final String TAG = "BbposUpdateController";
    private static final long TIMEOUT_DELAY_SEC = 60L;
    @NotNull
    private static final String ENC_HEX = "encHex";
    @NotNull
    private static final Map<String, String> UPDATE_PARAMS;

    public BbposReaderUpdateController(@NotNull BbposDeviceOtaController otaController, @NotNull ReaderUpdateListener listener2, @NotNull BbposOtaListener otaListener) {
        Intrinsics.checkNotNullParameter((Object)otaController, (String)"otaController");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)otaListener, (String)"otaListener");
        this.otaController = otaController;
        this.listener = listener2;
        otaListener.setUpdateController$sdk_release(this);
    }

    @Override
    public void cancel() {
        AndroidLog.INSTANCE.i(TAG, "cancelUpdates");
        try {
            this.otaController.stop();
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void checkForUpdates() {
        AndroidLog.INSTANCE.i(TAG, "checkForReaderUpdates");
        try {
            this.otaController.getTargetVersionWithData(new Hashtable<String, String>(UPDATE_PARAMS));
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void installConfig(@Nullable String configVersion, @Nullable String updateHex) {
        AndroidLog.INSTANCE.i(TAG, "installReaderConfig");
        try {
            if (configVersion == null && updateHex == null) {
                throw new IllegalArgumentException("Must include either configVersion or updateHex");
            }
            String string = configVersion;
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.targetVersionFuture = SettableFuture.create();
                this.otaController.setTargetVersionWithData(BbposReaderUpdateController.createSetTargetVersionData$default(this, null, it, null, 5, null));
                SettableFuture<Unit> settableFuture = this.targetVersionFuture;
                if (settableFuture != null) {
                    Unit cfr_ignored_0 = (Unit)settableFuture.get(60L, TimeUnit.SECONDS);
                }
            }
            Hashtable<String, Object> data = new Hashtable<String, Object>(UPDATE_PARAMS);
            String string2 = updateHex;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                ((Map)data).put(ENC_HEX, it);
            }
            this.otaController.startRemoteConfigUpdate(data);
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void installFirmware(@Nullable String firmwareVersion, @Nullable String updateHex) {
        AndroidLog.INSTANCE.i(TAG, "installReaderFirmware");
        try {
            if (firmwareVersion == null && updateHex == null) {
                throw new IllegalArgumentException("Must include either firmwareVersion or updateHex");
            }
            String string = firmwareVersion;
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.targetVersionFuture = SettableFuture.create();
                this.otaController.setTargetVersionWithData(BbposReaderUpdateController.createSetTargetVersionData$default(this, null, null, it, 3, null));
                SettableFuture<Unit> settableFuture = this.targetVersionFuture;
                if (settableFuture != null) {
                    Unit cfr_ignored_0 = (Unit)settableFuture.get(60L, TimeUnit.SECONDS);
                }
            }
            Hashtable<String, Object> data = new Hashtable<String, Object>(UPDATE_PARAMS);
            String string2 = updateHex;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                ((Map)data).put(ENC_HEX, it);
            }
            this.otaController.startRemoteFirmwareUpdate(data);
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void installKeys(@Nullable String keyProfile) {
        AndroidLog.INSTANCE.i(TAG, "installReaderKeys");
        try {
            if (keyProfile != null) {
                this.targetVersionFuture = SettableFuture.create();
                this.otaController.setTargetVersionWithData(BbposReaderUpdateController.createSetTargetVersionData$default(this, keyProfile, null, null, 6, null));
                SettableFuture<Unit> settableFuture = this.targetVersionFuture;
                if (settableFuture != null) {
                    Unit cfr_ignored_0 = (Unit)settableFuture.get(60L, TimeUnit.SECONDS);
                }
            }
            this.otaController.startRemoteKeyInjection(new Hashtable<String, Object>(UPDATE_PARAMS));
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }

    public final void onSetTargetVersion() {
        block0: {
            SettableFuture<Unit> settableFuture = this.targetVersionFuture;
            if (settableFuture == null) break block0;
            settableFuture.set((Object)Unit.INSTANCE);
        }
    }

    private final Hashtable<String, Object> createSetTargetVersionData(String keyProfile, String configVersion, String firmwareVersion) {
        Pair[] pairArray;
        String it;
        Map map2;
        Map $this$createSetTargetVersionData_u24lambda_u247 = map2 = MapsKt.toMutableMap(UPDATE_PARAMS);
        boolean bl = false;
        $this$createSetTargetVersionData_u24lambda_u247.put("applyToAll", "false");
        String string = keyProfile;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            pairArray = new Pair[]{TuplesKt.to((Object)"keyProfileName", (Object)it), TuplesKt.to((Object)"listType", (Object)((Object)BBDeviceOTAController.TargetVersionType.KEY_PROFILE))};
            $this$createSetTargetVersionData_u24lambda_u247.putAll(MapsKt.mapOf((Pair[])pairArray));
        }
        String string2 = configVersion;
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            pairArray = new Pair[]{TuplesKt.to((Object)"deviceSettingVersion", (Object)it), TuplesKt.to((Object)"terminalSettingVersion", (Object)it), TuplesKt.to((Object)"listType", (Object)((Object)BBDeviceOTAController.TargetVersionType.CONFIG))};
            $this$createSetTargetVersionData_u24lambda_u247.putAll(MapsKt.mapOf((Pair[])pairArray));
        }
        String string3 = firmwareVersion;
        if (string3 != null) {
            it = string3;
            boolean bl4 = false;
            pairArray = new Pair[]{TuplesKt.to((Object)"firmwareVersion", (Object)it), TuplesKt.to((Object)"listType", (Object)((Object)BBDeviceOTAController.TargetVersionType.FIRMWARE))};
            $this$createSetTargetVersionData_u24lambda_u247.putAll(MapsKt.mapOf((Pair[])pairArray));
        }
        Map map3 = map2;
        return new Hashtable<String, Object>(map3);
    }

    static /* synthetic */ Hashtable createSetTargetVersionData$default(BbposReaderUpdateController bbposReaderUpdateController, String string, String string2, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        return bbposReaderUpdateController.createSetTargetVersionData(string, string2, string3);
    }

    private final void handleException(Exception e2) {
        SettableFuture<Unit> settableFuture = this.targetVersionFuture;
        if (settableFuture != null) {
            settableFuture.setException((Throwable)e2);
        }
        Exception exception = e2;
        ReaderUpdateException readerUpdateException = exception instanceof BBDeviceControllerNotSetException ? (ReaderUpdateException)new ReaderUpdateException.UpdateFailed("Update failed due to configuration error", e2) : (exception instanceof OTAServerURLNotSetException ? (ReaderUpdateException)new ReaderUpdateException.UpdateFailed("Update failed due to configuration error", e2) : (exception instanceof BBDeviceNotConnectedException ? (ReaderUpdateException)new ReaderUpdateException.NotConnectedToReader("Update failed since there is no connected reader", e2) : (exception instanceof NoInternetConnectionException ? (ReaderUpdateException)new ReaderUpdateException.UpdateFailedServerError("Update failed due to lack of internet connection", e2) : (exception instanceof TimeoutException ? (ReaderUpdateException)new ReaderUpdateException.UpdateFailedReaderError("Reader timed out during update", e2) : (exception instanceof IllegalArgumentException ? (ReaderUpdateException)new ReaderUpdateException.UpdateFailed("Attempt to install invalid configuration", e2) : (ReaderUpdateException)new ReaderUpdateException.UpdateFailed("Update failed for unknown reason", e2))))));
        this.listener.handleReaderUpdateException(readerUpdateException);
        throw readerUpdateException;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"forceUpdate", (Object)"true"), TuplesKt.to((Object)"vendorID", (Object)"bbpos1"), TuplesKt.to((Object)"vendorSecret", (Object)"bbpos1"), TuplesKt.to((Object)"appID", (Object)"bbpos2"), TuplesKt.to((Object)"appSecret", (Object)"bbpos2")};
        UPDATE_PARAMS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/core/bbpos/BbposReaderUpdateController$Companion;", "", "()V", "ENC_HEX", "", "TAG", "TIMEOUT_DELAY_SEC", "", "UPDATE_PARAMS", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

