/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware;

import android.bluetooth.BluetoothDevice;
import androidx.annotation.CallSuper;
import com.stripe.bbpos.sdk.CardData;
import com.stripe.bbpos.sdk.CheckCardMode;
import com.stripe.bbpos.sdk.CheckCardResult;
import com.stripe.bbpos.sdk.ContactlessStatusTone;
import com.stripe.bbpos.sdk.DeviceInfo;
import com.stripe.bbpos.sdk.DisplayText;
import com.stripe.bbpos.sdk.Error;
import com.stripe.bbpos.sdk.ManualPanEntryType;
import com.stripe.bbpos.sdk.PinData;
import com.stripe.bbpos.sdk.PinEntryResult;
import com.stripe.bbpos.sdk.PinEntrySource;
import com.stripe.bbpos.sdk.PinPadTouchEvent;
import com.stripe.bbpos.sdk.TerminalSettingValue;
import com.stripe.bbpos.sdk.TransactionResult;
import com.stripe.core.bbpos.hardware.BBPOSLogHelper;
import com.stripe.core.bbpos.hardware.BbposReaderInfoFactory;
import com.stripe.core.bbpos.hardware.api.AmountInputResult;
import com.stripe.core.bbpos.hardware.api.BatteryStatus;
import com.stripe.core.bbpos.hardware.api.DeviceListenerWrapper;
import com.stripe.core.bbpos.hardware.api.DeviceResetReason;
import com.stripe.core.bbpos.hardware.api.SessionError;
import com.stripe.core.bbpos.hardware.api.TerminalSettingStatus;
import com.stripe.core.bbpos.hardware.discovery.BbposBluetoothDiscoveryFilter;
import com.stripe.core.featureflag.dagger.DebugLogsShouldBeSentToSplunk;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.status.ReaderStatusListener;
import com.stripe.core.stripeterminal.log.AndroidLog;
import com.stripe.jvmcore.hardware.emv.ConfigurationListener;
import com.stripe.jvmcore.hardware.emv.ReaderSettings;
import com.stripe.jvmcore.hardware.status.BbposTamper;
import com.stripe.jvmcore.hardware.status.DisconnectCause;
import com.stripe.jvmcore.hardware.status.ReaderException;
import com.stripe.jvmcore.logging.terminal.log.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0002\u0092\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0012J\u0016\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H&J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0017J\"\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0018\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020*2\u0006\u00100\u001a\u00020\"H\u0016J\u0018\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020*H\u0016J\b\u00105\u001a\u00020\u0012H\u0016J\u0010\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020*H\u0016J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020\u0012H\u0016J\u0016\u0010B\u001a\u00020\u00122\f\u0010C\u001a\b\u0012\u0004\u0012\u00020*0\u001bH\u0016J\u0010\u0010D\u001a\u00020\u00122\u0006\u0010E\u001a\u00020FH\u0016J$\u0010G\u001a\u00020\u00122\u0006\u0010,\u001a\u00020H2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*0JH\u0016J\u0010\u0010K\u001a\u00020\u00122\u0006\u0010:\u001a\u00020*H\u0016J\u0010\u0010L\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\fH\u0016J\u0018\u0010M\u001a\u00020\u00122\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0016J\u001e\u0010R\u001a\u00020\u00122\u0014\u0010S\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020T\u0018\u00010JH\u0016J$\u0010U\u001a\u00020\u00122\u0006\u0010V\u001a\u00020W2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*0JH\u0016J\u0010\u0010Y\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\fH\u0016J$\u0010Z\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\f2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*0JH\u0016J\u0018\u0010[\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0016J\u001c\u0010_\u001a\u00020\u00122\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020T0JH\u0016J\u00c8\u0001\u0010`\u001a\u00020\u00122\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020b2\u0006\u0010d\u001a\u00020b2\u0006\u0010e\u001a\u00020b2\u0006\u0010f\u001a\u00020b2\u0006\u0010g\u001a\u00020b2\u0006\u0010h\u001a\u00020b2\u0006\u0010i\u001a\u00020b2\u0006\u0010j\u001a\u00020b2\u0006\u0010k\u001a\u00020b2\u0006\u0010l\u001a\u00020b2\u0006\u0010m\u001a\u00020b2\u0006\u0010n\u001a\u00020b2\u0006\u0010o\u001a\u00020b2\u0006\u0010p\u001a\u00020b2\u0006\u0010q\u001a\u00020b2\u0006\u0010r\u001a\u00020b2\u0006\u0010s\u001a\u00020b2\u0006\u0010t\u001a\u00020b2\u0006\u0010u\u001a\u00020b2\u0006\u0010v\u001a\u00020b2\u0006\u0010w\u001a\u00020b2\u0006\u0010x\u001a\u00020b2\u0006\u0010y\u001a\u00020bH\u0016J\u0010\u0010z\u001a\u00020\u00122\u0006\u0010:\u001a\u00020*H\u0016J\u0010\u0010{\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\fH\u0016J\u0010\u0010|\u001a\u00020\u00122\u0006\u0010,\u001a\u00020}H\u0016J\u001c\u0010~\u001a\u00020\u00122\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u007f0JH\u0016J\u001a\u0010\u0080\u0001\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\f2\u0007\u0010\u0081\u0001\u001a\u00020*H\u0016J\u0012\u0010\u0082\u0001\u001a\u00020\u00122\u0007\u0010\u0083\u0001\u001a\u00020\u007fH\u0016J\u001d\u0010\u0084\u0001\u001a\u00020\u00122\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u007f0JH\u0016J\t\u0010\u0085\u0001\u001a\u00020\u0012H\u0016J\t\u0010\u0086\u0001\u001a\u00020\u0012H\u0016J\u001b\u0010\u0087\u0001\u001a\u00020\u00122\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0006\u0010)\u001a\u00020*H\u0016J\t\u0010\u008a\u0001\u001a\u00020\u0012H\u0016J\t\u0010\u008b\u0001\u001a\u00020\u0012H\u0016J\t\u0010\u008c\u0001\u001a\u00020\u0012H\u0016J\u0013\u0010\u008d\u0001\u001a\u00020\u00122\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0016J\u0016\u0010\u0090\u0001\u001a\u00030\u0091\u0001*\u00020(2\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0093\u0001"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposControllerListener;", "Lcom/stripe/core/bbpos/hardware/api/DeviceListenerWrapper;", "readerStatusListener", "Lcom/stripe/core/hardware/status/ReaderStatusListener;", "configurationListener", "Lcom/stripe/jvmcore/hardware/emv/ConfigurationListener;", "bbposReaderInfoFactory", "Lcom/stripe/core/bbpos/hardware/BbposReaderInfoFactory;", "discoveryFilter", "Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothDiscoveryFilter;", "debugLogsShouldBeSentToSplunk", "Ljavax/inject/Provider;", "", "loggerForTesting", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Lcom/stripe/core/hardware/status/ReaderStatusListener;Lcom/stripe/jvmcore/hardware/emv/ConfigurationListener;Lcom/stripe/core/bbpos/hardware/BbposReaderInfoFactory;Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothDiscoveryFilter;Ljavax/inject/Provider;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "logger", "onBatteryLow", "", "batteryStatus", "Lcom/stripe/core/bbpos/hardware/api/BatteryStatus;", "onBtConnected", "connectedDevice", "Landroid/bluetooth/BluetoothDevice;", "onBtDisconnected", "onBtReturnScanResults", "foundDevices", "", "onDeviceReset", "isSuccess", "reason", "Lcom/stripe/core/bbpos/hardware/api/DeviceResetReason;", "onDeviceResetAlert", "timeBeforeReset", "", "onDeviceTampered", "bbposTamper", "Lcom/stripe/jvmcore/hardware/status/BbposTamper;", "onError", "error", "Lcom/stripe/bbpos/sdk/Error;", "errorMessage", "", "onHardwareFunctionalTestResult", "result", "itemIndex", "onRequestDisplayAsterisk", "unmaskedDigits", "numOfAsterisk", "onRequestDisplayText", "displayText", "Lcom/stripe/bbpos/sdk/DisplayText;", "displayTextLanguage", "onRequestFinalConfirm", "onRequestManualPanEntry", "manualPanEntry", "Lcom/stripe/bbpos/sdk/ManualPanEntryType;", "onRequestOnlineProcess", "tlv", "onRequestPinEntry", "pinEntrySource", "Lcom/stripe/bbpos/sdk/PinEntrySource;", "onRequestProduceAudioTone", "tone", "Lcom/stripe/bbpos/sdk/ContactlessStatusTone;", "onRequestSelectAccountType", "onRequestSelectApplication", "appList", "onReturnAccessiblePINPadTouchEvent", "pinPadTouchEvent", "Lcom/stripe/bbpos/sdk/PinPadTouchEvent;", "onReturnAmount", "Lcom/stripe/core/bbpos/hardware/api/AmountInputResult;", "data", "", "onReturnBatchData", "onReturnCancelCheckCardResult", "onReturnCheckCardResult", "checkCardResult", "Lcom/stripe/bbpos/sdk/CheckCardResult$Type;", "cardData", "Lcom/stripe/bbpos/sdk/CardData;", "onReturnDebugLog", "debugLog", "", "onReturnDeviceInfo", "deviceInfo", "Lcom/stripe/bbpos/sdk/DeviceInfo;", "rawReaderData", "onReturnDisableInputAmountResult", "onReturnEncryptDataResult", "onReturnPinEntryResult", "Lcom/stripe/bbpos/sdk/PinEntryResult$Type;", "pinData", "Lcom/stripe/bbpos/sdk/PinData;", "onReturnReadAidResult", "onReturnReadTerminalSettingResult", "acquirerIdentifier", "Lcom/stripe/bbpos/sdk/TerminalSettingValue;", "terminalCountryCode", "transactionCurrencyCode", "transactionCurrencyExponent", "merchantNameAndLocation", "merchantIdentifier", "terminalIdentification", "terminalCapabilities", "terminalType", "additionalTerminalCapabilities", "normalModeTimeout", "standbyModeTimeout", "bluetoothDiscoveryTimeout", "msrPinEntryTimeout", "firmwareFallbackEnabled", "customBluetoothNamePrefix", "customBluetoothSerialSuffix", "firmwareForceChipEnabled", "iccTransactionBeepEnabled", "keypadEventBeepEnabled", "spocModeEnabled", "domesticDebitAidList", "visaDynamicReaderLimit", "buzzerSoundEnabled", "onReturnReversalData", "onReturnSetPinPadButtonsResult", "onReturnTransactionResult", "Lcom/stripe/bbpos/sdk/TransactionResult$Type;", "onReturnUpdateAidResult", "Lcom/stripe/core/bbpos/hardware/api/TerminalSettingStatus;", "onReturnUpdateDisplaySettingsResult", "message", "onReturnUpdateTerminalSettingResult", "status", "onReturnUpdateTerminalSettingsResult", "onSerialConnected", "onSerialDisconnected", "onSessionError", "sessionError", "Lcom/stripe/core/bbpos/hardware/api/SessionError;", "onSessionInitialized", "onUsbConnected", "onUsbDisconnected", "onWaitingForCard", "checkCardMode", "Lcom/stripe/bbpos/sdk/CheckCardMode;", "toDisconnectCause", "Lcom/stripe/jvmcore/hardware/status/DisconnectCause;", "BbposErrorMessage", "hardware_release"})
@SourceDebugExtension(value={"SMAP\nBbposControllerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposControllerListener.kt\ncom/stripe/core/bbpos/hardware/BbposControllerListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,445:1\n1603#2,9:446\n1855#2:455\n1856#2:457\n1612#2:458\n1#3:456\n187#4,3:459\n187#4,3:462\n*S KotlinDebug\n*F\n+ 1 BbposControllerListener.kt\ncom/stripe/core/bbpos/hardware/BbposControllerListener\n*L\n184#1:446,9\n184#1:455\n184#1:457\n184#1:458\n184#1:456\n405#1:459,3\n427#1:462,3\n*E\n"})
public abstract class BbposControllerListener
implements DeviceListenerWrapper {
    @NotNull
    private final ReaderStatusListener readerStatusListener;
    @NotNull
    private final ConfigurationListener configurationListener;
    @NotNull
    private final BbposReaderInfoFactory bbposReaderInfoFactory;
    @NotNull
    private final BbposBluetoothDiscoveryFilter discoveryFilter;
    @NotNull
    private final Provider<Boolean> debugLogsShouldBeSentToSplunk;
    @NotNull
    private final Log logger;

    public BbposControllerListener(@NotNull ReaderStatusListener readerStatusListener, @NotNull ConfigurationListener configurationListener, @NotNull BbposReaderInfoFactory bbposReaderInfoFactory, @NotNull BbposBluetoothDiscoveryFilter discoveryFilter, @DebugLogsShouldBeSentToSplunk @NotNull Provider<Boolean> debugLogsShouldBeSentToSplunk, @Nullable Log loggerForTesting) {
        Intrinsics.checkNotNullParameter((Object)readerStatusListener, (String)"readerStatusListener");
        Intrinsics.checkNotNullParameter((Object)configurationListener, (String)"configurationListener");
        Intrinsics.checkNotNullParameter((Object)bbposReaderInfoFactory, (String)"bbposReaderInfoFactory");
        Intrinsics.checkNotNullParameter((Object)discoveryFilter, (String)"discoveryFilter");
        Intrinsics.checkNotNullParameter(debugLogsShouldBeSentToSplunk, (String)"debugLogsShouldBeSentToSplunk");
        this.readerStatusListener = readerStatusListener;
        this.configurationListener = configurationListener;
        this.bbposReaderInfoFactory = bbposReaderInfoFactory;
        this.discoveryFilter = discoveryFilter;
        this.debugLogsShouldBeSentToSplunk = debugLogsShouldBeSentToSplunk;
        Log log = loggerForTesting;
        if (log == null) {
            log = Log.Companion.getLogger(BbposControllerListener.class);
        }
        this.logger = log;
    }

    public /* synthetic */ BbposControllerListener(ReaderStatusListener readerStatusListener, ConfigurationListener configurationListener, BbposReaderInfoFactory bbposReaderInfoFactory, BbposBluetoothDiscoveryFilter bbposBluetoothDiscoveryFilter, Provider provider, Log log, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            log = null;
        }
        this(readerStatusListener, configurationListener, bbposReaderInfoFactory, bbposBluetoothDiscoveryFilter, (Provider<Boolean>)provider, log);
    }

    private final DisconnectCause toDisconnectCause(Error $this$toDisconnectCause, String errorMessage) {
        DisconnectCause disconnectCause;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toDisconnectCause.ordinal()]) {
            case 1: {
                if (StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"The reader is already connected to another device", (boolean)false, (int)2, null)) {
                    disconnectCause = DisconnectCause.CONNECTED_TO_ANOTHER_DEVICE;
                    break;
                }
                disconnectCause = DisconnectCause.FAIL_TO_START_BLUETOOTH;
                break;
            }
            case 2: {
                if (StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"The reader is already connected to another device", (boolean)false, (int)2, null)) {
                    disconnectCause = DisconnectCause.CONNECTED_TO_ANOTHER_DEVICE;
                    break;
                }
                disconnectCause = DisconnectCause.FAIL_TO_START_USB;
                break;
            }
            case 3: {
                disconnectCause = DisconnectCause.USB_DEVICE_NOT_FOUND;
                break;
            }
            case 4: {
                disconnectCause = DisconnectCause.USB_DEVICE_PERMISSION_DENIED;
                break;
            }
            case 5: {
                disconnectCause = DisconnectCause.USB_NOT_SUPPORTED;
                break;
            }
            case 6: {
                disconnectCause = DisconnectCause.COMM_LINK_UNINITIALIZED;
                break;
            }
            default: {
                disconnectCause = DisconnectCause.UNKNOWN;
            }
        }
        return disconnectCause;
    }

    @Override
    public final void onBatteryLow(@NotNull BatteryStatus batteryStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        this.logger.i("onBatteryLow", new Pair[0]);
        this.readerStatusListener.handleLowBattery();
    }

    @Override
    @CallSuper
    public void onError(@NotNull Error error, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.logger.i("onError " + (Object)((Object)error) + ", " + errorMessage, new Pair[0]);
        switch (WhenMappings.$EnumSwitchMapping$0[error.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.readerStatusListener.handleReaderDisconnect(this.toDisconnectCause(error, errorMessage));
                break;
            }
            case 11: {
                this.readerStatusListener.handleDeviceBusy();
                break;
            }
            case 12: {
                BbposTamper bbposTamper;
                BbposTamper tamper = bbposTamper = BbposTamper.Companion.fromErrorMessage(errorMessage);
                boolean bl = false;
                this.onDeviceTampered(tamper);
                this.readerStatusListener.handleReaderException(tamper);
                break;
            }
            default: {
                BbposErrorMessage errorMsg = BbposErrorMessage.Companion.fromString(errorMessage);
                if (error == Error.INVALID_FUNCTION_IN_CURRENT_CONNECTION_MODE && errorMsg == BbposErrorMessage.USB_CONNECTION_WARNING_MSG) {
                    this.logger.i((Object)((Object)error) + ", continue the flow and fire onUsbConnected()", new Pair[0]);
                    this.onUsbConnected();
                    break;
                }
                if (error == Error.INVALID_FUNCTION_IN_CURRENT_CONNECTION_MODE && errorMsg == BbposErrorMessage.SERIAL_ALREADY_CONNECTED) {
                    this.logger.i((Object)((Object)error) + ", continue the flow and fire onSerialConnected()", new Pair[0]);
                    this.onSerialConnected();
                    break;
                }
                this.readerStatusListener.handleReaderException(new ReaderException(error.name() + ": " + errorMessage, null, 2, null));
            }
        }
    }

    public abstract void onDeviceTampered(@NotNull BbposTamper var1);

    @Override
    public void onReturnDebugLog(@Nullable Map<String, ? extends Object> debugLog) {
        String logString = BBPOSLogHelper.INSTANCE.toLogString(debugLog);
        Object object = this.debugLogsShouldBeSentToSplunk.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"debugLogsShouldBeSentToSplunk.get()");
        if (((Boolean)object).booleanValue()) {
            this.logger.i("onReturnDebugLog: " + BBPOSLogHelper.INSTANCE.toLogString(debugLog), new Pair[0]);
        } else {
            AndroidLog.INSTANCE.d("BbposControllerListener", "onReturnDebugLog: " + logString);
        }
    }

    @Override
    public void onDeviceResetAlert(int timeBeforeReset) {
        this.logger.i("onDeviceResetAlert timeBeforeReset=" + timeBeforeReset + " minutes", new Pair[0]);
    }

    @Override
    public void onDeviceReset(boolean isSuccess, @NotNull DeviceResetReason reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        this.logger.i("onDeviceReset isSuccess=" + isSuccess + " reason=" + (Object)((Object)reason), new Pair[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onBtReturnScanResults(@NotNull List<BluetoothDevice> foundDevices) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(foundDevices, (String)"foundDevices");
        Iterable iterable = foundDevices;
        BbposBluetoothDiscoveryFilter bbposBluetoothDiscoveryFilter = this.discoveryFilter;
        ReaderStatusListener readerStatusListener = this.readerStatusListener;
        boolean $i$f$mapNotNull = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Reader.BluetoothReader it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BluetoothDevice it = (BluetoothDevice)element$iv$iv;
            boolean bl2 = false;
            if (Reader.BluetoothReader.Companion.fromBluetoothDeviceOrNull(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        readerStatusListener.handleReaderDiscovery(CollectionsKt.toSet((Iterable)bbposBluetoothDiscoveryFilter.filterDevices(list)));
    }

    @Override
    public final void onBtConnected(@NotNull BluetoothDevice connectedDevice) {
        Intrinsics.checkNotNullParameter((Object)connectedDevice, (String)"connectedDevice");
        this.logger.i("onBTConnected", new Pair[0]);
        this.readerStatusListener.handleReaderConnect(Reader.BluetoothReader.Companion.fromBluetoothDevice(connectedDevice));
    }

    @Override
    public final void onBtDisconnected() {
        this.logger.i("onBTDisconnected", new Pair[0]);
        ReaderStatusListener.handleReaderDisconnect$default(this.readerStatusListener, null, 1, null);
    }

    @Override
    public void onUsbConnected() {
        this.logger.i("onUsbConnected", new Pair[0]);
        this.readerStatusListener.handleReaderConnect(Reader.UsbReader.UnspecifiedUsbReader.INSTANCE);
    }

    @Override
    public void onUsbDisconnected() {
        this.logger.i("onUsbDisconnected", new Pair[0]);
        ReaderStatusListener.handleReaderDisconnect$default(this.readerStatusListener, null, 1, null);
    }

    @Override
    public void onSerialConnected() {
        this.logger.i("onSerialConnected", new Pair[0]);
        this.readerStatusListener.handleReaderConnect(Reader.SerialReader.INSTANCE);
    }

    @Override
    public void onSerialDisconnected() {
        this.logger.i("onSerialDisconnected", new Pair[0]);
        ReaderStatusListener.handleReaderDisconnect$default(this.readerStatusListener, null, 1, null);
    }

    @Override
    public void onSessionInitialized() {
        this.logger.i("onSessionInitialized", new Pair[0]);
        this.readerStatusListener.handleSessionInitialized();
    }

    @Override
    public void onSessionError(@NotNull SessionError sessionError, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionError), (String)"sessionError");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.logger.i("onSessionError " + (Object)((Object)sessionError) + ", " + errorMessage, new Pair[0]);
        this.readerStatusListener.handleSessionException(new ReaderException(sessionError.name() + ": " + errorMessage, null, 2, null));
    }

    @Override
    public void onWaitingForCard(@NotNull CheckCardMode checkCardMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)checkCardMode), (String)"checkCardMode");
    }

    @Override
    public void onReturnCancelCheckCardResult(boolean isSuccess) {
    }

    @Override
    public void onReturnCheckCardResult(@NotNull CheckCardResult.Type checkCardResult, @NotNull CardData cardData) {
        Intrinsics.checkNotNullParameter((Object)((Object)checkCardResult), (String)"checkCardResult");
        Intrinsics.checkNotNullParameter((Object)((Object)cardData), (String)"cardData");
    }

    @Override
    public void onRequestSelectApplication(@NotNull List<String> appList) {
        Intrinsics.checkNotNullParameter(appList, (String)"appList");
    }

    @Override
    public void onRequestSelectAccountType() {
    }

    @Override
    public void onRequestFinalConfirm() {
    }

    @Override
    public void onRequestOnlineProcess(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
    }

    @Override
    public void onReturnBatchData(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
    }

    @Override
    public void onReturnReversalData(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
    }

    @Override
    public void onReturnTransactionResult(@NotNull TransactionResult.Type result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
    }

    @Override
    public void onRequestDisplayText(@NotNull DisplayText displayText, @NotNull String displayTextLanguage) {
        Intrinsics.checkNotNullParameter((Object)((Object)displayText), (String)"displayText");
        Intrinsics.checkNotNullParameter((Object)displayTextLanguage, (String)"displayTextLanguage");
    }

    @Override
    public void onRequestDisplayAsterisk(@NotNull String unmaskedDigits, int numOfAsterisk) {
        Intrinsics.checkNotNullParameter((Object)unmaskedDigits, (String)"unmaskedDigits");
    }

    @Override
    public void onReturnAccessiblePINPadTouchEvent(@NotNull PinPadTouchEvent pinPadTouchEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)pinPadTouchEvent), (String)"pinPadTouchEvent");
    }

    @Override
    public void onRequestProduceAudioTone(@NotNull ContactlessStatusTone tone) {
        Intrinsics.checkNotNullParameter((Object)((Object)tone), (String)"tone");
    }

    @Override
    public void onRequestPinEntry(@NotNull PinEntrySource pinEntrySource) {
        Intrinsics.checkNotNullParameter((Object)((Object)pinEntrySource), (String)"pinEntrySource");
    }

    @Override
    public void onReturnPinEntryResult(@NotNull PinEntryResult.Type result2, @NotNull PinData pinData) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        Intrinsics.checkNotNullParameter((Object)((Object)pinData), (String)"pinData");
    }

    @Override
    public void onReturnSetPinPadButtonsResult(boolean isSuccess) {
        this.logger.i("onReturnSetPinPadButtonsResult " + isSuccess, new Pair[0]);
    }

    @Override
    public void onReturnAmount(@NotNull AmountInputResult result2, @NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        Intrinsics.checkNotNullParameter(data, (String)"data");
    }

    @Override
    public void onReturnDisableInputAmountResult(boolean isSuccess) {
    }

    @Override
    public void onReturnDeviceInfo(@NotNull DeviceInfo deviceInfo, @NotNull Map<String, String> rawReaderData) {
        Intrinsics.checkNotNullParameter((Object)((Object)deviceInfo), (String)"deviceInfo");
        Intrinsics.checkNotNullParameter(rawReaderData, (String)"rawReaderData");
        this.logger.i("onReturnDeviceInfo " + rawReaderData, new Pair[0]);
        BbposReaderInfoFactory bbposReaderInfoFactory = this.bbposReaderInfoFactory;
        String string = deviceInfo.pinKsn;
        String string2 = deviceInfo.macKsn;
        String string3 = deviceInfo.emvKsn;
        String string4 = deviceInfo.trackKsn;
        String string5 = deviceInfo.batteryPercentage;
        String string6 = deviceInfo.terminalSettingVersion;
        String string7 = deviceInfo.deviceSettingVersion;
        String string8 = deviceInfo.bootloaderVersion;
        String string9 = deviceInfo.emvKeyProfileId;
        String string10 = deviceInfo.firmwareVersion;
        String string11 = deviceInfo.hardwareVersion;
        String string12 = deviceInfo.macKeyProfileId;
        String string13 = deviceInfo.pinKeyProfileId;
        String string14 = deviceInfo.serialNumber;
        String string15 = deviceInfo.trackKeyProfileId;
        String string16 = deviceInfo.isCharging;
        String string17 = deviceInfo.firmwareId;
        String string18 = deviceInfo.coinCellBatteryVoltage;
        this.readerStatusListener.handleDeviceInfo(bbposReaderInfoFactory.create(string, string3, string2, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, rawReaderData, null, string17, string18));
    }

    @Override
    public void onReturnReadTerminalSettingResult(@NotNull TerminalSettingValue acquirerIdentifier, @NotNull TerminalSettingValue terminalCountryCode, @NotNull TerminalSettingValue transactionCurrencyCode, @NotNull TerminalSettingValue transactionCurrencyExponent, @NotNull TerminalSettingValue merchantNameAndLocation, @NotNull TerminalSettingValue merchantIdentifier, @NotNull TerminalSettingValue terminalIdentification, @NotNull TerminalSettingValue terminalCapabilities, @NotNull TerminalSettingValue terminalType, @NotNull TerminalSettingValue additionalTerminalCapabilities, @NotNull TerminalSettingValue normalModeTimeout, @NotNull TerminalSettingValue standbyModeTimeout, @NotNull TerminalSettingValue bluetoothDiscoveryTimeout, @NotNull TerminalSettingValue msrPinEntryTimeout, @NotNull TerminalSettingValue firmwareFallbackEnabled, @NotNull TerminalSettingValue customBluetoothNamePrefix, @NotNull TerminalSettingValue customBluetoothSerialSuffix, @NotNull TerminalSettingValue firmwareForceChipEnabled, @NotNull TerminalSettingValue iccTransactionBeepEnabled, @NotNull TerminalSettingValue keypadEventBeepEnabled, @NotNull TerminalSettingValue spocModeEnabled, @NotNull TerminalSettingValue domesticDebitAidList, @NotNull TerminalSettingValue visaDynamicReaderLimit, @NotNull TerminalSettingValue buzzerSoundEnabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)acquirerIdentifier), (String)"acquirerIdentifier");
        Intrinsics.checkNotNullParameter((Object)((Object)terminalCountryCode), (String)"terminalCountryCode");
        Intrinsics.checkNotNullParameter((Object)((Object)transactionCurrencyCode), (String)"transactionCurrencyCode");
        Intrinsics.checkNotNullParameter((Object)((Object)transactionCurrencyExponent), (String)"transactionCurrencyExponent");
        Intrinsics.checkNotNullParameter((Object)((Object)merchantNameAndLocation), (String)"merchantNameAndLocation");
        Intrinsics.checkNotNullParameter((Object)((Object)merchantIdentifier), (String)"merchantIdentifier");
        Intrinsics.checkNotNullParameter((Object)((Object)terminalIdentification), (String)"terminalIdentification");
        Intrinsics.checkNotNullParameter((Object)((Object)terminalCapabilities), (String)"terminalCapabilities");
        Intrinsics.checkNotNullParameter((Object)((Object)terminalType), (String)"terminalType");
        Intrinsics.checkNotNullParameter((Object)((Object)additionalTerminalCapabilities), (String)"additionalTerminalCapabilities");
        Intrinsics.checkNotNullParameter((Object)((Object)normalModeTimeout), (String)"normalModeTimeout");
        Intrinsics.checkNotNullParameter((Object)((Object)standbyModeTimeout), (String)"standbyModeTimeout");
        Intrinsics.checkNotNullParameter((Object)((Object)bluetoothDiscoveryTimeout), (String)"bluetoothDiscoveryTimeout");
        Intrinsics.checkNotNullParameter((Object)((Object)msrPinEntryTimeout), (String)"msrPinEntryTimeout");
        Intrinsics.checkNotNullParameter((Object)((Object)firmwareFallbackEnabled), (String)"firmwareFallbackEnabled");
        Intrinsics.checkNotNullParameter((Object)((Object)customBluetoothNamePrefix), (String)"customBluetoothNamePrefix");
        Intrinsics.checkNotNullParameter((Object)((Object)customBluetoothSerialSuffix), (String)"customBluetoothSerialSuffix");
        Intrinsics.checkNotNullParameter((Object)((Object)firmwareForceChipEnabled), (String)"firmwareForceChipEnabled");
        Intrinsics.checkNotNullParameter((Object)((Object)iccTransactionBeepEnabled), (String)"iccTransactionBeepEnabled");
        Intrinsics.checkNotNullParameter((Object)((Object)keypadEventBeepEnabled), (String)"keypadEventBeepEnabled");
        Intrinsics.checkNotNullParameter((Object)((Object)spocModeEnabled), (String)"spocModeEnabled");
        Intrinsics.checkNotNullParameter((Object)((Object)domesticDebitAidList), (String)"domesticDebitAidList");
        Intrinsics.checkNotNullParameter((Object)((Object)visaDynamicReaderLimit), (String)"visaDynamicReaderLimit");
        Intrinsics.checkNotNullParameter((Object)((Object)buzzerSoundEnabled), (String)"buzzerSoundEnabled");
        this.logger.i("onReturnReadTerminalSettingResult", new Pair[0]);
        this.configurationListener.handleReaderSettings(new ReaderSettings(acquirerIdentifier.hexadecimal, terminalCountryCode.hexadecimal, transactionCurrencyCode.hexadecimal, transactionCurrencyExponent.hexadecimal, merchantNameAndLocation.hexadecimal, merchantIdentifier.hexadecimal, terminalIdentification.hexadecimal, terminalCapabilities.hexadecimal, terminalType.hexadecimal, additionalTerminalCapabilities.hexadecimal, normalModeTimeout.hexadecimal, standbyModeTimeout.hexadecimal, bluetoothDiscoveryTimeout.hexadecimal, msrPinEntryTimeout.hexadecimal, firmwareFallbackEnabled.hexadecimal, customBluetoothNamePrefix.hexadecimal, customBluetoothSerialSuffix.hexadecimal, firmwareForceChipEnabled.hexadecimal, iccTransactionBeepEnabled.hexadecimal, keypadEventBeepEnabled.hexadecimal, spocModeEnabled.hexadecimal, domesticDebitAidList.hexadecimal, visaDynamicReaderLimit.hexadecimal, buzzerSoundEnabled.hexadecimal));
    }

    @Override
    public void onReturnUpdateTerminalSettingResult(@NotNull TerminalSettingStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.logger.i("onReturnUpdateTerminalSettingResult", new Pair[0]);
        this.configurationListener.handleUpdateReaderSettings(status == TerminalSettingStatus.SUCCESS);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onReturnUpdateTerminalSettingsResult(@NotNull Map<String, ? extends TerminalSettingStatus> data) {
        block5: {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.logger.i("onReturnUpdateTerminalSettingsResult", new Pair[0]);
            if (data.isEmpty()) ** GOTO lbl-1000
            $this$any$iv = data;
            $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                v0 = false;
            } else {
                var5_4 = $this$any$iv.entrySet().iterator();
                while (var5_4.hasNext()) {
                    it = element$iv = var5_4.next();
                    $i$a$-any-BbposControllerListener$onReturnUpdateTerminalSettingsResult$failed$1 = false;
                    if (!(it.getValue() != TerminalSettingStatus.SUCCESS)) continue;
                    v0 = true;
                    break block5;
                }
                v0 = false;
            }
        }
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        failed = v1;
        this.configurationListener.handleUpdateReaderSettings(failed == false);
    }

    @Override
    public void onReturnUpdateDisplaySettingsResult(boolean isSuccess, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.i("onReturnUpdateDisplaySettingsResult", new Pair[0]);
        this.configurationListener.handleDisplaySettings(isSuccess);
    }

    @Override
    public void onReturnReadAidResult(@NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.logger.i("onReturnReadAIDResult", new Pair[0]);
        this.configurationListener.handleReaderAid(MapsKt.toMap(data));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onReturnUpdateAidResult(@NotNull Map<String, ? extends TerminalSettingStatus> data) {
        block5: {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.logger.i("onReturnUpdateAIDResult", new Pair[0]);
            if (data.isEmpty()) ** GOTO lbl-1000
            $this$any$iv = data;
            $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                v0 = false;
            } else {
                var5_4 = $this$any$iv.entrySet().iterator();
                while (var5_4.hasNext()) {
                    it = element$iv = var5_4.next();
                    $i$a$-any-BbposControllerListener$onReturnUpdateAidResult$failed$1 = false;
                    if (!(it.getValue() != TerminalSettingStatus.SUCCESS)) continue;
                    v0 = true;
                    break block5;
                }
                v0 = false;
            }
        }
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        failed = v1;
        this.configurationListener.handleUpdateReaderAidData(failed == false);
    }

    @Override
    public void onReturnEncryptDataResult(boolean isSuccess, @NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
    }

    @Override
    public void onHardwareFunctionalTestResult(int result2, int itemIndex, @Nullable String errorMessage) {
        StringBuilder stringBuilder = new StringBuilder().append("Functional test result <").append(result2).append("> for index <").append(itemIndex).append(">. ");
        String string = errorMessage;
        if (string == null) {
            string = "";
        }
        this.logger.d(stringBuilder.append(string).toString(), new Pair[0]);
    }

    @Override
    public void onRequestManualPanEntry(@NotNull ManualPanEntryType manualPanEntry) {
        Intrinsics.checkNotNullParameter((Object)((Object)manualPanEntry), (String)"manualPanEntry");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposControllerListener$BbposErrorMessage;", "", "msg", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getMsg", "()Ljava/lang/String;", "USB_CONNECTION_WARNING_MSG", "SERIAL_ALREADY_CONNECTED", "Companion", "hardware_release"})
    public static final class BbposErrorMessage
    extends Enum<BbposErrorMessage> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String msg;
        public static final /* enum */ BbposErrorMessage USB_CONNECTION_WARNING_MSG;
        public static final /* enum */ BbposErrorMessage SERIAL_ALREADY_CONNECTED;
        private static final /* synthetic */ BbposErrorMessage[] $VALUES;

        private BbposErrorMessage(String msg) {
            this.msg = msg;
        }

        @NotNull
        public final String getMsg() {
            return this.msg;
        }

        public static BbposErrorMessage[] values() {
            return (BbposErrorMessage[])$VALUES.clone();
        }

        public static BbposErrorMessage valueOf(String value) {
            return Enum.valueOf(BbposErrorMessage.class, value);
        }

        static {
            USB_CONNECTION_WARNING_MSG = new BbposErrorMessage("Cannot start USB again while USB is connected");
            SERIAL_ALREADY_CONNECTED = new BbposErrorMessage("Cannot start serial again while serial is connected");
            $VALUES = bbposErrorMessageArray = new BbposErrorMessage[]{BbposErrorMessage.USB_CONNECTION_WARNING_MSG, BbposErrorMessage.SERIAL_ALREADY_CONNECTED};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposControllerListener$BbposErrorMessage$Companion;", "", "()V", "fromString", "Lcom/stripe/core/bbpos/hardware/BbposControllerListener$BbposErrorMessage;", "msg", "", "hardware_release"})
        @SourceDebugExtension(value={"SMAP\nBbposControllerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposControllerListener.kt\ncom/stripe/core/bbpos/hardware/BbposControllerListener$BbposErrorMessage$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,445:1\n1282#2,2:446\n*S KotlinDebug\n*F\n+ 1 BbposControllerListener.kt\ncom/stripe/core/bbpos/hardware/BbposControllerListener$BbposErrorMessage$Companion\n*L\n74#1:446,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final BbposErrorMessage fromString(@NotNull String msg) {
                BbposErrorMessage bbposErrorMessage;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                    BbposErrorMessage[] $this$firstOrNull$iv = BbposErrorMessage.values();
                    boolean $i$f$firstOrNull = false;
                    int n2 = $this$firstOrNull$iv.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        BbposErrorMessage element$iv;
                        BbposErrorMessage it = element$iv = $this$firstOrNull$iv[i2];
                        boolean bl = false;
                        if (!StringsKt.equals((String)it.getMsg(), (String)msg, (boolean)true)) continue;
                        bbposErrorMessage = element$iv;
                        break block1;
                    }
                    bbposErrorMessage = null;
                }
                return bbposErrorMessage;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Error.values().length];
            try {
                nArray[Error.FAIL_TO_START_BT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.FAIL_TO_START_USB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.USB_DEVICE_NOT_FOUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.USB_DEVICE_PERMISSION_DENIED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.USB_NOT_SUPPORTED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.COMM_LINK_UNINITIALIZED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.AUDIO_PERMISSION_DENIED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.FAIL_TO_START_AUDIO.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.FAIL_TO_START_SERIAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.SERIAL_PERMISSION_DENIED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.DEVICE_BUSY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Error.TAMPER.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

