/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware;

import android.util.Base64;
import com.stripe.bbpos.sdk.Error;
import com.stripe.core.bbpos.hardware.BbposControllerListener;
import com.stripe.core.bbpos.hardware.BbposManagementListener;
import com.stripe.core.bbpos.hardware.BbposReaderInfoFactory;
import com.stripe.core.bbpos.hardware.discovery.BbposBluetoothDiscoveryFilter;
import com.stripe.core.bytearray.Extensions;
import com.stripe.core.hardware.ReaderEncryptionController;
import com.stripe.core.hardware.management.SignedDataListener;
import com.stripe.core.hardware.status.ReaderStatusListener;
import com.stripe.jvmcore.hardware.emv.ConfigurationListener;
import com.stripe.jvmcore.hardware.status.BbposTamper;
import com.stripe.jvmcore.hardware.status.TamperType;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.StructuredEventLogger;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.bbpos.BbposDomain;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.bbpos.BbposSdkScope;
import com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.EventData;
import com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.device.TamperModeEvent;
import java.util.Map;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\"\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0005j\u0002`\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J$\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00172\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0%H\u0016J\b\u0010&\u001a\u00020\u001aH\u0016R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0005j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/stripe/core/bbpos/hardware/BbposManagementListener;", "Lcom/stripe/core/bbpos/hardware/BbposControllerListener;", "signedDataListener", "Lcom/stripe/core/hardware/management/SignedDataListener;", "bbposSdkEventLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/BbposDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/BbposDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/BbposSdkScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/BbposSdkScope$Builder;", "Lcom/stripe/core/bbpos/hardware/BbposSdkEventLogger;", "structuredEventLogger", "Lcom/stripe/jvmcore/logging/StructuredEventLogger;", "readerStatusListener", "Lcom/stripe/core/hardware/status/ReaderStatusListener;", "configurationListener", "Lcom/stripe/jvmcore/hardware/emv/ConfigurationListener;", "bbposReaderInfoFactory", "Lcom/stripe/core/bbpos/hardware/BbposReaderInfoFactory;", "discoveryFilter", "Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothDiscoveryFilter;", "debugLogsShouldBeSentToSplunk", "Ljavax/inject/Provider;", "", "(Lcom/stripe/core/hardware/management/SignedDataListener;Lcom/stripe/jvmcore/logging/HealthLogger;Lcom/stripe/jvmcore/logging/StructuredEventLogger;Lcom/stripe/core/hardware/status/ReaderStatusListener;Lcom/stripe/jvmcore/hardware/emv/ConfigurationListener;Lcom/stripe/core/bbpos/hardware/BbposReaderInfoFactory;Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothDiscoveryFilter;Ljavax/inject/Provider;)V", "onDeviceTampered", "", "bbposTamper", "Lcom/stripe/jvmcore/hardware/status/BbposTamper;", "onError", "error", "Lcom/stripe/bbpos/sdk/Error;", "errorMessage", "", "onReturnEncryptDataResult", "isSuccess", "data", "", "onSerialConnected", "Companion", "hardware_release"})
public final class BbposManagementListener
extends BbposControllerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SignedDataListener signedDataListener;
    @NotNull
    private final HealthLogger<BbposDomain, BbposDomain.Builder, BbposSdkScope, BbposSdkScope.Builder> bbposSdkEventLogger;
    @NotNull
    private final StructuredEventLogger structuredEventLogger;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(BbposManagementListener.class);
    @NotNull
    private static final String OPEN_SERIAL_PORT_ERROR = "3101";
    @NotNull
    private static final String OPEN_SERIAL_PORT_TIMEOUT_ERROR = "3105";
    @NotNull
    private static final String OPEN_SERIAL_PORT_ERROR_MESSAGE = "open_serial_port_failed_3101";
    @NotNull
    private static final String OPEN_SERIAL_PORT_TIMEOUT_MESSAGE = "open_serial_port_timeout_3105";
    @NotNull
    private static final String UNKNOWN = "unknown";

    public BbposManagementListener(@NotNull SignedDataListener signedDataListener, @NotNull HealthLogger<BbposDomain, BbposDomain.Builder, BbposSdkScope, BbposSdkScope.Builder> bbposSdkEventLogger, @NotNull StructuredEventLogger structuredEventLogger, @NotNull ReaderStatusListener readerStatusListener, @NotNull ConfigurationListener configurationListener, @NotNull BbposReaderInfoFactory bbposReaderInfoFactory, @NotNull BbposBluetoothDiscoveryFilter discoveryFilter, @NotNull Provider<Boolean> debugLogsShouldBeSentToSplunk) {
        Intrinsics.checkNotNullParameter((Object)signedDataListener, (String)"signedDataListener");
        Intrinsics.checkNotNullParameter(bbposSdkEventLogger, (String)"bbposSdkEventLogger");
        Intrinsics.checkNotNullParameter((Object)structuredEventLogger, (String)"structuredEventLogger");
        Intrinsics.checkNotNullParameter((Object)readerStatusListener, (String)"readerStatusListener");
        Intrinsics.checkNotNullParameter((Object)configurationListener, (String)"configurationListener");
        Intrinsics.checkNotNullParameter((Object)bbposReaderInfoFactory, (String)"bbposReaderInfoFactory");
        Intrinsics.checkNotNullParameter((Object)discoveryFilter, (String)"discoveryFilter");
        Intrinsics.checkNotNullParameter(debugLogsShouldBeSentToSplunk, (String)"debugLogsShouldBeSentToSplunk");
        super(readerStatusListener, configurationListener, bbposReaderInfoFactory, discoveryFilter, debugLogsShouldBeSentToSplunk, null, 32, null);
        this.signedDataListener = signedDataListener;
        this.bbposSdkEventLogger = bbposSdkEventLogger;
        this.structuredEventLogger = structuredEventLogger;
    }

    @Override
    public void onReturnEncryptDataResult(boolean isSuccess, @NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        LOGGER.d("onReturnEncryptDataResult " + isSuccess, new Pair[0]);
        if (isSuccess) {
            String ksn = data.get("ksn");
            String mac = data.get("mac");
            if (mac != null && ksn != null) {
                LOGGER.d("Valid Signature Response data: " + data, new Pair[0]);
                String string = Base64.encodeToString((byte[])Extensions.INSTANCE.hexStringToByteArray(mac), (int)2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(mac.hexSt\u2026eArray(), Base64.NO_WRAP)");
                this.signedDataListener.handleSignedData(new SignedDataListener.SignedData(ksn, string, ReaderEncryptionController.EncryptionMethod.UNKNOWN));
            } else {
                LOGGER.d("Invalid Signature Response " + data, new Pair[0]);
                this.signedDataListener.handleSignedData(null);
            }
        } else {
            LOGGER.d("Signing Failed " + data, new Pair[0]);
            this.signedDataListener.handleSignedData(null);
        }
    }

    @Override
    public void onSerialConnected() {
        super.onSerialConnected();
        HealthLogger.incrementCounter$default(this.bbposSdkEventLogger, Outcome.Ok.INSTANCE, null, null, onSerialConnected.1.INSTANCE, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onError(@NotNull Error error, @NotNull String errorMessage) {
        block0: {
            void it;
            Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            super.onError(error, errorMessage);
            if (WhenMappings.$EnumSwitchMapping$0[error.ordinal()] != 1) break block0;
            LOGGER.d("FAIL_TO_START_SERIAL: " + errorMessage, new Pair[0]);
            String string = errorMessage;
            String string2 = "reason";
            Outcome outcome = Outcome.GenericError.INSTANCE;
            HealthLogger<BbposDomain, BbposDomain.Builder, BbposSdkScope, BbposSdkScope.Builder> healthLogger2 = this.bbposSdkEventLogger;
            boolean bl = false;
            String string3 = StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)OPEN_SERIAL_PORT_ERROR, (boolean)false, (int)2, null) ? OPEN_SERIAL_PORT_ERROR_MESSAGE : (StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)OPEN_SERIAL_PORT_TIMEOUT_ERROR, (boolean)false, (int)2, null) ? OPEN_SERIAL_PORT_TIMEOUT_MESSAGE : UNKNOWN);
            HealthLogger.incrementCounter$default(healthLogger2, outcome, MapsKt.mapOf((Pair)TuplesKt.to((Object)string2, (Object)string3)), null, onError.2.INSTANCE, 4, null);
        }
    }

    @Override
    public void onDeviceTampered(@NotNull BbposTamper bbposTamper) {
        com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.device.TamperType tamperType;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)bbposTamper, (String)"bbposTamper");
        String string3 = bbposTamper.getMode();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = bbposTamper.getStatus()) == null) {
            string2 = "";
        }
        if ((string = bbposTamper.getTime()) == null) {
            string = "";
        }
        switch (WhenMappings.$EnumSwitchMapping$1[bbposTamper.getTamperType().ordinal()]) {
            case 1: {
                tamperType = com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.device.TamperType.CONFIG_INTEGRITY_CHECK;
                break;
            }
            case 2: {
                tamperType = com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.device.TamperType.FIRMWARE_INTEGRITY_CHECK;
                break;
            }
            case 3: {
                tamperType = com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.device.TamperType.KEY_INTEGRITY_CHECK;
                break;
            }
            case 4: {
                tamperType = com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.device.TamperType.UNRECOVERABLE_TAMPER;
                break;
            }
            case 5: {
                tamperType = com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.device.TamperType.TAMPER_TYPE_INVALID;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        EventData eventData = new EventData(null, null, null, null, null, null, null, null, null, null, null, null, null, null, new TamperModeEvent(string3, string2, string, tamperType, null, 16, null), null, 49151, null);
        String string4 = BbposManagementListener.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"BbposManagementListener::class.java.simpleName");
        StructuredEventLogger.logStructuredEvent$default(this.structuredEventLogger, eventData, string4, null, 4, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposManagementListener$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "OPEN_SERIAL_PORT_ERROR", "", "OPEN_SERIAL_PORT_ERROR_MESSAGE", "OPEN_SERIAL_PORT_TIMEOUT_ERROR", "OPEN_SERIAL_PORT_TIMEOUT_MESSAGE", "UNKNOWN", "hardware_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Error.values().length];
            try {
                nArray[Error.FAIL_TO_START_SERIAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TamperType.values().length];
            try {
                nArray[TamperType.ConfigIntegrityCheck.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TamperType.FirmwareIntegrityCheck.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TamperType.KeyIntegrityCheck.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TamperType.UnrecoverableTamper.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TamperType.Unknown.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

