/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware;

import com.stripe.bbpos.sdk.CardData;
import com.stripe.bbpos.sdk.CheckCardMode;
import com.stripe.bbpos.sdk.CheckCardResult;
import com.stripe.bbpos.sdk.ContactlessStatusTone;
import com.stripe.bbpos.sdk.DisplayText;
import com.stripe.bbpos.sdk.Error;
import com.stripe.bbpos.sdk.ManualPanEntryType;
import com.stripe.bbpos.sdk.PinData;
import com.stripe.bbpos.sdk.PinEntryResult;
import com.stripe.bbpos.sdk.PinEntrySource;
import com.stripe.bbpos.sdk.TransactionResult;
import com.stripe.core.bbpos.hardware.BbposControllerListener;
import com.stripe.core.bbpos.hardware.BbposPaymentCollectionListener;
import com.stripe.core.bbpos.hardware.BbposReaderInfoFactory;
import com.stripe.core.bbpos.hardware.BbposTranslation;
import com.stripe.core.bbpos.hardware.CardRemovalChecker;
import com.stripe.core.bbpos.hardware.api.AmountInputResult;
import com.stripe.core.bbpos.hardware.discovery.BbposBluetoothDiscoveryFilter;
import com.stripe.core.bbpos.hardware.emv.CheckCardModeConverter;
import com.stripe.core.featureflag.dagger.DebugLogsShouldBeSentToSplunk;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.dagger.BluetoothUsbPinPadReaders;
import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.hardware.paymentcollection.ManualEntryEventReceiver;
import com.stripe.core.hardware.paymentcollection.ManualEntryType;
import com.stripe.core.hardware.paymentcollection.PaymentEventReceiver;
import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.hardware.status.ReaderStatusListener;
import com.stripe.core.hardware.tipping.BbposSdkTipSelectionType;
import com.stripe.core.hardware.tipping.Custom;
import com.stripe.core.hardware.tipping.FixedAmount;
import com.stripe.core.hardware.tipping.NoTipSelected;
import com.stripe.core.hardware.tipping.Percentage;
import com.stripe.core.hardware.tipping.TipSelected;
import com.stripe.core.hardware.tipping.TipSelectionFailure;
import com.stripe.core.hardware.tipping.TipSelectionResult;
import com.stripe.core.hardware.tipping.TippingSelectionFailureReason;
import com.stripe.core.hardware.tipping.Unknown;
import com.stripe.jvmcore.hardware.emv.ConfigurationListener;
import com.stripe.jvmcore.hardware.emv.IntermediateTransactionError;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadFailure;
import com.stripe.jvmcore.hardware.status.AudioAlertType;
import com.stripe.jvmcore.hardware.status.BbposTamper;
import com.stripe.jvmcore.hardware.status.ReaderDisplayMessage;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.HealthLoggerBuilder;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.bbpos.BbposDomain;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.bbpos.PaymentsScope;
import dagger.Lazy;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u007f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u0012\u000e\b\u0001\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020*2\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u000205H\u0016J\u0018\u00106\u001a\u00020*2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000201H\u0016J\b\u0010:\u001a\u00020*H\u0016J\u0010\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020*2\u0006\u0010?\u001a\u000201H\u0016J\u0010\u0010@\u001a\u00020*2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020*H\u0016J\u0016\u0010G\u001a\u00020*2\f\u0010H\u001a\b\u0012\u0004\u0012\u0002010IH\u0016J$\u0010J\u001a\u00020*2\u0006\u0010K\u001a\u00020L2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002010NH\u0017J\u0010\u0010O\u001a\u00020*2\u0006\u0010?\u001a\u000201H\u0016J\u0010\u0010P\u001a\u00020*2\u0006\u0010Q\u001a\u00020\u0017H\u0016J\u0018\u0010R\u001a\u00020*2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0016J\u0018\u0010W\u001a\u00020*2\u0006\u0010K\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020*2\u0006\u0010?\u001a\u000201H\u0016J\u0010\u0010\\\u001a\u00020*2\u0006\u0010Q\u001a\u00020\u0017H\u0016J\u0010\u0010]\u001a\u00020*2\u0006\u0010K\u001a\u00020^H\u0016J\b\u0010_\u001a\u00020*H\u0016J\u0010\u0010`\u001a\u00020*2\u0006\u0010a\u001a\u00020bH\u0016J\u000e\u0010c\u001a\u0004\u0018\u00010d*\u000208H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\n &*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006e"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposPaymentCollectionListener;", "Lcom/stripe/core/bbpos/hardware/BbposControllerListener;", "lazyPaymentEventReceiver", "Ldagger/Lazy;", "Lcom/stripe/core/hardware/paymentcollection/PaymentEventReceiver;", "lazyManualEntryEventReceiver", "Lcom/stripe/core/hardware/paymentcollection/ManualEntryEventReceiver;", "configurationListener", "Lcom/stripe/jvmcore/hardware/emv/ConfigurationListener;", "readerStatusListener", "Lcom/stripe/core/hardware/status/ReaderStatusListener;", "healthLoggerBuilder", "Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;", "bbposReaderInfoFactory", "Lcom/stripe/core/bbpos/hardware/BbposReaderInfoFactory;", "discoveryFilter", "Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothDiscoveryFilter;", "cardRemovalChecker", "Lcom/stripe/core/bbpos/hardware/CardRemovalChecker;", "connectedReaderProvider", "Ljavax/inject/Provider;", "Lcom/stripe/core/hardware/Reader;", "debugLogsShouldBeSentToSplunk", "", "loggerForTesting", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Ldagger/Lazy;Ldagger/Lazy;Lcom/stripe/jvmcore/hardware/emv/ConfigurationListener;Lcom/stripe/core/hardware/status/ReaderStatusListener;Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;Lcom/stripe/core/bbpos/hardware/BbposReaderInfoFactory;Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothDiscoveryFilter;Lcom/stripe/core/bbpos/hardware/CardRemovalChecker;Ljavax/inject/Provider;Ljavax/inject/Provider;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "healthLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/BbposDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/BbposDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/PaymentsScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/PaymentsScope$Builder;", "logger", "manualEntryEventReceiver", "getManualEntryEventReceiver", "()Lcom/stripe/core/hardware/paymentcollection/ManualEntryEventReceiver;", "paymentEventReceiver", "kotlin.jvm.PlatformType", "getPaymentEventReceiver", "()Lcom/stripe/core/hardware/paymentcollection/PaymentEventReceiver;", "onDeviceTampered", "", "bbposTamper", "Lcom/stripe/jvmcore/hardware/status/BbposTamper;", "onError", "error", "Lcom/stripe/bbpos/sdk/Error;", "errorMessage", "", "onRequestDisplayAsterisk", "unmaskedDigits", "numOfAsterisk", "", "onRequestDisplayText", "displayText", "Lcom/stripe/bbpos/sdk/DisplayText;", "displayTextLanguage", "onRequestFinalConfirm", "onRequestManualPanEntry", "manualPanEntry", "Lcom/stripe/bbpos/sdk/ManualPanEntryType;", "onRequestOnlineProcess", "tlv", "onRequestPinEntry", "pinEntrySource", "Lcom/stripe/bbpos/sdk/PinEntrySource;", "onRequestProduceAudioTone", "tone", "Lcom/stripe/bbpos/sdk/ContactlessStatusTone;", "onRequestSelectAccountType", "onRequestSelectApplication", "appList", "", "onReturnAmount", "result", "Lcom/stripe/core/bbpos/hardware/api/AmountInputResult;", "data", "", "onReturnBatchData", "onReturnCancelCheckCardResult", "isSuccess", "onReturnCheckCardResult", "checkCardResult", "Lcom/stripe/bbpos/sdk/CheckCardResult$Type;", "cardData", "Lcom/stripe/bbpos/sdk/CardData;", "onReturnPinEntryResult", "Lcom/stripe/bbpos/sdk/PinEntryResult$Type;", "pinData", "Lcom/stripe/bbpos/sdk/PinData;", "onReturnReversalData", "onReturnSetPinPadButtonsResult", "onReturnTransactionResult", "Lcom/stripe/bbpos/sdk/TransactionResult$Type;", "onSerialDisconnected", "onWaitingForCard", "checkCardMode", "Lcom/stripe/bbpos/sdk/CheckCardMode;", "toReaderDisplayMessage", "Lcom/stripe/jvmcore/hardware/status/ReaderDisplayMessage;", "hardware_release"})
@SourceDebugExtension(value={"SMAP\nBbposPaymentCollectionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposPaymentCollectionListener.kt\ncom/stripe/core/bbpos/hardware/BbposPaymentCollectionListener\n+ 2 HealthLogger.kt\ncom/stripe/jvmcore/logging/HealthLoggerBuilder\n+ 3 HealthLogger.kt\ncom/stripe/jvmcore/logging/HealthLoggerBuilder$DomainedBuilder\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,547:1\n436#2,4:548\n457#3,4:552\n1#4:556\n429#5:557\n502#5,5:558\n*S KotlinDebug\n*F\n+ 1 BbposPaymentCollectionListener.kt\ncom/stripe/core/bbpos/hardware/BbposPaymentCollectionListener\n*L\n76#1:548,4\n77#1:552,4\n471#1:557\n471#1:558,5\n*E\n"})
public final class BbposPaymentCollectionListener
extends BbposControllerListener {
    @NotNull
    private final Lazy<PaymentEventReceiver> lazyPaymentEventReceiver;
    @NotNull
    private final Lazy<ManualEntryEventReceiver> lazyManualEntryEventReceiver;
    @NotNull
    private final CardRemovalChecker cardRemovalChecker;
    @NotNull
    private final Provider<Reader> connectedReaderProvider;
    @NotNull
    private final Log logger;
    @NotNull
    private final HealthLogger<BbposDomain, BbposDomain.Builder, PaymentsScope, PaymentsScope.Builder> healthLogger;

    public BbposPaymentCollectionListener(@NotNull Lazy<PaymentEventReceiver> lazyPaymentEventReceiver, @NotNull Lazy<ManualEntryEventReceiver> lazyManualEntryEventReceiver, @NotNull ConfigurationListener configurationListener, @NotNull ReaderStatusListener readerStatusListener, @NotNull HealthLoggerBuilder healthLoggerBuilder, @NotNull BbposReaderInfoFactory bbposReaderInfoFactory, @NotNull BbposBluetoothDiscoveryFilter discoveryFilter, @NotNull CardRemovalChecker cardRemovalChecker, @NotNull Provider<Reader> connectedReaderProvider, @DebugLogsShouldBeSentToSplunk @NotNull Provider<Boolean> debugLogsShouldBeSentToSplunk, @Nullable Log loggerForTesting) {
        HealthLoggerBuilder.DomainedBuilder<BbposDomain, BbposDomain.Builder> this_$iv;
        Intrinsics.checkNotNullParameter(lazyPaymentEventReceiver, (String)"lazyPaymentEventReceiver");
        Intrinsics.checkNotNullParameter(lazyManualEntryEventReceiver, (String)"lazyManualEntryEventReceiver");
        Intrinsics.checkNotNullParameter((Object)configurationListener, (String)"configurationListener");
        Intrinsics.checkNotNullParameter((Object)readerStatusListener, (String)"readerStatusListener");
        Intrinsics.checkNotNullParameter((Object)healthLoggerBuilder, (String)"healthLoggerBuilder");
        Intrinsics.checkNotNullParameter((Object)bbposReaderInfoFactory, (String)"bbposReaderInfoFactory");
        Intrinsics.checkNotNullParameter((Object)discoveryFilter, (String)"discoveryFilter");
        Intrinsics.checkNotNullParameter((Object)cardRemovalChecker, (String)"cardRemovalChecker");
        Intrinsics.checkNotNullParameter(connectedReaderProvider, (String)"connectedReaderProvider");
        Intrinsics.checkNotNullParameter(debugLogsShouldBeSentToSplunk, (String)"debugLogsShouldBeSentToSplunk");
        super(readerStatusListener, configurationListener, bbposReaderInfoFactory, discoveryFilter, debugLogsShouldBeSentToSplunk, loggerForTesting);
        this.lazyPaymentEventReceiver = lazyPaymentEventReceiver;
        this.lazyManualEntryEventReceiver = lazyManualEntryEventReceiver;
        this.cardRemovalChecker = cardRemovalChecker;
        this.connectedReaderProvider = connectedReaderProvider;
        Log log = loggerForTesting;
        if (log == null) {
            log = Log.Companion.getLogger(BbposPaymentCollectionListener.class);
        }
        this.logger = log;
        HealthLoggerBuilder healthLoggerBuilder2 = healthLoggerBuilder;
        Function2 domainSetter$iv = healthLogger.1.INSTANCE;
        boolean $i$f$withDomain = false;
        this_$iv = new HealthLoggerBuilder.DomainedBuilder<BbposDomain, BbposDomain.Builder>((HealthLoggerBuilder)((Object)this_$iv), BbposDomain.class, BbposDomain.Builder.class, domainSetter$iv);
        Function2 scopeSetter$iv = healthLogger.2.INSTANCE;
        boolean $i$f$withScope = false;
        this.healthLogger = new HealthLoggerBuilder.DomainedBuilder.ScopedBuilder<PaymentsScope, PaymentsScope.Builder>(this_$iv, PaymentsScope.class, PaymentsScope.Builder.class, scopeSetter$iv).build();
    }

    public /* synthetic */ BbposPaymentCollectionListener(Lazy lazy, Lazy lazy2, ConfigurationListener configurationListener, ReaderStatusListener readerStatusListener, HealthLoggerBuilder healthLoggerBuilder, BbposReaderInfoFactory bbposReaderInfoFactory, BbposBluetoothDiscoveryFilter bbposBluetoothDiscoveryFilter, CardRemovalChecker cardRemovalChecker, Provider provider, Provider provider2, Log log, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x400) != 0) {
            log = null;
        }
        this((Lazy<PaymentEventReceiver>)lazy, (Lazy<ManualEntryEventReceiver>)lazy2, configurationListener, readerStatusListener, healthLoggerBuilder, bbposReaderInfoFactory, bbposBluetoothDiscoveryFilter, cardRemovalChecker, (Provider<Reader>)provider, (Provider<Boolean>)provider2, log);
    }

    private final PaymentEventReceiver getPaymentEventReceiver() {
        return (PaymentEventReceiver)this.lazyPaymentEventReceiver.get();
    }

    private final ManualEntryEventReceiver getManualEntryEventReceiver() {
        return (ManualEntryEventReceiver)this.lazyManualEntryEventReceiver.get();
    }

    @Override
    public void onWaitingForCard(@NotNull CheckCardMode checkCardMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)checkCardMode), (String)"checkCardMode");
        this.logger.i("onWaitingForCard " + (Object)((Object)checkCardMode), new Pair[0]);
        this.getPaymentEventReceiver().onReaderTypesChanged(CheckCardModeConverter.INSTANCE.toReaderConfiguration(checkCardMode));
    }

    @Override
    public void onReturnCancelCheckCardResult(boolean isSuccess) {
        this.logger.i("onReturnCancelCheckCardResult", new Pair[0]);
        this.getPaymentEventReceiver().onHardwareTransactionCanceled();
    }

    @Override
    public void onReturnCheckCardResult(@NotNull CheckCardResult.Type checkCardResult, @NotNull CardData cardData) {
        Intrinsics.checkNotNullParameter((Object)((Object)checkCardResult), (String)"checkCardResult");
        Intrinsics.checkNotNullParameter((Object)((Object)cardData), (String)"cardData");
        this.logger.i("onReturnCheckCardResult " + (Object)((Object)checkCardResult) + " cardData " + (Object)((Object)cardData), new Pair[0]);
        this.cardRemovalChecker.onCheckCardResult(checkCardResult);
        if (checkCardResult != CheckCardResult.Type.NO_CARD) {
            String string = checkCardResult.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            HealthLogger.incrementCounter$default(this.healthLogger, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"result", (Object)string)), null, onReturnCheckCardResult.1.INSTANCE, 5, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[checkCardResult.ordinal()]) {
            case 1: {
                this.getPaymentEventReceiver().onContactCardStateUpdate(ContactCardSlotState.EMPTY);
                break;
            }
            case 2: {
                this.getPaymentEventReceiver().onContactCardStateUpdate(ContactCardSlotState.CARD_INSERTED_CORRECTLY);
                break;
            }
            case 3: {
                this.getPaymentEventReceiver().onContactCardStateUpdate(ContactCardSlotState.CARD_INSERTED_INCORRECTLY);
                break;
            }
            case 4: {
                this.getPaymentEventReceiver().onCardSwiped(BbposTranslation.INSTANCE.extractMagStripeReadResult(cardData));
                this.getPaymentEventReceiver().onResetPaymentInterfaces();
                break;
            }
            case 5: {
                this.getPaymentEventReceiver().onCardSwiped(new MagStripeReadFailure(MagStripeReadFailure.FailureType.BAD_SWIPE));
                this.getPaymentEventReceiver().onResetPaymentInterfaces();
                break;
            }
            case 6: {
                this.getPaymentEventReceiver().onCardSwiped(new MagStripeReadFailure(MagStripeReadFailure.FailureType.BAD_SWIPE));
                this.getPaymentEventReceiver().onResetPaymentInterfaces();
                break;
            }
            case 7: {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                String string10;
                ManualEntryEventReceiver manualEntryEventReceiver = this.getManualEntryEventReceiver();
                if (manualEntryEventReceiver == null) break;
                String string11 = cardData.encCvv;
                if (string11 == null) {
                    string11 = string10 = "";
                }
                if ((string9 = cardData.encPan) == null) {
                    string9 = string8 = "";
                }
                if ((string7 = cardData.expiryDate) == null) {
                    string7 = string6 = "";
                }
                if ((string5 = cardData.maskedPan) == null) {
                    string5 = string4 = "";
                }
                if ((string3 = cardData.ksn) == null) {
                    string3 = string2 = "";
                }
                if ((string = cardData.posEntryMode) == null) {
                    string = "";
                }
                String string12 = string;
                manualEntryEventReceiver.onEncryptedDataCollected(string8, string6, string10, string4, string2, string12);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
            }
        }
    }

    @Override
    public void onRequestSelectApplication(@NotNull List<String> appList) {
        Intrinsics.checkNotNullParameter(appList, (String)"appList");
        this.logger.i("onRequestSelectApplication", new Pair[0]);
        HealthLogger.recordGauge$default(this.healthLogger, appList.size(), null, null, null, onRequestSelectApplication.1.INSTANCE, 14, null);
        this.getPaymentEventReceiver().onRequestSelectApplication(appList);
    }

    @Override
    public void onRequestSelectAccountType() {
        this.logger.i("onRequestSelectAccountType", new Pair[0]);
        HealthLogger.incrementCounter$default(this.healthLogger, null, null, null, onRequestSelectAccountType.1.INSTANCE, 7, null);
        this.getPaymentEventReceiver().onRequestSelectAccountType();
    }

    @Override
    public void onRequestFinalConfirm() {
        this.logger.i("onRequestFinalConfirm", new Pair[0]);
        HealthLogger.incrementCounter$default(this.healthLogger, null, null, null, onRequestFinalConfirm.1.INSTANCE, 7, null);
        this.getPaymentEventReceiver().onRequestFinalConfirm();
    }

    @Override
    public void onRequestOnlineProcess(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
        this.logger.i("onRequestOnlineProcess", new Pair[0]);
        HealthLogger.incrementCounter$default(this.healthLogger, null, null, null, onRequestOnlineProcess.1.INSTANCE, 7, null);
        this.getPaymentEventReceiver().onRequestOnlineAuthorisation(tlv);
    }

    @Override
    public void onReturnBatchData(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
        this.logger.i("onReturnBatchData", new Pair[0]);
        HealthLogger.incrementCounter$default(this.healthLogger, null, null, null, onReturnBatchData.1.INSTANCE, 7, null);
        if (((CharSequence)tlv).length() > 0) {
            this.getPaymentEventReceiver().onReturnFinalTlvBlob(tlv);
        }
    }

    @Override
    public void onReturnReversalData(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
        this.logger.i("onReturnReversalData", new Pair[0]);
        HealthLogger.incrementCounter$default(this.healthLogger, null, null, null, onReturnReversalData.1.INSTANCE, 7, null);
        if (((CharSequence)tlv).length() > 0) {
            this.getPaymentEventReceiver().onReturnFinalTlvBlob(tlv);
        }
    }

    @Override
    public void onReturnTransactionResult(@NotNull TransactionResult.Type result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        this.logger.i("onReturnTransactionResult " + (Object)((Object)result2), new Pair[0]);
        String string = result2.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        HealthLogger.incrementCounter$default(this.healthLogger, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"result", (Object)string)), null, onReturnTransactionResult.1.INSTANCE, 5, null);
        if (result2 == TransactionResult.Type.ICC_CARD_REMOVED) {
            this.getPaymentEventReceiver().onDisplayAdditionalMessage(ReaderDisplayMessage.CARD_REMOVED_TOO_EARLY);
            this.getPaymentEventReceiver().onContactCardStateUpdate(ContactCardSlotState.EMPTY);
        }
        if (result2 == TransactionResult.Type.NOT_ICC) {
            this.getPaymentEventReceiver().onChipCardInitializationFailed();
        }
        ManualEntryEventReceiver manualEntryEventReceiver = this.getManualEntryEventReceiver();
        if (manualEntryEventReceiver != null) {
            manualEntryEventReceiver.onReturnTransactionResult(BbposTranslation.INSTANCE.toTransactionResult(result2));
        }
        this.getPaymentEventReceiver().onReturnTransactionResult(BbposTranslation.INSTANCE.toTransactionResult(result2));
    }

    private final ReaderDisplayMessage toReaderDisplayMessage(DisplayText $this$toReaderDisplayMessage) {
        ReaderDisplayMessage readerDisplayMessage;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toReaderDisplayMessage.ordinal()]) {
            case 1: {
                readerDisplayMessage = ReaderDisplayMessage.TRY_ANOTHER_CARD;
                break;
            }
            case 2: {
                readerDisplayMessage = ReaderDisplayMessage.TRY_ANOTHER_READ_METHOD;
                break;
            }
            case 3: {
                readerDisplayMessage = ReaderDisplayMessage.CHECK_MOBILE_DEVICE;
                break;
            }
            case 4: {
                readerDisplayMessage = ReaderDisplayMessage.INSERT_OR_SWIPE_CARD;
                break;
            }
            case 5: {
                readerDisplayMessage = ReaderDisplayMessage.TRY_ANOTHER_READ_METHOD;
                break;
            }
            case 6: {
                Reader reader = (Reader)this.connectedReaderProvider.get();
                if ((reader instanceof Reader.BluetoothReader.Wisepad3Reader ? true : reader instanceof Reader.UsbReader.Wisepad3Reader) ? true : reader instanceof Reader.UsbReader.Wisepad3SReader) {
                    readerDisplayMessage = ReaderDisplayMessage.TRY_ANOTHER_CARD;
                    break;
                }
                readerDisplayMessage = ReaderDisplayMessage.SWIPE_CARD;
                break;
            }
            case 7: {
                readerDisplayMessage = ReaderDisplayMessage.MULTIPLE_CONTACTLESS_CARDS_DETECTED;
                break;
            }
            case 8: {
                readerDisplayMessage = ReaderDisplayMessage.INSERT_CARD;
                break;
            }
            case 9: {
                readerDisplayMessage = ReaderDisplayMessage.SWIPE_CARD;
                break;
            }
            case 10: {
                readerDisplayMessage = ReaderDisplayMessage.RETRY_CARD;
                break;
            }
            case 11: {
                readerDisplayMessage = ReaderDisplayMessage.REMOVE_CARD;
                break;
            }
            case 12: {
                readerDisplayMessage = ReaderDisplayMessage.TRY_ANOTHER_CARD;
                break;
            }
            case 13: {
                readerDisplayMessage = ReaderDisplayMessage.TRY_ANOTHER_READ_METHOD;
                break;
            }
            default: {
                readerDisplayMessage = null;
            }
        }
        return readerDisplayMessage;
    }

    @Override
    public void onRequestDisplayText(@NotNull DisplayText displayText, @NotNull String displayTextLanguage) {
        block23: {
            PinEntryStatus pinEntryStatus;
            Enum it;
            Intrinsics.checkNotNullParameter((Object)((Object)displayText), (String)"displayText");
            Intrinsics.checkNotNullParameter((Object)displayTextLanguage, (String)"displayTextLanguage");
            this.logger.i("onRequestDisplayText " + (Object)((Object)displayText), new Pair[0]);
            String string = displayText.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            HealthLogger.incrementCounter$default(this.healthLogger, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"result", (Object)string)), null, onRequestDisplayText.1.INSTANCE, 5, null);
            ReaderDisplayMessage readerDisplayMessage = this.toReaderDisplayMessage(displayText);
            if (readerDisplayMessage != null) {
                it = readerDisplayMessage;
                boolean bl = false;
                this.getPaymentEventReceiver().onDisplayAdditionalMessage((ReaderDisplayMessage)it);
            }
            switch (WhenMappings.$EnumSwitchMapping$1[displayText.ordinal()]) {
                case 14: {
                    this.getPaymentEventReceiver().onReadingCard();
                    break;
                }
                case 15: {
                    this.getPaymentEventReceiver().onContactCardStateUpdate(ContactCardSlotState.CARD_INSERTED_CORRECTLY);
                    this.getPaymentEventReceiver().onReadingCard();
                    break;
                }
                case 2: {
                    this.getPaymentEventReceiver().onContactCardStateUpdate(ContactCardSlotState.CARD_INSERTED_INCORRECTLY);
                    break;
                }
                case 1: {
                    this.getPaymentEventReceiver().onIntermediateTransactionError(IntermediateTransactionError.CONTACTLESS_LIMIT_EXCEEDED);
                    break;
                }
                case 3: {
                    this.getPaymentEventReceiver().onIntermediateTransactionError(IntermediateTransactionError.CHECK_MOBILE_DEVICE);
                    break;
                }
                case 5: {
                    break;
                }
                case 7: {
                    this.getPaymentEventReceiver().onIntermediateTransactionError(IntermediateTransactionError.MULTIPLE_CARDS_DETECTED);
                    break;
                }
                case 6: {
                    this.getPaymentEventReceiver().onEmptyCandidateList();
                    break;
                }
                case 10: 
                case 16: {
                    this.getPaymentEventReceiver().waitForCardPresent();
                    break;
                }
                case 17: {
                    this.getPaymentEventReceiver().onReadingCard();
                    break;
                }
                case 12: {
                    ManualEntryEventReceiver manualEntryEventReceiver = this.getManualEntryEventReceiver();
                    if (manualEntryEventReceiver != null) {
                        manualEntryEventReceiver.onInvalidInput();
                    }
                    break;
                }
                case 18: {
                    this.getPaymentEventReceiver().onIntermediateTransactionError(IntermediateTransactionError.BAD_TAP_READ);
                    break;
                }
                case 19: {
                    this.getPaymentEventReceiver().onIntermediateTransactionError(IntermediateTransactionError.TOO_MANY_TAPS);
                    break;
                }
                case 20: {
                    this.getPaymentEventReceiver().onReturnTransactionResult(TransactionResult.Result.CARD_STILL_INSERTED);
                    break;
                }
                case 21: {
                    this.getPaymentEventReceiver().onShowThankYou();
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$1[displayText.ordinal()]) {
                case 28: {
                    PinEntryStatus pinEntryStatus2 = PinEntryStatus.INCORRECT_PIN;
                    break;
                }
                case 29: {
                    PinEntryStatus pinEntryStatus2 = PinEntryStatus.SUCCESS;
                    break;
                }
                default: {
                    PinEntryStatus pinEntryStatus2 = pinEntryStatus = null;
                }
            }
            if (pinEntryStatus == null) break block23;
            it = pinEntryStatus;
            boolean bl = false;
            PaymentEventReceiver paymentEventReceiver = this.getPaymentEventReceiver();
            Intrinsics.checkNotNullExpressionValue((Object)paymentEventReceiver, (String)"paymentEventReceiver");
            PaymentEventReceiver.onPinEntryStatusChange$default(paymentEventReceiver, (PinEntryStatus)it, null, null, 6, null);
        }
    }

    @Override
    public void onRequestDisplayAsterisk(@NotNull String unmaskedDigits, int numOfAsterisk) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)unmaskedDigits, (String)"unmaskedDigits");
            this.logger.i("onRequestDisplayAsterisk unmaskedDigits " + unmaskedDigits + " numOfAsterisk " + numOfAsterisk, new Pair[0]);
            this.getPaymentEventReceiver().onUpdatePinEntryAsteriskCount(numOfAsterisk);
            ManualEntryEventReceiver manualEntryEventReceiver = this.getManualEntryEventReceiver();
            if (manualEntryEventReceiver == null) break block0;
            manualEntryEventReceiver.onRequestDisplayAsterisk(unmaskedDigits, numOfAsterisk);
        }
    }

    @Override
    public void onRequestPinEntry(@NotNull PinEntrySource pinEntrySource) {
        Intrinsics.checkNotNullParameter((Object)((Object)pinEntrySource), (String)"pinEntrySource");
        this.logger.i("onRequestPinEntry " + (Object)((Object)pinEntrySource), new Pair[0]);
        PaymentEventReceiver paymentEventReceiver = this.getPaymentEventReceiver();
        Intrinsics.checkNotNullExpressionValue((Object)paymentEventReceiver, (String)"paymentEventReceiver");
        PaymentEventReceiver.onPinEntryStatusChange$default(paymentEventReceiver, PinEntryStatus.REQUESTED, null, null, 6, null);
    }

    @Override
    public void onReturnPinEntryResult(@NotNull PinEntryResult.Type result2, @NotNull PinData pinData) {
        PinEntryStatus pinEntryStatus;
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        Intrinsics.checkNotNullParameter((Object)((Object)pinData), (String)"pinData");
        this.logger.i("onReturnPinEntryResult " + (Object)((Object)result2), new Pair[0]);
        switch (WhenMappings.$EnumSwitchMapping$2[result2.ordinal()]) {
            case 1: {
                throw new IllegalArgumentException("Invalid PinEntryResult.Type");
            }
            case 2: {
                pinEntryStatus = PinEntryStatus.ENTERED;
                break;
            }
            case 3: {
                pinEntryStatus = PinEntryStatus.CANCEL;
                break;
            }
            case 4: {
                pinEntryStatus = PinEntryStatus.TIMEOUT;
                break;
            }
            case 5: {
                pinEntryStatus = PinEntryStatus.BYPASS;
                break;
            }
            case 6: {
                pinEntryStatus = PinEntryStatus.WRONG_PIN_LENGTH;
                break;
            }
            case 7: {
                pinEntryStatus = PinEntryStatus.INCORRECT_PIN;
                break;
            }
            case 8: {
                pinEntryStatus = PinEntryStatus.ICC_REMOVED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PinEntryStatus convertedStatus = pinEntryStatus;
        if (convertedStatus == PinEntryStatus.ICC_REMOVED) {
            this.getPaymentEventReceiver().onContactCardStateUpdate(ContactCardSlotState.EMPTY);
        }
        this.getPaymentEventReceiver().onPinEntryStatusChange(convertedStatus, pinData.epb, pinData.ksn);
    }

    @Override
    public void onRequestProduceAudioTone(@NotNull ContactlessStatusTone tone) {
        AudioAlertType audioAlertType;
        Intrinsics.checkNotNullParameter((Object)((Object)tone), (String)"tone");
        this.logger.i("onRequestProduceAudioTone " + (Object)((Object)tone), new Pair[0]);
        PaymentEventReceiver paymentEventReceiver = this.getPaymentEventReceiver();
        switch (WhenMappings.$EnumSwitchMapping$3[tone.ordinal()]) {
            case 1: {
                throw new IllegalArgumentException("Invalid ContactlessStatusTone");
            }
            case 2: {
                audioAlertType = AudioAlertType.ALERT;
                break;
            }
            case 3: {
                audioAlertType = AudioAlertType.SUCCESS;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        paymentEventReceiver.onRequestProduceAudioTone(audioAlertType);
    }

    @Override
    public void onReturnSetPinPadButtonsResult(boolean isSuccess) {
        this.logger.i("onReturnSetPinPadButtonsResult " + isSuccess, new Pair[0]);
        this.getPaymentEventReceiver().onSetPinPadButtonsResult(isSuccess);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @BluetoothUsbPinPadReaders
    public void onReturnAmount(@NotNull AmountInputResult result, @NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.logger.i("onReturnAmount amountInputResult: " + (Object)result + ", data: " + data, new Pair[0]);
        switch (WhenMappings.$EnumSwitchMapping$4[result.ordinal()]) {
            case 1: {
                if (!(data.isEmpty() == false)) ** GOTO lbl65
                v0 = data.get("tipsAmount");
                if (v0 == null) ** GOTO lbl-1000
                $this$filter$iv = v0;
                $i$f$filter = false;
                var9_5 = $this$filter$iv;
                destination$iv$iv = new StringBuilder();
                $i$f$filterTo = false;
                var13_9 = $this$filterTo$iv$iv.length();
                for (index$iv$iv = 0; index$iv$iv < var13_9; ++index$iv$iv) {
                    it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    $i$a$-filter-BbposPaymentCollectionListener$onReturnAmount$tippingFlowResult$tipAmountLong$1 = false;
                    if (!Character.isDigit(it)) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                v1 = ((StringBuilder)destination$iv$iv).toString();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filterTo(StringBuilder(), predicate).toString()");
                v0 = v1;
                if (v1 != null) {
                    v2 = StringsKt.toLongOrNull((String)v0);
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                tipAmountLong = v2;
                var6_14 = data.get("tipSelectionType");
                if (var6_14 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var6_14.hashCode()) {
                    case 1537: {
                        if (var6_14.equals("01")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1538: {
                        if (var6_14.equals("02")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1539: {
                        if (var6_14.equals("03")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v3 = Percentage.INSTANCE;
                        break;
                    }
                    case 2: {
                        v3 = FixedAmount.INSTANCE;
                        break;
                    }
                    case 3: {
                        v3 = Custom.INSTANCE;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v3 = bbposSdkTipSelectionType = (BbposSdkTipSelectionType)Unknown.INSTANCE;
                    }
                }
                v4 = tipAmountLong == null ? (TipSelectionResult)new TipSelectionFailure(TippingSelectionFailureReason.CALLBACK_NO_TIP_AMOUNT) : (TipSelectionResult)new TipSelected(tipAmountLong, bbposSdkTipSelectionType);
                ** GOTO lbl66
lbl65:
                // 1 sources

                v4 = new TipSelectionFailure(TippingSelectionFailureReason.CALLBACK_NO_DATA);
lbl66:
                // 2 sources

                tippingFlowResult = v4;
                this.getPaymentEventReceiver().onKernelTippingSelectionResult(tippingFlowResult);
                break;
            }
            case 2: {
                this.getPaymentEventReceiver().onKernelTippingSelectionResult(NoTipSelected.INSTANCE);
                break;
            }
            case 3: {
                tippingFlowResult = new TipSelectionFailure(TippingSelectionFailureReason.TIMEOUT);
                this.getPaymentEventReceiver().onKernelTippingSelectionResult(tippingFlowResult);
                break;
            }
            case 4: {
                tippingFlowResult = new TipSelectionFailure(TippingSelectionFailureReason.INVALID_AMOUNT);
                this.getPaymentEventReceiver().onKernelTippingSelectionResult(tippingFlowResult);
            }
        }
    }

    @Override
    public void onRequestManualPanEntry(@NotNull ManualPanEntryType manualPanEntry) {
        block6: {
            ManualEntryType manualEntryType;
            Intrinsics.checkNotNullParameter((Object)((Object)manualPanEntry), (String)"manualPanEntry");
            this.logger.i("onRequestManualPanEntry manualPanEntryType: " + (Object)((Object)manualPanEntry), new Pair[0]);
            ManualEntryEventReceiver manualEntryEventReceiver = this.getManualEntryEventReceiver();
            if (manualEntryEventReceiver == null) break block6;
            switch (WhenMappings.$EnumSwitchMapping$5[manualPanEntry.ordinal()]) {
                case 1: {
                    throw new IllegalArgumentException("Unknown Manual Pan Entry Type");
                }
                case 2: {
                    manualEntryType = ManualEntryType.PAN_ENTRY;
                    break;
                }
                case 3: {
                    manualEntryType = ManualEntryType.CVV_ENTRY;
                    break;
                }
                case 4: {
                    manualEntryType = ManualEntryType.EXPIRY_DATE_ENTRY;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            manualEntryEventReceiver.onRequestManualEntry(manualEntryType);
        }
    }

    @Override
    public void onSerialDisconnected() {
        super.onSerialDisconnected();
        this.getPaymentEventReceiver().onReturnTransactionResult(TransactionResult.Result.DEVICE_FAILURE);
    }

    @Override
    public void onError(@NotNull Error error, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        super.onError(error, errorMessage);
        if (error == Error.DEVICE_BUSY && this.cardRemovalChecker.shouldFakeCardEmptyOnDeviceBusy()) {
            this.logger.e("Too many DEVICE_BUSY received when detecting card removal. Faking a card empty signal.", new Pair[0]);
            this.onReturnCheckCardResult(CheckCardResult.Type.NO_CARD, new CardData(null, null, null, null, null, null, null, null, null, 511, null));
        }
    }

    @Override
    public void onDeviceTampered(@NotNull BbposTamper bbposTamper) {
        Intrinsics.checkNotNullParameter((Object)bbposTamper, (String)"bbposTamper");
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;

        static {
            int[] nArray = new int[CheckCardResult.Type.values().length];
            try {
                nArray[CheckCardResult.Type.NO_CARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.INSERTED_CARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.NOT_ICC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.MSR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.BAD_SWIPE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.MAG_HEAD_FAIL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.MANUAL_PAN_ENTRY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.CHECK_CARD_RESULT_TYPE_UNKNOWN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.USE_ICC_CARD.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.TAP_CARD_DETECTED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.CARD_NOT_SUPPORTED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DisplayText.values().length];
            try {
                nArray[DisplayText.CTL_TRANSACTION_LIMIT_EXCEEDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.NOT_ICC_CARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.REFER_TO_YOUR_PAYMENT_DEVICE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INSERT_OR_SWIPE_CARD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CTL_NO_EMV_APPS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.NO_EMV_APPS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.MULTIPLE_CARDS_DETECTED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INSERT_CARD.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.USE_MAG_STRIPE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.PRESENT_CARD_AGAIN.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.REMOVE_CARD.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.NOT_ACCEPTED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CTL_APP_NOT_SUPPORTED.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.PLEASE_WAIT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.PROCESSING.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.PRESENT_CARD.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.AUTHORISING.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INSERT_SWIPE_OR_TRY_ANOTHER_CARD.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.TOO_MANY_TAPS.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CARD_IS_STILL_INSERTED.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.SHOW_THANK_YOU.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.DISPLAY_TEXT_UNKNOWN.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.APPROVED.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CALL_YOUR_BANK.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.DECLINED.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.ENTER_AMOUNT.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.ENTER_PIN.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INCORRECT_PIN.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.PIN_OK.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.TRY_AGAIN.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.TRANSACTION_TERMINATED.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.LAST_PIN_TRY.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.SELECT_ACCOUNT.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.APPROVED_PLEASE_SIGN.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.TIMEOUT.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.APPLICATION_EXPIRED.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.FINAL_CONFIRM.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.PIN_TRY_LIMIT_EXCEEDED.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CARD_INSERTED.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CARD_REMOVED.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INVALID_INPUT.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CARD_ERROR.ordinal()] = 42;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INCORRECT_CARD_DATA.ordinal()] = 43;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.ERROR_STATUS_WORD.ordinal()] = 44;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.DPAS_CDCVM.ordinal()] = 45;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CARD_NOT_ADMITTED.ordinal()] = 46;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INVALID_TRANSACTION.ordinal()] = 47;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INVALID_CARD_NUMBER.ordinal()] = 48;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.SYSTEM_MALFUNCTION.ordinal()] = 49;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.EXPIRED_CARD.ordinal()] = 50;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.TRANSACTION_NOT_PERMITTED.ordinal()] = 51;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INVALID_FUNCTION.ordinal()] = 52;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INVALID_CARD.ordinal()] = 53;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.WRONG_CARD.ordinal()] = 54;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.TERMINAL_NOT_PERMITTED.ordinal()] = 55;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.ORIGINAL_AMOUNT_INCORRECT.ordinal()] = 56;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CARD_NOT_READABLE.ordinal()] = 57;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.AUTHENTICATION_REQUIRED.ordinal()] = 58;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PinEntryResult.Type.values().length];
            try {
                nArray[PinEntryResult.Type.PIN_ENTRY_RESULT_UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.ENTERED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.CANCEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.TIMEOUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.BYPASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.WRONG_PIN_LENGTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.INCORRECT_PIN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.ICC_REMOVED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[ContactlessStatusTone.values().length];
            try {
                nArray[ContactlessStatusTone.CONTACTLESS_STATUS_TONE_UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContactlessStatusTone.ALERT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContactlessStatusTone.SUCCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[AmountInputResult.values().length];
            try {
                nArray[AmountInputResult.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmountInputResult.CANCEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmountInputResult.TIMEOUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmountInputResult.INVALID_AMOUNT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[ManualPanEntryType.values().length];
            try {
                nArray[ManualPanEntryType.MANUAL_PAN_ENTRY_TYPE_UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualPanEntryType.PAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualPanEntryType.CVV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualPanEntryType.EXPIRY_DATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$5 = nArray;
        }
    }
}

