/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.stripe.core.bbpos.hardware.api.DeviceControllerWrapper;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.ReaderConnectionController;
import com.stripe.jvmcore.logging.terminal.log.Log;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0012\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposReaderConnectionController;", "Lcom/stripe/core/hardware/ReaderConnectionController;", "deviceController", "Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;", "usbManager", "Landroid/hardware/usb/UsbManager;", "(Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;Landroid/hardware/usb/UsbManager;)V", "connect", "", "reader", "Lcom/stripe/core/hardware/Reader;", "connectBluetooth", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "connectSerial", "connectUsb", "Lcom/stripe/core/hardware/Reader$UsbReader;", "disconnect", "disconnectBluetooth", "disconnectSerial", "disconnectUsb", "resolveUsbReader", "usbReader", "setDebugLogEnabled", "enabled", "", "startSession", "Companion", "hardware_release"})
@SourceDebugExtension(value={"SMAP\nBbposReaderConnectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposReaderConnectionController.kt\ncom/stripe/core/bbpos/hardware/BbposReaderConnectionController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n288#2,2:132\n*S KotlinDebug\n*F\n+ 1 BbposReaderConnectionController.kt\ncom/stripe/core/bbpos/hardware/BbposReaderConnectionController\n*L\n109#1:132,2\n*E\n"})
public final class BbposReaderConnectionController
implements ReaderConnectionController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeviceControllerWrapper deviceController;
    @NotNull
    private final UsbManager usbManager;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(BbposReaderConnectionController.class);
    private static final long SHOPIFY_SESSION_TOKEN_1 = 3164773023L;
    private static final int SHOPIFY_SESSION_TOKEN_2 = 1689864296;

    public BbposReaderConnectionController(@NotNull DeviceControllerWrapper deviceController, @NotNull UsbManager usbManager) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        Intrinsics.checkNotNullParameter((Object)usbManager, (String)"usbManager");
        this.deviceController = deviceController;
        this.usbManager = usbManager;
    }

    @Override
    public void connect(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Reader reader2 = reader;
        if (reader2 instanceof Reader.SerialReader) {
            this.connectSerial();
        } else if (reader2 instanceof Reader.BluetoothReader) {
            this.connectBluetooth((Reader.BluetoothReader)reader);
        } else if (reader2 instanceof Reader.UsbReader) {
            this.connectUsb((Reader.UsbReader)reader);
        }
    }

    @Override
    public void disconnect(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Reader reader2 = reader;
        if (reader2 instanceof Reader.SerialReader) {
            this.disconnectSerial();
        } else if (reader2 instanceof Reader.BluetoothReader) {
            this.disconnectBluetooth();
        } else if (reader2 instanceof Reader.UsbReader) {
            this.disconnectUsb();
        }
    }

    @Override
    public void startSession(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        StringBuilder stringBuilder = new StringBuilder();
        String string = Long.toString(3164773023L, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        String string2 = Integer.toString(1689864296, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        String vendorToken = stringBuilder2.append(string2).toString();
        this.deviceController.initSession(vendorToken);
    }

    @Override
    public void setDebugLogEnabled(boolean enabled) {
        this.deviceController.setDebugLogEnabled(enabled);
    }

    private final void connectSerial() {
        LOGGER.i("connectSerial", new Pair[0]);
        this.deviceController.startSerial();
    }

    private final void connectBluetooth(Reader.BluetoothReader reader) {
        LOGGER.i("connectBluetooth", new Pair[0]);
        this.deviceController.connectBt(reader.getDevice());
    }

    private final void connectUsb(Reader.UsbReader reader) {
        block2: {
            Unit unit;
            LOGGER.i("connectUsb", new Pair[0]);
            Object object = this.resolveUsbReader(reader).getDevice();
            if (object != null && (object = object.getDeviceName()) != null) {
                Object deviceName = object;
                boolean bl = false;
                this.deviceController.startUsbWithDeviceName((String)deviceName);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            BbposReaderConnectionController $this$connectUsb_u24lambda_u241 = this;
            boolean bl = false;
            $this$connectUsb_u24lambda_u241.deviceController.startUsb();
        }
    }

    private final void disconnectSerial() {
        LOGGER.i("disconnectSerial", new Pair[0]);
        this.deviceController.disconnectSerial();
    }

    private final void disconnectBluetooth() {
        LOGGER.i("disconnectBluetooth", new Pair[0]);
        this.deviceController.disconnectBt();
    }

    private final void disconnectUsb() {
        LOGGER.i("disconnectUsb", new Pair[0]);
        this.deviceController.stopUsb();
    }

    private final Reader.UsbReader resolveUsbReader(Reader.UsbReader usbReader) {
        Reader.UsbReader usbReader2;
        UsbDevice usbDevice;
        UsbDevice device2 = usbReader.getDevice();
        HashMap hashMap = this.usbManager.getDeviceList();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"usbManager.deviceList");
        Map deviceList = hashMap;
        UsbDevice usbDevice2 = device2;
        if (CollectionsKt.contains((Iterable)deviceList.keySet(), (Object)(usbDevice2 != null ? usbDevice2.getDeviceName() : null))) {
            usbDevice = device2;
        } else {
            UsbDevice usbDevice3;
            Object v4;
            block19: {
                Iterable $this$firstOrNull$iv = deviceList.values();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    UsbDevice it = (UsbDevice)element$iv;
                    boolean bl = false;
                    UsbDevice usbDevice4 = device2;
                    if (!Intrinsics.areEqual((Object)it.getProductName(), (Object)(usbDevice4 != null ? usbDevice4.getProductName() : null))) continue;
                    v4 = element$iv;
                    break block19;
                }
                v4 = null;
            }
            if ((usbDevice3 = (UsbDevice)v4) == null) {
                usbDevice3 = device2;
            }
            if (usbDevice3 != null) {
                UsbDevice usbDevice5;
                UsbDevice it = usbDevice5 = usbDevice3;
                boolean bl = false;
                UsbDevice usbDevice6 = device2;
                if (!Intrinsics.areEqual((Object)it.getDeviceName(), (Object)(usbDevice6 != null ? usbDevice6.getDeviceName() : null))) {
                    Pair[] pairArray = new Pair[3];
                    UsbDevice usbDevice7 = device2;
                    pairArray[0] = TuplesKt.to((Object)"oldDeviceName", (Object)(usbDevice7 != null ? usbDevice7.getDeviceName() : null));
                    pairArray[1] = TuplesKt.to((Object)"newDeviceName", (Object)it.getDeviceName());
                    pairArray[2] = TuplesKt.to((Object)"productName", (Object)it.getProductName());
                    LOGGER.i("deviceName for reader has changed", pairArray);
                }
                usbDevice = usbDevice5;
            } else {
                usbDevice = null;
            }
        }
        UsbDevice connectableDevice = usbDevice;
        Reader.UsbReader usbReader3 = usbReader;
        if (usbReader3 instanceof Reader.UsbReader.Chipper2xReader) {
            usbReader2 = new Reader.UsbReader.Chipper2xReader(connectableDevice);
        } else if (usbReader3 instanceof Reader.UsbReader.StripeM2Reader) {
            usbReader2 = new Reader.UsbReader.StripeM2Reader(connectableDevice);
        } else if (usbReader3 instanceof Reader.UsbReader.UnspecifiedUsbReader) {
            usbReader2 = Reader.UsbReader.UnspecifiedUsbReader.INSTANCE;
        } else if (usbReader3 instanceof Reader.UsbReader.WisecubeReader) {
            usbReader2 = new Reader.UsbReader.WisecubeReader(connectableDevice);
        } else if (usbReader3 instanceof Reader.UsbReader.Wisepad3Reader) {
            usbReader2 = new Reader.UsbReader.Wisepad3Reader(connectableDevice);
        } else if (usbReader3 instanceof Reader.UsbReader.Wisepad3SReader) {
            usbReader2 = new Reader.UsbReader.Wisepad3SReader(connectableDevice);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return usbReader2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposReaderConnectionController$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "SHOPIFY_SESSION_TOKEN_1", "", "SHOPIFY_SESSION_TOKEN_2", "", "hardware_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

