/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware;

import com.stripe.bbpos.sdk.CheckCardMode;
import com.stripe.core.bbpos.hardware.BbposReaderConnectionController;
import com.stripe.core.bbpos.hardware.BbposReaderInfoController;
import com.stripe.core.bbpos.hardware.DelegatedDeviceController;
import com.stripe.core.bbpos.hardware.api.DeviceControllerWrapper;
import com.stripe.core.bbpos.hardware.emv.CheckCardModeConverter;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.ReaderConnectionController;
import com.stripe.core.hardware.ReaderController;
import com.stripe.core.hardware.ReaderInfoController;
import com.stripe.core.hardware.dagger.BluetoothUsbPinPadReaders;
import com.stripe.core.hardware.emv.CombinedKernelInterface;
import com.stripe.core.hardware.tipping.TipConfigValidationResult;
import com.stripe.core.stripeterminal.log.AndroidLog;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.CardStatus;
import com.stripe.jvmcore.time.Clock;
import com.stripe.proto.model.config.ReaderFeatureFlags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 -2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001-BK\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010\u00a2\u0006\u0002\u0010\u0014J\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0096\u0001J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001aH\u0015J\u0011\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0096\u0001J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0015J\t\u0010'\u001a\u00020\u001aH\u0096\u0001J\t\u0010(\u001a\u00020\u001aH\u0096\u0001J\u0011\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0096\u0001J\u0011\u0010,\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0096\u0001R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lcom/stripe/core/bbpos/hardware/BbposReaderController;", "Lcom/stripe/core/hardware/ReaderController;", "Lcom/stripe/core/hardware/ReaderConnectionController;", "Lcom/stripe/core/hardware/ReaderInfoController;", "Lcom/stripe/core/bbpos/hardware/DelegatedDeviceController;", "kernelInterface", "Lcom/stripe/core/hardware/emv/CombinedKernelInterface;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "deviceController", "Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;", "bbposReaderConnectionController", "Lcom/stripe/core/bbpos/hardware/BbposReaderConnectionController;", "bbposReaderInfoController", "Lcom/stripe/core/bbpos/hardware/BbposReaderInfoController;", "connectedReaderProvider", "Ljavax/inject/Provider;", "Lcom/stripe/core/hardware/Reader;", "featureFlagsProvider", "Lcom/stripe/proto/model/config/ReaderFeatureFlags;", "(Lcom/stripe/core/hardware/emv/CombinedKernelInterface;Lcom/stripe/jvmcore/time/Clock;Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;Lcom/stripe/core/bbpos/hardware/BbposReaderConnectionController;Lcom/stripe/core/bbpos/hardware/BbposReaderInfoController;Ljavax/inject/Provider;Ljavax/inject/Provider;)V", "getClock", "()Lcom/stripe/jvmcore/time/Clock;", "getFeatureFlagsProvider", "()Ljavax/inject/Provider;", "connect", "", "reader", "disableDevice", "cardStatus", "Lcom/stripe/jvmcore/hardware/emv/CardStatus;", "disableInputAmount", "disconnect", "enableDevice", "configuration", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration;", "enableInputAmount", "tipConfigValidationResult", "Lcom/stripe/core/hardware/tipping/TipConfigValidationResult;", "requestReaderBatteryInfo", "requestReaderInfo", "setDebugLogEnabled", "enabled", "", "startSession", "Companion", "hardware_release"})
@SourceDebugExtension(value={"SMAP\nBbposReaderController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposReaderController.kt\ncom/stripe/core/bbpos/hardware/BbposReaderController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n766#2:90\n857#2,2:91\n*S KotlinDebug\n*F\n+ 1 BbposReaderController.kt\ncom/stripe/core/bbpos/hardware/BbposReaderController\n*L\n51#1:90\n51#1:91,2\n*E\n"})
public final class BbposReaderController
extends ReaderController
implements ReaderConnectionController,
ReaderInfoController,
DelegatedDeviceController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Clock clock;
    @NotNull
    private final DeviceControllerWrapper deviceController;
    @NotNull
    private final BbposReaderConnectionController bbposReaderConnectionController;
    @NotNull
    private final BbposReaderInfoController bbposReaderInfoController;
    @NotNull
    private final Provider<Reader> connectedReaderProvider;
    @NotNull
    private final Provider<ReaderFeatureFlags> featureFlagsProvider;
    @NotNull
    public static final String TAG = "BbposReaderController";

    public BbposReaderController(@NotNull CombinedKernelInterface kernelInterface, @NotNull Clock clock, @NotNull DeviceControllerWrapper deviceController, @NotNull BbposReaderConnectionController bbposReaderConnectionController, @NotNull BbposReaderInfoController bbposReaderInfoController, @NotNull Provider<Reader> connectedReaderProvider, @NotNull Provider<ReaderFeatureFlags> featureFlagsProvider) {
        Intrinsics.checkNotNullParameter((Object)kernelInterface, (String)"kernelInterface");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        Intrinsics.checkNotNullParameter((Object)bbposReaderConnectionController, (String)"bbposReaderConnectionController");
        Intrinsics.checkNotNullParameter((Object)bbposReaderInfoController, (String)"bbposReaderInfoController");
        Intrinsics.checkNotNullParameter(connectedReaderProvider, (String)"connectedReaderProvider");
        Intrinsics.checkNotNullParameter(featureFlagsProvider, (String)"featureFlagsProvider");
        super(kernelInterface);
        this.clock = clock;
        this.deviceController = deviceController;
        this.bbposReaderConnectionController = bbposReaderConnectionController;
        this.bbposReaderInfoController = bbposReaderInfoController;
        this.connectedReaderProvider = connectedReaderProvider;
        this.featureFlagsProvider = featureFlagsProvider;
    }

    @Override
    @NotNull
    public Clock getClock() {
        return this.clock;
    }

    @Override
    @NotNull
    public Provider<ReaderFeatureFlags> getFeatureFlagsProvider() {
        return this.featureFlagsProvider;
    }

    @Override
    public void connect(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.bbposReaderConnectionController.connect(reader);
    }

    @Override
    public void disconnect(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.bbposReaderConnectionController.disconnect(reader);
    }

    @Override
    public void setDebugLogEnabled(boolean enabled) {
        this.bbposReaderConnectionController.setDebugLogEnabled(enabled);
    }

    @Override
    public void startSession(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.bbposReaderConnectionController.startSession(reader);
    }

    @Override
    public void requestReaderBatteryInfo() {
        this.bbposReaderInfoController.requestReaderBatteryInfo();
    }

    @Override
    public void requestReaderInfo() {
        this.bbposReaderInfoController.requestReaderInfo();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void enableDevice(@NotNull ReaderConfiguration configuration) {
        CheckCardMode checkCardMode;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        AndroidLog.INSTANCE.i(TAG, "enableDevice");
        this.getKernelInterface().setTransactionType(configuration.getEmvTransactionType());
        Reader reader = (Reader)this.connectedReaderProvider.get();
        if (reader instanceof Reader.BluetoothReader.Chipper1xReader) {
            checkCardMode = CheckCardMode.SWIPE_OR_INSERT;
        } else if ((reader instanceof Reader.BluetoothReader.Wisepad3Reader ? true : reader instanceof Reader.UsbReader.Wisepad3Reader) ? true : reader instanceof Reader.UsbReader.Wisepad3SReader) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = configuration.getReadersEnabled();
            CheckCardModeConverter checkCardModeConverter = CheckCardModeConverter.INSTANCE;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ReaderConfiguration.ReaderType it = (ReaderConfiguration.ReaderType)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it != ReaderConfiguration.ReaderType.MAGSTRIPE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            EnumSet<ReaderConfiguration.ReaderType> enumSet = EnumSet.copyOf((Collection)((List)destination$iv$iv));
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copyOf(\n                \u2026      }\n                )");
            checkCardMode = checkCardModeConverter.toCheckCardMode(enumSet);
        } else {
            checkCardMode = null;
        }
        CheckCardMode checkCardModeOverride = checkCardMode;
        this.startEmv(this.deviceController, configuration, checkCardModeOverride);
    }

    @Override
    protected void disableDevice(@NotNull CardStatus cardStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)cardStatus), (String)"cardStatus");
        AndroidLog.INSTANCE.i(TAG, "disableDevice " + (Object)((Object)cardStatus));
        if (cardStatus != CardStatus.CARD_IDLE) {
            this.deviceController.cancelCheckCard();
        }
    }

    @Override
    @BluetoothUsbPinPadReaders
    protected void enableInputAmount(@NotNull TipConfigValidationResult tipConfigValidationResult) {
        Intrinsics.checkNotNullParameter((Object)tipConfigValidationResult, (String)"tipConfigValidationResult");
        AndroidLog.INSTANCE.i(TAG, "enableInputAmount");
        this.enableInputAmount(this.deviceController, tipConfigValidationResult);
    }

    @Override
    @BluetoothUsbPinPadReaders
    protected void disableInputAmount() {
        AndroidLog.INSTANCE.i(TAG, "disableInputAmount");
        this.deviceController.disableInputAmount();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposReaderController$Companion;", "", "()V", "TAG", "", "hardware_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

