/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware;

import com.stripe.core.bbpos.hardware.BbposReaderConnectionController;
import com.stripe.core.bbpos.hardware.BbposReaderInfoController;
import com.stripe.core.bbpos.hardware.BbposUtilsKt;
import com.stripe.core.bbpos.hardware.api.DeviceControllerWrapper;
import com.stripe.core.device.ClientDeviceType;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.ReaderConnectionController;
import com.stripe.core.hardware.ReaderEncryptionController;
import com.stripe.core.hardware.ReaderInfoController;
import com.stripe.core.hardware.ReaderManagementController;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001fB%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\t\u0010\u0015\u001a\u00020\u000eH\u0096\u0001J\t\u0010\u0016\u001a\u00020\u000eH\u0096\u0001J\u0011\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0011\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/core/bbpos/hardware/BbposReaderManagementController;", "Lcom/stripe/core/hardware/ReaderManagementController;", "Lcom/stripe/core/hardware/ReaderConnectionController;", "Lcom/stripe/core/hardware/ReaderInfoController;", "deviceController", "Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;", "bbposReaderConnectionController", "Lcom/stripe/core/bbpos/hardware/BbposReaderConnectionController;", "bbposReaderInfoController", "Lcom/stripe/core/bbpos/hardware/BbposReaderInfoController;", "clientDeviceType", "Lcom/stripe/core/device/ClientDeviceType;", "(Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;Lcom/stripe/core/bbpos/hardware/BbposReaderConnectionController;Lcom/stripe/core/bbpos/hardware/BbposReaderInfoController;Lcom/stripe/core/device/ClientDeviceType;)V", "connect", "", "reader", "Lcom/stripe/core/hardware/Reader;", "disconnect", "getEncryptionMethodsToTry", "", "Lcom/stripe/core/hardware/ReaderEncryptionController$EncryptionMethod;", "requestReaderBatteryInfo", "requestReaderInfo", "setDebugLogEnabled", "enabled", "", "signData", "data", "", "encryptionMethod", "startSession", "Companion", "hardware_release"})
public final class BbposReaderManagementController
implements ReaderManagementController,
ReaderConnectionController,
ReaderInfoController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeviceControllerWrapper deviceController;
    @NotNull
    private final BbposReaderConnectionController bbposReaderConnectionController;
    @NotNull
    private final BbposReaderInfoController bbposReaderInfoController;
    @NotNull
    private final ClientDeviceType clientDeviceType;
    @NotNull
    public static final String TAG = "BbposReaderManagementController";

    public BbposReaderManagementController(@NotNull DeviceControllerWrapper deviceController, @NotNull BbposReaderConnectionController bbposReaderConnectionController, @NotNull BbposReaderInfoController bbposReaderInfoController, @NotNull ClientDeviceType clientDeviceType) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        Intrinsics.checkNotNullParameter((Object)bbposReaderConnectionController, (String)"bbposReaderConnectionController");
        Intrinsics.checkNotNullParameter((Object)bbposReaderInfoController, (String)"bbposReaderInfoController");
        Intrinsics.checkNotNullParameter((Object)clientDeviceType, (String)"clientDeviceType");
        this.deviceController = deviceController;
        this.bbposReaderConnectionController = bbposReaderConnectionController;
        this.bbposReaderInfoController = bbposReaderInfoController;
        this.clientDeviceType = clientDeviceType;
    }

    @Override
    public void connect(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.bbposReaderConnectionController.connect(reader);
    }

    @Override
    public void disconnect(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.bbposReaderConnectionController.disconnect(reader);
    }

    @Override
    public void setDebugLogEnabled(boolean enabled) {
        this.bbposReaderConnectionController.setDebugLogEnabled(enabled);
    }

    @Override
    public void startSession(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.bbposReaderConnectionController.startSession(reader);
    }

    @Override
    public void requestReaderBatteryInfo() {
        this.bbposReaderInfoController.requestReaderBatteryInfo();
    }

    @Override
    public void requestReaderInfo() {
        this.bbposReaderInfoController.requestReaderInfo();
    }

    @Override
    @NotNull
    public List<ReaderEncryptionController.EncryptionMethod> getEncryptionMethodsToTry() {
        List list;
        ClientDeviceType clientDeviceType = this.clientDeviceType;
        if (clientDeviceType instanceof ClientDeviceType.S700 ? true : Intrinsics.areEqual((Object)clientDeviceType, (Object)ClientDeviceType.Etna.INSTANCE)) {
            list = CollectionsKt.listOf((Object)((Object)ReaderEncryptionController.EncryptionMethod.MAC_ANSI_X9_19));
        } else if (((Intrinsics.areEqual((Object)clientDeviceType, (Object)ClientDeviceType.Unknown.INSTANCE) ? true : Intrinsics.areEqual((Object)clientDeviceType, (Object)ClientDeviceType.SunmiWhistler.INSTANCE)) ? true : Intrinsics.areEqual((Object)clientDeviceType, (Object)ClientDeviceType.Emulator.INSTANCE)) ? true : clientDeviceType instanceof ClientDeviceType.WisePosE) {
            ReaderEncryptionController.EncryptionMethod[] encryptionMethodArray = new ReaderEncryptionController.EncryptionMethod[]{ReaderEncryptionController.EncryptionMethod.AES_CMAC, ReaderEncryptionController.EncryptionMethod.MAC_ANSI_X9_19};
            list = CollectionsKt.listOf((Object[])encryptionMethodArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @Override
    public void signData(@NotNull byte[] data, @NotNull ReaderEncryptionController.EncryptionMethod encryptionMethod) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionMethod), (String)"encryptionMethod");
        BbposUtilsKt.encryptDataWithSettings(this.deviceController, data, encryptionMethod);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposReaderManagementController$Companion;", "", "()V", "TAG", "", "hardware_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

