/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware;

import androidx.annotation.VisibleForTesting;
import com.stripe.bbpos.sdk.CardData;
import com.stripe.bbpos.sdk.CheckCardMode;
import com.stripe.bbpos.sdk.CheckCardResult;
import com.stripe.bbpos.sdk.DisplayText;
import com.stripe.bbpos.sdk.PinData;
import com.stripe.bbpos.sdk.PinEntryResult;
import com.stripe.bbpos.sdk.PinEntrySource;
import com.stripe.bbpos.sdk.TransactionResult;
import com.stripe.core.bbpos.hardware.BbposControllerListener;
import com.stripe.core.bbpos.hardware.BbposReaderController;
import com.stripe.core.bbpos.hardware.BbposReaderInfoFactory;
import com.stripe.core.bbpos.hardware.BbposTranslation;
import com.stripe.core.bbpos.hardware.api.AmountInputResult;
import com.stripe.core.bbpos.hardware.discovery.BbposBluetoothDiscoveryFilter;
import com.stripe.core.bbpos.hardware.emv.CheckCardModeConverter;
import com.stripe.core.featureflag.dagger.DebugLogsShouldBeSentToSplunk;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.dagger.BluetoothUsbPinPadReaders;
import com.stripe.core.hardware.emv.CombinedKernelInterface;
import com.stripe.core.hardware.status.ReaderStatusListener;
import com.stripe.core.hardware.tipping.LegacyNoTipSelected;
import com.stripe.core.hardware.tipping.LegacyTipSelected;
import com.stripe.core.hardware.tipping.LegacyTipSelectionFailure;
import com.stripe.core.hardware.tipping.LegacyTipSelectionResult;
import com.stripe.core.hardware.tipping.TippingSelectionFailureReason;
import com.stripe.jvmcore.hardware.emv.CardStatus;
import com.stripe.jvmcore.hardware.emv.CheckForCardBehavior;
import com.stripe.jvmcore.hardware.emv.ConfigurationListener;
import com.stripe.jvmcore.hardware.emv.Confirmation;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadFailure;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadSuccess;
import com.stripe.jvmcore.hardware.magstripe.MagstripeTransactionListener;
import com.stripe.jvmcore.hardware.status.BbposTamper;
import com.stripe.jvmcore.hardware.status.ReaderDisplayMessage;
import com.stripe.jvmcore.hardware.status.ReaderEvent;
import com.stripe.jvmcore.logging.terminal.log.Log;
import dagger.Lazy;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 H2\u00020\u0001:\u0001HBe\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u000e\b\u0001\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020 H\u0016J\b\u0010'\u001a\u00020\u0018H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020 H\u0016J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0018H\u0016J\u0016\u0010.\u001a\u00020\u00182\f\u0010/\u001a\b\u0012\u0004\u0012\u00020 00H\u0016J$\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 05H\u0017J\u0010\u00106\u001a\u00020\u00182\u0006\u0010)\u001a\u00020 H\u0016J\u0010\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0015H\u0016J\u0018\u00109\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0015H\u0017J\u0018\u0010=\u001a\u00020\u00182\u0006\u00102\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00182\u0006\u0010)\u001a\u00020 H\u0016J\u0010\u0010B\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0015H\u0016J\u0010\u0010C\u001a\u00020\u00182\u0006\u00102\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u00182\u0006\u0010F\u001a\u00020GH\u0016R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposTransactionListener;", "Lcom/stripe/core/bbpos/hardware/BbposControllerListener;", "readerController", "Ldagger/Lazy;", "Lcom/stripe/core/bbpos/hardware/BbposReaderController;", "magstripeListener", "Lcom/stripe/jvmcore/hardware/magstripe/MagstripeTransactionListener;", "kernelInterface", "Lcom/stripe/core/hardware/emv/CombinedKernelInterface;", "configurationListener", "Lcom/stripe/jvmcore/hardware/emv/ConfigurationListener;", "readerStatusListener", "Lcom/stripe/core/hardware/status/ReaderStatusListener;", "connectedReaderProvider", "Ljavax/inject/Provider;", "Lcom/stripe/core/hardware/Reader;", "bbposReaderInfoFactory", "Lcom/stripe/core/bbpos/hardware/BbposReaderInfoFactory;", "discoveryFilter", "Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothDiscoveryFilter;", "debugLogsShouldBeSentToSplunk", "", "(Ldagger/Lazy;Lcom/stripe/jvmcore/hardware/magstripe/MagstripeTransactionListener;Lcom/stripe/core/hardware/emv/CombinedKernelInterface;Lcom/stripe/jvmcore/hardware/emv/ConfigurationListener;Lcom/stripe/core/hardware/status/ReaderStatusListener;Ljavax/inject/Provider;Lcom/stripe/core/bbpos/hardware/BbposReaderInfoFactory;Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothDiscoveryFilter;Ljavax/inject/Provider;)V", "notifyReaderStatusListener", "", "checkCardResult", "Lcom/stripe/bbpos/sdk/CheckCardResult$Type;", "onDeviceTampered", "bbposTamper", "Lcom/stripe/jvmcore/hardware/status/BbposTamper;", "onRequestDisplayAsterisk", "unmaskedDigits", "", "numOfAsterisk", "", "onRequestDisplayText", "displayText", "Lcom/stripe/bbpos/sdk/DisplayText;", "displayTextLanguage", "onRequestFinalConfirm", "onRequestOnlineProcess", "tlv", "onRequestPinEntry", "pinEntrySource", "Lcom/stripe/bbpos/sdk/PinEntrySource;", "onRequestSelectAccountType", "onRequestSelectApplication", "appList", "", "onReturnAmount", "result", "Lcom/stripe/core/bbpos/hardware/api/AmountInputResult;", "data", "", "onReturnBatchData", "onReturnCancelCheckCardResult", "isSuccess", "onReturnCheckCardResult", "cardData", "Lcom/stripe/bbpos/sdk/CardData;", "onReturnDisableInputAmountResult", "onReturnPinEntryResult", "Lcom/stripe/bbpos/sdk/PinEntryResult$Type;", "pinData", "Lcom/stripe/bbpos/sdk/PinData;", "onReturnReversalData", "onReturnSetPinPadButtonsResult", "onReturnTransactionResult", "Lcom/stripe/bbpos/sdk/TransactionResult$Type;", "onWaitingForCard", "checkCardMode", "Lcom/stripe/bbpos/sdk/CheckCardMode;", "Companion", "hardware_release"})
@SourceDebugExtension(value={"SMAP\nBbposTransactionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposTransactionListener.kt\ncom/stripe/core/bbpos/hardware/BbposTransactionListener\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,473:1\n429#2:474\n502#2,5:475\n*S KotlinDebug\n*F\n+ 1 BbposTransactionListener.kt\ncom/stripe/core/bbpos/hardware/BbposTransactionListener\n*L\n410#1:474\n410#1:475,5\n*E\n"})
public final class BbposTransactionListener
extends BbposControllerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy<BbposReaderController> readerController;
    @NotNull
    private final MagstripeTransactionListener magstripeListener;
    @NotNull
    private final CombinedKernelInterface kernelInterface;
    @NotNull
    private final ReaderStatusListener readerStatusListener;
    @NotNull
    private final Provider<Reader> connectedReaderProvider;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(BbposTransactionListener.class);

    public BbposTransactionListener(@NotNull Lazy<BbposReaderController> readerController, @NotNull MagstripeTransactionListener magstripeListener, @NotNull CombinedKernelInterface kernelInterface, @NotNull ConfigurationListener configurationListener, @NotNull ReaderStatusListener readerStatusListener, @NotNull Provider<Reader> connectedReaderProvider, @NotNull BbposReaderInfoFactory bbposReaderInfoFactory, @NotNull BbposBluetoothDiscoveryFilter discoveryFilter, @DebugLogsShouldBeSentToSplunk @NotNull Provider<Boolean> debugLogsShouldBeSentToSplunk) {
        Intrinsics.checkNotNullParameter(readerController, (String)"readerController");
        Intrinsics.checkNotNullParameter((Object)magstripeListener, (String)"magstripeListener");
        Intrinsics.checkNotNullParameter((Object)kernelInterface, (String)"kernelInterface");
        Intrinsics.checkNotNullParameter((Object)configurationListener, (String)"configurationListener");
        Intrinsics.checkNotNullParameter((Object)readerStatusListener, (String)"readerStatusListener");
        Intrinsics.checkNotNullParameter(connectedReaderProvider, (String)"connectedReaderProvider");
        Intrinsics.checkNotNullParameter((Object)bbposReaderInfoFactory, (String)"bbposReaderInfoFactory");
        Intrinsics.checkNotNullParameter((Object)discoveryFilter, (String)"discoveryFilter");
        Intrinsics.checkNotNullParameter(debugLogsShouldBeSentToSplunk, (String)"debugLogsShouldBeSentToSplunk");
        super(readerStatusListener, configurationListener, bbposReaderInfoFactory, discoveryFilter, debugLogsShouldBeSentToSplunk, null, 32, null);
        this.readerController = readerController;
        this.magstripeListener = magstripeListener;
        this.kernelInterface = kernelInterface;
        this.readerStatusListener = readerStatusListener;
        this.connectedReaderProvider = connectedReaderProvider;
    }

    @Override
    public void onWaitingForCard(@NotNull CheckCardMode checkCardMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)checkCardMode), (String)"checkCardMode");
        LOGGER.i("onWaitingForCard " + (Object)((Object)checkCardMode), new Pair[0]);
        this.readerStatusListener.handleRequestReaderConfiguration(CheckCardModeConverter.INSTANCE.toReaderConfiguration(checkCardMode));
        this.kernelInterface.reset();
    }

    @Override
    public void onReturnCancelCheckCardResult(boolean isSuccess) {
        LOGGER.i("onReturnCancelCheckCardResult " + isSuccess, new Pair[0]);
        ReaderStatusListener.handleCancellation$default(this.readerStatusListener, null, 1, null);
        this.kernelInterface.reset();
    }

    @Override
    public void onReturnCheckCardResult(@NotNull CheckCardResult.Type checkCardResult, @NotNull CardData cardData) {
        Intrinsics.checkNotNullParameter((Object)((Object)checkCardResult), (String)"checkCardResult");
        Intrinsics.checkNotNullParameter((Object)((Object)cardData), (String)"cardData");
        LOGGER.i("onReturnCheckCardResult " + (Object)((Object)checkCardResult), new Pair[0]);
        Reader reader = (Reader)this.connectedReaderProvider.get();
        boolean shouldPoll = (reader != null ? reader.getCheckForCardBehavior() : null) == CheckForCardBehavior.POLL_FOR_CARD_REMOVAL;
        this.notifyReaderStatusListener(checkCardResult);
        switch (WhenMappings.$EnumSwitchMapping$0[checkCardResult.ordinal()]) {
            case 1: {
                this.kernelInterface.handleCardStatus(CardStatus.NO_CARD);
                break;
            }
            case 2: {
                if (!shouldPoll) break;
                this.kernelInterface.checkForInsertedCard();
                break;
            }
            case 3: {
                if (!shouldPoll) break;
                this.kernelInterface.checkForInsertedCard();
                break;
            }
            case 4: {
                this.magstripeListener.handleReadResult(new MagStripeReadFailure(MagStripeReadFailure.FailureType.BAD_SWIPE));
                break;
            }
            case 5: {
                String encryptedTrack2 = cardData.encTrack2;
                String ksn = cardData.ksn;
                String maskedPan = cardData.maskedPan;
                String expiryDate = cardData.expiryDate;
                String serviceCode = cardData.serviceCode;
                if (encryptedTrack2 != null && ksn != null && maskedPan != null && expiryDate != null && serviceCode != null) {
                    if (((CharSequence)encryptedTrack2).length() == 0 || ((CharSequence)ksn).length() == 0) {
                        this.magstripeListener.handleReadResult(new MagStripeReadFailure(MagStripeReadFailure.FailureType.BAD_SWIPE));
                        break;
                    }
                    this.magstripeListener.handleReadResult(new MagStripeReadSuccess(encryptedTrack2, ksn, maskedPan, expiryDate, serviceCode, null, null, 96, null));
                    break;
                }
                LOGGER.w("Magstripe read was missing one or more required values", new Pair[0]);
                this.magstripeListener.handleReadResult(new MagStripeReadFailure(MagStripeReadFailure.FailureType.MSR_FAILURE));
                break;
            }
            case 6: {
                this.magstripeListener.handleReadResult(new MagStripeReadFailure(MagStripeReadFailure.FailureType.MSR_FAILURE));
                break;
            }
            case 7: {
                LOGGER.w("Received USE_ICC_CARD, which should be deprecated", new Pair[0]);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                LOGGER.w("Received MANUAL_PAN_ENTRY, which should not be used", new Pair[0]);
                break;
            }
            case 10: {
                this.magstripeListener.handleReadResult(new MagStripeReadFailure(MagStripeReadFailure.FailureType.BAD_SWIPE));
                break;
            }
            case 11: {
            }
        }
    }

    @Override
    public void onRequestSelectApplication(@NotNull List<String> appList) {
        Intrinsics.checkNotNullParameter(appList, (String)"appList");
        LOGGER.i("onRequestSelectApplication", new Pair[0]);
        this.kernelInterface.handleApplicationSelectionRequest(appList);
        this.readerStatusListener.handleApplicationSelectionRequest();
    }

    @Override
    public void onRequestSelectAccountType() {
        LOGGER.i("onRequestSelectAccountType", new Pair[0]);
        this.kernelInterface.handleAccountTypeSelectionRequest();
        this.readerStatusListener.handleAccountTypeSelectionRequest();
    }

    @Override
    public void onRequestFinalConfirm() {
        LOGGER.i("onRequestFinalConfirm", new Pair[0]);
        this.kernelInterface.handleFinalConfirmationRequest();
    }

    @Override
    public void onRequestOnlineProcess(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
        LOGGER.i("onRequestOnlineProcess", new Pair[0]);
        if (((CharSequence)tlv).length() > 0) {
            this.kernelInterface.handleAuthRequest(tlv);
        }
    }

    @Override
    public void onReturnBatchData(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
        LOGGER.i("onReturnBatchData", new Pair[0]);
        if (((CharSequence)tlv).length() > 0) {
            this.kernelInterface.handleFinalData(tlv);
        }
    }

    @Override
    public void onReturnReversalData(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
        LOGGER.i("onReturnReversalData", new Pair[0]);
        if (((CharSequence)tlv).length() > 0) {
            this.kernelInterface.handleFinalData(tlv);
        }
    }

    @Override
    public void onReturnTransactionResult(@NotNull TransactionResult.Type result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        LOGGER.i("onReturnTransactionResult " + (Object)((Object)result2), new Pair[0]);
        TransactionResult.Result emvResult = BbposTranslation.INSTANCE.toTransactionResult(result2);
        if (emvResult == TransactionResult.Result.ICC_CARD_REMOVED) {
            this.readerStatusListener.handleReaderDisplayMessage(ReaderDisplayMessage.CARD_REMOVED_TOO_EARLY);
            this.readerStatusListener.handleReaderEvent(ReaderEvent.CARD_REMOVED);
        }
        this.readerStatusListener.handleTransactionResult(emvResult);
        switch (WhenMappings.$EnumSwitchMapping$1[result2.ordinal()]) {
            case 1: {
                this.kernelInterface.handleCardStatus(CardStatus.NO_CARD);
                break;
            }
            case 2: {
                ((BbposReaderController)this.readerController.get()).refresh();
                break;
            }
            default: {
                this.kernelInterface.handleResult(emvResult);
            }
        }
    }

    @Override
    public void onRequestDisplayText(@NotNull DisplayText displayText, @NotNull String displayTextLanguage) {
        Intrinsics.checkNotNullParameter((Object)((Object)displayText), (String)"displayText");
        Intrinsics.checkNotNullParameter((Object)displayTextLanguage, (String)"displayTextLanguage");
        LOGGER.i("onRequestDisplayText " + (Object)((Object)displayText), new Pair[0]);
        ReaderDisplayMessage message = null;
        switch (WhenMappings.$EnumSwitchMapping$2[displayText.ordinal()]) {
            case 1: {
                message = ReaderDisplayMessage.TRY_ANOTHER_CARD;
                this.kernelInterface.handleResult(TransactionResult.Result.CONTACTLESS_LIMIT_EXCEEDED);
                break;
            }
            case 2: {
                this.readerStatusListener.handleReaderEvent(ReaderEvent.CARD_INSERTED);
                this.kernelInterface.handleCardStatus(CardStatus.CARD_PROCESSING);
                break;
            }
            case 3: {
                message = ReaderDisplayMessage.TRY_ANOTHER_READ_METHOD;
                this.kernelInterface.handleCardStatus(CardStatus.CARD_NOT_WORKING);
                break;
            }
            case 4: {
                message = ReaderDisplayMessage.CHECK_MOBILE_DEVICE;
                this.kernelInterface.handleResult(TransactionResult.Result.CHECK_MOBILE_DEVICE);
                break;
            }
            case 5: {
                message = ReaderDisplayMessage.INSERT_OR_SWIPE_CARD;
                this.kernelInterface.handleResult(TransactionResult.Result.INSERT_OR_SWIPE_REQUIRED);
                break;
            }
            case 6: {
                Reader reader = (Reader)this.connectedReaderProvider.get();
                boolean bl = reader != null ? reader.getFirmwareCanHandleSelection() : false;
                if (!bl) break;
                this.kernelInterface.handleResult(TransactionResult.Result.INSERT_OR_SWIPE_REQUIRED);
                break;
            }
            case 7: {
                message = ReaderDisplayMessage.TRY_ANOTHER_READ_METHOD;
                this.kernelInterface.handleResult(TransactionResult.Result.INSERT_OR_SWIPE_REQUIRED);
                break;
            }
            case 8: {
                Reader reader = (Reader)this.connectedReaderProvider.get();
                message = ((reader instanceof Reader.BluetoothReader.Wisepad3Reader ? true : reader instanceof Reader.UsbReader.Wisepad3Reader) ? true : reader instanceof Reader.UsbReader.Wisepad3SReader) ? ReaderDisplayMessage.TRY_ANOTHER_CARD : ReaderDisplayMessage.SWIPE_CARD;
                this.kernelInterface.handleResult(TransactionResult.Result.EMPTY_CANDIDATE_LIST);
                break;
            }
            case 9: {
                message = ReaderDisplayMessage.MULTIPLE_CONTACTLESS_CARDS_DETECTED;
                this.kernelInterface.handleResult(TransactionResult.Result.MULTIPLE_CARDS_DETECTED);
                break;
            }
            case 10: {
                message = ReaderDisplayMessage.INSERT_CARD;
                break;
            }
            case 11: {
                message = ReaderDisplayMessage.SWIPE_CARD;
                break;
            }
            case 12: {
                message = ReaderDisplayMessage.RETRY_CARD;
                break;
            }
            case 13: {
                message = ReaderDisplayMessage.REMOVE_CARD;
                break;
            }
            case 14: {
                message = ReaderDisplayMessage.TRY_ANOTHER_CARD;
                break;
            }
            case 15: {
                message = ReaderDisplayMessage.TRY_ANOTHER_READ_METHOD;
            }
        }
        if (message != null) {
            this.readerStatusListener.handleReaderDisplayMessage(message);
        }
        if (displayText == DisplayText.PRESENT_CARD_AGAIN) {
            this.kernelInterface.reset();
        }
    }

    @Override
    public void onRequestDisplayAsterisk(@NotNull String unmaskedDigits, int numOfAsterisk) {
        Intrinsics.checkNotNullParameter((Object)unmaskedDigits, (String)"unmaskedDigits");
        this.kernelInterface.handlePinDisplayUpdate(numOfAsterisk);
    }

    @Override
    public void onRequestPinEntry(@NotNull PinEntrySource pinEntrySource) {
        Intrinsics.checkNotNullParameter((Object)((Object)pinEntrySource), (String)"pinEntrySource");
        LOGGER.i("onRequestPinEntry " + (Object)((Object)pinEntrySource), new Pair[0]);
        this.kernelInterface.handlePinEntryRequest();
    }

    @Override
    public void onReturnPinEntryResult(@NotNull PinEntryResult.Type result2, @NotNull PinData pinData) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        Intrinsics.checkNotNullParameter((Object)((Object)pinData), (String)"pinData");
        LOGGER.i("onReturnPinEntryResult " + (Object)((Object)result2), new Pair[0]);
        switch (WhenMappings.$EnumSwitchMapping$3[result2.ordinal()]) {
            case 1: {
                throw new IllegalArgumentException("Invalid PinEntryResult.Type");
            }
            case 2: {
                this.kernelInterface.handlePinReceived(null);
                break;
            }
            case 3: {
                this.kernelInterface.cancel();
                break;
            }
            case 4: {
                this.kernelInterface.cancel();
                break;
            }
            case 5: {
                this.kernelInterface.handlePinReceived(null);
                break;
            }
            case 6: {
                this.kernelInterface.handlePinReceived(Confirmation.Pin.Error.WRONG_LENGTH);
                break;
            }
            case 7: {
                this.kernelInterface.handlePinReceived(Confirmation.Pin.Error.INCORRECT);
            }
        }
    }

    @Override
    public void onReturnSetPinPadButtonsResult(boolean isSuccess) {
        LOGGER.i("onReturnSetPinPadButtonsResult " + isSuccess, new Pair[0]);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @BluetoothUsbPinPadReaders
    public void onReturnAmount(@NotNull AmountInputResult result, @NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        BbposTransactionListener.LOGGER.i("onReturnAmount amountInputResult: " + (Object)result + ", data: " + data, new Pair[0]);
        switch (WhenMappings.$EnumSwitchMapping$4[result.ordinal()]) {
            case 1: {
                if (!(data.isEmpty() == false)) ** GOTO lbl32
                v0 = data.get("tipsAmount");
                if (v0 == null) ** GOTO lbl-1000
                $this$filter$iv = v0;
                $i$f$filter = false;
                var7_5 = $this$filter$iv;
                destination$iv$iv = new StringBuilder();
                $i$f$filterTo = false;
                var11_9 = $this$filterTo$iv$iv.length();
                for (index$iv$iv = 0; index$iv$iv < var11_9; ++index$iv$iv) {
                    it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    $i$a$-filter-BbposTransactionListener$onReturnAmount$tippingFlowResult$tipAmountLong$1 = false;
                    if (!Character.isDigit(it)) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                v1 = ((StringBuilder)destination$iv$iv).toString();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filterTo(StringBuilder(), predicate).toString()");
                v0 = v1;
                if (v1 != null) {
                    v2 = StringsKt.toLongOrNull((String)v0);
                } else lbl-1000:
                // 2 sources

                {
                    v2 = tipAmountLong = null;
                }
                v3 = tipAmountLong == null ? (LegacyTipSelectionResult)new LegacyTipSelectionFailure(TippingSelectionFailureReason.CALLBACK_NO_TIP_AMOUNT) : (LegacyTipSelectionResult)new LegacyTipSelected(tipAmountLong);
                ** GOTO lbl33
lbl32:
                // 1 sources

                v3 = new LegacyTipSelectionFailure(TippingSelectionFailureReason.CALLBACK_NO_DATA);
lbl33:
                // 2 sources

                tippingFlowResult = v3;
                this.readerStatusListener.handleTipSelectionResult(tippingFlowResult);
                break;
            }
            case 2: {
                this.readerStatusListener.handleTipSelectionResult(LegacyNoTipSelected.INSTANCE);
                break;
            }
            case 3: {
                tippingFlowResult = new LegacyTipSelectionFailure(TippingSelectionFailureReason.TIMEOUT);
                this.readerStatusListener.handleTipSelectionResult(tippingFlowResult);
                break;
            }
            case 4: {
                tippingFlowResult = new LegacyTipSelectionFailure(TippingSelectionFailureReason.INVALID_AMOUNT);
                this.readerStatusListener.handleTipSelectionResult(tippingFlowResult);
            }
        }
    }

    @Override
    @BluetoothUsbPinPadReaders
    public void onReturnDisableInputAmountResult(boolean isSuccess) {
        LOGGER.i("onReturnDisableInputAmountResult " + isSuccess, new Pair[0]);
        ReaderStatusListener.handleCancellation$default(this.readerStatusListener, null, 1, null);
    }

    @VisibleForTesting
    public final void notifyReaderStatusListener(@NotNull CheckCardResult.Type checkCardResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)checkCardResult), (String)"checkCardResult");
        switch (WhenMappings.$EnumSwitchMapping$0[checkCardResult.ordinal()]) {
            case 1: {
                this.readerStatusListener.handleReaderEvent(ReaderEvent.CARD_REMOVED);
                break;
            }
            case 2: {
                this.readerStatusListener.handleReaderEvent(ReaderEvent.CARD_INSERTED);
            }
        }
    }

    @Override
    public void onDeviceTampered(@NotNull BbposTamper bbposTamper) {
        Intrinsics.checkNotNullParameter((Object)bbposTamper, (String)"bbposTamper");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/bbpos/hardware/BbposTransactionListener$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "hardware_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[CheckCardResult.Type.values().length];
            try {
                nArray[CheckCardResult.Type.NO_CARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.INSERTED_CARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.NOT_ICC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.BAD_SWIPE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.MSR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.MAG_HEAD_FAIL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.USE_ICC_CARD.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.TAP_CARD_DETECTED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.MANUAL_PAN_ENTRY.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.CARD_NOT_SUPPORTED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckCardResult.Type.CHECK_CARD_RESULT_TYPE_UNKNOWN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TransactionResult.Type.values().length];
            try {
                nArray[TransactionResult.Type.NOT_ICC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Type.CANCELED_OR_TIMEOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[DisplayText.values().length];
            try {
                nArray[DisplayText.CTL_TRANSACTION_LIMIT_EXCEEDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.PROCESSING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.NOT_ICC_CARD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.REFER_TO_YOUR_PAYMENT_DEVICE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INSERT_OR_SWIPE_CARD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INSERT_SWIPE_OR_TRY_ANOTHER_CARD.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CTL_NO_EMV_APPS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.NO_EMV_APPS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.MULTIPLE_CARDS_DETECTED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.INSERT_CARD.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.USE_MAG_STRIPE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.PRESENT_CARD_AGAIN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.REMOVE_CARD.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.NOT_ACCEPTED.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayText.CTL_APP_NOT_SUPPORTED.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[PinEntryResult.Type.values().length];
            try {
                nArray[PinEntryResult.Type.PIN_ENTRY_RESULT_UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.ENTERED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.CANCEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.TIMEOUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.BYPASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.WRONG_PIN_LENGTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.INCORRECT_PIN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryResult.Type.ICC_REMOVED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[AmountInputResult.values().length];
            try {
                nArray[AmountInputResult.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmountInputResult.CANCEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmountInputResult.TIMEOUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmountInputResult.INVALID_AMOUNT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

