/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware;

import androidx.annotation.VisibleForTesting;
import com.stripe.jvmcore.logging.terminal.log.Log;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/core/bbpos/hardware/CardRemovalDeviceBusyDetector;", "", "()V", "consecutiveDeviceBusyCount", "", "isPollingCardRemoval", "", "onCardRemovalDetectionEnd", "", "onCardRemovalDetectionStart", "onReturnCheckCardResult", "shouldFakeCardEmptyOnDeviceBusy", "Companion", "hardware_release"})
public final class CardRemovalDeviceBusyDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int consecutiveDeviceBusyCount;
    private boolean isPollingCardRemoval;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(CardRemovalDeviceBusyDetector.class);
    public static final int MAX_CONSECUTIVE_DEVICE_BUSY_COUNT = 15;

    public final void onCardRemovalDetectionStart() {
        this.consecutiveDeviceBusyCount = 0;
        this.isPollingCardRemoval = true;
    }

    public final void onCardRemovalDetectionEnd() {
        this.isPollingCardRemoval = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldFakeCardEmptyOnDeviceBusy() {
        if (!this.isPollingCardRemoval) return false;
        ++this.consecutiveDeviceBusyCount;
        if (this.consecutiveDeviceBusyCount < 15) return false;
        LOGGER.e("Error detecting card removal. Always receiving DEVICE_BUSY.", new Pair[0]);
        return true;
    }

    public final void onReturnCheckCardResult() {
        this.consecutiveDeviceBusyCount = 0;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\b"}, d2={"Lcom/stripe/core/bbpos/hardware/CardRemovalDeviceBusyDetector$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "MAX_CONSECUTIVE_DEVICE_BUSY_COUNT", "", "getMAX_CONSECUTIVE_DEVICE_BUSY_COUNT$hardware_release$annotations", "hardware_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_CONSECUTIVE_DEVICE_BUSY_COUNT$hardware_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

