/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware;

import com.neovisionaries.i18n.CurrencyCode;
import com.stripe.bbpos.sdk.AmountInputType;
import com.stripe.bbpos.sdk.CheckCardMode;
import com.stripe.bbpos.sdk.ContactlessOnlinePinOption;
import com.stripe.bbpos.sdk.DomesticDebitPriority;
import com.stripe.bbpos.sdk.FixedAmountTips;
import com.stripe.bbpos.sdk.OtherAmountOption;
import com.stripe.bbpos.sdk.PercentageTips;
import com.stripe.bbpos.sdk.QuickChipOption;
import com.stripe.core.bbpos.hardware.api.DeviceControllerWrapper;
import com.stripe.core.bbpos.hardware.api.TippingOption;
import com.stripe.core.bbpos.hardware.emv.CheckCardModeConverter;
import com.stripe.core.hardware.tipping.InvalidTipConfig;
import com.stripe.core.hardware.tipping.TipConfigValidationResult;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.time.Clock;
import com.stripe.proto.model.config.ReaderFeatureFlags;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\f*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lcom/stripe/core/bbpos/hardware/DelegatedDeviceController;", "", "clock", "Lcom/stripe/jvmcore/time/Clock;", "getClock", "()Lcom/stripe/jvmcore/time/Clock;", "featureFlagsProvider", "Ljavax/inject/Provider;", "Lcom/stripe/proto/model/config/ReaderFeatureFlags;", "getFeatureFlagsProvider", "()Ljavax/inject/Provider;", "enableInputAmount", "", "Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;", "tipConfigValidationResult", "Lcom/stripe/core/hardware/tipping/TipConfigValidationResult;", "startEmv", "configuration", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration;", "checkCardModeOverride", "Lcom/stripe/bbpos/sdk/CheckCardMode;", "Companion", "hardware_release"})
@SourceDebugExtension(value={"SMAP\nDelegatedDeviceController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelegatedDeviceController.kt\ncom/stripe/core/bbpos/hardware/DelegatedDeviceController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1#2:141\n1549#3:142\n1620#3,3:143\n1549#3:146\n1620#3,3:147\n*S KotlinDebug\n*F\n+ 1 DelegatedDeviceController.kt\ncom/stripe/core/bbpos/hardware/DelegatedDeviceController\n*L\n49#1:142\n49#1:143,3\n62#1:146\n62#1:147,3\n*E\n"})
public interface DelegatedDeviceController {
    @NotNull
    public static final Companion Companion = com.stripe.core.bbpos.hardware.DelegatedDeviceController$Companion.$$INSTANCE;

    @NotNull
    public Clock getClock();

    @NotNull
    public Provider<ReaderFeatureFlags> getFeatureFlagsProvider();

    /*
     * WARNING - void declaration
     */
    default public void enableInputAmount(@NotNull DeviceControllerWrapper $this$enableInputAmount, @NotNull TipConfigValidationResult tipConfigValidationResult) {
        TippingOption tippingOption;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map22;
        String string;
        int n2;
        int n3;
        CurrencyCode currencyCode;
        Intrinsics.checkNotNullParameter((Object)$this$enableInputAmount, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tipConfigValidationResult, (String)"tipConfigValidationResult");
        TipConfigValidationResult tipConfigValidationResult2 = tipConfigValidationResult;
        if (tipConfigValidationResult2 instanceof com.stripe.core.hardware.tipping.PercentageTips) {
            void it;
            currencyCode = ((com.stripe.core.hardware.tipping.PercentageTips)tipConfigValidationResult).getCurrency();
            com.stripe.core.hardware.tipping.PercentageTips percentageTips = (com.stripe.core.hardware.tipping.PercentageTips)tipConfigValidationResult;
            n3 = currencyCode.getMinorUnit();
            n2 = currencyCode.getNumeric();
            boolean $i$a$-let-DelegatedDeviceController$enableInputAmount$tippingOption$22 = false;
            string = DelegatedDeviceController.Companion.formattedWith(it.getAmount(), it.getCurrency());
            Iterable iterable = ((com.stripe.core.hardware.tipping.PercentageTips)tipConfigValidationResult).getPercentageTips();
            $i$f$map22 = false;
            Iterable $i$a$-let-DelegatedDeviceController$enableInputAmount$tippingOption$22 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                int n4 = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl = false;
                BigDecimal bigDecimal = BigDecimal.valueOf((long)it2);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
                collection.add(bigDecimal.toPlainString());
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n5 = 16;
            ByteString byteString = null;
            List list = collection;
            String string2 = string;
            int n6 = n3;
            int n7 = n2;
            tippingOption = TippingOption.Percentage.box-impl(TippingOption.Percentage.constructor-impl(new PercentageTips(n7, n6, string2, list, byteString, n5, defaultConstructorMarker)));
        } else if (tipConfigValidationResult2 instanceof com.stripe.core.hardware.tipping.FixedAmountTips) {
            void it;
            currencyCode = ((com.stripe.core.hardware.tipping.FixedAmountTips)tipConfigValidationResult).getCurrency();
            com.stripe.core.hardware.tipping.FixedAmountTips $i$f$map22 = (com.stripe.core.hardware.tipping.FixedAmountTips)tipConfigValidationResult;
            n3 = currencyCode.getMinorUnit();
            n2 = currencyCode.getNumeric();
            boolean $i$a$-let-DelegatedDeviceController$enableInputAmount$tippingOption$42 = false;
            string = DelegatedDeviceController.Companion.formattedWith(it.getAmount(), it.getCurrency());
            $this$map$iv = ((com.stripe.core.hardware.tipping.FixedAmountTips)tipConfigValidationResult).getAmountTips();
            $i$f$map22 = false;
            Iterable $i$a$-let-DelegatedDeviceController$enableInputAmount$tippingOption$42 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                long it2 = ((Number)item$iv$iv).longValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DelegatedDeviceController.Companion.formattedWith(it2, currencyCode));
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n8 = 16;
            ByteString byteString = null;
            Collection collection2 = collection;
            String string3 = string;
            int n9 = n3;
            int n10 = n2;
            tippingOption = TippingOption.FixedAmount.box-impl(TippingOption.FixedAmount.constructor-impl(new FixedAmountTips(n10, n9, string3, (List)collection2, byteString, n8, defaultConstructorMarker)));
        } else if (tipConfigValidationResult2 instanceof InvalidTipConfig) {
            tippingOption = TippingOption.None.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        TippingOption tippingOption2 = tippingOption;
        $this$enableInputAmount.enableInputAmount(3600, AmountInputType.TIPS_ONLY, OtherAmountOption.CURRENCY, tippingOption2);
    }

    default public void startEmv(@NotNull DeviceControllerWrapper $this$startEmv, @NotNull ReaderConfiguration configuration, @Nullable CheckCardMode checkCardModeOverride) {
        ContactlessOnlinePinOption contactlessOnlinePinOption;
        DomesticDebitPriority domesticDebitPriority;
        QuickChipOption quickChipOption;
        CheckCardMode checkCardMode;
        com.stripe.bbpos.sdk.TransactionType transactionType;
        Intrinsics.checkNotNullParameter((Object)$this$startEmv, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        CurrencyCode currencyCode = configuration.getTransactionAmount().getCurrency();
        switch (WhenMappings.$EnumSwitchMapping$0[configuration.getTransactionType().ordinal()]) {
            case 1: {
                transactionType = com.stripe.bbpos.sdk.TransactionType.GOODS;
                break;
            }
            case 2: {
                transactionType = com.stripe.bbpos.sdk.TransactionType.REFUND;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if ((checkCardMode = checkCardModeOverride) == null) {
            checkCardMode = CheckCardModeConverter.INSTANCE.toCheckCardMode(configuration.getReadersEnabled());
        }
        switch (WhenMappings.$EnumSwitchMapping$1[configuration.getQuickChipMode().ordinal()]) {
            case 1: {
                quickChipOption = QuickChipOption.USE_EMV;
                break;
            }
            case 2: {
                quickChipOption = QuickChipOption.USE_CONFIG;
                break;
            }
            case 3: {
                quickChipOption = QuickChipOption.USE_QUICKCHIP;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean bl = configuration.getEmvTransactionType() != TransactionType.QUICK;
        int n2 = currencyCode.getNumeric();
        int n3 = currencyCode.getMinorUnit();
        String string = DelegatedDeviceController.Companion.formatted(configuration.getTransactionAmount());
        String string2 = DelegatedDeviceController.Companion.toTerminalTime(this.getClock().currentTimeMillis());
        String string3 = configuration.getTerminalCapabilitiesOverride();
        ReaderConfiguration.DomesticDebitPriority domesticDebitPriority2 = configuration.getDomesticDebitPriority();
        switch (domesticDebitPriority2 == null ? -1 : WhenMappings.$EnumSwitchMapping$2[domesticDebitPriority2.ordinal()]) {
            case 1: {
                domesticDebitPriority = DomesticDebitPriority.STANDARD;
                break;
            }
            case 2: {
                domesticDebitPriority = DomesticDebitPriority.TOP;
                break;
            }
            case 3: {
                domesticDebitPriority = DomesticDebitPriority.BOTTOM;
                break;
            }
            case 4: {
                domesticDebitPriority = DomesticDebitPriority.OFF;
                break;
            }
            case -1: {
                domesticDebitPriority = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ReaderConfiguration.ContactlessOnlinePinOption contactlessOnlinePinOption2 = configuration.getContactlessOnlinePinOption();
        switch (contactlessOnlinePinOption2 == null ? -1 : WhenMappings.$EnumSwitchMapping$3[contactlessOnlinePinOption2.ordinal()]) {
            case 1: {
                contactlessOnlinePinOption = ContactlessOnlinePinOption.DISABLED;
                break;
            }
            case 2: {
                contactlessOnlinePinOption = ContactlessOnlinePinOption.ENABLED;
                break;
            }
            case -1: {
                contactlessOnlinePinOption = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$startEmv.startEmv(transactionType, checkCardMode, quickChipOption, bl, n2, n3, string, string2, 3600, 90, 90, 90, string3, domesticDebitPriority, contactlessOnlinePinOption);
    }

    public static /* synthetic */ void startEmv$default(DelegatedDeviceController delegatedDeviceController, DeviceControllerWrapper deviceControllerWrapper, ReaderConfiguration readerConfiguration, CheckCardMode checkCardMode, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startEmv");
        }
        if ((n2 & 2) != 0) {
            checkCardMode = null;
        }
        delegatedDeviceController.startEmv(deviceControllerWrapper, readerConfiguration, checkCardMode);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002J\u0014\u0010\b\u001a\u00020\u0006*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\u0006*\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/core/bbpos/hardware/DelegatedDeviceController$Companion;", "", "()V", "terminalTimeFormatter", "Ljava/text/SimpleDateFormat;", "formatted", "", "Lcom/stripe/jvmcore/currency/Amount;", "formattedWith", "", "currency", "Lcom/neovisionaries/i18n/CurrencyCode;", "toTerminalTime", "hardware_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final SimpleDateFormat terminalTimeFormatter;

        private Companion() {
        }

        private final String formatted(Amount $this$formatted) {
            return this.formattedWith($this$formatted.getValue(), $this$formatted.getCurrency());
        }

        private final String formattedWith(long $this$formattedWith, CurrencyCode currency) {
            BigDecimal bigDecimal = BigDecimal.valueOf($this$formattedWith);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            String string = bigDecimal.movePointLeft(currency.getMinorUnit()).toPlainString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toBigDecimal()\n         \u2026         .toPlainString()");
            return string;
        }

        private final String toTerminalTime(long $this$toTerminalTime) {
            String string = terminalTimeFormatter.format($this$toTerminalTime);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"terminalTimeFormatter.format(this)");
            return string;
        }

        static {
            $$INSTANCE = new Companion();
            terminalTimeFormatter = new SimpleDateFormat("yyMMddHHmmss", Locale.US);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[ReaderConfiguration.TransactionType.values().length];
            try {
                nArray[ReaderConfiguration.TransactionType.GOODS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReaderConfiguration.TransactionType.REFUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReaderConfiguration.QuickChipOption.values().length];
            try {
                nArray[ReaderConfiguration.QuickChipOption.USE_EMV.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReaderConfiguration.QuickChipOption.USE_CONFIG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReaderConfiguration.QuickChipOption.USE_QUICKCHIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ReaderConfiguration.DomesticDebitPriority.values().length];
            try {
                nArray[ReaderConfiguration.DomesticDebitPriority.STANDARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReaderConfiguration.DomesticDebitPriority.TOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReaderConfiguration.DomesticDebitPriority.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReaderConfiguration.DomesticDebitPriority.OFF.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[ReaderConfiguration.ContactlessOnlinePinOption.values().length];
            try {
                nArray[ReaderConfiguration.ContactlessOnlinePinOption.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReaderConfiguration.ContactlessOnlinePinOption.ENABLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

