/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware.discovery;

import android.annotation.SuppressLint;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.ParcelUuid;
import com.stripe.core.bbpos.hardware.discovery.BbposBluetoothScanner;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.status.ReaderStatusListener;
import com.stripe.core.hardware.status.ScanFailedFatalError;
import com.stripe.core.stripeterminal.log.AndroidLog;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0002!\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u001a\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0017JJ\u0010\u001f\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u001426\u0010\n\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000bH\u0007J\b\u0010 \u001a\u00020\u0012H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\n\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothScanner;", "Landroid/bluetooth/le/ScanCallback;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "readerStatusListener", "Lcom/stripe/core/hardware/status/ReaderStatusListener;", "scannerProvider", "Ljavax/inject/Provider;", "Landroid/bluetooth/le/BluetoothLeScanner;", "(Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/core/hardware/status/ReaderStatusListener;Ljavax/inject/Provider;)V", "onReaderDiscovered", "Lkotlin/Function2;", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "Lkotlin/ParameterName;", "name", "reader", "", "deviceName", "", "retryCount", "", "scanState", "Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothScanner$ScanState;", "scanStateLock", "Ljava/util/concurrent/locks/ReentrantLock;", "onScanFailed", "errorCode", "onScanResult", "callbackType", "result", "Landroid/bluetooth/le/ScanResult;", "startScan", "stopScan", "Companion", "ScanState", "hardware_release"})
public final class BbposBluetoothScanner
extends ScanCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final ReaderStatusListener readerStatusListener;
    @NotNull
    private final Provider<BluetoothLeScanner> scannerProvider;
    @NotNull
    private Function2<? super Reader.BluetoothReader, ? super String, Unit> onReaderDiscovered;
    private int retryCount;
    @NotNull
    private volatile ScanState scanState;
    @NotNull
    private final ReentrantLock scanStateLock;
    @NotNull
    private static final String TAG = "BbposBluetoothScanner";
    @NotNull
    private static final String BASE_BLUETOOTH_UUID_PREFIX = "0000";
    @NotNull
    private static final String BASE_BLUETOOTH_UUID_POSTFIX = "0000-1000-8000-00805F9B34FB";
    @NotNull
    private static final String BBPOS_BLUETOOTH_SID = "FFA0";
    @NotNull
    private static final String BLUETOOTH_SERVICE_ID = "0000FFA0-0000-1000-8000-00805F9B34FB";
    private static final long RETRY_DELAY = 5000L;
    private static final int MAX_RETRIES = 5;

    public BbposBluetoothScanner(@NotNull CoroutineDispatcher dispatcher, @NotNull ReaderStatusListener readerStatusListener, @NotNull Provider<BluetoothLeScanner> scannerProvider) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)readerStatusListener, (String)"readerStatusListener");
        Intrinsics.checkNotNullParameter(scannerProvider, (String)"scannerProvider");
        this.dispatcher = dispatcher;
        this.readerStatusListener = readerStatusListener;
        this.scannerProvider = scannerProvider;
        this.onReaderDiscovered = onReaderDiscovered.1.INSTANCE;
        this.scanState = ScanState.STOPPED;
        this.scanStateLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"MissingPermission"})
    public final void startScan(int retryCount, @NotNull Function2<? super Reader.BluetoothReader, ? super String, Unit> onReaderDiscovered2) {
        Intrinsics.checkNotNullParameter(onReaderDiscovered2, (String)"onReaderDiscovered");
        this.onReaderDiscovered = onReaderDiscovered2;
        this.retryCount = retryCount;
        Lock lock = this.scanStateLock;
        lock.lock();
        try {
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.scanState.ordinal()]) {
                case 1: 
                case 2: {
                    this.scanState = ScanState.STARTED;
                    break;
                }
                case 3: {
                    ScanFilter scanningFilter = new ScanFilter.Builder().setServiceUuid(ParcelUuid.fromString((String)BLUETOOTH_SERVICE_ID)).build();
                    ScanSettings settings = new ScanSettings.Builder().setScanMode(2).build();
                    BluetoothLeScanner bluetoothLeScanner = (BluetoothLeScanner)this.scannerProvider.get();
                    if (bluetoothLeScanner != null) {
                        bluetoothLeScanner.startScan(CollectionsKt.listOf((Object)scanningFilter), settings, (ScanCallback)this);
                    }
                    this.scanState = ScanState.STARTED;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void startScan$default(BbposBluetoothScanner bbposBluetoothScanner, int n2, Function2 function2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 0;
        }
        bbposBluetoothScanner.startScan(n2, (Function2<? super Reader.BluetoothReader, ? super String, Unit>)function2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"MissingPermission"})
    public final void stopScan() {
        Lock lock = this.scanStateLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.scanState == ScanState.STARTED) {
                this.scanState = ScanState.STOPPING;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.dispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BbposBluetoothScanner this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = BbposBluetoothScanner.access$getScanStateLock$p(this.this$0);
                        var3_4 = this.this$0;
                        var2_3.lock();
                        try {
                            $i$a$-withLock-BbposBluetoothScanner$stopScan$2$1 = false;
                            if (BbposBluetoothScanner.access$getScanState$p(var3_4) == ScanState.STOPPING) {
                                v1 = (BluetoothLeScanner)BbposBluetoothScanner.access$getScannerProvider$p(var3_4).get();
                                if (v1 != null) {
                                    v1.stopScan((ScanCallback)var3_4);
                                }
                                BbposBluetoothScanner.access$setScanState$p(var3_4, ScanState.STOPPED);
                            }
                            var4_6 = Unit.INSTANCE;
                        }
                        finally {
                            var2_3.unlock();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @SuppressLint(value={"MissingPermission"})
    public void onScanResult(int callbackType, @Nullable ScanResult result2) {
        block1: {
            Object object = result2;
            if (object == null || (object = object.getDevice()) == null || (object = object.getName()) == null) break block1;
            Object deviceName = object;
            boolean bl = false;
            Reader.BluetoothReader bluetoothReader = Reader.BluetoothReader.Companion.fromBluetoothDeviceOrNull(result2.getDevice());
            if (bluetoothReader != null) {
                Reader.BluetoothReader bluetoothReader2 = bluetoothReader;
                boolean bl2 = false;
                this.onReaderDiscovered.invoke((Object)bluetoothReader2, deviceName);
            }
        }
    }

    public void onScanFailed(int errorCode) {
        AndroidLog.INSTANCE.d(TAG, "scanFailed, errorCode: " + errorCode);
        switch (errorCode) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.readerStatusListener.handleReaderException(new ScanFailedFatalError(errorCode, "Bluetooth scan failed", null, 4, null));
                break;
            }
            case 5: 
            case 6: {
                if (this.retryCount < 5) {
                    BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.dispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ BbposBluetoothScanner this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                                    if (v0 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    this.this$0.startScan(BbposBluetoothScanner.access$getRetryCount$p(this.this$0) + 1, (Function2<? super Reader.BluetoothReader, ? super String, Unit>)BbposBluetoothScanner.access$getOnReaderDiscovered$p(this.this$0));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    break;
                }
                this.readerStatusListener.handleReaderException(new ScanFailedFatalError(errorCode, "Bluetooth scan failed", null, 4, null));
                break;
            }
            default: {
                this.readerStatusListener.handleReaderException(new ScanFailedFatalError(errorCode, "Bluetooth scan failed", null, 4, null));
            }
        }
    }

    public static final /* synthetic */ ReentrantLock access$getScanStateLock$p(BbposBluetoothScanner $this) {
        return $this.scanStateLock;
    }

    public static final /* synthetic */ ScanState access$getScanState$p(BbposBluetoothScanner $this) {
        return $this.scanState;
    }

    public static final /* synthetic */ Provider access$getScannerProvider$p(BbposBluetoothScanner $this) {
        return $this.scannerProvider;
    }

    public static final /* synthetic */ void access$setScanState$p(BbposBluetoothScanner $this, ScanState scanState) {
        $this.scanState = scanState;
    }

    public static final /* synthetic */ int access$getRetryCount$p(BbposBluetoothScanner $this) {
        return $this.retryCount;
    }

    public static final /* synthetic */ Function2 access$getOnReaderDiscovered$p(BbposBluetoothScanner $this) {
        return $this.onReaderDiscovered;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothScanner$Companion;", "", "()V", "BASE_BLUETOOTH_UUID_POSTFIX", "", "BASE_BLUETOOTH_UUID_PREFIX", "BBPOS_BLUETOOTH_SID", "BLUETOOTH_SERVICE_ID", "MAX_RETRIES", "", "RETRY_DELAY", "", "TAG", "hardware_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothScanner$ScanState;", "", "(Ljava/lang/String;I)V", "STARTED", "STOPPING", "STOPPED", "hardware_release"})
    private static final class ScanState
    extends Enum<ScanState> {
        public static final /* enum */ ScanState STARTED = new ScanState();
        public static final /* enum */ ScanState STOPPING = new ScanState();
        public static final /* enum */ ScanState STOPPED = new ScanState();
        private static final /* synthetic */ ScanState[] $VALUES;

        public static ScanState[] values() {
            return (ScanState[])$VALUES.clone();
        }

        public static ScanState valueOf(String value) {
            return Enum.valueOf(ScanState.class, value);
        }

        static {
            $VALUES = scanStateArray = new ScanState[]{ScanState.STARTED, ScanState.STOPPING, ScanState.STOPPED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScanState.values().length];
            try {
                nArray[ScanState.STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScanState.STOPPING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScanState.STOPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

