/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.bbpos.hardware.discovery;

import android.annotation.SuppressLint;
import com.stripe.core.bbpos.hardware.discovery.BbposBluetoothScanner;
import com.stripe.core.hardware.ConnectionType;
import com.stripe.core.hardware.DiscoveryController;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.status.ReaderStatusListener;
import com.stripe.core.stripeterminal.log.AndroidLog;
import com.stripe.jvmcore.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stripe/core/bbpos/hardware/discovery/DefaultBluetoothDiscoveryController;", "Lcom/stripe/core/hardware/DiscoveryController;", "bluetoothScanner", "Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothScanner;", "readerStatusListener", "Lcom/stripe/core/hardware/status/ReaderStatusListener;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "(Lcom/stripe/core/bbpos/hardware/discovery/BbposBluetoothScanner;Lcom/stripe/core/hardware/status/ReaderStatusListener;Lcom/stripe/jvmcore/time/Clock;)V", "discoveredReaders", "", "", "Lcom/stripe/core/bbpos/hardware/discovery/DefaultBluetoothDiscoveryController$Companion$ReaderEntry;", "timer", "Ljava/util/Timer;", "discover", "", "readerClasses", "", "Lkotlin/reflect/KClass;", "Lcom/stripe/core/hardware/Reader;", "connectionType", "Lcom/stripe/core/hardware/ConnectionType;", "onReaderDiscovered", "reader", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "deviceName", "stopDiscover", "Companion", "RemoveStaleEntriesTask", "hardware_release"})
@SourceDebugExtension(value={"SMAP\nDefaultBluetoothDiscoveryController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultBluetoothDiscoveryController.kt\ncom/stripe/core/bbpos/hardware/discovery/DefaultBluetoothDiscoveryController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1549#2:89\n1620#2,3:90\n*S KotlinDebug\n*F\n+ 1 DefaultBluetoothDiscoveryController.kt\ncom/stripe/core/bbpos/hardware/discovery/DefaultBluetoothDiscoveryController\n*L\n65#1:89\n65#1:90,3\n*E\n"})
public final class DefaultBluetoothDiscoveryController
implements DiscoveryController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BbposBluetoothScanner bluetoothScanner;
    @NotNull
    private final ReaderStatusListener readerStatusListener;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Map<String, Companion.ReaderEntry> discoveredReaders;
    @Nullable
    private Timer timer;
    @NotNull
    private static final String TAG = "BBBTDiscoveryController";
    private static final long POLL_TIME_MS = 5000L;

    @Inject
    public DefaultBluetoothDiscoveryController(@NotNull BbposBluetoothScanner bluetoothScanner, @NotNull ReaderStatusListener readerStatusListener, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)((Object)bluetoothScanner), (String)"bluetoothScanner");
        Intrinsics.checkNotNullParameter((Object)readerStatusListener, (String)"readerStatusListener");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.bluetoothScanner = bluetoothScanner;
        this.readerStatusListener = readerStatusListener;
        this.clock = clock;
        this.discoveredReaders = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressLint(value={"MissingPermission"})
    public void discover(@NotNull List<? extends KClass<? extends Reader>> readerClasses, @NotNull ConnectionType connectionType) {
        void $this$discover_u24lambda_u240;
        Timer timer2;
        Intrinsics.checkNotNullParameter(readerClasses, (String)"readerClasses");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        AndroidLog.INSTANCE.i(TAG, "discoverDevices");
        this.discoveredReaders.clear();
        BbposBluetoothScanner.startScan$default(this.bluetoothScanner, 0, (Function2)new Function2<Reader.BluetoothReader, String, Unit>(readerClasses, this){
            final /* synthetic */ List<KClass<? extends Reader>> $readerClasses;
            final /* synthetic */ DefaultBluetoothDiscoveryController this$0;
            {
                this.$readerClasses = $readerClasses;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Reader.BluetoothReader reader, @NotNull String deviceName) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
                if (this.$readerClasses.contains(Reflection.getOrCreateKotlinClass(reader.getClass()))) {
                    DefaultBluetoothDiscoveryController.access$onReaderDiscovered(this.this$0, reader, deviceName);
                }
            }
        }, 1, null);
        Timer timer3 = timer2 = new Timer();
        DefaultBluetoothDiscoveryController defaultBluetoothDiscoveryController = this;
        boolean bl = false;
        $this$discover_u24lambda_u240.scheduleAtFixedRate((TimerTask)new RemoveStaleEntriesTask(), 5000L, 5000L);
        defaultBluetoothDiscoveryController.timer = timer2;
    }

    /*
     * WARNING - void declaration
     */
    private final void onReaderDiscovered(Reader.BluetoothReader reader, String deviceName) {
        if (!this.discoveredReaders.containsKey(deviceName)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.discoveredReaders.put(deviceName, new Companion.ReaderEntry(reader, this.clock.currentTimeMillis()));
            Iterable iterable = this.discoveredReaders.values();
            ReaderStatusListener readerStatusListener = this.readerStatusListener;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Companion.ReaderEntry readerEntry = (Companion.ReaderEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getReader());
            }
            readerStatusListener.handleReaderDiscovery(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        } else {
            Companion.ReaderEntry readerEntry = this.discoveredReaders.get(deviceName);
            if (readerEntry != null) {
                readerEntry.setTimeStamp(this.clock.currentTimeMillis());
            }
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void stopDiscover() {
        AndroidLog.INSTANCE.i(TAG, "stopDiscoverReaders");
        this.bluetoothScanner.stopScan();
        Timer timer2 = this.timer;
        if (timer2 != null) {
            timer2.cancel();
        }
        this.timer = null;
    }

    public static final /* synthetic */ void access$onReaderDiscovered(DefaultBluetoothDiscoveryController $this, Reader.BluetoothReader reader, String deviceName) {
        $this.onReaderDiscovered(reader, deviceName);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/core/bbpos/hardware/discovery/DefaultBluetoothDiscoveryController$Companion;", "", "()V", "POLL_TIME_MS", "", "TAG", "", "ReaderEntry", "hardware_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/stripe/core/bbpos/hardware/discovery/DefaultBluetoothDiscoveryController$Companion$ReaderEntry;", "", "reader", "Lcom/stripe/core/hardware/Reader;", "timeStamp", "", "(Lcom/stripe/core/hardware/Reader;J)V", "getReader", "()Lcom/stripe/core/hardware/Reader;", "getTimeStamp", "()J", "setTimeStamp", "(J)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "hardware_release"})
        private static final class ReaderEntry {
            @NotNull
            private final Reader reader;
            private long timeStamp;

            public ReaderEntry(@NotNull Reader reader, long timeStamp) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                this.reader = reader;
                this.timeStamp = timeStamp;
            }

            @NotNull
            public final Reader getReader() {
                return this.reader;
            }

            public final long getTimeStamp() {
                return this.timeStamp;
            }

            public final void setTimeStamp(long l2) {
                this.timeStamp = l2;
            }

            @NotNull
            public final Reader component1() {
                return this.reader;
            }

            public final long component2() {
                return this.timeStamp;
            }

            @NotNull
            public final ReaderEntry copy(@NotNull Reader reader, long timeStamp) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                return new ReaderEntry(reader, timeStamp);
            }

            public static /* synthetic */ ReaderEntry copy$default(ReaderEntry readerEntry, Reader reader, long l2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    reader = readerEntry.reader;
                }
                if ((n2 & 2) != 0) {
                    l2 = readerEntry.timeStamp;
                }
                return readerEntry.copy(reader, l2);
            }

            @NotNull
            public String toString() {
                return "ReaderEntry(reader=" + this.reader + ", timeStamp=" + this.timeStamp + ')';
            }

            public int hashCode() {
                int result2 = this.reader.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.timeStamp);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReaderEntry)) {
                    return false;
                }
                ReaderEntry readerEntry = (ReaderEntry)other;
                if (!Intrinsics.areEqual((Object)this.reader, (Object)readerEntry.reader)) {
                    return false;
                }
                return this.timeStamp == readerEntry.timeStamp;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/bbpos/hardware/discovery/DefaultBluetoothDiscoveryController$RemoveStaleEntriesTask;", "Ljava/util/TimerTask;", "(Lcom/stripe/core/bbpos/hardware/discovery/DefaultBluetoothDiscoveryController;)V", "run", "", "hardware_release"})
    @SourceDebugExtension(value={"SMAP\nDefaultBluetoothDiscoveryController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultBluetoothDiscoveryController.kt\ncom/stripe/core/bbpos/hardware/discovery/DefaultBluetoothDiscoveryController$RemoveStaleEntriesTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n766#2:89\n857#2,2:90\n1549#2:92\n1620#2,3:93\n*S KotlinDebug\n*F\n+ 1 DefaultBluetoothDiscoveryController.kt\ncom/stripe/core/bbpos/hardware/discovery/DefaultBluetoothDiscoveryController$RemoveStaleEntriesTask\n*L\n48#1:89\n48#1:90,2\n53#1:92\n53#1:93,3\n*E\n"})
    private final class RemoveStaleEntriesTask
    extends TimerTask {
        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Object it;
            void $this$filterTo$iv$iv;
            long currentTime = DefaultBluetoothDiscoveryController.this.clock.currentTimeMillis();
            Iterable $this$filter$iv = DefaultBluetoothDiscoveryController.this.discoveredReaders.entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(currentTime - ((Companion.ReaderEntry)it.getValue()).getTimeStamp() > 5000L)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List staleEntries = (List)destination$iv$iv;
            if (!((Collection)staleEntries).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                DefaultBluetoothDiscoveryController.this.discoveredReaders.entrySet().removeAll(staleEntries);
                $this$filter$iv = DefaultBluetoothDiscoveryController.this.discoveredReaders.values();
                ReaderStatusListener readerStatusListener = DefaultBluetoothDiscoveryController.this.readerStatusListener;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Companion.ReaderEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Companion.ReaderEntry)it).getReader());
                }
                readerStatusListener.handleReaderDiscovery(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
            }
        }
    }
}

