/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity;

import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import androidx.annotation.VisibleForTesting;
import com.squareup.wire.Message;
import com.stripe.core.connectivity.ConnectivityLogger;
import com.stripe.core.connectivity.ConnectivityLoggerKt;
import com.stripe.core.connectivity.ConnectivityRepository;
import com.stripe.core.connectivity.ConnectivityType;
import com.stripe.core.connectivity.EthernetConnection;
import com.stripe.core.connectivity.NetworkLinkProperties;
import com.stripe.core.connectivity.WifiAuthenticationResult;
import com.stripe.core.connectivity.WifiConfigurationStore;
import com.stripe.core.connectivity.WifiConfigurationUtilities;
import com.stripe.core.connectivity.WifiConnection;
import com.stripe.core.connectivity.WifiSSID;
import com.stripe.jvmcore.loggingmodels.Trace;
import com.stripe.jvmcore.loggingmodels.TraceLogger;
import com.stripe.proto.model.observability.schema.connectivity.Context;
import com.stripe.proto.model.observability.schema.connectivity.EthernetContext;
import com.stripe.proto.model.observability.schema.connectivity.Event;
import com.stripe.proto.model.observability.schema.connectivity.NetworkConnected;
import com.stripe.proto.model.observability.schema.connectivity.NetworkLost;
import com.stripe.proto.model.observability.schema.connectivity.NetworkPropertiesChanged;
import com.stripe.proto.model.observability.schema.connectivity.Payload;
import com.stripe.proto.model.observability.schema.connectivity.WifiConnectionAttempt;
import com.stripe.proto.model.observability.schema.connectivity.WifiConnectivityChanged;
import com.stripe.proto.model.observability.schema.connectivity.WifiContext;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0001'B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u001a\u0010$\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0012\u0010&\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/stripe/core/connectivity/ConnectivityLogger;", "", "connectivityRepository", "Lcom/stripe/core/connectivity/ConnectivityRepository;", "wifiConnectConfigurationStore", "Lcom/stripe/core/connectivity/WifiConfigurationStore;", "traceLogger", "Lcom/stripe/jvmcore/loggingmodels/TraceLogger;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/stripe/core/connectivity/ConnectivityRepository;Lcom/stripe/core/connectivity/WifiConfigurationStore;Lcom/stripe/jvmcore/loggingmodels/TraceLogger;Lkotlinx/coroutines/CoroutineDispatcher;)V", "lastKnownWifiEvent", "Lcom/stripe/core/connectivity/WifiConnection;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "init", "", "logEvent", "event", "Lcom/stripe/proto/model/observability/schema/connectivity/Event;", "connectivityType", "Lcom/stripe/core/connectivity/ConnectivityType;", "logWifiConnectionEvent", "wifiConnection", "logWifiConnectionEventAttempt", "scanResult", "Landroid/net/wifi/ScanResult;", "result", "Lcom/stripe/core/connectivity/WifiAuthenticationResult;", "logWifiConnectionPropertiesChangedEvent", "onEthernetConnectionStatusChanged", "ethernetConnection", "Lcom/stripe/core/connectivity/EthernetConnection;", "onEthernetNetworkLinkPropertiesChanged", "linkProperties", "Lcom/stripe/core/connectivity/NetworkLinkProperties;", "onNetworkLinkPropertiesChanged", "onWifiConnectionStatusChanged", "onWifiNetworkLinkPropertiesChanged", "Companion", "connectivity_release"})
public final class ConnectivityLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectivityRepository connectivityRepository;
    @NotNull
    private final WifiConfigurationStore wifiConnectConfigurationStore;
    @NotNull
    private final TraceLogger traceLogger;
    @Nullable
    private WifiConnection lastKnownWifiEvent;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private static final String SERVICE = "connectivity";
    @NotNull
    private static final String EVENT_METHOD = "event";
    @NotNull
    private static final String WIFI_CONNECTION_EVENT_METHOD = "connection_attempt";

    public ConnectivityLogger(@NotNull ConnectivityRepository connectivityRepository, @NotNull WifiConfigurationStore wifiConnectConfigurationStore, @NotNull TraceLogger traceLogger, @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)connectivityRepository, (String)"connectivityRepository");
        Intrinsics.checkNotNullParameter((Object)wifiConnectConfigurationStore, (String)"wifiConnectConfigurationStore");
        Intrinsics.checkNotNullParameter((Object)traceLogger, (String)"traceLogger");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.connectivityRepository = connectivityRepository;
        this.wifiConnectConfigurationStore = wifiConnectConfigurationStore;
        this.traceLogger = traceLogger;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)dispatcher));
    }

    public final void init() {
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.connectivityRepository.getWifiConnectionFlow()), (Function2)((Function2)new Function2<WifiConnection, Continuation<? super Unit>, Object>((Object)this){

            @Nullable
            public final Object invoke(@NotNull WifiConnection p0, @NotNull Continuation<? super Unit> $completion) {
                return ConnectivityLogger.access$init$onWifiConnectionStatusChanged((ConnectivityLogger)init.1.access$getReceiver$p(this), p0, $completion);
            }

            public static final /* synthetic */ Object access$getReceiver$p(init.1 $this) {
                return $this.receiver;
            }
        })), (CoroutineScope)this.scope);
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.connectivityRepository.getNetworkLinkPropertiesFlow(ConnectivityType.WIFI)), (Function2)((Function2)new Function2<NetworkLinkProperties, Continuation<? super Unit>, Object>((Object)this){

            @Nullable
            public final Object invoke(@Nullable NetworkLinkProperties p0, @NotNull Continuation<? super Unit> $completion) {
                return ConnectivityLogger.access$init$onWifiNetworkLinkPropertiesChanged((ConnectivityLogger)init.2.access$getReceiver$p(this), p0, $completion);
            }

            public static final /* synthetic */ Object access$getReceiver$p(init.2 $this) {
                return $this.receiver;
            }
        })), (CoroutineScope)this.scope);
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.connectivityRepository.getEthernetConnectionFlow()), (Function2)((Function2)new Function2<EthernetConnection, Continuation<? super Unit>, Object>((Object)this){

            @Nullable
            public final Object invoke(@NotNull EthernetConnection p0, @NotNull Continuation<? super Unit> $completion) {
                return ConnectivityLogger.access$init$onEthernetConnectionStatusChanged((ConnectivityLogger)init.3.access$getReceiver$p(this), p0, $completion);
            }

            public static final /* synthetic */ Object access$getReceiver$p(init.3 $this) {
                return $this.receiver;
            }
        })), (CoroutineScope)this.scope);
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.connectivityRepository.getNetworkLinkPropertiesFlow(ConnectivityType.ETHERNET)), (Function2)((Function2)new Function2<NetworkLinkProperties, Continuation<? super Unit>, Object>((Object)this){

            @Nullable
            public final Object invoke(@Nullable NetworkLinkProperties p0, @NotNull Continuation<? super Unit> $completion) {
                return ConnectivityLogger.access$init$onEthernetNetworkLinkPropertiesChanged((ConnectivityLogger)init.4.access$getReceiver$p(this), p0, $completion);
            }

            public static final /* synthetic */ Object access$getReceiver$p(init.4 $this) {
                return $this.receiver;
            }
        })), (CoroutineScope)this.scope);
    }

    private final void onWifiConnectionStatusChanged(WifiConnection wifiConnection) {
        String currentSSID;
        WifiConnection wifiConnection2 = this.lastKnownWifiEvent;
        Object object = wifiConnection2 instanceof WifiConnection.Connected ? (WifiConnection.Connected)wifiConnection2 : null;
        String lastKnownEventSSID = object != null && (object = ((WifiConnection.Connected)object).getSsid()) != null ? ((WifiSSID)object).getValue() : null;
        Object object2 = wifiConnection instanceof WifiConnection.Connected ? (WifiConnection.Connected)wifiConnection : null;
        String string = object2 != null && (object2 = ((WifiConnection.Connected)object2).getSsid()) != null ? ((WifiSSID)object2).getValue() : (currentSSID = null);
        if (lastKnownEventSSID != null && Intrinsics.areEqual((Object)lastKnownEventSSID, (Object)currentSSID)) {
            this.logWifiConnectionPropertiesChangedEvent(wifiConnection);
        } else {
            this.logWifiConnectionEvent(wifiConnection);
        }
        this.lastKnownWifiEvent = wifiConnection;
    }

    private final void logWifiConnectionPropertiesChangedEvent(WifiConnection wifiConnection) {
        this.logEvent(new Event(null, null, null, new WifiConnectivityChanged(ConnectivityLoggerKt.toProto(wifiConnection, this.wifiConnectConfigurationStore), null, 2, null), null, null, 55, null), ConnectivityType.WIFI);
    }

    private final void logWifiConnectionEvent(WifiConnection wifiConnection) {
        Event event;
        WifiConnection wifiConnection2 = wifiConnection;
        if (wifiConnection2 instanceof WifiConnection.Connected) {
            event = new Event(new NetworkConnected(ConnectivityLoggerKt.toProto(wifiConnection, this.wifiConnectConfigurationStore), null, null, 6, null), null, null, null, null, null, 62, null);
        } else if (wifiConnection2 instanceof WifiConnection.Disconnected) {
            event = new Event(null, null, new NetworkLost(null, 1, null), null, null, null, 59, null);
        } else {
            if (wifiConnection2 instanceof WifiConnection.Unknown) {
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        Event event2 = event;
        this.logEvent(event2, ConnectivityType.WIFI);
    }

    private final void onWifiNetworkLinkPropertiesChanged(NetworkLinkProperties linkProperties) {
        this.onNetworkLinkPropertiesChanged(linkProperties, ConnectivityType.WIFI);
    }

    private final void onEthernetNetworkLinkPropertiesChanged(NetworkLinkProperties linkProperties) {
        this.onNetworkLinkPropertiesChanged(linkProperties, ConnectivityType.ETHERNET);
    }

    private final void onNetworkLinkPropertiesChanged(NetworkLinkProperties linkProperties, ConnectivityType connectivityType) {
        if (linkProperties == null) {
            return;
        }
        Event event = new Event(null, new NetworkPropertiesChanged(ConnectivityLoggerKt.toProto(linkProperties), null, 2, null), null, null, null, null, 61, null);
        this.logEvent(event, connectivityType);
    }

    private final void onEthernetConnectionStatusChanged(EthernetConnection ethernetConnection) {
        Event event;
        EthernetConnection ethernetConnection2 = ethernetConnection;
        if (ethernetConnection2 instanceof EthernetConnection.Connected) {
            event = new Event(new NetworkConnected(null, new com.stripe.proto.model.observability.schema.connectivity.EthernetConnection(null, null, null, 7, null), null, 5, null), null, null, null, null, null, 62, null);
        } else if (ethernetConnection2 instanceof EthernetConnection.Disconnected) {
            event = new Event(null, null, new NetworkLost(null, 1, null), null, null, null, 59, null);
        } else {
            if (ethernetConnection2 instanceof EthernetConnection.Unknown) {
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        Event event2 = event;
        this.logEvent(event2, ConnectivityType.ETHERNET);
    }

    private final void logEvent(Event event, ConnectivityType connectivityType) {
        Context context;
        switch (WhenMappings.$EnumSwitchMapping$0[connectivityType.ordinal()]) {
            case 1: {
                context = Companion.makeWifiContext$connectivity_release(this.connectivityRepository.getWifiMacAddress(), this.connectivityRepository.getRouterMacAddress(), this.connectivityRepository.getConnectedWifiConfiguration());
                break;
            }
            case 2: {
                context = Companion.makeEthernetContext$connectivity_release();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Context context2 = context;
        Trace it = TraceLogger.startTrace$default(this.traceLogger, SERVICE, EVENT_METHOD, new Payload(event, context2, null, 4, null), null, null, null, null, null, null, null, null, 2040, null);
        boolean bl = false;
        this.traceLogger.endTraceWithSuccess(it, (Message<?, ?>)null, (Map<String, String>)null);
    }

    public final void logWifiConnectionEventAttempt(@NotNull ScanResult scanResult, @NotNull WifiAuthenticationResult result2) {
        Intrinsics.checkNotNullParameter((Object)scanResult, (String)"scanResult");
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        if (result2 == WifiAuthenticationResult.None) {
            return;
        }
        String string = scanResult.SSID;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scanResult.SSID");
        String string2 = scanResult.BSSID;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"scanResult.BSSID");
        String string3 = scanResult.capabilities;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"scanResult.capabilities");
        Trace it = TraceLogger.startTrace$default(this.traceLogger, SERVICE, WIFI_CONNECTION_EVENT_METHOD, new Payload(new Event(null, null, null, null, new WifiConnectionAttempt(string, string2, string3, null, 8, null), null, 47, null), null, null, 6, null), null, null, null, null, null, null, null, null, 2040, null);
        boolean bl = false;
        if (result2 == WifiAuthenticationResult.Success) {
            this.traceLogger.endTraceWithSuccess(it, (Message<?, ?>)null, (Map<String, String>)null);
        } else {
            TraceLogger.endTraceWithErrorMessage$default(this.traceLogger, it, "Failed to connect: " + (Object)((Object)result2), null, null, 12, null);
        }
    }

    private static final /* synthetic */ Object init$onWifiConnectionStatusChanged(ConnectivityLogger $this$init_u24onWifiConnectionStatusChanged, WifiConnection p0, Continuation $completion) {
        $this$init_u24onWifiConnectionStatusChanged.onWifiConnectionStatusChanged(p0);
        return Unit.INSTANCE;
    }

    private static final /* synthetic */ Object init$onWifiNetworkLinkPropertiesChanged(ConnectivityLogger $this$init_u24onWifiNetworkLinkPropertiesChanged, NetworkLinkProperties p0, Continuation $completion) {
        $this$init_u24onWifiNetworkLinkPropertiesChanged.onWifiNetworkLinkPropertiesChanged(p0);
        return Unit.INSTANCE;
    }

    private static final /* synthetic */ Object init$onEthernetConnectionStatusChanged(ConnectivityLogger $this$init_u24onEthernetConnectionStatusChanged, EthernetConnection p0, Continuation $completion) {
        $this$init_u24onEthernetConnectionStatusChanged.onEthernetConnectionStatusChanged(p0);
        return Unit.INSTANCE;
    }

    private static final /* synthetic */ Object init$onEthernetNetworkLinkPropertiesChanged(ConnectivityLogger $this$init_u24onEthernetNetworkLinkPropertiesChanged, NetworkLinkProperties p0, Continuation $completion) {
        $this$init_u24onEthernetNetworkLinkPropertiesChanged.onEthernetNetworkLinkPropertiesChanged(p0);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$init$onWifiConnectionStatusChanged(ConnectivityLogger $receiver, WifiConnection p0, Continuation $completion) {
        return ConnectivityLogger.init$onWifiConnectionStatusChanged($receiver, p0, $completion);
    }

    public static final /* synthetic */ Object access$init$onWifiNetworkLinkPropertiesChanged(ConnectivityLogger $receiver, NetworkLinkProperties p0, Continuation $completion) {
        return ConnectivityLogger.init$onWifiNetworkLinkPropertiesChanged($receiver, p0, $completion);
    }

    public static final /* synthetic */ Object access$init$onEthernetConnectionStatusChanged(ConnectivityLogger $receiver, EthernetConnection p0, Continuation $completion) {
        return ConnectivityLogger.init$onEthernetConnectionStatusChanged($receiver, p0, $completion);
    }

    public static final /* synthetic */ Object access$init$onEthernetNetworkLinkPropertiesChanged(ConnectivityLogger $receiver, NetworkLinkProperties p0, Continuation $completion) {
        return ConnectivityLogger.init$onEthernetNetworkLinkPropertiesChanged($receiver, p0, $completion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\tJ'\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0001\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/core/connectivity/ConnectivityLogger$Companion;", "", "()V", "EVENT_METHOD", "", "SERVICE", "WIFI_CONNECTION_EVENT_METHOD", "makeEthernetContext", "Lcom/stripe/proto/model/observability/schema/connectivity/Context;", "makeEthernetContext$connectivity_release", "makeWifiContext", "wifiMacAddress", "routerMacAddress", "wifiConfiguration", "Landroid/net/wifi/WifiConfiguration;", "makeWifiContext$connectivity_release", "connectivity_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final Context makeEthernetContext$connectivity_release() {
            return new Context(null, new EthernetContext(null, 1, null), null, 5, null);
        }

        @VisibleForTesting
        @NotNull
        public final Context makeWifiContext$connectivity_release(@NotNull String wifiMacAddress, @NotNull String routerMacAddress, @Nullable WifiConfiguration wifiConfiguration) {
            Intrinsics.checkNotNullParameter((Object)wifiMacAddress, (String)"wifiMacAddress");
            Intrinsics.checkNotNullParameter((Object)routerMacAddress, (String)"routerMacAddress");
            WifiConfiguration wifiConfiguration2 = wifiConfiguration;
            List list = wifiConfiguration2 != null ? WifiConfigurationUtilities.INSTANCE.getSupportedKeys(wifiConfiguration2) : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            WifiConfiguration wifiConfiguration3 = wifiConfiguration;
            List list2 = wifiConfiguration3 != null ? WifiConfigurationUtilities.INSTANCE.getSupportedProtocols(wifiConfiguration3) : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            WifiConfiguration wifiConfiguration4 = wifiConfiguration;
            List list3 = wifiConfiguration4 != null ? WifiConfigurationUtilities.INSTANCE.getAuthAlgorithms(wifiConfiguration4) : null;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            WifiConfiguration wifiConfiguration5 = wifiConfiguration;
            List list4 = wifiConfiguration5 != null ? WifiConfigurationUtilities.INSTANCE.getPairwiseCiphers(wifiConfiguration5) : null;
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            WifiConfiguration wifiConfiguration6 = wifiConfiguration;
            List list5 = wifiConfiguration6 != null ? WifiConfigurationUtilities.INSTANCE.getGroupCiphers(wifiConfiguration6) : null;
            if (list5 == null) {
                list5 = CollectionsKt.emptyList();
            }
            return new Context(new WifiContext(wifiMacAddress, routerMacAddress, list, list2, list3, list4, list5, null, 128, null), null, null, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectivityType.values().length];
            try {
                nArray[ConnectivityType.WIFI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectivityType.ETHERNET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

