/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity;

import androidx.annotation.VisibleForTesting;
import com.stripe.core.connectivity.NetworkLinkProperties;
import com.stripe.core.connectivity.WifiConfigurationStore;
import com.stripe.core.connectivity.WifiConnection;
import com.stripe.core.connectivity.WifiSecurity;
import com.stripe.proto.model.observability.schema.connectivity.NetworkProperties;
import com.stripe.proto.model.observability.schema.connectivity.WifiConnected;
import com.stripe.proto.model.observability.schema.connectivity.WifiDisconnected;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0001\u001a\u0014\u0010\u0000\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a8\u0006\u0007"}, d2={"toProto", "Lcom/stripe/proto/model/observability/schema/connectivity/NetworkProperties;", "Lcom/stripe/core/connectivity/NetworkLinkProperties;", "Lcom/stripe/proto/model/observability/schema/connectivity/WifiConnection;", "Lcom/stripe/core/connectivity/WifiConnection;", "wifiConnectConfigurationStore", "Lcom/stripe/core/connectivity/WifiConfigurationStore;", "connectivity_release"})
@SourceDebugExtension(value={"SMAP\nConnectivityLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectivityLogger.kt\ncom/stripe/core/connectivity/ConnectivityLoggerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1549#2:270\n1620#2,3:271\n*S KotlinDebug\n*F\n+ 1 ConnectivityLogger.kt\ncom/stripe/core/connectivity/ConnectivityLoggerKt\n*L\n264#1:270\n264#1:271,3\n*E\n"})
public final class ConnectivityLoggerKt {
    @VisibleForTesting
    @NotNull
    public static final com.stripe.proto.model.observability.schema.connectivity.WifiConnection toProto(@NotNull WifiConnection $this$toProto, @NotNull WifiConfigurationStore wifiConnectConfigurationStore) {
        com.stripe.proto.model.observability.schema.connectivity.WifiConnection wifiConnection;
        Intrinsics.checkNotNullParameter((Object)$this$toProto, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wifiConnectConfigurationStore, (String)"wifiConnectConfigurationStore");
        WifiConnection wifiConnection2 = $this$toProto;
        if (Intrinsics.areEqual((Object)wifiConnection2, (Object)WifiConnection.Disconnected.INSTANCE)) {
            wifiConnection = new com.stripe.proto.model.observability.schema.connectivity.WifiConnection(null, new WifiDisconnected(null, 1, null), null, 5, null);
        } else if (wifiConnection2 instanceof WifiConnection.Connected) {
            String string = ((WifiConnection.Connected)$this$toProto).getSsid().getValue();
            int n2 = ((WifiConnection.Connected)$this$toProto).getSignalLevel();
            int n3 = ((WifiConnection.Connected)$this$toProto).getNumSignalLevels();
            int n4 = ((WifiConnection.Connected)$this$toProto).getFrequency();
            String string2 = ((WifiConnection.Connected)$this$toProto).getWifiSecurity() != WifiSecurity.UNSUPPORTED ? ((WifiConnection.Connected)$this$toProto).getWifiSecurity().name() : "";
            Inet4Address inet4Address = wifiConnectConfigurationStore.getIPAddress(((WifiConnection.Connected)$this$toProto).getSsid());
            String string3 = inet4Address != null ? inet4Address.getHostName() : null;
            if (string3 == null) {
                string3 = "";
            }
            InetAddress inetAddress = wifiConnectConfigurationStore.getSubnetMask(((WifiConnection.Connected)$this$toProto).getSsid());
            String string4 = inetAddress != null ? inetAddress.getHostName() : null;
            if (string4 == null) {
                string4 = "";
            }
            InetAddress inetAddress2 = wifiConnectConfigurationStore.getGateway(((WifiConnection.Connected)$this$toProto).getSsid());
            String string5 = inetAddress2 != null ? inetAddress2.getHostName() : null;
            if (string5 == null) {
                string5 = "";
            }
            wifiConnection = new com.stripe.proto.model.observability.schema.connectivity.WifiConnection(new WifiConnected(string, n2, n3, n4, string2, string3, string4, string5, CollectionsKt.joinToString$default((Iterable)wifiConnectConfigurationStore.getDnsServers(((WifiConnection.Connected)$this$toProto).getSsid()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null), null, 512, null), null, null, 6, null);
        } else {
            if (wifiConnection2 instanceof WifiConnection.Unknown) {
                throw new IllegalStateException("Should be filtered out.".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return wifiConnection;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final NetworkProperties toProto(@NotNull NetworkLinkProperties $this$toProto) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toProto, (String)"<this>");
        String string = $this$toProto.getIpAddress();
        if (string == null) {
            string = "";
        }
        Iterable iterable = $this$toProto.getDnsServers();
        String string2 = string;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InetAddress inetAddress = (InetAddress)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = it.getHostAddress();
            if (string3 == null) {
                string3 = "";
            }
            collection.add(string3);
        }
        InetAddress inetAddress = $this$toProto.getSubnetMask();
        String string4 = inetAddress != null ? inetAddress.getHostAddress() : null;
        if (string4 == null) {
            string4 = "";
        }
        InetAddress inetAddress2 = $this$toProto.getGateway();
        String string5 = inetAddress2 != null ? inetAddress2.getHostAddress() : null;
        if (string5 == null) {
            string5 = "";
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 16;
        ByteString byteString = null;
        String string6 = string5;
        String string7 = string4;
        List list = (List)destination$iv$iv;
        String string8 = string2;
        return new NetworkProperties(string8, list, string7, string6, byteString, n2, defaultConstructorMarker);
    }
}

