/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.RouteInfo;
import com.stripe.core.connectivity.NetworkLinkProperties;
import com.stripe.core.connectivity.SubnetMaskUtilities;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u001a \u0010\f\u001a\u0004\u0018\u0001H\r\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u0003*\u00020\u0004H\u0082\b\u00a2\u0006\u0002\u0010\u0006\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001a\u0010\n\u001a\u0004\u0018\u00010\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\u0010"}, d2={"LOCALHOST", "", "gateway", "Ljava/net/InetAddress;", "Landroid/net/LinkProperties;", "getGateway", "(Landroid/net/LinkProperties;)Ljava/net/InetAddress;", "ipAddress", "getIpAddress", "(Landroid/net/LinkProperties;)Ljava/lang/String;", "subnetMask", "getSubnetMask", "inetAddressOfType", "T", "toNetworkLinkProperties", "Lcom/stripe/core/connectivity/NetworkLinkProperties;", "connectivity_release"})
@SourceDebugExtension(value={"SMAP\nConnectivityRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectivityRepository.kt\ncom/stripe/core/connectivity/ConnectivityRepositoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,453:1\n449#1,2:454\n451#1:460\n449#1,2:463\n451#1:469\n1549#2:456\n1620#2,3:457\n288#2,2:461\n1549#2:465\n1620#2,3:466\n288#2,2:470\n1855#2,2:472\n288#2,2:474\n1549#2:476\n1620#2,3:477\n288#2,2:480\n*S KotlinDebug\n*F\n+ 1 ConnectivityRepository.kt\ncom/stripe/core/connectivity/ConnectivityRepositoryKt\n*L\n413#1:454,2\n413#1:460\n414#1:463,2\n414#1:469\n413#1:456\n413#1:457,3\n413#1:461,2\n414#1:465\n414#1:466,3\n414#1:470,2\n421#1:472,2\n433#1:474,2\n450#1:476\n450#1:477,3\n451#1:480,2\n*E\n"})
public final class ConnectivityRepositoryKt {
    @NotNull
    private static final String LOCALHOST = "192.168.0.1";

    /*
     * WARNING - void declaration
     */
    private static final String getIpAddress(LinkProperties $this$ipAddress) {
        Object v5;
        Object v4;
        Inet4Address ipv4;
        block7: {
            void $this$firstOrNull$iv$iv;
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv;
            Object v2;
            Object v1;
            Object element$iv$iv2;
            Collection collection;
            block6: {
                void $this$firstOrNull$iv$iv2;
                Iterator $this$mapTo$iv$iv$iv2;
                Iterable $this$map$iv$iv2;
                LinkProperties $this$inetAddressOfType$iv = $this$ipAddress;
                boolean $i$f$inetAddressOfType = false;
                List list = $this$inetAddressOfType$iv.getLinkAddresses();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"linkAddresses");
                Iterable iterable = list;
                boolean $i$f$map = false;
                void var6_8 = $this$map$iv$iv2;
                Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv2, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    void p0$iv;
                    Object item$iv$iv$iv = iterator.next();
                    LinkAddress linkAddress = (LinkAddress)item$iv$iv$iv;
                    collection = destination$iv$iv$iv;
                    boolean bl = false;
                    collection.add(p0$iv.getAddress());
                }
                $this$map$iv$iv2 = (List)destination$iv$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv2 : $this$firstOrNull$iv$iv2) {
                    InetAddress it$iv = (InetAddress)element$iv$iv2;
                    boolean bl = false;
                    if (!(it$iv instanceof Inet4Address)) continue;
                    v1 = element$iv$iv2;
                    break block6;
                }
                v1 = v2 = null;
            }
            if (!(v1 instanceof Inet4Address)) {
                v2 = null;
            }
            ipv4 = (Inet4Address)((InetAddress)v2);
            LinkProperties $this$inetAddressOfType$iv = $this$ipAddress;
            boolean $i$f$inetAddressOfType = false;
            List list = $this$inetAddressOfType$iv.getLinkAddresses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"linkAddresses");
            Iterable $i$f$firstOrNull = list;
            boolean $i$f$map = false;
            element$iv$iv2 = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void p0$iv;
                collection = (LinkAddress)item$iv$iv$iv;
                Collection collection2 = destination$iv$iv$iv;
                boolean bl = false;
                collection2.add(p0$iv.getAddress());
            }
            $this$map$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$firstOrNull2 = false;
            for (Object element$iv$iv3 : $this$firstOrNull$iv$iv) {
                InetAddress it$iv = (InetAddress)element$iv$iv3;
                boolean bl = false;
                if (!(it$iv instanceof Inet6Address)) continue;
                v4 = element$iv$iv3;
                break block7;
            }
            v4 = v5 = null;
        }
        if (!(v4 instanceof Inet6Address)) {
            v5 = null;
        }
        Inet6Address ipv6 = (Inet6Address)((InetAddress)v5);
        Inet4Address inet4Address = ipv4;
        InetAddress inetAddress = inet4Address != null ? (InetAddress)inet4Address : (InetAddress)ipv6;
        return inetAddress != null ? inetAddress.getHostAddress() : null;
    }

    private static final InetAddress getSubnetMask(LinkProperties $this$subnetMask) {
        List list = $this$subnetMask.getRoutes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"routes");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RouteInfo it = (RouteInfo)element$iv;
            boolean bl = false;
            Inet4Address inetAddress = SubnetMaskUtilities.INSTANCE.prefixLengthToInetAddress(it.getDestination().getPrefixLength());
            if (inetAddress == null) continue;
            return inetAddress;
        }
        return null;
    }

    private static final InetAddress getGateway(LinkProperties $this$gateway) {
        Object v1;
        block1: {
            List list = $this$gateway.getRoutes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"routes");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RouteInfo it = (RouteInfo)element$iv;
                boolean bl = false;
                InetAddress gateway = it.getGateway();
                if (!(gateway != null && !gateway.isAnyLocalAddress())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        RouteInfo routeInfo = v1;
        return routeInfo != null ? routeInfo.getGateway() : null;
    }

    private static final NetworkLinkProperties toNetworkLinkProperties(LinkProperties $this$toNetworkLinkProperties) {
        List list = $this$toNetworkLinkProperties.getDnsServers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dnsServers");
        return new NetworkLinkProperties(list, ConnectivityRepositoryKt.getSubnetMask($this$toNetworkLinkProperties), ConnectivityRepositoryKt.getGateway($this$toNetworkLinkProperties), ConnectivityRepositoryKt.getIpAddress($this$toNetworkLinkProperties));
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ <T extends InetAddress> T inetAddressOfType(LinkProperties $this$inetAddressOfType) {
        Object v1;
        block2: {
            void $this$mapTo$iv$iv;
            boolean $i$f$inetAddressOfType = false;
            List list = $this$inetAddressOfType.getLinkAddresses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"linkAddresses");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                LinkAddress linkAddress = (LinkAddress)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getAddress());
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                InetAddress it = (InetAddress)element$iv;
                boolean bl = false;
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (!(it instanceof InetAddress)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)((InetAddress)v1);
    }

    public static final /* synthetic */ NetworkLinkProperties access$toNetworkLinkProperties(LinkProperties $receiver) {
        return ConnectivityRepositoryKt.toNetworkLinkProperties($receiver);
    }
}

