/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity;

import android.annotation.SuppressLint;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import androidx.annotation.VisibleForTesting;
import com.stripe.core.connectivity.CellularConnection;
import com.stripe.core.connectivity.ConnectivityRepository;
import com.stripe.core.connectivity.ConnectivityRepositoryKt;
import com.stripe.core.connectivity.ConnectivityStatus;
import com.stripe.core.connectivity.ConnectivityType;
import com.stripe.core.connectivity.DefaultConnectivityRepository;
import com.stripe.core.connectivity.EthernetConnection;
import com.stripe.core.connectivity.NetworkLinkProperties;
import com.stripe.core.connectivity.WifiConfigurationUtilities;
import com.stripe.core.connectivity.WifiConnection;
import com.stripe.core.connectivity.WifiConnectionRepository;
import com.stripe.core.connectivity.WifiSSID;
import com.stripe.core.connectivity.WifiScanResult;
import com.stripe.core.connectivity.WifiSecurity;
import com.stripe.jvmcore.logging.terminal.log.Log;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 H2\u00020\u0001:\u0003HIJB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0019\u00106\u001a\u0002072\u0006\u00108\u001a\u00020-H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J\u0011\u0010:\u001a\u0004\u0018\u00010;H\u0001\u00a2\u0006\u0004\b<\u0010=J \u0010>\u001a\u00020(2\u0006\u0010?\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u00132\u0006\u0010A\u001a\u00020\u0010H\u0002J\u0014\u0010B\u001a\u0004\u0018\u00010-2\b\u0010C\u001a\u0004\u0018\u00010DH\u0017J\u0018\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000f2\u0006\u0010C\u001a\u00020DH\u0016J\b\u0010F\u001a\u000207H\u0017J\b\u0010G\u001a\u00020;H\u0003R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0012\u0010\"\u001a\u00060#R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010&R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010!R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0012\u00100\u001a\u000601R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u00170\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010&R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u00020-8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006K"}, d2={"Lcom/stripe/core/connectivity/DefaultConnectivityRepository;", "Lcom/stripe/core/connectivity/ConnectivityRepository;", "connectivityManager", "Landroid/net/ConnectivityManager;", "wifiManager", "Landroid/net/wifi/WifiManager;", "wifiConnectionRepositoryProvider", "Ljavax/inject/Provider;", "Lcom/stripe/core/connectivity/WifiConnectionRepository;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Landroid/net/ConnectivityManager;Landroid/net/wifi/WifiManager;Ljavax/inject/Provider;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "_cellularConnection", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/core/connectivity/CellularConnection;", "_ethernetConnectionFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/core/connectivity/EthernetConnection;", "_ethernetLinkProperties", "Lcom/stripe/core/connectivity/NetworkLinkProperties;", "_wifiConnectionFlow", "Lcom/stripe/core/connectivity/WifiConnection;", "_wifiLinkProperties", "connectedWifiConfiguration", "Landroid/net/wifi/WifiConfiguration;", "getConnectedWifiConfiguration", "()Landroid/net/wifi/WifiConfiguration;", "defaultDnsServers", "", "Ljava/net/Inet4Address;", "getDefaultDnsServers", "()Ljava/util/List;", "ethernetCallback", "Lcom/stripe/core/connectivity/DefaultConnectivityRepository$EthernetCallback;", "ethernetConnectionFlow", "getEthernetConnectionFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "generalConnectivityStatusFlow", "Lcom/stripe/core/connectivity/ConnectivityStatus;", "getGeneralConnectivityStatusFlow", "recommendedDnsServers", "getRecommendedDnsServers", "routerMacAddress", "", "getRouterMacAddress", "()Ljava/lang/String;", "wifiCallback", "Lcom/stripe/core/connectivity/DefaultConnectivityRepository$WifiCallback;", "wifiConnectionFlow", "getWifiConnectionFlow", "wifiMacAddress", "getWifiMacAddress", "canResolveDns", "", "localIpAddress", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancelWifiStrengthJob", "", "cancelWifiStrengthJob$connectivity_release", "()Lkotlin/Unit;", "connectionDataTransformer", "wifi", "ethernet", "cellular", "getIpAddress", "connectivityType", "Lcom/stripe/core/connectivity/ConnectivityType;", "getNetworkLinkPropertiesFlow", "hasConfiguredWifiNetworks", "listenForConnectivityChanges", "Companion", "EthernetCallback", "WifiCallback", "connectivity_release"})
@ExperimentalCoroutinesApi
@SourceDebugExtension(value={"SMAP\nConnectivityRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectivityRepository.kt\ncom/stripe/core/connectivity/DefaultConnectivityRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,453:1\n288#2,2:454\n11653#3,9:456\n13579#3:465\n13580#3:467\n11662#3:468\n1#4:466\n*S KotlinDebug\n*F\n+ 1 ConnectivityRepository.kt\ncom/stripe/core/connectivity/DefaultConnectivityRepository\n*L\n158#1:454,2\n252#1:456,9\n252#1:465\n252#1:467\n252#1:468\n252#1:466\n*E\n"})
public final class DefaultConnectivityRepository
implements ConnectivityRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectivityManager connectivityManager;
    @NotNull
    private final WifiManager wifiManager;
    @NotNull
    private final Provider<WifiConnectionRepository> wifiConnectionRepositoryProvider;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    @NotNull
    private final Log logger;
    @NotNull
    private final MutableStateFlow<NetworkLinkProperties> _ethernetLinkProperties;
    @NotNull
    private final MutableStateFlow<NetworkLinkProperties> _wifiLinkProperties;
    @NotNull
    private final MutableStateFlow<WifiConnection> _wifiConnectionFlow;
    @NotNull
    private final StateFlow<WifiConnection> wifiConnectionFlow;
    @NotNull
    private final MutableStateFlow<EthernetConnection> _ethernetConnectionFlow;
    @NotNull
    private final StateFlow<EthernetConnection> ethernetConnectionFlow;
    @NotNull
    private final StateFlow<CellularConnection> _cellularConnection;
    @NotNull
    private final StateFlow<ConnectivityStatus> generalConnectivityStatusFlow;
    @NotNull
    private final WifiCallback wifiCallback;
    @NotNull
    private final EthernetCallback ethernetCallback;
    @NotNull
    private static final String DEVICE_DOMAIN_NAME_SUFFIX = "device.stripe-terminal-local-reader.net";
    private static final long SIGNAL_INTERVAL_MILLIS = 5000L;
    public static final int NUM_RSSI_LEVELS = 5;
    public static final long SCAN_ATTEMPT_DELAY_MILLIS = 1000L;
    public static final int MAX_SCAN_ATTEMPTS = 5;

    public DefaultConnectivityRepository(@NotNull ConnectivityManager connectivityManager, @NotNull WifiManager wifiManager, @NotNull Provider<WifiConnectionRepository> wifiConnectionRepositoryProvider, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull Log logger2) {
        Intrinsics.checkNotNullParameter((Object)connectivityManager, (String)"connectivityManager");
        Intrinsics.checkNotNullParameter((Object)wifiManager, (String)"wifiManager");
        Intrinsics.checkNotNullParameter(wifiConnectionRepositoryProvider, (String)"wifiConnectionRepositoryProvider");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.connectivityManager = connectivityManager;
        this.wifiManager = wifiManager;
        this.wifiConnectionRepositoryProvider = wifiConnectionRepositoryProvider;
        this.coroutineDispatcher = coroutineDispatcher;
        this.logger = logger2;
        this._ethernetLinkProperties = StateFlowKt.MutableStateFlow(null);
        this._wifiLinkProperties = StateFlowKt.MutableStateFlow(null);
        this._wifiConnectionFlow = StateFlowKt.MutableStateFlow((Object)WifiConnection.Unknown.INSTANCE);
        this.wifiConnectionFlow = (StateFlow)this._wifiConnectionFlow;
        this._ethernetConnectionFlow = StateFlowKt.MutableStateFlow((Object)EthernetConnection.Unknown.INSTANCE);
        this.ethernetConnectionFlow = (StateFlow)this._ethernetConnectionFlow;
        this._cellularConnection = FlowKt.stateIn((Flow)FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super CellularConnection>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DefaultConnectivityRepository this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        ConnectivityManager.NetworkCallback networkCallback2 = new ConnectivityManager.NetworkCallback((ProducerScope<? super CellularConnection>)$this$callbackFlow){
                            final /* synthetic */ ProducerScope<CellularConnection> $$this$callbackFlow;
                            {
                                this.$$this$callbackFlow = $$this$callbackFlow;
                            }

                            public void onAvailable(@NotNull Network network) {
                                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                                this.$$this$callbackFlow.trySend-JP2dKIU((Object)CellularConnection.Connected.INSTANCE);
                            }

                            public void onUnavailable() {
                                this.$$this$callbackFlow.trySend-JP2dKIU((Object)CellularConnection.Disconnected.INSTANCE);
                            }

                            public void onLost(@NotNull Network network) {
                                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                                this.$$this$callbackFlow.trySend-JP2dKIU((Object)CellularConnection.Disconnected.INSTANCE);
                            }
                        };
                        DefaultConnectivityRepository.access$getConnectivityManager$p(this.this$0).registerNetworkCallback(new NetworkRequest.Builder().addTransportType(0).addCapability(12).build(), networkCallback2);
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(this.this$0, networkCallback2){
                            final /* synthetic */ DefaultConnectivityRepository this$0;
                            final /* synthetic */ _cellularConnection.networkCallback.1 $networkCallback;
                            {
                                this.this$0 = $receiver;
                                this.$networkCallback = $networkCallback;
                                super(0);
                            }

                            public final void invoke() {
                                DefaultConnectivityRepository.access$getConnectivityManager$p(this.this$0).unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.$networkCallback);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ProducerScope<? super CellularConnection>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super CellularConnection> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.coroutineDispatcher)), (SharingStarted)SharingStarted.Companion.WhileSubscribed$default((SharingStarted.Companion)SharingStarted.Companion, (long)0L, (long)0L, (int)3, null), (Object)CellularConnection.Unknown.INSTANCE);
        this.generalConnectivityStatusFlow = FlowKt.stateIn((Flow)FlowKt.combineTransform((Flow)((Flow)this._wifiConnectionFlow), (Flow)((Flow)this._ethernetConnectionFlow), (Flow)((Flow)this._cellularConnection), (Function5)((Function5)new Function5<FlowCollector<? super ConnectivityStatus>, WifiConnection, EthernetConnection, CellularConnection, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            /* synthetic */ Object L$2;
            /* synthetic */ Object L$3;
            final /* synthetic */ DefaultConnectivityRepository this$0;
            {
                this.this$0 = $receiver;
                super(5, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FlowCollector $this$combineTransform = (FlowCollector)this.L$0;
                        WifiConnection wifi = (WifiConnection)this.L$1;
                        EthernetConnection ethernet = (EthernetConnection)this.L$2;
                        CellularConnection cell = (CellularConnection)this.L$3;
                        this.L$0 = null;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 1;
                        Object object3 = $this$combineTransform.emit((Object)((Object)DefaultConnectivityRepository.access$connectionDataTransformer(this.this$0, wifi, ethernet, cell)), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super ConnectivityStatus> p1, @NotNull WifiConnection p2, @NotNull EthernetConnection p3, @NotNull CellularConnection p4, @Nullable Continuation<? super Unit> p5) {
                Function5<FlowCollector<? super ConnectivityStatus>, WifiConnection, EthernetConnection, CellularConnection, Continuation<? super Unit>, Object> function5 = new /* invalid duplicate definition of identical inner class */;
                function5.L$0 = p1;
                function5.L$1 = p2;
                function5.L$2 = p3;
                function5.L$3 = p4;
                return function5.invokeSuspend((Object)Unit.INSTANCE);
            }
        })), (CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.coroutineDispatcher)), (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)((Object)ConnectivityStatus.UNKNOWN));
        this.wifiCallback = new WifiCallback();
        this.ethernetCallback = new EthernetCallback();
        this.listenForConnectivityChanges();
    }

    @Override
    @NotNull
    public StateFlow<NetworkLinkProperties> getNetworkLinkPropertiesFlow(@NotNull ConnectivityType connectivityType) {
        StateFlow stateFlow;
        Intrinsics.checkNotNullParameter((Object)((Object)connectivityType), (String)"connectivityType");
        switch (WhenMappings.$EnumSwitchMapping$0[connectivityType.ordinal()]) {
            case 1: {
                stateFlow = (StateFlow)this._ethernetLinkProperties;
                break;
            }
            case 2: {
                stateFlow = (StateFlow)this._wifiLinkProperties;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stateFlow;
    }

    @Override
    @NotNull
    public StateFlow<WifiConnection> getWifiConnectionFlow() {
        return this.wifiConnectionFlow;
    }

    @Override
    @NotNull
    public StateFlow<EthernetConnection> getEthernetConnectionFlow() {
        return this.ethernetConnectionFlow;
    }

    @Override
    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    @NotNull
    public String getWifiMacAddress() {
        String string = this.wifiManager.getConnectionInfo().getMacAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wifiManager.connectionInfo.macAddress");
        return string;
    }

    @Override
    @NotNull
    public String getRouterMacAddress() {
        String string = this.wifiManager.getConnectionInfo().getBSSID();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    @Nullable
    public WifiConfiguration getConnectedWifiConfiguration() {
        Object v1;
        block1: {
            List list = this.wifiManager.getConfiguredNetworks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wifiManager.configuredNetworks");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WifiConfiguration it = (WifiConfiguration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.SSID, (Object)this.wifiManager.getConnectionInfo().getSSID())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Override
    @NotNull
    public List<Inet4Address> getRecommendedDnsServers() {
        Object[] objectArray = new Inet4Address[2];
        InetAddress inetAddress = InetAddress.getByName("1.1.1.1");
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(\"1.1.1.1\")");
        objectArray[0] = WifiConfigurationUtilities.INSTANCE.ipv4orNull(inetAddress);
        InetAddress inetAddress2 = InetAddress.getByName("1.0.0.1");
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getByName(\"1.0.0.1\")");
        objectArray[1] = WifiConfigurationUtilities.INSTANCE.ipv4orNull(inetAddress2);
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Inet4Address> getDefaultDnsServers() {
        Object[] objectArray = new Inet4Address[2];
        InetAddress inetAddress = InetAddress.getByName("8.8.8.8");
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(\"8.8.8.8\")");
        objectArray[0] = WifiConfigurationUtilities.INSTANCE.ipv4orNull(inetAddress);
        InetAddress inetAddress2 = InetAddress.getByName("8.8.4.4");
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getByName(\"8.8.4.4\")");
        objectArray[1] = WifiConfigurationUtilities.INSTANCE.ipv4orNull(inetAddress2);
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Override
    @NotNull
    public StateFlow<ConnectivityStatus> getGeneralConnectivityStatusFlow() {
        return this.generalConnectivityStatusFlow;
    }

    @SuppressLint(value={"MissingPermission"})
    private final void listenForConnectivityChanges() {
        this.connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().addTransportType(1).build(), (ConnectivityManager.NetworkCallback)this.wifiCallback);
        this.connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().addTransportType(3).build(), (ConnectivityManager.NetworkCallback)this.ethernetCallback);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressLint(value={"MissingPermission"})
    @Nullable
    public String getIpAddress(@Nullable ConnectivityType connectivityType) {
        String string;
        if (connectivityType != null) {
            NetworkLinkProperties networkLinkProperties = (NetworkLinkProperties)this.getNetworkLinkPropertiesFlow(connectivityType).getValue();
            string = networkLinkProperties != null ? networkLinkProperties.getIpAddress() : null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            ConnectivityType[] $this$mapNotNull$iv = ConnectivityType.values();
            boolean $i$f$mapNotNull = false;
            ConnectivityType[] connectivityTypeArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n2 = ((void)$this$forEach$iv$iv$iv).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i2];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                NetworkLinkProperties networkLinkProperties = (NetworkLinkProperties)this.getNetworkLinkPropertiesFlow((ConnectivityType)it).getValue();
                if ((networkLinkProperties != null ? networkLinkProperties.getIpAddress() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }
        return string;
    }

    @Override
    @Nullable
    public Object canResolveDns(@NotNull String localIpAddress, @NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.coroutineDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(localIpAddress, null){
            int label;
            final /* synthetic */ String $localIpAddress;
            {
                this.$localIpAddress = $localIpAddress;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        String subdomain = StringsKt.replace$default((String)this.$localIpAddress, (char)'.', (char)'-', (boolean)false, (int)4, null);
                        String host = subdomain + ".device.stripe-terminal-local-reader.net";
                        try {
                            bl = Intrinsics.areEqual((Object)this.$localIpAddress, (Object)InetAddress.getByName(host).getHostAddress());
                        }
                        catch (UnknownHostException unknownHostException) {
                            bl = false;
                        }
                        catch (SecurityException securityException) {
                            bl = false;
                        }
                        return Boxing.boxBoolean((bl ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean hasConfiguredWifiNetworks() {
        List list = this.wifiManager.getConfiguredNetworks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wifiManager.configuredNetworks");
        return !((Collection)list).isEmpty();
    }

    @VisibleForTesting
    @Nullable
    public final Unit cancelWifiStrengthJob$connectivity_release() {
        Unit unit;
        Job job = this.wifiCallback.get_wifiStrengthJob$connectivity_release().getAndSet(null);
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final ConnectivityStatus connectionDataTransformer(WifiConnection wifi, EthernetConnection ethernet, CellularConnection cellular) {
        return wifi instanceof WifiConnection.Connected || ethernet instanceof EthernetConnection.Connected || cellular instanceof CellularConnection.Connected ? ConnectivityStatus.AVAILABLE : (wifi instanceof WifiConnection.Unknown && ethernet instanceof EthernetConnection.Unknown && cellular instanceof CellularConnection.Unknown ? ConnectivityStatus.UNKNOWN : ConnectivityStatus.UNAVAILABLE);
    }

    public static final /* synthetic */ ConnectivityManager access$getConnectivityManager$p(DefaultConnectivityRepository $this) {
        return $this.connectivityManager;
    }

    public static final /* synthetic */ ConnectivityStatus access$connectionDataTransformer(DefaultConnectivityRepository $this, WifiConnection wifi, EthernetConnection ethernet, CellularConnection cellular) {
        return $this.connectionDataTransformer(wifi, ethernet, cellular);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/core/connectivity/DefaultConnectivityRepository$Companion;", "", "()V", "DEVICE_DOMAIN_NAME_SUFFIX", "", "MAX_SCAN_ATTEMPTS", "", "NUM_RSSI_LEVELS", "SCAN_ATTEMPT_DELAY_MILLIS", "", "SIGNAL_INTERVAL_MILLIS", "connectivity_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lcom/stripe/core/connectivity/DefaultConnectivityRepository$EthernetCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "(Lcom/stripe/core/connectivity/DefaultConnectivityRepository;)V", "onAvailable", "", "network", "Landroid/net/Network;", "onLinkPropertiesChanged", "linkProperties", "Landroid/net/LinkProperties;", "onLost", "onUnavailable", "connectivity_release"})
    public final class EthernetCallback
    extends ConnectivityManager.NetworkCallback {
        public void onAvailable(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            DefaultConnectivityRepository.this._ethernetConnectionFlow.setValue((Object)EthernetConnection.Connected.INSTANCE);
        }

        public void onUnavailable() {
            DefaultConnectivityRepository.this._ethernetConnectionFlow.setValue((Object)EthernetConnection.Disconnected.INSTANCE);
        }

        public void onLinkPropertiesChanged(@NotNull Network network, @NotNull LinkProperties linkProperties) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Intrinsics.checkNotNullParameter((Object)linkProperties, (String)"linkProperties");
            DefaultConnectivityRepository.this._ethernetConnectionFlow.setValue((Object)EthernetConnection.Connected.INSTANCE);
            DefaultConnectivityRepository.this._ethernetLinkProperties.setValue((Object)ConnectivityRepositoryKt.access$toNetworkLinkProperties(linkProperties));
        }

        public void onLost(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            DefaultConnectivityRepository.this._ethernetConnectionFlow.setValue((Object)EthernetConnection.Disconnected.INSTANCE);
            DefaultConnectivityRepository.this._ethernetLinkProperties.setValue(null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectivityType.values().length];
            try {
                nArray[ConnectivityType.ETHERNET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectivityType.WIFI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\rH\u0003J\u0014\u0010\u0017\u001a\u00020\r2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0002R,\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/stripe/core/connectivity/DefaultConnectivityRepository$WifiCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "(Lcom/stripe/core/connectivity/DefaultConnectivityRepository;)V", "_wifiStrengthJob", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/coroutines/Job;", "get_wifiStrengthJob$connectivity_release$annotations", "()V", "get_wifiStrengthJob$connectivity_release", "()Ljava/util/concurrent/atomic/AtomicReference;", "set_wifiStrengthJob$connectivity_release", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "onAvailable", "", "network", "Landroid/net/Network;", "onLinkPropertiesChanged", "linkProperties", "Landroid/net/LinkProperties;", "onLost", "onUnavailable", "startWifiStrengthJob", "updateWifiConnectionFlow", "updateWifiStrengthJob", "newJob", "connectivity_release"})
    @SourceDebugExtension(value={"SMAP\nConnectivityRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectivityRepository.kt\ncom/stripe/core/connectivity/DefaultConnectivityRepository$WifiCallback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,453:1\n1#2:454\n288#3,2:455\n*S KotlinDebug\n*F\n+ 1 ConnectivityRepository.kt\ncom/stripe/core/connectivity/DefaultConnectivityRepository$WifiCallback\n*L\n330#1:455,2\n*E\n"})
    public final class WifiCallback
    extends ConnectivityManager.NetworkCallback {
        @NotNull
        private AtomicReference<Job> _wifiStrengthJob = new AtomicReference<Object>(null);

        public void onAvailable(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            this.startWifiStrengthJob();
        }

        public void onUnavailable() {
            block0: {
                this.updateWifiConnectionFlow();
                Job job = this._wifiStrengthJob.getAndSet(null);
                if (job == null) break block0;
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
        }

        public void onLinkPropertiesChanged(@NotNull Network network, @NotNull LinkProperties linkProperties) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Intrinsics.checkNotNullParameter((Object)linkProperties, (String)"linkProperties");
            DefaultConnectivityRepository.this._wifiLinkProperties.setValue((Object)ConnectivityRepositoryKt.access$toNetworkLinkProperties(linkProperties));
        }

        public void onLost(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            this.updateWifiConnectionFlow();
            Job job = this._wifiStrengthJob.getAndSet(null);
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            DefaultConnectivityRepository.this._wifiLinkProperties.setValue(null);
        }

        private final void startWifiStrengthJob() {
            Job job;
            this.updateWifiStrengthJob(null);
            DefaultConnectivityRepository.this.logger.d("Initiating WiFi strength job", new Pair[0]);
            Job p0 = job = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DefaultConnectivityRepository.this.coroutineDispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ WifiCallback this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
lbl6:
                            // 3 sources

                            while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                WifiCallback.access$updateWifiConnectionFlow(this.this$0);
                                this.L$0 = $this$launch;
                                this.label = 1;
                                v0 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                                if (v0 != var3_2) continue;
                                return var3_2;
                            }
                            break;
                        }
                        case 1: {
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            ** GOTO lbl6
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            boolean bl = false;
            this.updateWifiStrengthJob(p0);
        }

        private final void updateWifiStrengthJob(Job newJob) {
            block0: {
                Job oldJob;
                Job job = oldJob = this._wifiStrengthJob.getAndSet(newJob);
                if (job == null) break block0;
                Job job2 = job;
                DefaultConnectivityRepository defaultConnectivityRepository = DefaultConnectivityRepository.this;
                Job it = job2;
                boolean bl = false;
                Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
                defaultConnectivityRepository.logger.d("Existing WiFi Strength job cancelled.", new Pair[0]);
            }
        }

        static /* synthetic */ void updateWifiStrengthJob$default(WifiCallback wifiCallback, Job job, int n2, Object object) {
            if ((n2 & 1) != 0) {
                job = null;
            }
            wifiCallback.updateWifiStrengthJob(job);
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"MissingPermission"})
        private final void updateWifiConnectionFlow() {
            WifiConnection wifiConnection;
            String ssid = DefaultConnectivityRepository.this.wifiManager.getConnectionInfo().getSSID();
            MutableStateFlow mutableStateFlow = DefaultConnectivityRepository.this._wifiConnectionFlow;
            if (Intrinsics.areEqual((Object)ssid, (Object)"<unknown ssid>")) {
                wifiConnection = WifiConnection.Disconnected.INSTANCE;
            } else {
                Object v4;
                MutableStateFlow mutableStateFlow2;
                WifiInfo connectionInfo;
                block4: {
                    void $this$firstOrNull$iv;
                    connectionInfo = DefaultConnectivityRepository.this.wifiManager.getConnectionInfo();
                    WifiConnectionRepository wifiConnectionRepository = (WifiConnectionRepository)DefaultConnectivityRepository.this.wifiConnectionRepositoryProvider.get();
                    List list = DefaultConnectivityRepository.this.wifiManager.getScanResults();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wifiManager.scanResults");
                    Iterable iterable = wifiConnectionRepository.transformScanResults(list);
                    mutableStateFlow2 = mutableStateFlow;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        WifiScanResult it = (WifiScanResult)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getSsid().getValue(), (Object)ssid)) continue;
                        v4 = element$iv;
                        break block4;
                    }
                    v4 = null;
                }
                mutableStateFlow = mutableStateFlow2;
                Object object = v4;
                if (object == null || (object = object.getSecurity()) == null) {
                    object = WifiSecurity.UNSUPPORTED;
                }
                Object securityType = object;
                Intrinsics.checkNotNullExpressionValue((Object)ssid, (String)"ssid");
                wifiConnection = new WifiConnection.Connected(new WifiSSID(ssid), connectionInfo.getFrequency(), WifiManager.calculateSignalLevel((int)DefaultConnectivityRepository.this.wifiManager.getConnectionInfo().getRssi(), (int)5), 5, (WifiSecurity)((Object)securityType));
            }
            mutableStateFlow.setValue((Object)wifiConnection);
        }

        @NotNull
        public final AtomicReference<Job> get_wifiStrengthJob$connectivity_release() {
            return this._wifiStrengthJob;
        }

        public final void set_wifiStrengthJob$connectivity_release(@NotNull AtomicReference<Job> atomicReference) {
            Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
            this._wifiStrengthJob = atomicReference;
        }

        @VisibleForTesting
        public static /* synthetic */ void get_wifiStrengthJob$connectivity_release$annotations() {
        }

        public static final /* synthetic */ void access$updateWifiConnectionFlow(WifiCallback $this) {
            $this.updateWifiConnectionFlow();
        }
    }
}

