/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import androidx.annotation.VisibleForTesting;
import com.stripe.core.connectivity.ConnectivityLogger;
import com.stripe.core.connectivity.SignalStrength;
import com.stripe.core.connectivity.WifiAuthenticationResult;
import com.stripe.core.connectivity.WifiConfigurationStore;
import com.stripe.core.connectivity.WifiConfigurationUtilities;
import com.stripe.core.connectivity.WifiConnectionRepository;
import com.stripe.core.connectivity.WifiSSID;
import com.stripe.core.connectivity.WifiScanResult;
import com.stripe.core.connectivity.WifiSecurity;
import com.stripe.core.connectivity.WifiStateBroadcastReceiver;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.strings.StringsExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001MBI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J!\u00103\u001a\u0002042\u0006\u00105\u001a\u00020!2\u0006\u00106\u001a\u000207H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\u0019\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020'H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J!\u00109\u001a\u0002042\u0006\u00105\u001a\u00020!2\u0006\u00106\u001a\u000207H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J)\u0010<\u001a\u0002042\u0006\u0010=\u001a\u0002072\u0006\u00106\u001a\u0002072\u0006\u0010>\u001a\u00020\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0019\u0010@\u001a\u0002042\u0006\u0010:\u001a\u00020'H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0012\u0010A\u001a\u0004\u0018\u00010'2\u0006\u0010B\u001a\u00020CH\u0016J\u0011\u0010D\u001a\u000204H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010EJ\u0011\u0010F\u001a\u000204H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010EJ\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I0 H\u0016J\u0014\u0010J\u001a\u0002042\n\b\u0002\u0010K\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010L\u001a\u0002042\u0006\u0010:\u001a\u00020'H\u0016R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010$R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0 0&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010$R\u001c\u0010.\u001a\u00020/8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010\u0016\u001a\u0004\b1\u00102\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006N"}, d2={"Lcom/stripe/core/connectivity/DefaultWifiConnectionRepository;", "Lcom/stripe/core/connectivity/WifiConnectionRepository;", "context", "Landroid/content/Context;", "wifiManager", "Landroid/net/wifi/WifiManager;", "wifiConfigurationStore", "Lcom/stripe/core/connectivity/WifiConfigurationStore;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "signalConvertor", "Lkotlin/Function1;", "", "Lcom/stripe/core/connectivity/SignalStrength;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "connectivityLogger", "Lcom/stripe/core/connectivity/ConnectivityLogger;", "(Landroid/content/Context;Landroid/net/wifi/WifiManager;Lcom/stripe/core/connectivity/WifiConfigurationStore;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlin/jvm/functions/Function1;Lcom/stripe/jvmcore/logging/terminal/log/Log;Lcom/stripe/core/connectivity/ConnectivityLogger;)V", "_inProcessWifiConnectionAttempt", "Lcom/stripe/core/connectivity/DefaultWifiConnectionRepository$WifiConnectionAttemptMetadata;", "get_inProcessWifiConnectionAttempt$annotations", "()V", "_isWifiConnectionProcessing", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "_scanJob", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/coroutines/Job;", "_wifiAuthenticationResult", "Lcom/stripe/core/connectivity/WifiAuthenticationResult;", "_wifiScanResultsFlow", "", "Lcom/stripe/core/connectivity/WifiScanResult;", "isWifiConnectionProcessing", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "savedWifiConfigsFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "Landroid/net/wifi/WifiConfiguration;", "getSavedWifiConfigsFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "wifiAuthenticationResult", "getWifiAuthenticationResult", "wifiScanResultsFlow", "getWifiScanResultsFlow", "wifiStateBroadcastReceiver", "Lcom/stripe/core/connectivity/WifiStateBroadcastReceiver;", "getWifiStateBroadcastReceiver$connectivity_release$annotations", "getWifiStateBroadcastReceiver$connectivity_release", "()Lcom/stripe/core/connectivity/WifiStateBroadcastReceiver;", "connectToSupportedWifiNetwork", "", "wifiScanResult", "password", "", "(Lcom/stripe/core/connectivity/WifiScanResult;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connectToWifiNetwork", "wifiConfiguration", "(Landroid/net/wifi/WifiConfiguration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connectToWifiNetworkWithWPASecurity", "networkName", "isHidden", "(Ljava/lang/String;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "forgetWifiConfiguration", "getWifiConfiguration", "wifiSSID", "Lcom/stripe/core/connectivity/WifiSSID;", "refreshWifiScanResults", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scanForWifiNetworks", "transformScanResults", "scanResults", "Landroid/net/wifi/ScanResult;", "updateScanJob", "newJob", "updateWifiConfiguration", "WifiConnectionAttemptMetadata", "connectivity_release"})
@SourceDebugExtension(value={"SMAP\nWifiConnectionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WifiConnectionRepository.kt\ncom/stripe/core/connectivity/DefaultWifiConnectionRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,300:1\n1#2:301\n766#3:302\n857#3,2:303\n1549#3:305\n1620#3,3:306\n1045#3:309\n1194#3,2:310\n1222#3,4:312\n1477#3:316\n1502#3,3:317\n1505#3,3:327\n1360#3:330\n1446#3,2:331\n1045#3:333\n1448#3,3:334\n361#4,7:320\n*S KotlinDebug\n*F\n+ 1 WifiConnectionRepository.kt\ncom/stripe/core/connectivity/DefaultWifiConnectionRepository\n*L\n265#1:302\n265#1:303,2\n266#1:305\n266#1:306,3\n275#1:309\n276#1:310,2\n276#1:312,4\n279#1:316\n279#1:317,3\n279#1:327,3\n280#1:330\n280#1:331,2\n281#1:333\n280#1:334,3\n279#1:320,7\n*E\n"})
public final class DefaultWifiConnectionRepository
implements WifiConnectionRepository {
    @NotNull
    private final WifiManager wifiManager;
    @NotNull
    private final WifiConfigurationStore wifiConfigurationStore;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    @NotNull
    private final Function1<Integer, SignalStrength> signalConvertor;
    @NotNull
    private final Log logger;
    @NotNull
    private final ConnectivityLogger connectivityLogger;
    @NotNull
    private AtomicReference<Job> _scanJob;
    @NotNull
    private final MutableStateFlow<List<WifiScanResult>> _wifiScanResultsFlow;
    @NotNull
    private final StateFlow<List<WifiScanResult>> wifiScanResultsFlow;
    @NotNull
    private final MutableStateFlow<Boolean> _isWifiConnectionProcessing;
    @NotNull
    private final StateFlow<Boolean> isWifiConnectionProcessing;
    @NotNull
    private final MutableStateFlow<WifiAuthenticationResult> _wifiAuthenticationResult;
    @NotNull
    private final StateFlow<WifiAuthenticationResult> wifiAuthenticationResult;
    @NotNull
    private final SharedFlow<List<WifiConfiguration>> savedWifiConfigsFlow;
    @Nullable
    private WifiConnectionAttemptMetadata _inProcessWifiConnectionAttempt;
    @NotNull
    private final WifiStateBroadcastReceiver wifiStateBroadcastReceiver;

    public DefaultWifiConnectionRepository(@NotNull Context context, @NotNull WifiManager wifiManager, @NotNull WifiConfigurationStore wifiConfigurationStore, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull Function1<? super Integer, ? extends SignalStrength> signalConvertor, @NotNull Log logger2, @NotNull ConnectivityLogger connectivityLogger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)wifiManager, (String)"wifiManager");
        Intrinsics.checkNotNullParameter((Object)wifiConfigurationStore, (String)"wifiConfigurationStore");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter(signalConvertor, (String)"signalConvertor");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)connectivityLogger, (String)"connectivityLogger");
        this.wifiManager = wifiManager;
        this.wifiConfigurationStore = wifiConfigurationStore;
        this.coroutineDispatcher = coroutineDispatcher;
        this.signalConvertor = signalConvertor;
        this.logger = logger2;
        this.connectivityLogger = connectivityLogger;
        this._scanJob = new AtomicReference<Object>(null);
        this._wifiScanResultsFlow = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.wifiScanResultsFlow = FlowKt.asStateFlow(this._wifiScanResultsFlow);
        this._isWifiConnectionProcessing = StateFlowKt.MutableStateFlow((Object)false);
        this.isWifiConnectionProcessing = FlowKt.asStateFlow(this._isWifiConnectionProcessing);
        this._wifiAuthenticationResult = StateFlowKt.MutableStateFlow((Object)((Object)WifiAuthenticationResult.None));
        this.wifiAuthenticationResult = FlowKt.asStateFlow(this._wifiAuthenticationResult);
        this.savedWifiConfigsFlow = this.wifiConfigurationStore.getConfiguredNetworksFlow();
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.getWifiAuthenticationResult()), (Function2)((Function2)new Function2<WifiAuthenticationResult, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultWifiConnectionRepository this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WifiAuthenticationResult result2 = (WifiAuthenticationResult)((Object)this.L$0);
                        WifiConnectionAttemptMetadata wifiConnectionAttemptMetadata = this.this$0._inProcessWifiConnectionAttempt;
                        if (wifiConnectionAttemptMetadata != null) {
                            WifiConnectionAttemptMetadata wifiConnectionAttemptMetadata2 = wifiConnectionAttemptMetadata;
                            DefaultWifiConnectionRepository defaultWifiConnectionRepository = this.this$0;
                            WifiConnectionAttemptMetadata connectionAttempt = wifiConnectionAttemptMetadata2;
                            boolean bl = false;
                            if (result2 == WifiAuthenticationResult.Success) {
                                defaultWifiConnectionRepository.wifiConfigurationStore.saveWifiConfiguration(connectionAttempt.getInProcessWifiConfig());
                            }
                            if (result2 != WifiAuthenticationResult.None) {
                                WifiScanResult wifiScanResult = connectionAttempt.getWifiScanResult();
                                if (wifiScanResult != null) {
                                    WifiScanResult wifiScanResult2 = wifiScanResult;
                                    boolean bl2 = false;
                                    defaultWifiConnectionRepository.connectivityLogger.logWifiConnectionEventAttempt(wifiScanResult2.getOriginalScanResult(), result2);
                                }
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<WifiAuthenticationResult, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull WifiAuthenticationResult p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create((Object)p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.coroutineDispatcher)));
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.isWifiConnectionProcessing()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ boolean Z$0;
            final /* synthetic */ DefaultWifiConnectionRepository this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean it = this.Z$0;
                        if (!it) {
                            this.this$0._inProcessWifiConnectionAttempt = null;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<Boolean, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.Z$0 = (Boolean)value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.coroutineDispatcher)));
        this.wifiStateBroadcastReceiver = new WifiStateBroadcastReceiver(this._isWifiConnectionProcessing, this._wifiAuthenticationResult, this.logger);
        context.registerReceiver((BroadcastReceiver)this.wifiStateBroadcastReceiver, new IntentFilter("android.net.wifi.supplicant.STATE_CHANGE"));
    }

    @Override
    @NotNull
    public StateFlow<List<WifiScanResult>> getWifiScanResultsFlow() {
        return this.wifiScanResultsFlow;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> isWifiConnectionProcessing() {
        return this.isWifiConnectionProcessing;
    }

    @Override
    @NotNull
    public StateFlow<WifiAuthenticationResult> getWifiAuthenticationResult() {
        return this.wifiAuthenticationResult;
    }

    @NotNull
    public SharedFlow<List<WifiConfiguration>> getSavedWifiConfigsFlow() {
        return this.savedWifiConfigsFlow;
    }

    private static /* synthetic */ void get_inProcessWifiConnectionAttempt$annotations() {
    }

    @NotNull
    public final WifiStateBroadcastReceiver getWifiStateBroadcastReceiver$connectivity_release() {
        return this.wifiStateBroadcastReceiver;
    }

    @VisibleForTesting
    public static /* synthetic */ void getWifiStateBroadcastReceiver$connectivity_release$annotations() {
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    @Nullable
    public Object refreshWifiScanResults(@NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.coroutineDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultWifiConnectionRepository this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MutableStateFlow mutableStateFlow = DefaultWifiConnectionRepository.access$get_wifiScanResultsFlow$p(this.this$0);
                        List list = DefaultWifiConnectionRepository.access$getWifiManager$p(this.this$0).getScanResults();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wifiManager.scanResults");
                        mutableStateFlow.setValue(this.this$0.transformScanResults(list));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object scanForWifiNetworks(@NotNull Continuation<? super Unit> $completion) {
        Job job;
        this.updateScanJob(null);
        this.logger.d("Initiating WiFi network scan", new Pair[0]);
        Job p0 = job = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.coroutineDispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int I$0;
            boolean Z$0;
            int label;
            final /* synthetic */ DefaultWifiConnectionRepository this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        attempt = 0;
                        success = false;
lbl7:
                        // 3 sources

                        while (!success && ++attempt <= 5) {
                            success = DefaultWifiConnectionRepository.access$getWifiManager$p(this.this$0).startScan();
                            this.I$0 = attempt;
                            this.Z$0 = success;
                            this.label = 1;
                            v0 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                            if (v0 != var4_2) continue;
                            return var4_2;
                        }
                        break;
                    }
                    case 1: {
                        success = this.Z$0;
                        attempt = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                if (success) {
                    DefaultWifiConnectionRepository.access$getLogger$p(this.this$0).d("Successfully started WiFi scan after " + attempt + " attempt(s)", new Pair[0]);
                } else {
                    DefaultWifiConnectionRepository.access$getLogger$p(this.this$0).d("Aborted WiFi scan after " + (attempt - 1) + " failed attempts", new Pair[0]);
                }
                DefaultWifiConnectionRepository.access$get_scanJob$p(this.this$0).set(null);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        boolean bl = false;
        this.updateScanJob(p0);
        return Unit.INSTANCE;
    }

    private final void updateScanJob(Job newJob) {
        block0: {
            Job oldJob;
            Job job = oldJob = this._scanJob.getAndSet(newJob);
            if (job == null) break block0;
            Job it = job;
            boolean bl = false;
            Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
            this.logger.d("Existing WiFi scan cancelled.", new Pair[0]);
        }
    }

    static /* synthetic */ void updateScanJob$default(DefaultWifiConnectionRepository defaultWifiConnectionRepository, Job job, int n2, Object object) {
        if ((n2 & 1) != 0) {
            job = null;
        }
        defaultWifiConnectionRepository.updateScanJob(job);
    }

    @Override
    @Nullable
    public Object connectToWifiNetworkWithWPASecurity(@NotNull String networkName, @NotNull String password, boolean isHidden, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.coroutineDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(networkName, password, isHidden, this, null){
            int label;
            final /* synthetic */ String $networkName;
            final /* synthetic */ String $password;
            final /* synthetic */ boolean $isHidden;
            final /* synthetic */ DefaultWifiConnectionRepository this$0;
            {
                this.$networkName = $networkName;
                this.$password = $password;
                this.$isHidden = $isHidden;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WifiConfiguration config = WifiConfigurationUtilities.INSTANCE.wifiConfigFromSSIDAndPassword(this.$networkName, this.$password, this.$isHidden);
                        DefaultWifiConnectionRepository.access$set_inProcessWifiConnectionAttempt$p(this.this$0, new WifiConnectionAttemptMetadata(config, null));
                        this.label = 1;
                        Object object3 = this.this$0.connectToWifiNetwork(config, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object connectToWifiNetwork(@NotNull WifiScanResult wifiScanResult, @NotNull String password, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.coroutineDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(wifiScanResult, this, password, null){
            int label;
            final /* synthetic */ WifiScanResult $wifiScanResult;
            final /* synthetic */ DefaultWifiConnectionRepository this$0;
            final /* synthetic */ String $password;
            {
                this.$wifiScanResult = $wifiScanResult;
                this.this$0 = $receiver;
                this.$password = $password;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (this.$wifiScanResult.getSecurity() == WifiSecurity.UNSUPPORTED) return Unit.INSTANCE;
                        this.label = 1;
                        Object object3 = DefaultWifiConnectionRepository.access$connectToSupportedWifiNetwork(this.this$0, this.$wifiScanResult, this.$password, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object connectToSupportedWifiNetwork(WifiScanResult wifiScanResult, String password, Continuation<? super Unit> $completion) {
        WifiConfiguration config = WifiConfigurationUtilities.INSTANCE.wifiConfigFromWifiScanResult(wifiScanResult, password);
        this._inProcessWifiConnectionAttempt = new WifiConnectionAttemptMetadata(config, wifiScanResult);
        Object object = this.connectToWifiNetwork(config, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object connectToWifiNetwork(@NotNull WifiConfiguration wifiConfiguration, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.coroutineDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, wifiConfiguration, null){
            int label;
            final /* synthetic */ DefaultWifiConnectionRepository this$0;
            final /* synthetic */ WifiConfiguration $wifiConfiguration;
            {
                this.this$0 = $receiver;
                this.$wifiConfiguration = $wifiConfiguration;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultWifiConnectionRepository.access$get_isWifiConnectionProcessing$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)true));
                        DefaultWifiConnectionRepository.access$get_wifiAuthenticationResult$p(this.this$0).setValue((Object)((Object)WifiAuthenticationResult.None));
                        WifiConfigurationUtilities.INSTANCE.connectToNetwork(DefaultWifiConnectionRepository.access$getWifiManager$p(this.this$0), this.$wifiConfiguration);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<WifiScanResult> transformScanResults(@NotNull List<ScanResult> scanResults) {
        void $this$flatMapTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        void $this$associateByTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(scanResults, (String)"scanResults");
        Iterable $this$filter$iv = scanResults;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ScanResult)element$iv$iv;
            boolean bl = false;
            String string = ((ScanResult)it).SSID;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.SSID");
            boolean bl2 = !StringsKt.isBlank((CharSequence)string);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void scanResult;
            it = (ScanResult)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = scanResult.SSID;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scanResult.SSID");
            WifiSSID wifiSSID = new WifiSSID(StringsExtKt.surroundInDoubleQuotes(string));
            String string2 = scanResult.capabilities;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"scanResult.capabilities");
            object.add(new WifiScanResult(wifiSSID, WifiSecurity.Companion.fromCapabilities(string2), (SignalStrength)((Object)this.signalConvertor.invoke((Object)scanResult.level)), (ScanResult)scanResult));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$associateBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                WifiScanResult it = (WifiScanResult)a2;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getSignalStrength().getLevel());
                it = (WifiScanResult)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getSignalStrength().getLevel()));
            }
        });
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            WifiScanResult bl = (WifiScanResult)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl3 = false;
            object.put(it2.getSsid().getValue(), element$iv$iv);
        }
        Iterable $this$groupBy$iv = destination$iv$iv2.values();
        boolean $i$f$groupBy = false;
        Iterable capacity$iv22 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            it = (WifiScanResult)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = ((WifiScanResult)it).getSignalStrength().getLevel();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object wifiScanResultMap = destination$iv$iv;
        Iterable $this$flatMap$iv = CollectionsKt.sortedDescending((Iterable)wifiScanResultMap.keySet());
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            List list2;
            int signalStrength = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            List list3 = (List)wifiScanResultMap.get(signalStrength);
            if (list3 != null) {
                Iterable $this$sortedBy$iv2 = list3;
                boolean $i$f$sortedBy2 = false;
                list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                    public final int compare(T a2, T b2) {
                        WifiScanResult it = (WifiScanResult)a2;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getSsid().getValue());
                        it = (WifiScanResult)b2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSsid().getValue())));
                    }
                });
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public WifiConfiguration getWifiConfiguration(@NotNull WifiSSID wifiSSID) {
        Intrinsics.checkNotNullParameter((Object)wifiSSID, (String)"wifiSSID");
        return this.wifiConfigurationStore.getWifiConfiguration(wifiSSID);
    }

    @Override
    public void updateWifiConfiguration(@NotNull WifiConfiguration wifiConfiguration) {
        Intrinsics.checkNotNullParameter((Object)wifiConfiguration, (String)"wifiConfiguration");
        this.wifiConfigurationStore.saveWifiConfiguration(wifiConfiguration);
    }

    @Override
    @Nullable
    public Object forgetWifiConfiguration(@NotNull WifiConfiguration wifiConfiguration, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.coroutineDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, wifiConfiguration, null){
            int label;
            final /* synthetic */ DefaultWifiConnectionRepository this$0;
            final /* synthetic */ WifiConfiguration $wifiConfiguration;
            {
                this.this$0 = $receiver;
                this.$wifiConfiguration = $wifiConfiguration;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WifiConfigurationUtilities.INSTANCE.forgetWifiConfiguration(DefaultWifiConnectionRepository.access$getWifiManager$p(this.this$0), this.$wifiConfiguration);
                        DefaultWifiConnectionRepository.access$getWifiConfigurationStore$p(this.this$0).forgetWifiConfiguration(this.$wifiConfiguration);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableStateFlow access$get_wifiScanResultsFlow$p(DefaultWifiConnectionRepository $this) {
        return $this._wifiScanResultsFlow;
    }

    public static final /* synthetic */ WifiManager access$getWifiManager$p(DefaultWifiConnectionRepository $this) {
        return $this.wifiManager;
    }

    public static final /* synthetic */ Log access$getLogger$p(DefaultWifiConnectionRepository $this) {
        return $this.logger;
    }

    public static final /* synthetic */ AtomicReference access$get_scanJob$p(DefaultWifiConnectionRepository $this) {
        return $this._scanJob;
    }

    public static final /* synthetic */ Object access$connectToSupportedWifiNetwork(DefaultWifiConnectionRepository $this, WifiScanResult wifiScanResult, String password, Continuation $completion) {
        return $this.connectToSupportedWifiNetwork(wifiScanResult, password, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ MutableStateFlow access$get_isWifiConnectionProcessing$p(DefaultWifiConnectionRepository $this) {
        return $this._isWifiConnectionProcessing;
    }

    public static final /* synthetic */ MutableStateFlow access$get_wifiAuthenticationResult$p(DefaultWifiConnectionRepository $this) {
        return $this._wifiAuthenticationResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/stripe/core/connectivity/DefaultWifiConnectionRepository$WifiConnectionAttemptMetadata;", "", "inProcessWifiConfig", "Landroid/net/wifi/WifiConfiguration;", "wifiScanResult", "Lcom/stripe/core/connectivity/WifiScanResult;", "(Landroid/net/wifi/WifiConfiguration;Lcom/stripe/core/connectivity/WifiScanResult;)V", "getInProcessWifiConfig", "()Landroid/net/wifi/WifiConfiguration;", "getWifiScanResult", "()Lcom/stripe/core/connectivity/WifiScanResult;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "connectivity_release"})
    public static final class WifiConnectionAttemptMetadata {
        @NotNull
        private final WifiConfiguration inProcessWifiConfig;
        @Nullable
        private final WifiScanResult wifiScanResult;

        public WifiConnectionAttemptMetadata(@NotNull WifiConfiguration inProcessWifiConfig, @Nullable WifiScanResult wifiScanResult) {
            Intrinsics.checkNotNullParameter((Object)inProcessWifiConfig, (String)"inProcessWifiConfig");
            this.inProcessWifiConfig = inProcessWifiConfig;
            this.wifiScanResult = wifiScanResult;
        }

        public /* synthetic */ WifiConnectionAttemptMetadata(WifiConfiguration wifiConfiguration, WifiScanResult wifiScanResult, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                wifiScanResult = null;
            }
            this(wifiConfiguration, wifiScanResult);
        }

        @NotNull
        public final WifiConfiguration getInProcessWifiConfig() {
            return this.inProcessWifiConfig;
        }

        @Nullable
        public final WifiScanResult getWifiScanResult() {
            return this.wifiScanResult;
        }

        @NotNull
        public final WifiConfiguration component1() {
            return this.inProcessWifiConfig;
        }

        @Nullable
        public final WifiScanResult component2() {
            return this.wifiScanResult;
        }

        @NotNull
        public final WifiConnectionAttemptMetadata copy(@NotNull WifiConfiguration inProcessWifiConfig, @Nullable WifiScanResult wifiScanResult) {
            Intrinsics.checkNotNullParameter((Object)inProcessWifiConfig, (String)"inProcessWifiConfig");
            return new WifiConnectionAttemptMetadata(inProcessWifiConfig, wifiScanResult);
        }

        public static /* synthetic */ WifiConnectionAttemptMetadata copy$default(WifiConnectionAttemptMetadata wifiConnectionAttemptMetadata, WifiConfiguration wifiConfiguration, WifiScanResult wifiScanResult, int n2, Object object) {
            if ((n2 & 1) != 0) {
                wifiConfiguration = wifiConnectionAttemptMetadata.inProcessWifiConfig;
            }
            if ((n2 & 2) != 0) {
                wifiScanResult = wifiConnectionAttemptMetadata.wifiScanResult;
            }
            return wifiConnectionAttemptMetadata.copy(wifiConfiguration, wifiScanResult);
        }

        @NotNull
        public String toString() {
            return "WifiConnectionAttemptMetadata(inProcessWifiConfig=" + this.inProcessWifiConfig + ", wifiScanResult=" + this.wifiScanResult + ')';
        }

        public int hashCode() {
            int result2 = this.inProcessWifiConfig.hashCode();
            result2 = result2 * 31 + (this.wifiScanResult == null ? 0 : this.wifiScanResult.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WifiConnectionAttemptMetadata)) {
                return false;
            }
            WifiConnectionAttemptMetadata wifiConnectionAttemptMetadata = (WifiConnectionAttemptMetadata)other;
            if (!Intrinsics.areEqual((Object)this.inProcessWifiConfig, (Object)wifiConnectionAttemptMetadata.inProcessWifiConfig)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.wifiScanResult, (Object)wifiConnectionAttemptMetadata.wifiScanResult);
        }
    }
}

