/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity;

import androidx.annotation.VisibleForTesting;
import com.stripe.core.connectivity.WifiConfigurationUtilities;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0006R(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/stripe/core/connectivity/SubnetMaskUtilities;", "", "()V", "prefixLengthInetAddressMapping", "", "", "", "getPrefixLengthInetAddressMapping$connectivity_release$annotations", "getPrefixLengthInetAddressMapping$connectivity_release", "()Ljava/util/Map;", "inetAddressMappingToPrefixLength", "inetAddress", "Ljava/net/Inet4Address;", "(Ljava/net/Inet4Address;)Ljava/lang/Integer;", "(Ljava/lang/String;)Ljava/lang/Integer;", "prefixLengthToInetAddress", "length", "subnetMaskFromString", "text", "connectivity_release"})
@SourceDebugExtension(value={"SMAP\nSubnetMaskUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubnetMaskUtilities.kt\ncom/stripe/core/connectivity/SubnetMaskUtilities\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,60:1\n215#2,2:61\n*S KotlinDebug\n*F\n+ 1 SubnetMaskUtilities.kt\ncom/stripe/core/connectivity/SubnetMaskUtilities\n*L\n52#1:61,2\n*E\n"})
public final class SubnetMaskUtilities {
    @NotNull
    public static final SubnetMaskUtilities INSTANCE = new SubnetMaskUtilities();
    @NotNull
    private static final Map<Integer, String> prefixLengthInetAddressMapping;

    private SubnetMaskUtilities() {
    }

    @NotNull
    public final Map<Integer, String> getPrefixLengthInetAddressMapping$connectivity_release() {
        return prefixLengthInetAddressMapping;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPrefixLengthInetAddressMapping$connectivity_release$annotations() {
    }

    @Nullable
    public final Inet4Address subnetMaskFromString(@NotNull String text) {
        Inet4Address inet4Address;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String trimmed = ((Object)StringsKt.trim((CharSequence)text)).toString();
        Integer n2 = this.inetAddressMappingToPrefixLength(trimmed);
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            inet4Address = INSTANCE.prefixLengthToInetAddress(it);
        } else {
            inet4Address = null;
        }
        return inet4Address;
    }

    @Nullable
    public final Inet4Address prefixLengthToInetAddress(int length) {
        Inet4Address inet4Address;
        String string = prefixLengthInetAddressMapping.get(length);
        if (string != null) {
            String it = string;
            boolean bl = false;
            InetAddress inetAddress = InetAddress.getByName(it);
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(it)");
            inet4Address = WifiConfigurationUtilities.INSTANCE.ipv4orNull(inetAddress);
        } else {
            inet4Address = null;
        }
        return inet4Address;
    }

    @Nullable
    public final Integer inetAddressMappingToPrefixLength(@NotNull Inet4Address inetAddress) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        return this.inetAddressMappingToPrefixLength(inetAddress.getHostAddress());
    }

    @Nullable
    public final Integer inetAddressMappingToPrefixLength(@Nullable String inetAddress) {
        Map<Integer, String> $this$forEach$iv = prefixLengthInetAddressMapping;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, String> element$iv;
            Map.Entry<Integer, String> it = element$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getValue(), (Object)inetAddress)) continue;
            return it.getKey();
        }
        return null;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)8, (Object)"255.0.0.0"), TuplesKt.to((Object)9, (Object)"255.128.0.0"), TuplesKt.to((Object)10, (Object)"255.192.0.0"), TuplesKt.to((Object)11, (Object)"255.224.0.0"), TuplesKt.to((Object)12, (Object)"255.240.0.0"), TuplesKt.to((Object)13, (Object)"255.248.0.0"), TuplesKt.to((Object)14, (Object)"255.252.0.0"), TuplesKt.to((Object)15, (Object)"255.254.0.0"), TuplesKt.to((Object)16, (Object)"255.255.0.0"), TuplesKt.to((Object)17, (Object)"255.255.128.0"), TuplesKt.to((Object)18, (Object)"255.255.192.0"), TuplesKt.to((Object)19, (Object)"255.255.224.0"), TuplesKt.to((Object)20, (Object)"255.255.240.0"), TuplesKt.to((Object)21, (Object)"255.255.248.0"), TuplesKt.to((Object)22, (Object)"255.255.252.0"), TuplesKt.to((Object)23, (Object)"255.255.254.0"), TuplesKt.to((Object)24, (Object)"255.255.255.0"), TuplesKt.to((Object)25, (Object)"255.255.255.128"), TuplesKt.to((Object)26, (Object)"255.255.255.192"), TuplesKt.to((Object)27, (Object)"255.255.255.224"), TuplesKt.to((Object)28, (Object)"255.255.255.240"), TuplesKt.to((Object)29, (Object)"255.255.255.248"), TuplesKt.to((Object)30, (Object)"255.255.255.252")};
        prefixLengthInetAddressMapping = MapsKt.mapOf((Pair[])pairArray);
    }
}

