/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.LinkAddress;
import android.net.wifi.WifiConfiguration;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.stripe.core.connectivity.SubnetMaskUtilities;
import com.stripe.core.connectivity.WifiAdvancedConfig;
import com.stripe.core.connectivity.WifiConfigurationUtilities;
import com.stripe.core.connectivity.WifiSSID;
import com.stripe.jvmcore.dagger.ForApplication;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 +2\u00020\u0001:\u0003+,-B\u0011\b\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000bJ\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\n2\u0006\u0010!\u001a\u00020\u001bJ\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010!\u001a\u00020\u001bJ\u0014\u0010\"\u001a\u0004\u0018\u00010 2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u001bJ\u0014\u0010$\u001a\u0004\u0018\u00010 2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u001d2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0010\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010!\u001a\u00020\u001bJ\u0014\u0010&\u001a\u0004\u0018\u00010 2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010'\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\u001bJ\u0006\u0010(\u001a\u00020\u0016J\u000e\u0010)\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000bJ\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002R'\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR'\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/stripe/core/connectivity/WifiConfigurationStore;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "dataStore", "Lcom/stripe/core/connectivity/WifiConfigurationStore$DataStore;", "(Lcom/stripe/core/connectivity/WifiConfigurationStore$DataStore;)V", "_configuredNetworksFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Landroid/net/wifi/WifiConfiguration;", "get_configuredNetworksFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "_configuredNetworksFlow$delegate", "Lkotlin/Lazy;", "configuredNetworksFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "getConfiguredNetworksFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "configuredNetworksFlow$delegate", "emitConfiguredNetworks", "", "forgetWifiConfiguration", "wifiConfiguration", "fromJSON", "ssid", "Lcom/stripe/core/connectivity/WifiSSID;", "jsonObject", "Lorg/json/JSONObject;", "getConfiguredNetworks", "getDnsServers", "Ljava/net/Inet4Address;", "wifiSSID", "getGateway", "Ljava/net/InetAddress;", "getIPAddress", "getJSONObject", "getSubnetMask", "getWifiConfiguration", "removeAllEntries", "saveWifiConfiguration", "toJSON", "Companion", "DataStore", "EncryptedPrefsDataStore", "connectivity_release"})
@SourceDebugExtension(value={"SMAP\nWifiConfigurationStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WifiConfigurationStore.kt\ncom/stripe/core/connectivity/WifiConfigurationStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1603#2,9:216\n1855#2:225\n1856#2:227\n1612#2:228\n1549#2:230\n1620#2,3:231\n1#3:226\n1#3:229\n*S KotlinDebug\n*F\n+ 1 WifiConfigurationStore.kt\ncom/stripe/core/connectivity/WifiConfigurationStore\n*L\n39#1:216,9\n39#1:225\n39#1:227\n39#1:228\n124#1:230\n124#1:231,3\n39#1:226\n*E\n"})
public final class WifiConfigurationStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataStore dataStore;
    @NotNull
    private final Lazy _configuredNetworksFlow$delegate;
    @NotNull
    private final Lazy configuredNetworksFlow$delegate;
    @NotNull
    private static final String SHARED_PREFERENCES_NAME = "wifi_config_store";
    private static final int CurrentSerializationVersion = 0;
    @NotNull
    private static final String SerializationVersion_JsonKey = "version";
    @NotNull
    private static final String PreSharedKey_JsonKey = "pre_shared_key";
    @NotNull
    private static final String HiddenNetwork_JsonKey = "hidden_key";
    @NotNull
    public static final String IpAddress_JsonKey = "ip_address";
    @NotNull
    public static final String SubNetMask_JsonKey = "subnet_mask";
    @NotNull
    public static final String Gateway_JsonKey = "gateway";
    @NotNull
    public static final String DnsServers_JsonKey = "dns_servers";

    public WifiConfigurationStore(@NotNull DataStore dataStore) {
        Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
        this.dataStore = dataStore;
        this._configuredNetworksFlow$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableStateFlow<List<? extends WifiConfiguration>>>(this){
            final /* synthetic */ WifiConfigurationStore this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MutableStateFlow<List<WifiConfiguration>> invoke() {
                return StateFlowKt.MutableStateFlow((Object)WifiConfigurationStore.access$getConfiguredNetworks(this.this$0));
            }
        }));
        this.configuredNetworksFlow$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedFlow<? extends List<? extends WifiConfiguration>>>(this){
            final /* synthetic */ WifiConfigurationStore this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SharedFlow<List<WifiConfiguration>> invoke() {
                return FlowKt.asSharedFlow((MutableSharedFlow)((MutableSharedFlow)WifiConfigurationStore.access$get_configuredNetworksFlow(this.this$0)));
            }
        }));
    }

    @Inject
    public WifiConfigurationStore(@ForApplication @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(new EncryptedPrefsDataStore(context));
    }

    private final MutableStateFlow<List<WifiConfiguration>> get_configuredNetworksFlow() {
        Lazy lazy = this._configuredNetworksFlow$delegate;
        return (MutableStateFlow)lazy.getValue();
    }

    @NotNull
    public final SharedFlow<List<WifiConfiguration>> getConfiguredNetworksFlow() {
        Lazy lazy = this.configuredNetworksFlow$delegate;
        return (SharedFlow)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<WifiConfiguration> getConfiguredNetworks() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.dataStore.getAllKeys();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WifiConfiguration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String ssidString = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.getWifiConfiguration(new WifiSSID(ssidString)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void emitConfiguredNetworks() {
        this.get_configuredNetworksFlow().setValue(this.getConfiguredNetworks());
    }

    public final void removeAllEntries() {
        this.dataStore.removeAllEntries();
        this.emitConfiguredNetworks();
    }

    public final void saveWifiConfiguration(@NotNull WifiConfiguration wifiConfiguration) {
        Intrinsics.checkNotNullParameter((Object)wifiConfiguration, (String)"wifiConfiguration");
        String string = wifiConfiguration.SSID;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wifiConfiguration.SSID");
        this.dataStore.putString(string, this.toJSON(wifiConfiguration).toString());
        this.emitConfiguredNetworks();
    }

    public final void forgetWifiConfiguration(@NotNull WifiConfiguration wifiConfiguration) {
        Intrinsics.checkNotNullParameter((Object)wifiConfiguration, (String)"wifiConfiguration");
        String string = wifiConfiguration.SSID;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wifiConfiguration.SSID");
        this.dataStore.removeString(string);
        this.emitConfiguredNetworks();
    }

    @Nullable
    public final WifiConfiguration getWifiConfiguration(@NotNull WifiSSID wifiSSID) {
        WifiConfiguration wifiConfiguration;
        Intrinsics.checkNotNullParameter((Object)wifiSSID, (String)"wifiSSID");
        JSONObject jSONObject = this.getJSONObject(wifiSSID);
        if (jSONObject != null) {
            JSONObject it = jSONObject;
            boolean bl = false;
            wifiConfiguration = this.fromJSON(wifiSSID, it);
        } else {
            wifiConfiguration = null;
        }
        return wifiConfiguration;
    }

    @NotNull
    public final List<Inet4Address> getDnsServers(@NotNull WifiSSID wifiSSID) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)wifiSSID, (String)"wifiSSID");
                object = this.getJSONObject(wifiSSID);
                if (object == null) break block2;
                JSONObject it = object;
                boolean bl = false;
                List<Inet4Address> list = this.getDnsServers(it);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final List<Inet4Address> getDnsServers(JSONObject jsonObject) {
        Object object;
        List dnsServers = new ArrayList();
        try {
            boolean bl = false;
            JSONObject jSONObject = jsonObject;
            object = Result.constructor-impl((Object)(jSONObject != null ? jSONObject.getJSONArray(DnsServers_JsonKey) : null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        JSONArray jSONArray = (JSONArray)(Result.isFailure-impl((Object)object) ? null : object);
        if (jSONArray != null) {
            JSONArray it = jSONArray;
            boolean bl = false;
            int i2 = 0;
            int n2 = it.length();
            if (i2 <= n2) {
                while (true) {
                    Object object2;
                    try {
                        boolean bl2 = false;
                        InetAddress inetAddress = InetAddress.getByName(it.getString(i2));
                        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(it.getString(i))");
                        object2 = Result.constructor-impl((Object)WifiConfigurationUtilities.INSTANCE.ipv4orNull(inetAddress));
                    }
                    catch (Throwable throwable) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    Inet4Address dnsServer = (Inet4Address)(Result.isFailure-impl((Object)object2) ? null : object2);
                    if (dnsServer != null) {
                        dnsServers.add(dnsServer);
                    }
                    if (i2 == n2) break;
                    ++i2;
                }
            }
        }
        return dnsServers;
    }

    @Nullable
    public final Inet4Address getIPAddress(@NotNull WifiSSID wifiSSID) {
        Inet4Address inet4Address;
        Intrinsics.checkNotNullParameter((Object)wifiSSID, (String)"wifiSSID");
        JSONObject jSONObject = this.getJSONObject(wifiSSID);
        if (jSONObject != null) {
            JSONObject it = jSONObject;
            boolean bl = false;
            inet4Address = this.getIPAddress(it);
        } else {
            inet4Address = null;
        }
        return inet4Address;
    }

    private final Inet4Address getIPAddress(JSONObject jsonObject) {
        Inet4Address inet4Address;
        String string = WifiConfigurationStore.Companion.getStringFromJSON(jsonObject, IpAddress_JsonKey);
        if (string != null) {
            Object object;
            String it = string;
            boolean bl = false;
            try {
                boolean bl2 = false;
                InetAddress inetAddress = InetAddress.getByName(it);
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(it)");
                object = Result.constructor-impl((Object)WifiConfigurationUtilities.INSTANCE.ipv4orNull(inetAddress));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            inet4Address = (Inet4Address)(Result.isFailure-impl((Object)object) ? null : object);
        } else {
            inet4Address = null;
        }
        return inet4Address;
    }

    @Nullable
    public final InetAddress getSubnetMask(@NotNull WifiSSID wifiSSID) {
        Inet4Address inet4Address;
        Intrinsics.checkNotNullParameter((Object)wifiSSID, (String)"wifiSSID");
        JSONObject jSONObject = this.getJSONObject(wifiSSID);
        if (jSONObject != null) {
            JSONObject it = jSONObject;
            boolean bl = false;
            inet4Address = this.getSubnetMask(it);
        } else {
            inet4Address = null;
        }
        return inet4Address;
    }

    private final Inet4Address getSubnetMask(JSONObject jsonObject) {
        JSONObject jSONObject = jsonObject;
        return SubnetMaskUtilities.INSTANCE.prefixLengthToInetAddress(jSONObject != null ? jSONObject.optInt(SubNetMask_JsonKey) : 0);
    }

    @Nullable
    public final InetAddress getGateway(@NotNull WifiSSID wifiSSID) {
        Inet4Address inet4Address;
        Intrinsics.checkNotNullParameter((Object)wifiSSID, (String)"wifiSSID");
        JSONObject jSONObject = this.getJSONObject(wifiSSID);
        if (jSONObject != null) {
            JSONObject it = jSONObject;
            boolean bl = false;
            inet4Address = this.getGateway(it);
        } else {
            inet4Address = null;
        }
        return inet4Address;
    }

    private final Inet4Address getGateway(JSONObject jsonObject) {
        Inet4Address inet4Address;
        String string = WifiConfigurationStore.Companion.getStringFromJSON(jsonObject, Gateway_JsonKey);
        if (string != null) {
            Object object;
            String it = string;
            boolean bl = false;
            try {
                boolean bl2 = false;
                InetAddress inetAddress = InetAddress.getByName(it);
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(it)");
                object = Result.constructor-impl((Object)WifiConfigurationUtilities.INSTANCE.ipv4orNull(inetAddress));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            inet4Address = (Inet4Address)(Result.isFailure-impl((Object)object) ? null : object);
        } else {
            inet4Address = null;
        }
        return inet4Address;
    }

    private final JSONObject getJSONObject(WifiSSID wifiSSID) {
        Object object;
        String string = this.dataStore.getString(wifiSSID.getValue(), null);
        if (string == null) {
            return null;
        }
        String jsonString = string;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)new JSONObject(jsonString));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (JSONObject)(Result.isFailure-impl((Object)object) ? null : object);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONObject toJSON(WifiConfiguration wifiConfiguration) {
        JSONObject jsonObject = new JSONObject();
        WifiConfigurationUtilities.StaticIPConfigurationWrapper staticIpConfig = WifiConfigurationUtilities.INSTANCE.getCurrentStaticIpConfigurationOrEmpty(wifiConfiguration);
        LinkAddress linkAddress = staticIpConfig.getLinkAddress();
        jsonObject.put(SerializationVersion_JsonKey, 0);
        jsonObject.put(PreSharedKey_JsonKey, (Object)wifiConfiguration.preSharedKey);
        jsonObject.put(HiddenNetwork_JsonKey, wifiConfiguration.hiddenSSID);
        LinkAddress linkAddress2 = linkAddress;
        jsonObject.put(SubNetMask_JsonKey, linkAddress2 != null ? linkAddress2.getPrefixLength() : 0);
        switch (WhenMappings.$EnumSwitchMapping$0[WifiConfigurationUtilities.INSTANCE.getConfigType(wifiConfiguration).ordinal()]) {
            case 1: {
                jsonObject.put(IpAddress_JsonKey, null);
                jsonObject.put(Gateway_JsonKey, null);
                jsonObject.put(DnsServers_JsonKey, null);
                break;
            }
            case 2: {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object = linkAddress;
                jsonObject.put(IpAddress_JsonKey, object != null && (object = object.getAddress()) != null ? ((InetAddress)object).getHostAddress() : null);
                InetAddress inetAddress = staticIpConfig.getGateway();
                jsonObject.put(Gateway_JsonKey, (Object)(inetAddress != null ? inetAddress.getHostAddress() : null));
                Iterable iterable = staticIpConfig.getDnsServers();
                String string = DnsServers_JsonKey;
                JSONObject jSONObject = jsonObject;
                boolean $i$f$map = false;
                void var7_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    InetAddress inetAddress2 = (InetAddress)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getHostAddress());
                }
                collection = (List)destination$iv$iv;
                Collection collection2 = collection;
                jSONObject.put(string, (Object)new JSONArray(collection2));
            }
        }
        return jsonObject;
    }

    private final WifiConfiguration fromJSON(WifiSSID ssid, JSONObject jsonObject) {
        WifiConfiguration wifiConfiguration;
        String string = jsonObject.optString(PreSharedKey_JsonKey);
        if (string == null) {
            return null;
        }
        String preSharedKey = string;
        boolean hiddenNetwork = jsonObject.optBoolean(HiddenNetwork_JsonKey, false);
        int serializationVersion = jsonObject.optInt(SerializationVersion_JsonKey, 0);
        Inet4Address ipAddress = this.getIPAddress(jsonObject);
        Inet4Address subnetMask = this.getSubnetMask(jsonObject);
        Inet4Address gateway = this.getGateway(jsonObject);
        List<Inet4Address> dnsServers = this.getDnsServers(jsonObject);
        WifiConfiguration it = wifiConfiguration = new WifiConfiguration();
        boolean bl = false;
        it.SSID = ssid.getValue();
        it.preSharedKey = preSharedKey;
        it.hiddenSSID = hiddenNetwork;
        if (ipAddress == null || subnetMask == null || gateway == null || dnsServers.isEmpty() || !WifiConfigurationUtilities.INSTANCE.setAdvancedInfo(it, ipAddress, subnetMask, gateway, dnsServers)) {
            WifiConfigurationUtilities.INSTANCE.clearAdvancedInfo(it);
        }
        return wifiConfiguration;
    }

    public static final /* synthetic */ List access$getConfiguredNetworks(WifiConfigurationStore $this) {
        return $this.getConfiguredNetworks();
    }

    public static final /* synthetic */ MutableStateFlow access$get_configuredNetworksFlow(WifiConfigurationStore $this) {
        return $this.get_configuredNetworksFlow();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/core/connectivity/WifiConfigurationStore$Companion;", "", "()V", "CurrentSerializationVersion", "", "DnsServers_JsonKey", "", "Gateway_JsonKey", "HiddenNetwork_JsonKey", "IpAddress_JsonKey", "PreSharedKey_JsonKey", "SHARED_PREFERENCES_NAME", "SerializationVersion_JsonKey", "SubNetMask_JsonKey", "getStringFromJSON", "jsonObject", "Lorg/json/JSONObject;", "key", "connectivity_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String getStringFromJSON(JSONObject jsonObject, String key) {
            JSONObject jSONObject = jsonObject;
            String rawString = jSONObject != null ? jSONObject.optString(key) : null;
            CharSequence charSequence = rawString;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : rawString;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H&J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004H&J\b\u0010\u000b\u001a\u00020\tH&J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/stripe/core/connectivity/WifiConfigurationStore$DataStore;", "", "getAllKeys", "", "", "getString", "key", "defaultString", "putString", "", "value", "removeAllEntries", "removeString", "connectivity_release"})
    public static interface DataStore {
        public void putString(@NotNull String var1, @Nullable String var2);

        @Nullable
        public String getString(@NotNull String var1, @Nullable String var2);

        public void removeString(@NotNull String var1);

        @NotNull
        public Set<String> getAllKeys();

        public void removeAllEntries();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nH\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/core/connectivity/WifiConfigurationStore$EncryptedPrefsDataStore;", "Lcom/stripe/core/connectivity/WifiConfigurationStore$DataStore;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "masterKey", "Landroidx/security/crypto/MasterKey;", "sharedPreferences", "Landroid/content/SharedPreferences;", "getAllKeys", "", "", "kotlin.jvm.PlatformType", "getString", "key", "defaultString", "putString", "", "value", "removeAllEntries", "removeString", "connectivity_release"})
    @SourceDebugExtension(value={"SMAP\nWifiConfigurationStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WifiConfigurationStore.kt\ncom/stripe/core/connectivity/WifiConfigurationStore$EncryptedPrefsDataStore\n+ 2 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n*L\n1#1,215:1\n39#2,12:216\n39#2,12:228\n39#2,12:240\n*S KotlinDebug\n*F\n+ 1 WifiConfigurationStore.kt\ncom/stripe/core/connectivity/WifiConfigurationStore$EncryptedPrefsDataStore\n*L\n169#1:216,12\n176#1:228,12\n179#1:240,12\n*E\n"})
    public static final class EncryptedPrefsDataStore
    implements DataStore {
        @NotNull
        private final MasterKey masterKey;
        @NotNull
        private final SharedPreferences sharedPreferences;

        public EncryptedPrefsDataStore(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            MasterKey masterKey = new MasterKey.Builder(context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
            Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"Builder(context)\n       \u2026GCM)\n            .build()");
            this.masterKey = masterKey;
            SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((Context)context, (String)WifiConfigurationStore.SHARED_PREFERENCES_NAME, (MasterKey)this.masterKey, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n            cont\u2026heme.AES256_GCM\n        )");
            this.sharedPreferences = sharedPreferences;
        }

        @Override
        public void putString(@NotNull String key, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$putString_u24lambda_u240 = editor$iv;
            boolean bl = false;
            $this$putString_u24lambda_u240.putString(key, value);
            editor$iv.apply();
        }

        @Override
        @Nullable
        public String getString(@NotNull String key, @Nullable String defaultString) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.sharedPreferences.getString(key, defaultString);
        }

        @Override
        public void removeString(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$removeString_u24lambda_u241 = editor$iv;
            boolean bl = false;
            $this$removeString_u24lambda_u241.remove(key);
            editor$iv.apply();
        }

        @Override
        @NotNull
        public Set<String> getAllKeys() {
            return this.sharedPreferences.getAll().keySet();
        }

        @Override
        public void removeAllEntries() {
            SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$removeAllEntries_u24lambda_u242 = editor$iv;
            boolean bl = false;
            $this$removeAllEntries_u24lambda_u242.clear();
            editor$iv.apply();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WifiAdvancedConfig.values().length];
            try {
                nArray[WifiAdvancedConfig.DHCP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WifiAdvancedConfig.STATIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

