/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity;

import android.net.LinkAddress;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import androidx.annotation.VisibleForTesting;
import com.stripe.core.connectivity.SubnetMaskUtilities;
import com.stripe.core.connectivity.WifiAdvancedConfig;
import com.stripe.core.connectivity.WifiScanResult;
import com.stripe.core.connectivity.WifiSecurity;
import com.stripe.core.stripeterminal.log.AndroidLog;
import com.stripe.jvmcore.strings.StringsExtKt;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003<=>B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0001H\u0002J+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004J\u001e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!J \u0010\"\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u0004J\n\u0010&\u001a\u00020\n*\u00020\u000eJ\u0010\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013*\u00020\u000eJ\n\u0010(\u001a\u00020)*\u00020\u000eJ\n\u0010*\u001a\u00020+*\u00020\u000eJ\u0010\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013*\u00020\u000eJ\u0010\u0010-\u001a\u0006\u0012\u0002\b\u00030.*\u00020\u000eH\u0002J\u0010\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013*\u00020\u000eJ\u0010\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013*\u00020\u000eJ\u0010\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013*\u00020\u000eJ\f\u00102\u001a\u0004\u0018\u000103*\u000204J0\u00105\u001a\u00020!*\u00020\u000e2\u0006\u00106\u001a\u0002032\u0006\u00107\u001a\u0002032\u0006\u00108\u001a\u0002032\f\u00109\u001a\b\u0012\u0004\u0012\u0002030\u0013J\u0014\u0010:\u001a\u00020\n*\u00020\u000e2\u0006\u0010;\u001a\u00020)H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/stripe/core/connectivity/WifiConfigurationUtilities;", "", "()V", "DefaultConstructorIPAddress", "", "GatewayField", "IPAddressField", "TAG", "kotlin.jvm.PlatformType", "connectToNetwork", "", "wifiManager", "Landroid/net/wifi/WifiManager;", "wifiConfiguration", "Landroid/net/wifi/WifiConfiguration;", "forgetWifiConfiguration", "forgetWifiNetworkId", "getEmptyStaticIpConfiguration", "getValuesFromBitset", "", "bitSet", "Ljava/util/BitSet;", "strings", "", "getValuesFromBitset$connectivity_release", "(Ljava/util/BitSet;[Ljava/lang/String;)Ljava/util/List;", "validateIPV4FromString", "Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressValidation;", "untrimmedText", "wifiConfigFromSSIDAndPassword", "ssid", "password", "isHidden", "", "wifiConfigFromSSIDAndPasswordHelper", "wifiConfigFromWifiScanResult", "wifiNetwork", "Lcom/stripe/core/connectivity/WifiScanResult;", "clearAdvancedInfo", "getAuthAlgorithms", "getConfigType", "Lcom/stripe/core/connectivity/WifiAdvancedConfig;", "getCurrentStaticIpConfigurationOrEmpty", "Lcom/stripe/core/connectivity/WifiConfigurationUtilities$StaticIPConfigurationWrapper;", "getGroupCiphers", "getIPAssignmentEnum", "", "getPairwiseCiphers", "getSupportedKeys", "getSupportedProtocols", "ipv4orNull", "Ljava/net/Inet4Address;", "Ljava/net/InetAddress;", "setAdvancedInfo", "ipAddress", "subnetMask", "gateway", "dnsServers", "setIpAssignment", "config", "InetAddressParseError", "InetAddressValidation", "StaticIPConfigurationWrapper", "connectivity_release"})
@SourceDebugExtension(value={"SMAP\nWifiConfigurationUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WifiConfigurationUtilities.kt\ncom/stripe/core/connectivity/WifiConfigurationUtilities\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n288#2,2:289\n1855#2,2:291\n1864#2,3:296\n766#2:299\n857#2,2:300\n1603#2,9:302\n1855#2:311\n1856#2:313\n1612#2:314\n13579#3,2:293\n1#4:295\n1#4:312\n*S KotlinDebug\n*F\n+ 1 WifiConfigurationUtilities.kt\ncom/stripe/core/connectivity/WifiConfigurationUtilities\n*L\n91#1:289,2\n103#1:291,2\n174#1:296,3\n269#1:299\n269#1:300,2\n270#1:302,9\n270#1:311\n270#1:313\n270#1:314\n133#1:293,2\n270#1:312\n*E\n"})
public final class WifiConfigurationUtilities {
    @NotNull
    public static final WifiConfigurationUtilities INSTANCE = new WifiConfigurationUtilities();
    private static final String TAG = INSTANCE.getClass().getSimpleName();
    @NotNull
    private static final String IPAddressField = "ipAddress";
    @NotNull
    private static final String GatewayField = "gateway";
    @NotNull
    private static final String DefaultConstructorIPAddress = "0.0.0.0";

    private WifiConfigurationUtilities() {
    }

    @Nullable
    public final Inet4Address ipv4orNull(@NotNull InetAddress $this$ipv4orNull) {
        Intrinsics.checkNotNullParameter((Object)$this$ipv4orNull, (String)"<this>");
        return $this$ipv4orNull instanceof Inet4Address ? (Inet4Address)$this$ipv4orNull : null;
    }

    @NotNull
    public final InetAddressValidation validateIPV4FromString(@NotNull String untrimmedText) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)untrimmedText, (String)"untrimmedText");
        String text = ((Object)StringsKt.trim((CharSequence)untrimmedText)).toString();
        if (((CharSequence)text).length() == 0 || Intrinsics.areEqual((Object)text, (Object)DefaultConstructorIPAddress)) {
            return new InetAddressValidation.Error(InetAddressParseError.INVALID_STRING);
        }
        try {
            boolean bl = false;
            InetAddress inetAddress = InetAddress.getByName(text);
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(text)");
            Inet4Address ipAddress = INSTANCE.ipv4orNull(inetAddress);
            object = Result.constructor-impl((Object)(ipAddress != null ? (InetAddressValidation)new InetAddressValidation.Success(ipAddress) : (InetAddressValidation)new InetAddressValidation.Error(InetAddressParseError.IPV6_UNSUPPORTED)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        InetAddressValidation.Error error = new InetAddressValidation.Error(InetAddressParseError.INVALID_STRING);
        return (InetAddressValidation)(Result.isFailure-impl((Object)object) ? error : object);
    }

    @NotNull
    public final WifiConfiguration wifiConfigFromWifiScanResult(@NotNull WifiScanResult wifiNetwork, @NotNull String password) {
        WifiConfiguration wifiConfiguration;
        Intrinsics.checkNotNullParameter((Object)wifiNetwork, (String)"wifiNetwork");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String ssid = wifiNetwork.getSsid().getValue();
        switch (WhenMappings.$EnumSwitchMapping$0[wifiNetwork.getSecurity().ordinal()]) {
            case 1: 
            case 2: {
                wifiConfiguration = this.wifiConfigFromSSIDAndPasswordHelper(ssid, password, false);
                break;
            }
            case 3: {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                AndroidLog.INSTANCE.e(string, "Unsupported WifiSecurity. Trying to connect anyways, but will likely fail.");
                wifiConfiguration = this.wifiConfigFromSSIDAndPasswordHelper(ssid, password, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return wifiConfiguration;
    }

    @NotNull
    public final WifiConfiguration wifiConfigFromSSIDAndPassword(@NotNull String ssid, @NotNull String password, boolean isHidden) {
        Intrinsics.checkNotNullParameter((Object)ssid, (String)"ssid");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.wifiConfigFromSSIDAndPasswordHelper(StringsExtKt.surroundInDoubleQuotes(ssid), password, isHidden);
    }

    private final WifiConfiguration wifiConfigFromSSIDAndPasswordHelper(String ssid, String password, boolean isHidden) {
        WifiConfiguration wifiConfiguration;
        WifiConfiguration it = wifiConfiguration = new WifiConfiguration();
        boolean bl = false;
        it.SSID = ssid;
        it.hiddenSSID = isHidden;
        it.preSharedKey = StringsExtKt.surroundInDoubleQuotes(password);
        return wifiConfiguration;
    }

    private final void forgetWifiNetworkId(WifiManager wifiManager, WifiConfiguration wifiConfiguration) {
        wifiManager.removeNetwork(wifiConfiguration.networkId);
        wifiManager.saveConfiguration();
    }

    public final void forgetWifiConfiguration(@NotNull WifiManager wifiManager, @NotNull WifiConfiguration wifiConfiguration) {
        Intrinsics.checkNotNullParameter((Object)wifiManager, (String)"wifiManager");
        Intrinsics.checkNotNullParameter((Object)wifiConfiguration, (String)"wifiConfiguration");
        try {
            Object v1;
            block4: {
                List list = wifiManager.getConfiguredNetworks();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wifiManager.configuredNetworks");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    WifiConfiguration it = (WifiConfiguration)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.SSID, (Object)wifiConfiguration.SSID)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            WifiConfiguration savedNetwork = v1;
            if (savedNetwork != null) {
                this.forgetWifiNetworkId(wifiManager, savedNetwork);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public final void connectToNetwork(@NotNull WifiManager wifiManager, @NotNull WifiConfiguration wifiConfiguration) {
        Intrinsics.checkNotNullParameter((Object)wifiManager, (String)"wifiManager");
        Intrinsics.checkNotNullParameter((Object)wifiConfiguration, (String)"wifiConfiguration");
        try {
            List list = wifiManager.getConfiguredNetworks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wifiManager.configuredNetworks");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WifiConfiguration it = (WifiConfiguration)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                INSTANCE.forgetWifiNetworkId(wifiManager, it);
            }
        }
        catch (SecurityException $this$forEach$iv) {
            // empty catch block
        }
        int networkId = wifiManager.addNetwork(wifiConfiguration);
        wifiManager.disconnect();
        wifiManager.enableNetwork(networkId, true);
        wifiManager.reconnect();
    }

    private final Enum<?> getIPAssignmentEnum(WifiConfiguration $this$getIPAssignmentEnum) {
        Object object = $this$getIPAssignmentEnum.getClass().getMethod("getIpAssignment", new Class[0]).invoke((Object)$this$getIPAssignmentEnum, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
        return (Enum)object;
    }

    private final Object getEmptyStaticIpConfiguration() {
        Class<?> staticConfigClass = Class.forName("android.net.StaticIpConfiguration");
        Object obj = staticConfigClass.newInstance();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"staticConfigClass.newInstance()");
        return obj;
    }

    @NotNull
    public final StaticIPConfigurationWrapper getCurrentStaticIpConfigurationOrEmpty(@NotNull WifiConfiguration $this$getCurrentStaticIpConfigurationOrEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$getCurrentStaticIpConfigurationOrEmpty, (String)"<this>");
        Object config = $this$getCurrentStaticIpConfigurationOrEmpty.getClass().getMethod("getStaticIpConfiguration", new Class[0]).invoke((Object)$this$getCurrentStaticIpConfigurationOrEmpty, new Object[0]);
        Object object = config;
        if (object == null) {
            object = this.getEmptyStaticIpConfiguration();
        }
        return new StaticIPConfigurationWrapper(object);
    }

    @NotNull
    public final WifiAdvancedConfig getConfigType(@NotNull WifiConfiguration $this$getConfigType) {
        Intrinsics.checkNotNullParameter((Object)$this$getConfigType, (String)"<this>");
        Enum<?> enum_ = this.getIPAssignmentEnum($this$getConfigType);
        WifiAdvancedConfig[] $this$forEach$iv = WifiAdvancedConfig.values();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            WifiAdvancedConfig element$iv;
            WifiAdvancedConfig it = element$iv = $this$forEach$iv[i2];
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getEnumName(), (Object)enum_.name())) continue;
            return it;
        }
        return WifiAdvancedConfig.DHCP;
    }

    public final void clearAdvancedInfo(@NotNull WifiConfiguration $this$clearAdvancedInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$clearAdvancedInfo, (String)"<this>");
        this.setIpAssignment($this$clearAdvancedInfo, WifiAdvancedConfig.DHCP);
        StaticIPConfigurationWrapper staticConfigWrapper = this.getCurrentStaticIpConfigurationOrEmpty($this$clearAdvancedInfo);
        Object[] objectArray = new Class[]{staticConfigWrapper.getJavaClass()};
        Method method = $this$clearAdvancedInfo.getClass().getMethod("setStaticIpConfiguration", (Class<?>[])objectArray);
        objectArray = new Object[]{this.getEmptyStaticIpConfiguration()};
        method.invoke((Object)$this$clearAdvancedInfo, objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setAdvancedInfo(@NotNull WifiConfiguration $this$setAdvancedInfo, @NotNull Inet4Address ipAddress, @NotNull Inet4Address subnetMask, @NotNull Inet4Address gateway, @NotNull List<Inet4Address> dnsServers) {
        int prefixLength;
        Intrinsics.checkNotNullParameter((Object)$this$setAdvancedInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)IPAddressField);
        Intrinsics.checkNotNullParameter((Object)subnetMask, (String)"subnetMask");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)GatewayField);
        Intrinsics.checkNotNullParameter(dnsServers, (String)"dnsServers");
        Inet4Address it = subnetMask;
        boolean $i$a$-let-WifiConfigurationUtilities$setAdvancedInfo$prefixLength$22 = false;
        Integer n2 = SubnetMaskUtilities.INSTANCE.inetAddressMappingToPrefixLength(it);
        int n3 = prefixLength = n2 != null ? n2 : 0;
        if (dnsServers.isEmpty() || prefixLength == 0) {
            AndroidLog.INSTANCE.d("WifiConfigUtilities", "Ignoring setAdvancedInfo for invalid configuration");
            return false;
        }
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        AndroidLog.INSTANCE.d(string, "setAdvancedInfo IP -> " + ipAddress);
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        AndroidLog.INSTANCE.d(string2, "setAdvancedInfo subnetMask -> " + subnetMask);
        String string3 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
        AndroidLog.INSTANCE.d(string3, "setAdvancedInfo gateway -> " + gateway);
        Iterable $this$forEachIndexed$iv = dnsServers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void inetAddress;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Inet4Address inet4Address = (Inet4Address)item$iv;
            int index = n4;
            boolean bl = false;
            String string4 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"TAG");
            AndroidLog.INSTANCE.d(string4, "setAdvancedInfo DNS[" + index + "] -> " + inetAddress);
        }
        this.setIpAssignment($this$setAdvancedInfo, WifiAdvancedConfig.STATIC);
        StaticIPConfigurationWrapper staticConfigWrapper = new StaticIPConfigurationWrapper(this.getEmptyStaticIpConfiguration());
        Class[] $i$a$-let-WifiConfigurationUtilities$setAdvancedInfo$prefixLength$22 = new Class[]{InetAddress.class, Integer.TYPE};
        Constructor constructor = LinkAddress.class.getConstructor($i$a$-let-WifiConfigurationUtilities$setAdvancedInfo$prefixLength$22);
        Intrinsics.checkNotNullExpressionValue(constructor, (String)"LinkAddress::class.java.\u2026vaPrimitiveType\n        )");
        Constructor laConstructor = constructor;
        Object[] objectArray = new Object[]{ipAddress, prefixLength};
        Object t2 = laConstructor.newInstance(objectArray);
        Intrinsics.checkNotNull(t2, (String)"null cannot be cast to non-null type android.net.LinkAddress");
        LinkAddress linkAddress = (LinkAddress)t2;
        staticConfigWrapper.setField(IPAddressField, linkAddress);
        staticConfigWrapper.setField(GatewayField, gateway);
        List<InetAddress> currentDnsServers = staticConfigWrapper.getDnsServers();
        currentDnsServers.clear();
        currentDnsServers.addAll((Collection<InetAddress>)dnsServers);
        objectArray = new Class[]{staticConfigWrapper.getJavaClass()};
        Method method = $this$setAdvancedInfo.getClass().getMethod("setStaticIpConfiguration", (Class<?>[])objectArray);
        objectArray = new Object[]{staticConfigWrapper.getStaticConfig()};
        method.invoke((Object)$this$setAdvancedInfo, objectArray);
        return true;
    }

    @NotNull
    public final List<String> getSupportedKeys(@NotNull WifiConfiguration $this$getSupportedKeys) {
        Intrinsics.checkNotNullParameter((Object)$this$getSupportedKeys, (String)"<this>");
        BitSet bitSet = $this$getSupportedKeys.allowedKeyManagement;
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"allowedKeyManagement");
        Intrinsics.checkNotNullExpressionValue((Object)WifiConfiguration.KeyMgmt.strings, (String)"strings");
        return this.getValuesFromBitset$connectivity_release(bitSet, WifiConfiguration.KeyMgmt.strings);
    }

    @NotNull
    public final List<String> getSupportedProtocols(@NotNull WifiConfiguration $this$getSupportedProtocols) {
        Intrinsics.checkNotNullParameter((Object)$this$getSupportedProtocols, (String)"<this>");
        BitSet bitSet = $this$getSupportedProtocols.allowedProtocols;
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"allowedProtocols");
        Intrinsics.checkNotNullExpressionValue((Object)WifiConfiguration.Protocol.strings, (String)"strings");
        return this.getValuesFromBitset$connectivity_release(bitSet, WifiConfiguration.Protocol.strings);
    }

    @NotNull
    public final List<String> getAuthAlgorithms(@NotNull WifiConfiguration $this$getAuthAlgorithms) {
        Intrinsics.checkNotNullParameter((Object)$this$getAuthAlgorithms, (String)"<this>");
        BitSet bitSet = $this$getAuthAlgorithms.allowedAuthAlgorithms;
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"allowedAuthAlgorithms");
        Intrinsics.checkNotNullExpressionValue((Object)WifiConfiguration.AuthAlgorithm.strings, (String)"strings");
        return this.getValuesFromBitset$connectivity_release(bitSet, WifiConfiguration.AuthAlgorithm.strings);
    }

    @NotNull
    public final List<String> getPairwiseCiphers(@NotNull WifiConfiguration $this$getPairwiseCiphers) {
        Intrinsics.checkNotNullParameter((Object)$this$getPairwiseCiphers, (String)"<this>");
        BitSet bitSet = $this$getPairwiseCiphers.allowedPairwiseCiphers;
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"allowedPairwiseCiphers");
        Intrinsics.checkNotNullExpressionValue((Object)WifiConfiguration.PairwiseCipher.strings, (String)"strings");
        return this.getValuesFromBitset$connectivity_release(bitSet, WifiConfiguration.PairwiseCipher.strings);
    }

    @NotNull
    public final List<String> getGroupCiphers(@NotNull WifiConfiguration $this$getGroupCiphers) {
        Intrinsics.checkNotNullParameter((Object)$this$getGroupCiphers, (String)"<this>");
        BitSet bitSet = $this$getGroupCiphers.allowedGroupCiphers;
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"allowedGroupCiphers");
        Intrinsics.checkNotNullExpressionValue((Object)WifiConfiguration.GroupCipher.strings, (String)"strings");
        return this.getValuesFromBitset$connectivity_release(bitSet, WifiConfiguration.GroupCipher.strings);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<String> getValuesFromBitset$connectivity_release(@NotNull BitSet bitSet, @NotNull String[] strings) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        Iterable $this$filter$iv = (Iterable)RangesKt.until((int)0, (int)bitSet.size());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int index = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!bitSet.get(index)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            int index = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if ((String)ArraysKt.getOrNull((Object[])strings, (int)index) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void setIpAssignment(WifiConfiguration $this$setIpAssignment, WifiAdvancedConfig config) {
        Class<?> clazz = this.getIPAssignmentEnum($this$setIpAssignment).getClass();
        Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<out kotlin.Enum<*>>");
        Class<?> ipAssignmentEnum = clazz;
        Object[] objectArray = new Class[]{ipAssignmentEnum};
        Method method = $this$setIpAssignment.getClass().getMethod("setIpAssignment", (Class<?>[])objectArray);
        objectArray = new Object[]{Enum.valueOf(ipAssignmentEnum, config.getEnumName())};
        method.invoke((Object)$this$setIpAssignment, objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressParseError;", "", "(Ljava/lang/String;I)V", "IPV6_UNSUPPORTED", "INVALID_STRING", "connectivity_release"})
    public static final class InetAddressParseError
    extends Enum<InetAddressParseError> {
        public static final /* enum */ InetAddressParseError IPV6_UNSUPPORTED = new InetAddressParseError();
        public static final /* enum */ InetAddressParseError INVALID_STRING = new InetAddressParseError();
        private static final /* synthetic */ InetAddressParseError[] $VALUES;

        public static InetAddressParseError[] values() {
            return (InetAddressParseError[])$VALUES.clone();
        }

        public static InetAddressParseError valueOf(String value) {
            return Enum.valueOf(InetAddressParseError.class, value);
        }

        static {
            $VALUES = inetAddressParseErrorArray = new InetAddressParseError[]{InetAddressParseError.IPV6_UNSUPPORTED, InetAddressParseError.INVALID_STRING};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressValidation;", "", "()V", "Error", "Success", "Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressValidation$Error;", "Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressValidation$Success;", "connectivity_release"})
    public static abstract class InetAddressValidation {
        private InetAddressValidation() {
        }

        public /* synthetic */ InetAddressValidation(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressValidation$Error;", "Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressValidation;", "error", "Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressParseError;", "(Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressParseError;)V", "getError", "()Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressParseError;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "connectivity_release"})
        public static final class Error
        extends InetAddressValidation {
            @NotNull
            private final InetAddressParseError error;

            public Error(@NotNull InetAddressParseError error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final InetAddressParseError getError() {
                return this.error;
            }

            @NotNull
            public final InetAddressParseError component1() {
                return this.error;
            }

            @NotNull
            public final Error copy(@NotNull InetAddressParseError error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                return new Error(error);
            }

            public static /* synthetic */ Error copy$default(Error error, InetAddressParseError inetAddressParseError, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    inetAddressParseError = error.error;
                }
                return error.copy(inetAddressParseError);
            }

            @NotNull
            public String toString() {
                return "Error(error=" + (Object)((Object)this.error) + ')';
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return this.error == error.error;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressValidation$Success;", "Lcom/stripe/core/connectivity/WifiConfigurationUtilities$InetAddressValidation;", "ipv4Address", "Ljava/net/Inet4Address;", "(Ljava/net/Inet4Address;)V", "getIpv4Address", "()Ljava/net/Inet4Address;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "connectivity_release"})
        public static final class Success
        extends InetAddressValidation {
            @NotNull
            private final Inet4Address ipv4Address;

            public Success(@NotNull Inet4Address ipv4Address) {
                Intrinsics.checkNotNullParameter((Object)ipv4Address, (String)"ipv4Address");
                super(null);
                this.ipv4Address = ipv4Address;
            }

            @NotNull
            public final Inet4Address getIpv4Address() {
                return this.ipv4Address;
            }

            @NotNull
            public final Inet4Address component1() {
                return this.ipv4Address;
            }

            @NotNull
            public final Success copy(@NotNull Inet4Address ipv4Address) {
                Intrinsics.checkNotNullParameter((Object)ipv4Address, (String)"ipv4Address");
                return new Success(ipv4Address);
            }

            public static /* synthetic */ Success copy$default(Success success, Inet4Address inet4Address, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    inet4Address = success.ipv4Address;
                }
                return success.copy(inet4Address);
            }

            @NotNull
            public String toString() {
                return "Success(ipv4Address=" + this.ipv4Address + ')';
            }

            public int hashCode() {
                return this.ipv4Address.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)this.ipv4Address, (Object)success.ipv4Address);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/stripe/core/connectivity/WifiConfigurationUtilities$StaticIPConfigurationWrapper;", "", "staticConfig", "(Ljava/lang/Object;)V", "javaClass", "Ljava/lang/Class;", "getJavaClass", "()Ljava/lang/Class;", "getStaticConfig", "()Ljava/lang/Object;", "equals", "", "other", "getDnsServers", "", "Ljava/net/InetAddress;", "getGateway", "getLinkAddress", "Landroid/net/LinkAddress;", "hashCode", "", "setField", "", "name", "", "value", "connectivity_release"})
    public static final class StaticIPConfigurationWrapper {
        @NotNull
        private final Object staticConfig;
        @NotNull
        private final Class<Object> javaClass;

        public StaticIPConfigurationWrapper(@NotNull Object staticConfig) {
            Intrinsics.checkNotNullParameter((Object)staticConfig, (String)"staticConfig");
            this.staticConfig = staticConfig;
            this.javaClass = this.staticConfig.getClass();
        }

        @NotNull
        public final Object getStaticConfig() {
            return this.staticConfig;
        }

        @NotNull
        public final List<InetAddress> getDnsServers() {
            Object object = this.staticConfig.getClass().getField("dnsServers").get(this.staticConfig);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<java.net.InetAddress>");
            return TypeIntrinsics.asMutableList((Object)object);
        }

        @Nullable
        public final LinkAddress getLinkAddress() {
            return (LinkAddress)this.staticConfig.getClass().getField(WifiConfigurationUtilities.IPAddressField).get(this.staticConfig);
        }

        @Nullable
        public final InetAddress getGateway() {
            return (InetAddress)this.staticConfig.getClass().getField(WifiConfigurationUtilities.GatewayField).get(this.staticConfig);
        }

        public final void setField(@NotNull String name, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.staticConfig.getClass().getField(name).set(this.staticConfig, value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            StaticIPConfigurationWrapper staticIPConfigurationWrapper = other instanceof StaticIPConfigurationWrapper ? (StaticIPConfigurationWrapper)other : null;
            return Objects.equals(this.staticConfig, staticIPConfigurationWrapper != null ? staticIPConfigurationWrapper.staticConfig : null);
        }

        public int hashCode() {
            return this.staticConfig.hashCode();
        }

        @NotNull
        public final Class<Object> getJavaClass() {
            return this.javaClass;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WifiSecurity.values().length];
            try {
                nArray[WifiSecurity.WPA2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WifiSecurity.WPA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WifiSecurity.UNSUPPORTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

