/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity;

import android.net.wifi.WifiConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0001\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0019\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lcom/stripe/core/connectivity/WifiSecurity;", "", "code", "", "minPasswordLength", "", "(Ljava/lang/String;ILjava/lang/String;I)V", "getCode", "()Ljava/lang/String;", "getMinPasswordLength", "()I", "WPA", "WPA2", "UNSUPPORTED", "Companion", "connectivity_release"})
public final class WifiSecurity
extends Enum<WifiSecurity> {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final String code;
    private final int minPasswordLength;
    @NotNull
    private static final List<WifiSecurity> ORDERED_SECURITY_MODES;
    public static final /* enum */ WifiSecurity WPA;
    public static final /* enum */ WifiSecurity WPA2;
    public static final /* enum */ WifiSecurity UNSUPPORTED;
    private static final /* synthetic */ WifiSecurity[] $VALUES;

    private WifiSecurity(String code, int minPasswordLength) {
        this.code = code;
        this.minPasswordLength = minPasswordLength;
    }

    @Nullable
    public final String getCode() {
        return this.code;
    }

    public final int getMinPasswordLength() {
        return this.minPasswordLength;
    }

    public static WifiSecurity[] values() {
        return (WifiSecurity[])$VALUES.clone();
    }

    public static WifiSecurity valueOf(String value) {
        return Enum.valueOf(WifiSecurity.class, value);
    }

    static {
        WPA = new WifiSecurity("WPA", 8);
        WPA2 = new WifiSecurity("WPA2", 8);
        UNSUPPORTED = new WifiSecurity(null, 0);
        $VALUES = wifiSecurityArray = new WifiSecurity[]{WifiSecurity.WPA, WifiSecurity.WPA2, WifiSecurity.UNSUPPORTED};
        Companion = new Companion(null);
        WifiSecurity[] wifiSecurityArray = new WifiSecurity[]{WPA, WPA2};
        ORDERED_SECURITY_MODES = CollectionsKt.reversed((Iterable)CollectionsKt.listOf((Object[])wifiSecurityArray));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/core/connectivity/WifiSecurity$Companion;", "", "()V", "ORDERED_SECURITY_MODES", "", "Lcom/stripe/core/connectivity/WifiSecurity;", "fromCapabilities", "capabilities", "", "fromWifiConfiguration", "wifiConfiguration", "Landroid/net/wifi/WifiConfiguration;", "connectivity_release"})
    @SourceDebugExtension(value={"SMAP\nWifiSecurity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WifiSecurity.kt\ncom/stripe/core/connectivity/WifiSecurity$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n288#2,2:66\n*S KotlinDebug\n*F\n+ 1 WifiSecurity.kt\ncom/stripe/core/connectivity/WifiSecurity$Companion\n*L\n47#1:66,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WifiSecurity fromCapabilities(@NotNull String capabilities) {
            WifiSecurity wifiSecurity;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)capabilities, (String)"capabilities");
                Iterable $this$firstOrNull$iv = ORDERED_SECURITY_MODES;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    WifiSecurity it = (WifiSecurity)((Object)element$iv);
                    boolean bl = false;
                    if (!(it.getCode() != null && StringsKt.contains$default((CharSequence)capabilities, (CharSequence)it.getCode(), (boolean)false, (int)2, null))) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            if ((wifiSecurity = (WifiSecurity)v0) == null) {
                wifiSecurity = UNSUPPORTED;
            }
            return wifiSecurity;
        }

        @NotNull
        public final WifiSecurity fromWifiConfiguration(@NotNull WifiConfiguration wifiConfiguration) {
            Intrinsics.checkNotNullParameter((Object)wifiConfiguration, (String)"wifiConfiguration");
            return wifiConfiguration.allowedKeyManagement.get(1) ? (wifiConfiguration.allowedProtocols.get(1) ? WPA2 : WPA) : UNSUPPORTED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

