/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.SupplicantState;
import android.os.Handler;
import android.os.Looper;
import androidx.core.content.IntentCompat;
import com.stripe.core.connectivity.WifiAuthenticationResult;
import com.stripe.jvmcore.logging.terminal.log.Log;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0015\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0017R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/stripe/core/connectivity/WifiStateBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "isProcessing", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "authResult", "Lcom/stripe/core/connectivity/WifiAuthenticationResult;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Lkotlinx/coroutines/flow/MutableStateFlow;Lkotlinx/coroutines/flow/MutableStateFlow;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "handler", "Landroid/os/Handler;", "supplicantStates", "", "Landroid/net/wifi/SupplicantState;", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "onSupplicantState", "supplicantState", "onSupplicantState$connectivity_release", "Companion", "connectivity_release"})
public final class WifiStateBroadcastReceiver
extends BroadcastReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableStateFlow<Boolean> isProcessing;
    @NotNull
    private final MutableStateFlow<WifiAuthenticationResult> authResult;
    @NotNull
    private final Log logger;
    @NotNull
    private final List<SupplicantState> supplicantStates;
    @NotNull
    private final Handler handler;
    private static final long TIMEOUT_MILLIS = 7500L;

    public WifiStateBroadcastReceiver(@NotNull MutableStateFlow<Boolean> isProcessing, @NotNull MutableStateFlow<WifiAuthenticationResult> authResult, @NotNull Log logger2) {
        Intrinsics.checkNotNullParameter(isProcessing, (String)"isProcessing");
        Intrinsics.checkNotNullParameter(authResult, (String)"authResult");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.isProcessing = isProcessing;
        this.authResult = authResult;
        this.logger = logger2;
        this.supplicantStates = new ArrayList();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        block0: {
            SupplicantState supplicantState;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            SupplicantState supplicantState2 = supplicantState = (SupplicantState)IntentCompat.getParcelableExtra((Intent)intent, (String)"newState", SupplicantState.class);
            if (supplicantState2 == null) break block0;
            SupplicantState it = supplicantState2;
            boolean bl = false;
            this.onSupplicantState$connectivity_release(it);
            this.handler.removeCallbacksAndMessages(null);
            this.handler.postDelayed(() -> WifiStateBroadcastReceiver.onReceive$lambda$1$lambda$0(this), 7500L);
        }
    }

    public final void onSupplicantState$connectivity_release(@NotNull SupplicantState supplicantState) {
        Intrinsics.checkNotNullParameter((Object)supplicantState, (String)"supplicantState");
        boolean isDoneProcessing = false;
        this.logger.d("New Wifi Supplicant State: " + supplicantState, new Pair[0]);
        switch (WhenMappings.$EnumSwitchMapping$0[supplicantState.ordinal()]) {
            case 3: {
                WifiAuthenticationResult wifiAuthenticationResult;
                SupplicantState supplicantState2 = (SupplicantState)CollectionsKt.lastOrNull(this.supplicantStates);
                switch (supplicantState2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[supplicantState2.ordinal()]) {
                    case 1: {
                        isDoneProcessing = true;
                        WifiAuthenticationResult wifiAuthenticationResult2 = WifiAuthenticationResult.InvalidSsid;
                        break;
                    }
                    case 2: {
                        isDoneProcessing = true;
                        WifiAuthenticationResult wifiAuthenticationResult2 = WifiAuthenticationResult.InvalidPassword;
                        break;
                    }
                    default: {
                        WifiAuthenticationResult wifiAuthenticationResult2 = wifiAuthenticationResult = null;
                    }
                }
                if (wifiAuthenticationResult == null) break;
                WifiAuthenticationResult it = wifiAuthenticationResult;
                boolean bl = false;
                this.authResult.setValue((Object)it);
                break;
            }
            case 4: {
                isDoneProcessing = true;
                this.authResult.setValue((Object)WifiAuthenticationResult.Success);
                break;
            }
            default: {
                this.supplicantStates.add(supplicantState);
            }
        }
        if (isDoneProcessing) {
            this.supplicantStates.clear();
            this.isProcessing.setValue((Object)false);
        }
    }

    private static final void onReceive$lambda$1$lambda$0(WifiStateBroadcastReceiver this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.isProcessing.compareAndSet((Object)true, (Object)false)) {
            this$0.supplicantStates.clear();
            this$0.authResult.setValue((Object)WifiAuthenticationResult.UnknownError);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/connectivity/WifiStateBroadcastReceiver$Companion;", "", "()V", "TIMEOUT_MILLIS", "", "connectivity_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SupplicantState.values().length];
            try {
                nArray[SupplicantState.SCANNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SupplicantState.FOUR_WAY_HANDSHAKE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SupplicantState.DISCONNECTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SupplicantState.COMPLETED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

