/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.connectivity.dagger;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import com.stripe.core.connectivity.ArmadaNetworkConnectivityRepository;
import com.stripe.core.connectivity.ConnectivityLogger;
import com.stripe.core.connectivity.ConnectivityRepository;
import com.stripe.core.connectivity.ConnectivityStatus;
import com.stripe.core.connectivity.DefaultArmadaNetworkConnectivityRepository;
import com.stripe.core.connectivity.DefaultConnectivityRepository;
import com.stripe.core.connectivity.DefaultWifiConnectionRepository;
import com.stripe.core.connectivity.WifiConfigurationStore;
import com.stripe.core.connectivity.WifiConnectionRepository;
import com.stripe.core.connectivity.WifiManagerHelperKt;
import com.stripe.jvmcore.dagger.ForApplication;
import com.stripe.jvmcore.dagger.IO;
import com.stripe.jvmcore.dagger.IsNetworkAvailable;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.TraceLogger;
import dagger.Module;
import dagger.Provides;
import javax.inject.Provider;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J5\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bH\u0007J9\u0010\u001e\u001a\u00020\u001a2\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b#\u00a8\u0006$"}, d2={"Lcom/stripe/core/connectivity/dagger/ConnectivityModule;", "", "()V", "getLogger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "provideConnectivityLogger", "Lcom/stripe/core/connectivity/ConnectivityLogger;", "connectivityRepository", "Lcom/stripe/core/connectivity/ConnectivityRepository;", "wifiConnectConfigurationStore", "Lcom/stripe/core/connectivity/WifiConfigurationStore;", "traceLogger", "Lcom/stripe/jvmcore/loggingmodels/TraceLogger;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "provideNetworkConnectivityRepository", "Lcom/stripe/core/connectivity/ArmadaNetworkConnectivityRepository;", "okHttpClient", "Lokhttp3/OkHttpClient;", "providesConnectivityRepository", "connectivityManager", "Landroid/net/ConnectivityManager;", "wifiManager", "Landroid/net/wifi/WifiManager;", "wifiConnectionRepositoryProvider", "Ljavax/inject/Provider;", "Lcom/stripe/core/connectivity/WifiConnectionRepository;", "providesConnectivityRepository$connectivity_release", "providesIsNetworkAvailable", "", "providesWifiConnectionRepository", "context", "Landroid/content/Context;", "wifiConfigurationStore", "connectivityLogger", "providesWifiConnectionRepository$connectivity_release", "connectivity_release"})
public final class ConnectivityModule {
    @NotNull
    public static final ConnectivityModule INSTANCE = new ConnectivityModule();

    private ConnectivityModule() {
    }

    @Provides
    @Singleton
    @NotNull
    public final ConnectivityRepository providesConnectivityRepository$connectivity_release(@NotNull ConnectivityManager connectivityManager, @NotNull WifiManager wifiManager, @NotNull Provider<WifiConnectionRepository> wifiConnectionRepositoryProvider, @IO @NotNull CoroutineDispatcher coroutineDispatcher) {
        Intrinsics.checkNotNullParameter((Object)connectivityManager, (String)"connectivityManager");
        Intrinsics.checkNotNullParameter((Object)wifiManager, (String)"wifiManager");
        Intrinsics.checkNotNullParameter(wifiConnectionRepositoryProvider, (String)"wifiConnectionRepositoryProvider");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        return new DefaultConnectivityRepository(connectivityManager, wifiManager, wifiConnectionRepositoryProvider, coroutineDispatcher, this.getLogger());
    }

    @Provides
    @Singleton
    @NotNull
    public final WifiConnectionRepository providesWifiConnectionRepository$connectivity_release(@ForApplication @NotNull Context context, @NotNull WifiManager wifiManager, @NotNull WifiConfigurationStore wifiConfigurationStore, @IO @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull ConnectivityLogger connectivityLogger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)wifiManager, (String)"wifiManager");
        Intrinsics.checkNotNullParameter((Object)wifiConfigurationStore, (String)"wifiConfigurationStore");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)connectivityLogger, (String)"connectivityLogger");
        return new DefaultWifiConnectionRepository(context, wifiManager, wifiConfigurationStore, coroutineDispatcher, WifiManagerHelperKt.getSignalStrengthConvertor(), this.getLogger(), connectivityLogger);
    }

    @Provides
    @IsNetworkAvailable
    public final boolean providesIsNetworkAvailable(@NotNull ConnectivityRepository connectivityRepository) {
        Intrinsics.checkNotNullParameter((Object)connectivityRepository, (String)"connectivityRepository");
        return connectivityRepository.getGeneralConnectivityStatusFlow().getValue() == ConnectivityStatus.AVAILABLE;
    }

    @Provides
    @Singleton
    @NotNull
    public final ConnectivityLogger provideConnectivityLogger(@NotNull ConnectivityRepository connectivityRepository, @NotNull WifiConfigurationStore wifiConnectConfigurationStore, @NotNull TraceLogger traceLogger, @IO @NotNull CoroutineDispatcher coroutineDispatcher) {
        Intrinsics.checkNotNullParameter((Object)connectivityRepository, (String)"connectivityRepository");
        Intrinsics.checkNotNullParameter((Object)wifiConnectConfigurationStore, (String)"wifiConnectConfigurationStore");
        Intrinsics.checkNotNullParameter((Object)traceLogger, (String)"traceLogger");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        return new ConnectivityLogger(connectivityRepository, wifiConnectConfigurationStore, traceLogger, coroutineDispatcher);
    }

    @Provides
    @Singleton
    @NotNull
    public final ArmadaNetworkConnectivityRepository provideNetworkConnectivityRepository(@NotNull ConnectivityRepository connectivityRepository, @NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)connectivityRepository, (String)"connectivityRepository");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        return new DefaultArmadaNetworkConnectivityRepository(connectivityRepository, okHttpClient);
    }

    private final Log getLogger() {
        return Log.Companion.getLogger(DefaultConnectivityRepository.class);
    }
}

