/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.dagger.modules;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import com.stripe.jvmcore.dagger.ForApplication;
import com.stripe.jvmcore.dagger.PackageName;
import dagger.Module;
import dagger.Provides;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0007J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/core/dagger/modules/ApplicationModule;", "", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "provideApplication", "provideContentResolver", "Landroid/content/ContentResolver;", "provideContext", "Landroid/content/Context;", "provideFilesDirectory", "Ljava/io/File;", "providePackageName", "", "dagger_release"})
public final class ApplicationModule {
    @NotNull
    private final Application application;

    public ApplicationModule(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.application = application;
    }

    @Provides
    @NotNull
    public final Application provideApplication() {
        return this.application;
    }

    @Provides
    @ForApplication
    @NotNull
    public final Context provideContext() {
        Context context = this.application.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"application.applicationContext");
        return context;
    }

    @Provides
    @PackageName
    @NotNull
    public final String providePackageName() {
        String string = this.application.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"application.packageName");
        return string;
    }

    @Provides
    @NotNull
    public final ContentResolver provideContentResolver() {
        ContentResolver contentResolver = this.application.getContentResolver();
        Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"application.contentResolver");
        return contentResolver;
    }

    @Provides
    @ForApplication
    @NotNull
    public final File provideFilesDirectory() {
        File file = this.application.getFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"application.filesDir");
        return file;
    }
}

