/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.device;

import com.stripe.core.connectivity.ConnectivityRepository;
import com.stripe.core.device.ApiDeviceInfo;
import com.stripe.jvmcore.device.DeviceInfoRepository;
import com.stripe.proto.model.common.DeviceInfo;
import com.stripe.proto.model.common.HardwareModel;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/core/device/ApiDeviceInfoProvider;", "", "connectivityRepository", "Lcom/stripe/core/connectivity/ConnectivityRepository;", "deviceInfoRepository", "Lcom/stripe/jvmcore/device/DeviceInfoRepository;", "platformDeviceInfoDecorator", "Lcom/stripe/core/device/ApiDeviceInfoProvider$PlatformDeviceInfoDecorator;", "(Lcom/stripe/core/connectivity/ConnectivityRepository;Lcom/stripe/jvmcore/device/DeviceInfoRepository;Lcom/stripe/core/device/ApiDeviceInfoProvider$PlatformDeviceInfoDecorator;)V", "getDeviceInfo", "Lcom/stripe/core/device/ApiDeviceInfo;", "PlatformDeviceInfoDecorator", "device_release"})
public final class ApiDeviceInfoProvider {
    @NotNull
    private final ConnectivityRepository connectivityRepository;
    @NotNull
    private final DeviceInfoRepository deviceInfoRepository;
    @NotNull
    private final PlatformDeviceInfoDecorator platformDeviceInfoDecorator;

    @Inject
    public ApiDeviceInfoProvider(@NotNull ConnectivityRepository connectivityRepository, @NotNull DeviceInfoRepository deviceInfoRepository, @NotNull PlatformDeviceInfoDecorator platformDeviceInfoDecorator) {
        Intrinsics.checkNotNullParameter((Object)connectivityRepository, (String)"connectivityRepository");
        Intrinsics.checkNotNullParameter((Object)deviceInfoRepository, (String)"deviceInfoRepository");
        Intrinsics.checkNotNullParameter((Object)platformDeviceInfoDecorator, (String)"platformDeviceInfoDecorator");
        this.connectivityRepository = connectivityRepository;
        this.deviceInfoRepository = deviceInfoRepository;
        this.platformDeviceInfoDecorator = platformDeviceInfoDecorator;
    }

    @NotNull
    public final ApiDeviceInfo getDeviceInfo() {
        DeviceInfo.DeviceClass deviceClass = DeviceInfo.DeviceClass.READER;
        String string = this.deviceInfoRepository.getSerialNumber();
        HardwareModel hardwareModel = this.deviceInfoRepository.getHardwareModel();
        String string2 = this.deviceInfoRepository.getHardwareVersion();
        String string3 = this.deviceInfoRepository.getSoftwareVersion();
        String string4 = ConnectivityRepository.getIpAddress$default(this.connectivityRepository, null, 1, null);
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string4;
        DeviceInfo it = new DeviceInfo(deviceClass, string, hardwareModel, null, string5, string2, string3, null, null, null, null, null, null, null, null, null, 65416, null);
        boolean bl = false;
        DeviceInfo plymouthDeviceInfo = this.platformDeviceInfoDecorator.decorate(it);
        return new ApiDeviceInfo(plymouthDeviceInfo, this.deviceInfoRepository.getMainlandDeviceType());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001:\u0001\u0005J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/stripe/core/device/ApiDeviceInfoProvider$PlatformDeviceInfoDecorator;", "", "decorate", "Lcom/stripe/proto/model/common/DeviceInfo;", "deviceInfo", "NoOp", "device_release"})
    public static interface PlatformDeviceInfoDecorator {
        @NotNull
        public DeviceInfo decorate(@NotNull DeviceInfo var1);

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/core/device/ApiDeviceInfoProvider$PlatformDeviceInfoDecorator$NoOp;", "Lcom/stripe/core/device/ApiDeviceInfoProvider$PlatformDeviceInfoDecorator;", "()V", "decorate", "Lcom/stripe/proto/model/common/DeviceInfo;", "deviceInfo", "device_release"})
        public static final class NoOp
        implements PlatformDeviceInfoDecorator {
            @NotNull
            public static final NoOp INSTANCE = new NoOp();

            private NoOp() {
            }

            @Override
            @NotNull
            public DeviceInfo decorate(@NotNull DeviceInfo deviceInfo) {
                Intrinsics.checkNotNullParameter((Object)((Object)deviceInfo), (String)"deviceInfo");
                return deviceInfo;
            }
        }
    }
}

