/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.device;

import android.os.Build;
import com.stripe.core.device.BuildValues;
import com.stripe.core.device.BuildValuesFactory;
import com.stripe.core.device.DefaultBuildValuesFactory;
import com.stripe.core.device.OsType;
import com.stripe.core.device.SerialSupplier;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00062\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/core/device/DefaultBuildValuesFactory;", "Lcom/stripe/core/device/BuildValuesFactory;", "serialSupplier", "Lcom/stripe/core/device/SerialSupplier;", "(Lcom/stripe/core/device/SerialSupplier;)V", "brand", "", "device", "fingerprint", "manufacturer", "model", "product", "create", "Lcom/stripe/core/device/BuildValues;", "getBuildValue", "supplier", "Lkotlin/Function0;", "getOsType", "Lcom/stripe/core/device/OsType;", "isEmulator", "", "device_release"})
public final class DefaultBuildValuesFactory
implements BuildValuesFactory {
    @NotNull
    private final SerialSupplier serialSupplier;
    @NotNull
    private final String brand;
    @NotNull
    private final String device;
    @NotNull
    private final String fingerprint;
    @NotNull
    private final String manufacturer;
    @NotNull
    private final String model;
    @NotNull
    private final String product;

    public DefaultBuildValuesFactory(@NotNull SerialSupplier serialSupplier) {
        Intrinsics.checkNotNullParameter((Object)serialSupplier, (String)"serialSupplier");
        this.serialSupplier = serialSupplier;
        this.brand = this.getBuildValue((Function0<String>)((Function0)brand.1.INSTANCE));
        this.device = this.getBuildValue((Function0<String>)((Function0)device.1.INSTANCE));
        this.fingerprint = this.getBuildValue((Function0<String>)((Function0)fingerprint.1.INSTANCE));
        this.manufacturer = this.getBuildValue((Function0<String>)((Function0)manufacturer.1.INSTANCE));
        this.model = this.getBuildValue((Function0<String>)((Function0)model.1.INSTANCE));
        this.product = this.getBuildValue((Function0<String>)((Function0)product.1.INSTANCE));
    }

    @Override
    @NotNull
    public BuildValues create() {
        String baseOs2 = Build.VERSION.SDK_INT >= 23 ? this.getBuildValue((Function0<String>)((Function0)create.baseOs.1.INSTANCE)) : "";
        boolean isEmulator = this.isEmulator();
        String string = this.brand;
        String string2 = this.device;
        String string3 = this.fingerprint;
        String string4 = this.getBuildValue((Function0<String>)((Function0)create.1.INSTANCE));
        BuildValues.HardwareManufacturer hardwareManufacturer = BuildValues.HardwareManufacturer.Companion.fromValue$device_release(this.manufacturer);
        String string5 = this.model;
        String string6 = this.product;
        int n2 = Build.VERSION.SDK_INT;
        OsType osType = this.getOsType();
        String string7 = this.serialSupplier.get-E8XB-7w(isEmulator);
        return new BuildValues(string, string2, string3, string4, hardwareManufacturer, string5, string6, baseOs2, osType, n2, string7, isEmulator, null);
    }

    private final boolean isEmulator() {
        return StringsKt.startsWith$default((String)this.brand, (String)"generic", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)this.device, (String)"generic", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.fingerprint, (String)"generic", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.fingerprint, (String)"unknown", (boolean)false, (int)2, null) || StringsKt.contains((CharSequence)this.model, (CharSequence)"sdk", (boolean)true) || StringsKt.contains$default((CharSequence)this.model, (CharSequence)"Emulator", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)this.manufacturer, (CharSequence)"Genymotion", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)this.product, (CharSequence)"sdk", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)this.product, (CharSequence)"emulator", (boolean)false, (int)2, null);
    }

    private final OsType getOsType() {
        String osTypeValue2 = this.getBuildValue((Function0<String>)((Function0)getOsType.osTypeValue.1.INSTANCE));
        return Intrinsics.areEqual((Object)osTypeValue2, (Object)OsType.User.INSTANCE.getValue()) ? (OsType)OsType.User.INSTANCE : (Intrinsics.areEqual((Object)osTypeValue2, (Object)OsType.UserDebug.INSTANCE.getValue()) ? (OsType)OsType.UserDebug.INSTANCE : (Intrinsics.areEqual((Object)osTypeValue2, (Object)OsType.Eng.INSTANCE.getValue()) ? (OsType)OsType.Eng.INSTANCE : (OsType)new OsType.Other(osTypeValue2)));
    }

    private final String getBuildValue(Function0<String> supplier) {
        Object object;
        try {
            object = Result.constructor-impl((Object)supplier.invoke());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = null;
        String string = (String)(Result.isFailure-impl((Object)object) ? object2 : object);
        if (string == null) {
            string = "";
        }
        return string;
    }
}

