/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.device;

import com.stripe.core.device.BuildValues;
import com.stripe.core.device.ClientDeviceType;
import com.stripe.core.device.ClientDeviceTypeParser;
import com.stripe.core.serialnumber.DeviceSerialNumber;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.serialnumber.SmartPOSDeviceMetadata;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0016J\u001d\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/stripe/core/device/DefaultClientDeviceTypeParser;", "Lcom/stripe/core/device/ClientDeviceTypeParser;", "buildValues", "Lcom/stripe/core/device/BuildValues;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Lcom/stripe/core/device/BuildValues;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "clientDeviceType", "Lcom/stripe/core/device/ClientDeviceType;", "determineClientDeviceType", "get", "getBbposClientDeviceType", "serialNumber", "Lcom/stripe/core/serialnumber/DeviceSerialNumber;", "getBbposClientDeviceType-wDMJIJk", "(Ljava/lang/String;)Lcom/stripe/core/device/ClientDeviceType;", "device_release"})
public final class DefaultClientDeviceTypeParser
implements ClientDeviceTypeParser {
    @NotNull
    private final BuildValues buildValues;
    @NotNull
    private final Log logger;
    @NotNull
    private final ClientDeviceType clientDeviceType;

    public DefaultClientDeviceTypeParser(@NotNull BuildValues buildValues, @NotNull Log logger2) {
        Intrinsics.checkNotNullParameter((Object)buildValues, (String)"buildValues");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.buildValues = buildValues;
        this.logger = logger2;
        this.clientDeviceType = this.determineClientDeviceType();
    }

    @Override
    @NotNull
    public ClientDeviceType get() {
        return this.clientDeviceType;
    }

    private final ClientDeviceType determineClientDeviceType() {
        ClientDeviceType clientDeviceType;
        ClientDeviceType it = clientDeviceType = Intrinsics.areEqual((Object)this.buildValues.getManufacturer(), (Object)BuildValues.HardwareManufacturer.Sunmi.INSTANCE) ? (ClientDeviceType)ClientDeviceType.SunmiWhistler.INSTANCE : (this.buildValues.isEmulator() ? (ClientDeviceType)ClientDeviceType.Emulator.INSTANCE : (Intrinsics.areEqual((Object)this.buildValues.getManufacturer(), (Object)BuildValues.HardwareManufacturer.Bbpos.INSTANCE) ? this.getBbposClientDeviceType-wDMJIJk(this.buildValues.getSerial-q_5ZKBc()) : (ClientDeviceType)ClientDeviceType.Unknown.INSTANCE));
        boolean bl = false;
        this.logger.i("ClientDeviceType = " + it, new Pair[0]);
        return clientDeviceType;
    }

    private final ClientDeviceType getBbposClientDeviceType-wDMJIJk(String serialNumber) {
        ClientDeviceType clientDeviceType;
        switch (WhenMappings.$EnumSwitchMapping$0[DeviceSerialNumber.Companion.toDeviceMetadata-wDMJIJk(serialNumber).ordinal()]) {
            case 1: {
                clientDeviceType = new ClientDeviceType.WisePosE(true);
                break;
            }
            case 2: {
                clientDeviceType = new ClientDeviceType.WisePosE(false);
                break;
            }
            case 3: {
                clientDeviceType = new ClientDeviceType.S700(true);
                break;
            }
            case 4: {
                clientDeviceType = new ClientDeviceType.S700(false);
                break;
            }
            case 5: {
                clientDeviceType = ClientDeviceType.Etna.INSTANCE;
                break;
            }
            case 6: {
                this.logger.e("Failed to get ClientDeviceType from serial number \"" + serialNumber + "\" on a BBPOS device.", new Pair[0]);
                clientDeviceType = ClientDeviceType.Unknown.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return clientDeviceType;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SmartPOSDeviceMetadata.values().length];
            try {
                nArray[SmartPOSDeviceMetadata.WisePosEDevKit.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartPOSDeviceMetadata.WisePosE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartPOSDeviceMetadata.S700DevKit.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartPOSDeviceMetadata.S700.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartPOSDeviceMetadata.Etna.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartPOSDeviceMetadata.UnknownDevice.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

