/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.hardware;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.hardware.usb.UsbDevice;
import com.stripe.jvmcore.hardware.emv.CheckForCardBehavior;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B9\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u0082\u0001\u0003\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/stripe/core/hardware/Reader;", "", "firmwareCanHandleSelection", "", "checkForCardBehavior", "Lcom/stripe/jvmcore/hardware/emv/CheckForCardBehavior;", "needsOtaUpdate", "needsReconnectAfterConfigUpdate", "needsSplashScreenUpdate", "quickEmvAutoResponse", "(ZLcom/stripe/jvmcore/hardware/emv/CheckForCardBehavior;ZZZZ)V", "getCheckForCardBehavior", "()Lcom/stripe/jvmcore/hardware/emv/CheckForCardBehavior;", "getFirmwareCanHandleSelection", "()Z", "getNeedsOtaUpdate", "getNeedsReconnectAfterConfigUpdate", "getNeedsSplashScreenUpdate", "getQuickEmvAutoResponse", "BluetoothReader", "SerialReader", "UsbReader", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "Lcom/stripe/core/hardware/Reader$SerialReader;", "Lcom/stripe/core/hardware/Reader$UsbReader;", "hardware_release"})
public abstract class Reader {
    private final boolean firmwareCanHandleSelection;
    @NotNull
    private final CheckForCardBehavior checkForCardBehavior;
    private final boolean needsOtaUpdate;
    private final boolean needsReconnectAfterConfigUpdate;
    private final boolean needsSplashScreenUpdate;
    private final boolean quickEmvAutoResponse;

    private Reader(boolean firmwareCanHandleSelection, CheckForCardBehavior checkForCardBehavior, boolean needsOtaUpdate, boolean needsReconnectAfterConfigUpdate, boolean needsSplashScreenUpdate, boolean quickEmvAutoResponse) {
        this.firmwareCanHandleSelection = firmwareCanHandleSelection;
        this.checkForCardBehavior = checkForCardBehavior;
        this.needsOtaUpdate = needsOtaUpdate;
        this.needsReconnectAfterConfigUpdate = needsReconnectAfterConfigUpdate;
        this.needsSplashScreenUpdate = needsSplashScreenUpdate;
        this.quickEmvAutoResponse = quickEmvAutoResponse;
    }

    public /* synthetic */ Reader(boolean bl, CheckForCardBehavior checkForCardBehavior, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            bl5 = true;
        }
        this(bl, checkForCardBehavior, bl2, bl3, bl4, bl5, null);
    }

    public final boolean getFirmwareCanHandleSelection() {
        return this.firmwareCanHandleSelection;
    }

    @NotNull
    public final CheckForCardBehavior getCheckForCardBehavior() {
        return this.checkForCardBehavior;
    }

    public final boolean getNeedsOtaUpdate() {
        return this.needsOtaUpdate;
    }

    public final boolean getNeedsReconnectAfterConfigUpdate() {
        return this.needsReconnectAfterConfigUpdate;
    }

    public final boolean getNeedsSplashScreenUpdate() {
        return this.needsSplashScreenUpdate;
    }

    public final boolean getQuickEmvAutoResponse() {
        return this.quickEmvAutoResponse;
    }

    public /* synthetic */ Reader(boolean firmwareCanHandleSelection, CheckForCardBehavior checkForCardBehavior, boolean needsOtaUpdate, boolean needsReconnectAfterConfigUpdate, boolean needsSplashScreenUpdate, boolean quickEmvAutoResponse, DefaultConstructorMarker $constructor_marker) {
        this(firmwareCanHandleSelection, checkForCardBehavior, needsOtaUpdate, needsReconnectAfterConfigUpdate, needsSplashScreenUpdate, quickEmvAutoResponse);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00112\u00020\u0001:\u0006\u000f\u0010\u0011\u0012\u0013\u0014BA\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0005\u0015\u0016\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader;", "Lcom/stripe/core/hardware/Reader;", "device", "Landroid/bluetooth/BluetoothDevice;", "firmwareCanHandleSelection", "", "checkForCardBehavior", "Lcom/stripe/jvmcore/hardware/emv/CheckForCardBehavior;", "needsOtaUpdate", "needsReconnectAfterConfigUpdate", "needsSplashScreenUpdate", "quickEmvAutoResponse", "(Landroid/bluetooth/BluetoothDevice;ZLcom/stripe/jvmcore/hardware/emv/CheckForCardBehavior;ZZZZ)V", "getDevice", "()Landroid/bluetooth/BluetoothDevice;", "Chipper1xReader", "Chipper2xReader", "Companion", "StripeM2Reader", "WisecubeReader", "Wisepad3Reader", "Lcom/stripe/core/hardware/Reader$BluetoothReader$Chipper1xReader;", "Lcom/stripe/core/hardware/Reader$BluetoothReader$Chipper2xReader;", "Lcom/stripe/core/hardware/Reader$BluetoothReader$StripeM2Reader;", "Lcom/stripe/core/hardware/Reader$BluetoothReader$WisecubeReader;", "Lcom/stripe/core/hardware/Reader$BluetoothReader$Wisepad3Reader;", "hardware_release"})
    public static abstract class BluetoothReader
    extends Reader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final BluetoothDevice device;

        private BluetoothReader(BluetoothDevice device2, boolean firmwareCanHandleSelection, CheckForCardBehavior checkForCardBehavior, boolean needsOtaUpdate, boolean needsReconnectAfterConfigUpdate, boolean needsSplashScreenUpdate, boolean quickEmvAutoResponse) {
            super(firmwareCanHandleSelection, checkForCardBehavior, needsOtaUpdate, needsReconnectAfterConfigUpdate, needsSplashScreenUpdate, quickEmvAutoResponse, null);
            this.device = device2;
        }

        public /* synthetic */ BluetoothReader(BluetoothDevice bluetoothDevice, boolean bl, CheckForCardBehavior checkForCardBehavior, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x40) != 0) {
                bl5 = true;
            }
            this(bluetoothDevice, bl, checkForCardBehavior, bl2, bl3, bl4, bl5, null);
        }

        @NotNull
        public final BluetoothDevice getDevice() {
            return this.device;
        }

        public /* synthetic */ BluetoothReader(BluetoothDevice device2, boolean firmwareCanHandleSelection, CheckForCardBehavior checkForCardBehavior, boolean needsOtaUpdate, boolean needsReconnectAfterConfigUpdate, boolean needsSplashScreenUpdate, boolean quickEmvAutoResponse, DefaultConstructorMarker $constructor_marker) {
            this(device2, firmwareCanHandleSelection, checkForCardBehavior, needsOtaUpdate, needsReconnectAfterConfigUpdate, needsSplashScreenUpdate, quickEmvAutoResponse);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$Chipper1xReader;", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "device", "Landroid/bluetooth/BluetoothDevice;", "(Landroid/bluetooth/BluetoothDevice;)V", "Companion", "hardware_release"})
        public static final class Chipper1xReader
        extends BluetoothReader {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final List<String> namePrefixes;

            public Chipper1xReader(@NotNull BluetoothDevice device2) {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                super(device2, false, CheckForCardBehavior.DO_NOT_POLL, true, false, false, false, 64, null);
            }

            static {
                Object[] objectArray = new String[]{"Shopi", "CHB1"};
                namePrefixes = CollectionsKt.listOf((Object[])objectArray);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$Chipper1xReader$Companion;", "", "()V", "namePrefixes", "", "", "getNamePrefixes", "()Ljava/util/List;", "hardware_release"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final List<String> getNamePrefixes() {
                    return namePrefixes;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$Chipper2xReader;", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "device", "Landroid/bluetooth/BluetoothDevice;", "(Landroid/bluetooth/BluetoothDevice;)V", "Companion", "hardware_release"})
        public static final class Chipper2xReader
        extends BluetoothReader {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final List<String> namePrefixes;

            public Chipper2xReader(@NotNull BluetoothDevice device2) {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                super(device2, false, CheckForCardBehavior.DO_NOT_POLL, true, false, false, false, 64, null);
            }

            static {
                Object[] objectArray = new String[]{"CHB20", "CHB22"};
                namePrefixes = CollectionsKt.listOf((Object[])objectArray);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$Chipper2xReader$Companion;", "", "()V", "namePrefixes", "", "", "getNamePrefixes", "()Ljava/util/List;", "hardware_release"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final List<String> getNamePrefixes() {
                    return namePrefixes;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$Companion;", "", "()V", "bondStateFromDevice", "", "bluetoothDevice", "Landroid/bluetooth/BluetoothDevice;", "createBondWithDevice", "", "fromBluetoothDevice", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "device", "fromBluetoothDeviceOrNull", "nameFromAdapter", "", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "nameFromDevice", "hardware_release"})
        @SourceDebugExtension(value={"SMAP\nReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reader.kt\ncom/stripe/core/hardware/Reader$BluetoothReader$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,390:1\n1747#2,3:391\n1747#2,3:394\n1747#2,3:397\n1747#2,3:400\n1747#2,3:403\n*S KotlinDebug\n*F\n+ 1 Reader.kt\ncom/stripe/core/hardware/Reader$BluetoothReader$Companion\n*L\n166#1:391,3\n169#1:394,3\n172#1:397,3\n175#1:400,3\n178#1:403,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BluetoothReader fromBluetoothDevice(@NotNull BluetoothDevice device2) {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                BluetoothReader bluetoothReader = this.fromBluetoothDeviceOrNull(device2);
                if (bluetoothReader == null) {
                    bluetoothReader = new Chipper2xReader(device2);
                }
                return bluetoothReader;
            }

            @Nullable
            public final BluetoothReader fromBluetoothDeviceOrNull(@Nullable BluetoothDevice device2) {
                BluetoothReader bluetoothReader;
                BluetoothDevice bluetoothDevice = device2;
                if (bluetoothDevice != null) {
                    BluetoothDevice bluetoothDevice2 = bluetoothDevice;
                    boolean bl = false;
                    String string = Companion.nameFromDevice(bluetoothDevice2);
                    if (string != null) {
                        String it;
                        boolean bl2;
                        boolean $i$f$any;
                        Iterable $this$any$iv;
                        String name;
                        block27: {
                            name = string;
                            boolean bl3 = false;
                            $this$any$iv = Chipper1xReader.Companion.getNamePrefixes();
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it = (String)element$iv;
                                    boolean bl4 = false;
                                    if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                                    bl2 = true;
                                    break block27;
                                }
                                bl2 = false;
                            }
                        }
                        if (bl2) {
                            bluetoothReader = new Chipper1xReader(bluetoothDevice2);
                        } else {
                            boolean bl5;
                            block28: {
                                $this$any$iv = Chipper2xReader.Companion.getNamePrefixes();
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl5 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        it = (String)element$iv;
                                        boolean bl6 = false;
                                        if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                                        bl5 = true;
                                        break block28;
                                    }
                                    bl5 = false;
                                }
                            }
                            if (bl5) {
                                bluetoothReader = new Chipper2xReader(bluetoothDevice2);
                            } else {
                                boolean bl7;
                                block29: {
                                    $this$any$iv = StripeM2Reader.Companion.getNamePrefixes();
                                    $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl7 = false;
                                    } else {
                                        for (Object element$iv : $this$any$iv) {
                                            it = (String)element$iv;
                                            boolean bl8 = false;
                                            if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                                            bl7 = true;
                                            break block29;
                                        }
                                        bl7 = false;
                                    }
                                }
                                if (bl7) {
                                    bluetoothReader = new StripeM2Reader(bluetoothDevice2);
                                } else {
                                    boolean bl9;
                                    block30: {
                                        $this$any$iv = WisecubeReader.Companion.getNamePrefixes();
                                        $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            bl9 = false;
                                        } else {
                                            for (Object element$iv : $this$any$iv) {
                                                it = (String)element$iv;
                                                boolean bl10 = false;
                                                if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                                                bl9 = true;
                                                break block30;
                                            }
                                            bl9 = false;
                                        }
                                    }
                                    if (bl9) {
                                        bluetoothReader = new WisecubeReader(bluetoothDevice2);
                                    } else {
                                        boolean bl11;
                                        block31: {
                                            $this$any$iv = Wisepad3Reader.Companion.getNamePrefixes();
                                            $i$f$any = false;
                                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                bl11 = false;
                                            } else {
                                                for (Object element$iv : $this$any$iv) {
                                                    it = (String)element$iv;
                                                    boolean bl12 = false;
                                                    if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                                                    bl11 = true;
                                                    break block31;
                                                }
                                                bl11 = false;
                                            }
                                        }
                                        bluetoothReader = bl11 ? (BluetoothReader)new Wisepad3Reader(bluetoothDevice2) : null;
                                    }
                                }
                            }
                        }
                    } else {
                        bluetoothReader = null;
                    }
                } else {
                    bluetoothReader = null;
                }
                return bluetoothReader;
            }

            @SuppressLint(value={"MissingPermission"})
            @Nullable
            public final String nameFromDevice(@NotNull BluetoothDevice bluetoothDevice) {
                Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"bluetoothDevice");
                return bluetoothDevice.getName();
            }

            @SuppressLint(value={"MissingPermission"})
            @Nullable
            public final String nameFromAdapter(@NotNull BluetoothAdapter bluetoothAdapter) {
                Intrinsics.checkNotNullParameter((Object)bluetoothAdapter, (String)"bluetoothAdapter");
                return bluetoothAdapter.getName();
            }

            @SuppressLint(value={"MissingPermission"})
            public final int bondStateFromDevice(@NotNull BluetoothDevice bluetoothDevice) {
                Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"bluetoothDevice");
                return bluetoothDevice.getBondState();
            }

            @SuppressLint(value={"MissingPermission"})
            public final boolean createBondWithDevice(@NotNull BluetoothDevice bluetoothDevice) {
                Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"bluetoothDevice");
                return bluetoothDevice.createBond();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$StripeM2Reader;", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "device", "Landroid/bluetooth/BluetoothDevice;", "(Landroid/bluetooth/BluetoothDevice;)V", "Companion", "hardware_release"})
        public static final class StripeM2Reader
        extends BluetoothReader {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final List<String> namePrefixes;

            public StripeM2Reader(@NotNull BluetoothDevice device2) {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                super(device2, false, CheckForCardBehavior.DO_NOT_POLL, false, false, false, false, 64, null);
            }

            static {
                Object[] objectArray = new String[]{"CHB30", "CHB31", "STRM2", "Stripe M2"};
                namePrefixes = CollectionsKt.listOf((Object[])objectArray);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$StripeM2Reader$Companion;", "", "()V", "namePrefixes", "", "", "getNamePrefixes", "()Ljava/util/List;", "hardware_release"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final List<String> getNamePrefixes() {
                    return namePrefixes;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$WisecubeReader;", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "device", "Landroid/bluetooth/BluetoothDevice;", "(Landroid/bluetooth/BluetoothDevice;)V", "Companion", "hardware_release"})
        public static final class WisecubeReader
        extends BluetoothReader {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final List<String> namePrefixes;

            public WisecubeReader(@NotNull BluetoothDevice device2) {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                super(device2, false, CheckForCardBehavior.DO_NOT_POLL, true, false, false, false, null);
            }

            static {
                Object[] objectArray = new String[]{"Tap &", "CHB6"};
                namePrefixes = CollectionsKt.listOf((Object[])objectArray);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$WisecubeReader$Companion;", "", "()V", "namePrefixes", "", "", "getNamePrefixes", "()Ljava/util/List;", "hardware_release"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final List<String> getNamePrefixes() {
                    return namePrefixes;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$Wisepad3Reader;", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "device", "Landroid/bluetooth/BluetoothDevice;", "(Landroid/bluetooth/BluetoothDevice;)V", "Companion", "hardware_release"})
        public static final class Wisepad3Reader
        extends BluetoothReader {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final List<String> namePrefixes = CollectionsKt.listOf((Object)"WPC3");

            public Wisepad3Reader(@NotNull BluetoothDevice device2) {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                super(device2, true, CheckForCardBehavior.DO_NOT_POLL, false, false, true, false, 64, null);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/core/hardware/Reader$BluetoothReader$Wisepad3Reader$Companion;", "", "()V", "namePrefixes", "", "", "getNamePrefixes", "()Ljava/util/List;", "hardware_release"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final List<String> getNamePrefixes() {
                    return namePrefixes;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/core/hardware/Reader$SerialReader;", "Lcom/stripe/core/hardware/Reader;", "()V", "hardware_release"})
    public static final class SerialReader
    extends Reader {
        @NotNull
        public static final SerialReader INSTANCE = new SerialReader();

        private SerialReader() {
            super(false, CheckForCardBehavior.POLL_FOR_CARD_REMOVAL, false, true, false, false, 32, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00152\u00020\u0001:\u0007\u0014\u0015\u0016\u0017\u0018\u0019\u001aBE\b\u0004\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0006\u001b\u001c\u001d\u001e\u001f \u00a8\u0006!"}, d2={"Lcom/stripe/core/hardware/Reader$UsbReader;", "Lcom/stripe/core/hardware/Reader;", "device", "Landroid/hardware/usb/UsbDevice;", "firmwareCanHandleSelection", "", "checkForCardBehavior", "Lcom/stripe/jvmcore/hardware/emv/CheckForCardBehavior;", "needsOtaUpdate", "needsReconnectAfterConfigUpdate", "needsSplashScreenUpdate", "quickEmvAutoResponse", "(Landroid/hardware/usb/UsbDevice;ZLcom/stripe/jvmcore/hardware/emv/CheckForCardBehavior;ZZZZ)V", "getDevice", "()Landroid/hardware/usb/UsbDevice;", "equals", "other", "", "hashCode", "", "Chipper2xReader", "Companion", "StripeM2Reader", "UnspecifiedUsbReader", "WisecubeReader", "Wisepad3Reader", "Wisepad3SReader", "Lcom/stripe/core/hardware/Reader$UsbReader$Chipper2xReader;", "Lcom/stripe/core/hardware/Reader$UsbReader$StripeM2Reader;", "Lcom/stripe/core/hardware/Reader$UsbReader$UnspecifiedUsbReader;", "Lcom/stripe/core/hardware/Reader$UsbReader$WisecubeReader;", "Lcom/stripe/core/hardware/Reader$UsbReader$Wisepad3Reader;", "Lcom/stripe/core/hardware/Reader$UsbReader$Wisepad3SReader;", "hardware_release"})
    public static abstract class UsbReader
    extends Reader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final UsbDevice device;

        private UsbReader(UsbDevice device2, boolean firmwareCanHandleSelection, CheckForCardBehavior checkForCardBehavior, boolean needsOtaUpdate, boolean needsReconnectAfterConfigUpdate, boolean needsSplashScreenUpdate, boolean quickEmvAutoResponse) {
            super(firmwareCanHandleSelection, checkForCardBehavior, needsOtaUpdate, needsReconnectAfterConfigUpdate, needsSplashScreenUpdate, quickEmvAutoResponse, null);
            this.device = device2;
        }

        public /* synthetic */ UsbReader(UsbDevice usbDevice, boolean bl, CheckForCardBehavior checkForCardBehavior, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                usbDevice = null;
            }
            if ((n2 & 0x40) != 0) {
                bl5 = true;
            }
            this(usbDevice, bl, checkForCardBehavior, bl2, bl3, bl4, bl5, null);
        }

        @Nullable
        public final UsbDevice getDevice() {
            return this.device;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.stripe.core.hardware.Reader.UsbReader");
            UsbReader cfr_ignored_0 = (UsbReader)other;
            UsbDevice usbDevice = this.device;
            UsbDevice usbDevice2 = ((UsbReader)other).device;
            if (!Intrinsics.areEqual((Object)(usbDevice != null ? Integer.valueOf(usbDevice.getDeviceId()) : null), (Object)(usbDevice2 != null ? Integer.valueOf(usbDevice2.getDeviceId()) : null))) {
                return false;
            }
            UsbDevice usbDevice3 = this.device;
            UsbDevice usbDevice4 = ((UsbReader)other).device;
            if (!Intrinsics.areEqual((Object)(usbDevice3 != null ? Integer.valueOf(usbDevice3.getVendorId()) : null), (Object)(usbDevice4 != null ? Integer.valueOf(usbDevice4.getVendorId()) : null))) {
                return false;
            }
            UsbDevice usbDevice5 = this.device;
            UsbDevice usbDevice6 = ((UsbReader)other).device;
            return Intrinsics.areEqual((Object)(usbDevice5 != null ? Integer.valueOf(usbDevice5.getProductId()) : null), (Object)(usbDevice6 != null ? Integer.valueOf(usbDevice6.getProductId()) : null));
        }

        public int hashCode() {
            UsbDevice usbDevice = this.device;
            return usbDevice != null ? usbDevice.hashCode() : 0;
        }

        public /* synthetic */ UsbReader(UsbDevice device2, boolean firmwareCanHandleSelection, CheckForCardBehavior checkForCardBehavior, boolean needsOtaUpdate, boolean needsReconnectAfterConfigUpdate, boolean needsSplashScreenUpdate, boolean quickEmvAutoResponse, DefaultConstructorMarker $constructor_marker) {
            this(device2, firmwareCanHandleSelection, checkForCardBehavior, needsOtaUpdate, needsReconnectAfterConfigUpdate, needsSplashScreenUpdate, quickEmvAutoResponse);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/hardware/Reader$UsbReader$Chipper2xReader;", "Lcom/stripe/core/hardware/Reader$UsbReader;", "device", "Landroid/hardware/usb/UsbDevice;", "(Landroid/hardware/usb/UsbDevice;)V", "hardware_release"})
        public static final class Chipper2xReader
        extends UsbReader {
            public Chipper2xReader(@Nullable UsbDevice device2) {
                super(device2, false, CheckForCardBehavior.DO_NOT_POLL, true, false, false, false, 64, null);
            }

            public /* synthetic */ Chipper2xReader(UsbDevice usbDevice, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    usbDevice = null;
                }
                this(usbDevice);
            }

            public Chipper2xReader() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\b"}, d2={"Lcom/stripe/core/hardware/Reader$UsbReader$Companion;", "", "()V", "fromUsbDevice", "Lcom/stripe/core/hardware/Reader$UsbReader;", "device", "Landroid/hardware/usb/UsbDevice;", "UsbDeviceFilter", "hardware_release"})
        @SourceDebugExtension(value={"SMAP\nReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reader.kt\ncom/stripe/core/hardware/Reader$UsbReader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,390:1\n1#2:391\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final UsbReader fromUsbDevice(@Nullable UsbDevice device2) {
                UsbReader usbReader;
                if (device2 == null) {
                    usbReader = null;
                } else {
                    Enum enum_;
                    block12: {
                        Enum enum_2;
                        UsbDeviceFilter[] usbDeviceFilterArray = UsbDeviceFilter.values();
                        int n2 = usbDeviceFilterArray.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            UsbDeviceFilter usbDeviceFilter;
                            UsbDeviceFilter it = usbDeviceFilter = usbDeviceFilterArray[i2];
                            boolean bl = false;
                            if (!it.matches$hardware_release(device2)) continue;
                            enum_2 = usbDeviceFilter;
                            break block12;
                        }
                        enum_2 = enum_ = null;
                    }
                    if (enum_ != null) {
                        Enum filteredDevices = enum_;
                        boolean bl = false;
                        switch (WhenMappings.$EnumSwitchMapping$0[filteredDevices.ordinal()]) {
                            case 1: {
                                usbReader = new Chipper2xReader(device2);
                                break;
                            }
                            case 2: {
                                usbReader = new StripeM2Reader(device2);
                                break;
                            }
                            case 3: {
                                usbReader = new WisecubeReader(device2);
                                break;
                            }
                            case 4: {
                                usbReader = new Wisepad3Reader(device2);
                                break;
                            }
                            case 5: {
                                usbReader = new Wisepad3SReader(device2);
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    } else {
                        usbReader = null;
                    }
                }
                return usbReader;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\u0010\u0005\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0006\"\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/core/hardware/Reader$UsbReader$Companion$UsbDeviceFilter;", "", "productId", "", "vendorId", "productNamePrefixes", "", "", "(Ljava/lang/String;III[Ljava/lang/String;)V", "[Ljava/lang/String;", "matches", "", "device", "Landroid/hardware/usb/UsbDevice;", "matches$hardware_release", "CHIPPER_2X", "STRIPE_M2", "WISECUBE", "WISEPAD_3", "WISEPAD_3S", "hardware_release"})
            @SourceDebugExtension(value={"SMAP\nReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reader.kt\ncom/stripe/core/hardware/Reader$UsbReader$Companion$UsbDeviceFilter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,390:1\n12744#2,2:391\n*S KotlinDebug\n*F\n+ 1 Reader.kt\ncom/stripe/core/hardware/Reader$UsbReader$Companion$UsbDeviceFilter\n*L\n274#1:391,2\n*E\n"})
            public static final class UsbDeviceFilter
            extends Enum<UsbDeviceFilter> {
                private final int productId;
                private final int vendorId;
                @NotNull
                private final String[] productNamePrefixes;
                public static final /* enum */ UsbDeviceFilter CHIPPER_2X;
                public static final /* enum */ UsbDeviceFilter STRIPE_M2;
                public static final /* enum */ UsbDeviceFilter WISECUBE;
                public static final /* enum */ UsbDeviceFilter WISEPAD_3;
                public static final /* enum */ UsbDeviceFilter WISEPAD_3S;
                private static final /* synthetic */ UsbDeviceFilter[] $VALUES;

                private UsbDeviceFilter(int productId, int vendorId, String ... productNamePrefixes) {
                    this.productId = productId;
                    this.vendorId = vendorId;
                    this.productNamePrefixes = productNamePrefixes;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean matches$hardware_release(@NotNull UsbDevice device2) {
                    Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                    if (device2.getProductId() != this.productId) return false;
                    if (device2.getVendorId() != this.vendorId) return false;
                    String[] $this$any$iv = this.productNamePrefixes;
                    boolean $i$f$any = false;
                    int n2 = 0;
                    int n3 = $this$any$iv.length;
                    while (n2 < n3) {
                        boolean bl;
                        String element$iv;
                        String productNamePrefix = element$iv = $this$any$iv[n2];
                        boolean bl2 = false;
                        if (productNamePrefix != null) {
                            String string;
                            boolean bl3 = false;
                            String string2 = string = device2.getProductName();
                            if (string2 != null) {
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"productName");
                                if (StringsKt.startsWith$default((String)string, (String)productNamePrefix, (boolean)false, (int)2, null)) {
                                    return true;
                                }
                                bl = false;
                            } else {
                                bl = false;
                            }
                        } else {
                            if (device2.getProductName() == null) {
                                return true;
                            }
                            bl = false;
                        }
                        if (bl) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }

                public static UsbDeviceFilter[] values() {
                    return (UsbDeviceFilter[])$VALUES.clone();
                }

                public static UsbDeviceFilter valueOf(String value) {
                    return Enum.valueOf(UsbDeviceFilter.class, value);
                }

                static {
                    String[] stringArray = new String[]{"BBPOS", "CHB20", "CHB22"};
                    CHIPPER_2X = new UsbDeviceFilter(22352, 11369, stringArray);
                    stringArray = new String[]{"Stripe M2", "STRM2"};
                    STRIPE_M2 = new UsbDeviceFilter(257, 5538, stringArray);
                    stringArray = new String[]{"WISEPAD 2", "Tap &", null};
                    WISECUBE = new UsbDeviceFilter(257, 5538, stringArray);
                    stringArray = new String[]{"WISEPAD 3", "WPC30", "WPC32"};
                    WISEPAD_3 = new UsbDeviceFilter(257, 5538, stringArray);
                    stringArray = new String[]{"WPS32", "WPS33"};
                    WISEPAD_3S = new UsbDeviceFilter(257, 5538, stringArray);
                    $VALUES = usbDeviceFilterArray = new UsbDeviceFilter[]{UsbDeviceFilter.CHIPPER_2X, UsbDeviceFilter.STRIPE_M2, UsbDeviceFilter.WISECUBE, UsbDeviceFilter.WISEPAD_3, UsbDeviceFilter.WISEPAD_3S};
                }
            }

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[UsbDeviceFilter.values().length];
                    try {
                        nArray[UsbDeviceFilter.CHIPPER_2X.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[UsbDeviceFilter.STRIPE_M2.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[UsbDeviceFilter.WISECUBE.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[UsbDeviceFilter.WISEPAD_3.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[UsbDeviceFilter.WISEPAD_3S.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/hardware/Reader$UsbReader$StripeM2Reader;", "Lcom/stripe/core/hardware/Reader$UsbReader;", "device", "Landroid/hardware/usb/UsbDevice;", "(Landroid/hardware/usb/UsbDevice;)V", "hardware_release"})
        public static final class StripeM2Reader
        extends UsbReader {
            public StripeM2Reader(@Nullable UsbDevice device2) {
                super(device2, false, CheckForCardBehavior.DO_NOT_POLL, false, false, false, false, 64, null);
            }

            public /* synthetic */ StripeM2Reader(UsbDevice usbDevice, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    usbDevice = null;
                }
                this(usbDevice);
            }

            public StripeM2Reader() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/core/hardware/Reader$UsbReader$UnspecifiedUsbReader;", "Lcom/stripe/core/hardware/Reader$UsbReader;", "()V", "hardware_release"})
        public static final class UnspecifiedUsbReader
        extends UsbReader {
            @NotNull
            public static final UnspecifiedUsbReader INSTANCE = new UnspecifiedUsbReader();

            private UnspecifiedUsbReader() {
                super(null, false, CheckForCardBehavior.DO_NOT_POLL, true, false, false, false, 65, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/hardware/Reader$UsbReader$WisecubeReader;", "Lcom/stripe/core/hardware/Reader$UsbReader;", "device", "Landroid/hardware/usb/UsbDevice;", "(Landroid/hardware/usb/UsbDevice;)V", "hardware_release"})
        public static final class WisecubeReader
        extends UsbReader {
            public WisecubeReader(@Nullable UsbDevice device2) {
                super(device2, false, CheckForCardBehavior.DO_NOT_POLL, true, false, false, false, null);
            }

            public /* synthetic */ WisecubeReader(UsbDevice usbDevice, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    usbDevice = null;
                }
                this(usbDevice);
            }

            public WisecubeReader() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/hardware/Reader$UsbReader$Wisepad3Reader;", "Lcom/stripe/core/hardware/Reader$UsbReader;", "device", "Landroid/hardware/usb/UsbDevice;", "(Landroid/hardware/usb/UsbDevice;)V", "hardware_release"})
        public static final class Wisepad3Reader
        extends UsbReader {
            public Wisepad3Reader(@Nullable UsbDevice device2) {
                super(device2, true, CheckForCardBehavior.DO_NOT_POLL, false, false, true, false, 64, null);
            }

            public /* synthetic */ Wisepad3Reader(UsbDevice usbDevice, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    usbDevice = null;
                }
                this(usbDevice);
            }

            public Wisepad3Reader() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/hardware/Reader$UsbReader$Wisepad3SReader;", "Lcom/stripe/core/hardware/Reader$UsbReader;", "device", "Landroid/hardware/usb/UsbDevice;", "(Landroid/hardware/usb/UsbDevice;)V", "hardware_release"})
        public static final class Wisepad3SReader
        extends UsbReader {
            public Wisepad3SReader(@Nullable UsbDevice device2) {
                super(device2, true, CheckForCardBehavior.DO_NOT_POLL, false, false, true, false, 64, null);
            }

            public /* synthetic */ Wisepad3SReader(UsbDevice usbDevice, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    usbDevice = null;
                }
                this(usbDevice);
            }

            public Wisepad3SReader() {
                this(null, 1, null);
            }
        }
    }
}

