/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.hardware.emv;

import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.emv.CombinedKernelInterface;
import com.stripe.core.hardware.emv.EmvTransactionListener;
import com.stripe.core.hardware.emv.KernelController;
import com.stripe.core.hardware.emv.KernelInterface;
import com.stripe.jvmcore.hardware.emv.CardStatus;
import com.stripe.jvmcore.hardware.emv.CheckForCardBehavior;
import com.stripe.jvmcore.hardware.emv.Confirmation;
import com.stripe.jvmcore.hardware.emv.Phase;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0016\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u000bH\u0016J\u0012\u0010\"\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u000bH\u0002J\b\u0010)\u001a\u00020\u000bH\u0016J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020 H\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0013H\u0016J\b\u0010.\u001a\u00020\u000bH\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/stripe/core/hardware/emv/CanceledKernelInterface;", "Lcom/stripe/core/hardware/emv/KernelInterface;", "kernelController", "Lcom/stripe/core/hardware/emv/KernelController;", "transactionListener", "Lcom/stripe/core/hardware/emv/EmvTransactionListener;", "connectedReaderProvider", "Ljavax/inject/Provider;", "Lcom/stripe/core/hardware/Reader;", "(Lcom/stripe/core/hardware/emv/KernelController;Lcom/stripe/core/hardware/emv/EmvTransactionListener;Ljavax/inject/Provider;)V", "cancel", "", "cardStatus", "Lcom/stripe/jvmcore/hardware/emv/CardStatus;", "checkForInsertedCard", "handleAccountTypeSelectionRequest", "handleApplicationSelectionRequest", "tlvBlobList", "", "", "handleAuthRequest", "tlvBlob", "callbackInterface", "Lcom/stripe/core/hardware/emv/CombinedKernelInterface;", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "handleCardStatus", "handleFinalConfirmationRequest", "handleFinalData", "handlePinDisplayUpdate", "asteriskCount", "", "handlePinEntryRequest", "handlePinReceived", "pinError", "Lcom/stripe/jvmcore/hardware/emv/Confirmation$Pin$Error;", "handleResult", "result", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult$Result;", "idleCard", "reset", "selectApplication", "index", "selectLanguage", "language", "startPinEntry", "hardware_release"})
public final class CanceledKernelInterface
implements KernelInterface {
    @NotNull
    private final KernelController kernelController;
    @NotNull
    private final EmvTransactionListener transactionListener;
    @NotNull
    private final Provider<Reader> connectedReaderProvider;

    @Inject
    public CanceledKernelInterface(@NotNull KernelController kernelController, @NotNull EmvTransactionListener transactionListener, @NotNull Provider<Reader> connectedReaderProvider) {
        Intrinsics.checkNotNullParameter((Object)kernelController, (String)"kernelController");
        Intrinsics.checkNotNullParameter((Object)transactionListener, (String)"transactionListener");
        Intrinsics.checkNotNullParameter(connectedReaderProvider, (String)"connectedReaderProvider");
        this.kernelController = kernelController;
        this.transactionListener = transactionListener;
        this.connectedReaderProvider = connectedReaderProvider;
    }

    @Override
    @NotNull
    public CardStatus cardStatus() {
        return this.transactionListener.cardStatus();
    }

    @Override
    public void selectApplication(int index) {
    }

    @Override
    public void selectLanguage(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
    }

    @Override
    public void startPinEntry() {
    }

    @Override
    @NotNull
    public Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        CompletableDeferred canceledDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        Job.DefaultImpls.cancel$default((Job)((Job)canceledDeferred), null, (int)1, null);
        return (Deferred)canceledDeferred;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void handleCardStatus(@NotNull CardStatus cardStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)cardStatus), (String)"cardStatus");
        this.transactionListener.handleCardStatus(cardStatus);
    }

    @Override
    public void handleApplicationSelectionRequest(@NotNull List<String> tlvBlobList) {
        Intrinsics.checkNotNullParameter(tlvBlobList, (String)"tlvBlobList");
        this.kernelController.cancel(Phase.APPLICATION_SELECTION);
    }

    @Override
    public void handleAccountTypeSelectionRequest() {
        this.kernelController.cancel(Phase.ACCOUNT_TYPE_SELECTION);
    }

    @Override
    public void handlePinEntryRequest() {
        this.kernelController.cancel(Phase.PIN);
    }

    @Override
    public void handlePinDisplayUpdate(int asteriskCount) {
    }

    @Override
    public void handlePinReceived(@Nullable Confirmation.Pin.Error pinError) {
    }

    @Override
    public void handleFinalConfirmationRequest() {
        this.kernelController.cancel(Phase.FINAL_CONFIRMATION);
    }

    @Override
    public void handleAuthRequest(@NotNull String tlvBlob, @NotNull CombinedKernelInterface callbackInterface) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        Intrinsics.checkNotNullParameter((Object)callbackInterface, (String)"callbackInterface");
        this.kernelController.cancel(Phase.AUTH);
    }

    @Override
    public void handleFinalData(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
    }

    @Override
    public void handleResult(@NotNull TransactionResult.Result result2) {
        boolean shouldPoll;
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        if (result2 == TransactionResult.Result.ICC_CARD_REMOVED) {
            this.handleCardStatus(CardStatus.NO_CARD);
        }
        this.idleCard();
        Reader reader = (Reader)this.connectedReaderProvider.get();
        boolean bl = shouldPoll = (reader != null ? reader.getCheckForCardBehavior() : null) == CheckForCardBehavior.POLL_FOR_CARD_REMOVAL;
        if (shouldPoll) {
            this.checkForInsertedCard();
        } else {
            this.transactionListener.handleTransactionResult(new TransactionResult(result2, null));
        }
    }

    @Override
    public void checkForInsertedCard() {
        if (this.cardStatus() == CardStatus.CARD_IDLE) {
            this.kernelController.checkforInsertedCard();
        }
    }

    @Override
    public void reset() {
    }

    private final void idleCard() {
        if (this.cardStatus() == CardStatus.CARD_PROCESSING) {
            this.handleCardStatus(CardStatus.CARD_IDLE);
        }
    }
}

