/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.hardware.emv;

import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.emv.KernelInterface;
import com.stripe.core.stripeterminal.log.AndroidLog;
import com.stripe.jvmcore.hardware.emv.CardStatus;
import com.stripe.jvmcore.hardware.emv.Confirmation;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 :2\u00020\u0001:\u0001:B?\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0019J\u0014\u0010\u001e\u001a\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020!J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010#\u001a\u00020!J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010(\u001a\u00020\u0019J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010#\u001a\u00020!J\u000e\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\u0019J\u0010\u0010.\u001a\u00020\u00192\b\u0010/\u001a\u0004\u0018\u000100J\u000e\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020\u0019J\u000e\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020,J\u000e\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020!J\u0006\u00109\u001a\u00020\u0019R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006;"}, d2={"Lcom/stripe/core/hardware/emv/CombinedKernelInterface;", "", "quickKernelInterface", "Lcom/stripe/core/hardware/emv/KernelInterface;", "quickKernelWithAuthResponseInterface", "traditionalKernelInterface", "canceledKernelInterface", "connectedReaderProvider", "Ljavax/inject/Provider;", "Lcom/stripe/core/hardware/Reader;", "(Lcom/stripe/core/hardware/emv/KernelInterface;Lcom/stripe/core/hardware/emv/KernelInterface;Lcom/stripe/core/hardware/emv/KernelInterface;Lcom/stripe/core/hardware/emv/KernelInterface;Ljavax/inject/Provider;)V", "currentInterface", "getCurrentInterface", "()Lcom/stripe/core/hardware/emv/KernelInterface;", "<set-?>", "", "isCanceled", "()Z", "Lcom/stripe/jvmcore/hardware/emv/TransactionType;", "transactionType", "getTransactionType", "()Lcom/stripe/jvmcore/hardware/emv/TransactionType;", "setTransactionType", "(Lcom/stripe/jvmcore/hardware/emv/TransactionType;)V", "cancel", "", "cardStatus", "Lcom/stripe/jvmcore/hardware/emv/CardStatus;", "checkForInsertedCard", "handleAccountTypeSelectionRequest", "handleApplicationSelectionRequest", "tlvBlobList", "", "", "handleAuthRequest", "tlvBlob", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "handleCardStatus", "handleFinalConfirmationRequest", "handleFinalData", "handlePinDisplayUpdate", "asteriskCount", "", "handlePinEntryRequest", "handlePinReceived", "pinError", "Lcom/stripe/jvmcore/hardware/emv/Confirmation$Pin$Error;", "handleResult", "result", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult$Result;", "reset", "selectApplication", "index", "selectLanguage", "language", "startPinEntry", "Companion", "hardware_release"})
public final class CombinedKernelInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KernelInterface quickKernelInterface;
    @NotNull
    private final KernelInterface quickKernelWithAuthResponseInterface;
    @NotNull
    private final KernelInterface traditionalKernelInterface;
    @NotNull
    private final KernelInterface canceledKernelInterface;
    @NotNull
    private final Provider<Reader> connectedReaderProvider;
    @NotNull
    private TransactionType transactionType;
    private boolean isCanceled;
    @NotNull
    public static final String TAG = "CombinedKernelInterface";

    @Inject
    public CombinedKernelInterface(@Named(value="Quick") @NotNull KernelInterface quickKernelInterface, @Named(value="QuickWithAuthResponse") @NotNull KernelInterface quickKernelWithAuthResponseInterface, @Named(value="Traditional") @NotNull KernelInterface traditionalKernelInterface, @Named(value="Canceled") @NotNull KernelInterface canceledKernelInterface, @NotNull Provider<Reader> connectedReaderProvider) {
        Intrinsics.checkNotNullParameter((Object)quickKernelInterface, (String)"quickKernelInterface");
        Intrinsics.checkNotNullParameter((Object)quickKernelWithAuthResponseInterface, (String)"quickKernelWithAuthResponseInterface");
        Intrinsics.checkNotNullParameter((Object)traditionalKernelInterface, (String)"traditionalKernelInterface");
        Intrinsics.checkNotNullParameter((Object)canceledKernelInterface, (String)"canceledKernelInterface");
        Intrinsics.checkNotNullParameter(connectedReaderProvider, (String)"connectedReaderProvider");
        this.quickKernelInterface = quickKernelInterface;
        this.quickKernelWithAuthResponseInterface = quickKernelWithAuthResponseInterface;
        this.traditionalKernelInterface = traditionalKernelInterface;
        this.canceledKernelInterface = canceledKernelInterface;
        this.connectedReaderProvider = connectedReaderProvider;
        this.transactionType = TransactionType.QUICK;
    }

    @NotNull
    public final TransactionType getTransactionType() {
        return this.transactionType;
    }

    public final synchronized void setTransactionType(@NotNull TransactionType transactionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"<set-?>");
        this.transactionType = transactionType;
    }

    public final boolean isCanceled() {
        return this.isCanceled;
    }

    private final KernelInterface getCurrentInterface() {
        KernelInterface kernelInterface;
        if (this.isCanceled) {
            kernelInterface = this.canceledKernelInterface;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.transactionType.ordinal()]) {
                case 1: {
                    Reader reader = (Reader)this.connectedReaderProvider.get();
                    boolean bl = reader != null ? reader.getQuickEmvAutoResponse() : false;
                    if (bl) {
                        kernelInterface = this.quickKernelInterface;
                        break;
                    }
                    kernelInterface = this.quickKernelWithAuthResponseInterface;
                    break;
                }
                case 2: {
                    kernelInterface = this.traditionalKernelInterface;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return kernelInterface;
    }

    @NotNull
    public final synchronized CardStatus cardStatus() {
        return this.getCurrentInterface().cardStatus();
    }

    public final synchronized void selectApplication(int index) {
        AndroidLog.INSTANCE.i(TAG, "selectApplication " + index);
        this.getCurrentInterface().selectApplication(index);
    }

    public final synchronized void selectLanguage(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        AndroidLog.INSTANCE.i(TAG, "selectLanguage " + language);
        this.getCurrentInterface().selectLanguage(language);
    }

    public final synchronized void startPinEntry() {
        AndroidLog.INSTANCE.i(TAG, "startPinEntry");
        this.getCurrentInterface().startPinEntry();
    }

    @NotNull
    public final synchronized Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        AndroidLog.INSTANCE.i(TAG, "handleAuthResponse");
        return this.getCurrentInterface().handleAuthResponse(tlvBlob);
    }

    public final synchronized void cancel() {
        AndroidLog.INSTANCE.i(TAG, "cancel");
        this.getCurrentInterface().cancel();
        this.isCanceled = true;
    }

    public final synchronized void handleCardStatus(@NotNull CardStatus cardStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)cardStatus), (String)"cardStatus");
        AndroidLog.INSTANCE.i(TAG, "handleCardStatus " + (Object)((Object)cardStatus));
        this.getCurrentInterface().handleCardStatus(cardStatus);
    }

    public final synchronized void handleApplicationSelectionRequest(@NotNull List<String> tlvBlobList) {
        Intrinsics.checkNotNullParameter(tlvBlobList, (String)"tlvBlobList");
        AndroidLog.INSTANCE.i(TAG, "handleApplicationSelectionRequest");
        this.getCurrentInterface().handleApplicationSelectionRequest(tlvBlobList);
    }

    public final synchronized void handleAccountTypeSelectionRequest() {
        AndroidLog.INSTANCE.i(TAG, "handleAccountTypeSelectionRequest");
        this.getCurrentInterface().handleAccountTypeSelectionRequest();
    }

    public final synchronized void handlePinEntryRequest() {
        AndroidLog.INSTANCE.i(TAG, "handlePinEntryRequest");
        this.getCurrentInterface().handlePinEntryRequest();
    }

    public final synchronized void handlePinDisplayUpdate(int asteriskCount) {
        this.getCurrentInterface().handlePinDisplayUpdate(asteriskCount);
    }

    public final synchronized void handlePinReceived(@Nullable Confirmation.Pin.Error pinError) {
        this.getCurrentInterface().handlePinReceived(pinError);
    }

    public final synchronized void handleFinalConfirmationRequest() {
        AndroidLog.INSTANCE.i(TAG, "handleFinalConfirmationRequest");
        this.getCurrentInterface().handleFinalConfirmationRequest();
    }

    public final synchronized void handleAuthRequest(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        AndroidLog.INSTANCE.i(TAG, "handleAuthRequest");
        this.getCurrentInterface().handleAuthRequest(tlvBlob, this);
    }

    public final synchronized void handleFinalData(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        AndroidLog.INSTANCE.i(TAG, "handleFinalData");
        this.getCurrentInterface().handleFinalData(tlvBlob);
    }

    public final synchronized void handleResult(@NotNull TransactionResult.Result result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        AndroidLog.INSTANCE.i(TAG, "handleResult: " + (Object)((Object)result2));
        this.getCurrentInterface().handleResult(result2);
        this.reset();
    }

    public final synchronized void checkForInsertedCard() {
        AndroidLog.INSTANCE.i(TAG, "checkForInsertedCard");
        this.getCurrentInterface().checkForInsertedCard();
    }

    public final synchronized void reset() {
        AndroidLog.INSTANCE.i(TAG, "reset");
        this.quickKernelInterface.reset();
        this.traditionalKernelInterface.reset();
        this.canceledKernelInterface.reset();
        this.isCanceled = false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/hardware/emv/CombinedKernelInterface$Companion;", "", "()V", "TAG", "", "hardware_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransactionType.values().length];
            try {
                nArray[TransactionType.QUICK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionType.TRADITIONAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

