/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.hardware.emv;

import com.stripe.core.hardware.Optional;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.emv.EmvTransactionListener;
import com.stripe.core.hardware.emv.KernelController;
import com.stripe.core.hardware.emv.KernelInterface;
import com.stripe.jvmcore.hardware.emv.CardStatus;
import com.stripe.jvmcore.hardware.emv.Confirmation;
import com.stripe.jvmcore.hardware.emv.Phase;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020+H\u0016J\b\u0010/\u001a\u00020+H\u0002J\b\u00100\u001a\u00020+H\u0016J\u0016\u00101\u001a\u00020+2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u00104\u001a\u00020+H\u0016J\u0010\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020#H\u0016J\b\u00107\u001a\u00020+H\u0016J\u0012\u00108\u001a\u00020+2\b\u00109\u001a\u0004\u0018\u00010\u001fH\u0016J\r\u0010:\u001a\u00020+H\u0000\u00a2\u0006\u0002\b;J\b\u0010<\u001a\u00020+H\u0016J\b\u0010=\u001a\u00020+H\u0004J\u0010\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020#H\u0016J\u0010\u0010@\u001a\u00020+2\u0006\u0010?\u001a\u00020#H\u0004J\u0010\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u00020\u0011H\u0016J\b\u0010C\u001a\u00020+H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006D"}, d2={"Lcom/stripe/core/hardware/emv/KernelAutomator;", "Lcom/stripe/core/hardware/emv/KernelInterface;", "kernelController", "Lcom/stripe/core/hardware/emv/KernelController;", "transactionListener", "Lcom/stripe/core/hardware/emv/EmvTransactionListener;", "connectedReaderProvider", "Ljavax/inject/Provider;", "Lcom/stripe/core/hardware/Reader;", "(Lcom/stripe/core/hardware/emv/KernelController;Lcom/stripe/core/hardware/emv/EmvTransactionListener;Ljavax/inject/Provider;)V", "applicationConfirmations", "Ljava/util/Queue;", "Lcom/stripe/jvmcore/hardware/emv/Confirmation;", "getApplicationConfirmations", "()Ljava/util/Queue;", "applicationTlvBlobs", "", "", "getApplicationTlvBlobs", "()Ljava/util/List;", "setApplicationTlvBlobs", "(Ljava/util/List;)V", "getConnectedReaderProvider$hardware_release", "()Ljavax/inject/Provider;", "currentPhase", "Lcom/stripe/jvmcore/hardware/emv/Phase;", "getCurrentPhase$hardware_release", "()Lcom/stripe/jvmcore/hardware/emv/Phase;", "setCurrentPhase$hardware_release", "(Lcom/stripe/jvmcore/hardware/emv/Phase;)V", "currentPinError", "Lcom/stripe/jvmcore/hardware/emv/Confirmation$Pin$Error;", "getKernelController$hardware_release", "()Lcom/stripe/core/hardware/emv/KernelController;", "selectedApplicationIndex", "", "getSelectedApplicationIndex", "()I", "setSelectedApplicationIndex", "(I)V", "getTransactionListener$hardware_release", "()Lcom/stripe/core/hardware/emv/EmvTransactionListener;", "cancel", "", "cardStatus", "Lcom/stripe/jvmcore/hardware/emv/CardStatus;", "checkForInsertedCard", "completeApplicationConfirmation", "handleAccountTypeSelectionRequest", "handleApplicationSelectionRequest", "tlvBlobList", "handleCardStatus", "handleFinalConfirmationRequest", "handlePinDisplayUpdate", "asteriskCount", "handlePinEntryRequest", "handlePinReceived", "pinError", "idleCard", "idleCard$hardware_release", "reset", "resetSelection", "selectApplication", "index", "selectApplicationOnController", "selectLanguage", "language", "startPinEntry", "hardware_release"})
public abstract class KernelAutomator
implements KernelInterface {
    @NotNull
    private final KernelController kernelController;
    @NotNull
    private final EmvTransactionListener transactionListener;
    @NotNull
    private final Provider<Reader> connectedReaderProvider;
    @NotNull
    private Phase currentPhase;
    @Nullable
    private Confirmation.Pin.Error currentPinError;
    @NotNull
    private List<String> applicationTlvBlobs;
    @NotNull
    private final Queue<Confirmation> applicationConfirmations;
    private int selectedApplicationIndex;

    public KernelAutomator(@NotNull KernelController kernelController, @NotNull EmvTransactionListener transactionListener, @NotNull Provider<Reader> connectedReaderProvider) {
        Intrinsics.checkNotNullParameter((Object)kernelController, (String)"kernelController");
        Intrinsics.checkNotNullParameter((Object)transactionListener, (String)"transactionListener");
        Intrinsics.checkNotNullParameter(connectedReaderProvider, (String)"connectedReaderProvider");
        this.kernelController = kernelController;
        this.transactionListener = transactionListener;
        this.connectedReaderProvider = connectedReaderProvider;
        this.currentPhase = Phase.NONE;
        this.applicationTlvBlobs = CollectionsKt.emptyList();
        this.applicationConfirmations = new LinkedList();
    }

    @NotNull
    public final KernelController getKernelController$hardware_release() {
        return this.kernelController;
    }

    @NotNull
    public final EmvTransactionListener getTransactionListener$hardware_release() {
        return this.transactionListener;
    }

    @NotNull
    public final Provider<Reader> getConnectedReaderProvider$hardware_release() {
        return this.connectedReaderProvider;
    }

    @NotNull
    public final Phase getCurrentPhase$hardware_release() {
        return this.currentPhase;
    }

    public final void setCurrentPhase$hardware_release(@NotNull Phase phase) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"<set-?>");
        this.currentPhase = phase;
    }

    @NotNull
    protected final List<String> getApplicationTlvBlobs() {
        return this.applicationTlvBlobs;
    }

    protected final void setApplicationTlvBlobs(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.applicationTlvBlobs = list;
    }

    @NotNull
    protected final Queue<Confirmation> getApplicationConfirmations() {
        return this.applicationConfirmations;
    }

    protected final int getSelectedApplicationIndex() {
        return this.selectedApplicationIndex;
    }

    protected final void setSelectedApplicationIndex(int n2) {
        this.selectedApplicationIndex = n2;
    }

    @Override
    @NotNull
    public CardStatus cardStatus() {
        return this.transactionListener.cardStatus();
    }

    @Override
    public void handleCardStatus(@NotNull CardStatus cardStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)cardStatus), (String)"cardStatus");
        this.transactionListener.handleCardStatus(cardStatus);
    }

    @Override
    public void cancel() {
        this.kernelController.cancel(this.currentPhase);
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentPhase.ordinal()]) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.transactionListener.handleConfirmationRequest(Optional.Companion.absent());
            }
        }
        this.currentPhase = Phase.NONE;
    }

    @Override
    public void selectApplication(int index) {
        this.selectApplicationOnController(index);
    }

    protected final void selectApplicationOnController(int index) {
        this.currentPhase = Phase.NONE;
        this.kernelController.selectApplication(index);
    }

    @Override
    public void selectLanguage(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.completeApplicationConfirmation();
    }

    @Override
    public void startPinEntry() {
        this.kernelController.startPinEntry();
    }

    @Override
    public void handleAccountTypeSelectionRequest() {
        this.currentPhase = Phase.ACCOUNT_TYPE_SELECTION;
    }

    @Override
    public void handleApplicationSelectionRequest(@NotNull List<String> tlvBlobList) {
        Intrinsics.checkNotNullParameter(tlvBlobList, (String)"tlvBlobList");
        this.currentPhase = Phase.APPLICATION_SELECTION;
        this.resetSelection();
    }

    private final void completeApplicationConfirmation() {
        if (this.applicationConfirmations.isEmpty()) {
            this.transactionListener.handleConfirmationRequest(Optional.Companion.absent());
            this.selectApplicationOnController(this.selectedApplicationIndex);
        } else {
            Confirmation confirmation = this.applicationConfirmations.remove();
            Intrinsics.checkNotNullExpressionValue((Object)confirmation, (String)"applicationConfirmations.remove()");
            this.transactionListener.handleConfirmationRequest((Optional<Confirmation>)Optional.Companion.of(confirmation));
        }
    }

    @Override
    public void handlePinEntryRequest() {
        this.currentPhase = Phase.PIN;
        this.transactionListener.handlePinDisplayUpdate(0);
        this.transactionListener.handleConfirmationRequest((Optional<Confirmation>)Optional.Companion.of(new Confirmation.Pin(this.currentPinError)));
    }

    @Override
    public void handlePinDisplayUpdate(int asteriskCount) {
        this.transactionListener.handlePinDisplayUpdate(asteriskCount);
    }

    @Override
    public void handlePinReceived(@Nullable Confirmation.Pin.Error pinError) {
        this.currentPhase = Phase.NONE;
        this.currentPinError = pinError;
        this.transactionListener.handleConfirmationRequest(Optional.Companion.absent());
    }

    @Override
    public void handleFinalConfirmationRequest() {
        this.kernelController.sendConfirmation(true);
    }

    @Override
    public void checkForInsertedCard() {
        if (this.cardStatus() == CardStatus.CARD_IDLE) {
            this.kernelController.checkforInsertedCard();
        }
    }

    @Override
    public void reset() {
        this.currentPhase = Phase.NONE;
        this.currentPinError = null;
        this.resetSelection();
    }

    protected final void resetSelection() {
        this.applicationConfirmations.clear();
        this.applicationTlvBlobs = CollectionsKt.emptyList();
        this.selectedApplicationIndex = 0;
    }

    public final void idleCard$hardware_release() {
        if (this.cardStatus() == CardStatus.CARD_PROCESSING) {
            this.handleCardStatus(CardStatus.CARD_IDLE);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Phase.values().length];
            try {
                nArray[Phase.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Phase.ACCOUNT_TYPE_SELECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Phase.APPLICATION_SELECTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Phase.PIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Phase.FINAL_CONFIRMATION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Phase.AUTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

