/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.hardware.emv;

import com.stripe.core.hardware.Optional;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.emv.CombinedKernelInterface;
import com.stripe.core.hardware.emv.EmvTransactionListener;
import com.stripe.core.hardware.emv.KernelAuthResponseDelegate;
import com.stripe.core.hardware.emv.KernelAutomator;
import com.stripe.core.hardware.emv.KernelController;
import com.stripe.core.stripeterminal.log.AndroidLog;
import com.stripe.jvmcore.hardware.emv.AccountType;
import com.stripe.jvmcore.hardware.emv.Confirmation;
import com.stripe.jvmcore.hardware.emv.Phase;
import com.stripe.jvmcore.hardware.emv.SourceType;
import com.stripe.jvmcore.hardware.emv.TlvMap;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0016\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/stripe/core/hardware/emv/TraditionalKernelAutomator;", "Lcom/stripe/core/hardware/emv/KernelAutomator;", "kernelController", "Lcom/stripe/core/hardware/emv/KernelController;", "transactionListener", "Lcom/stripe/core/hardware/emv/EmvTransactionListener;", "connectedReaderProvider", "Ljavax/inject/Provider;", "Lcom/stripe/core/hardware/Reader;", "kernelAuthDelegate", "Lcom/stripe/core/hardware/emv/KernelAuthResponseDelegate;", "(Lcom/stripe/core/hardware/emv/KernelController;Lcom/stripe/core/hardware/emv/EmvTransactionListener;Ljavax/inject/Provider;Lcom/stripe/core/hardware/emv/KernelAuthResponseDelegate;)V", "cancel", "", "handleAccountTypeSelectionRequest", "handleApplicationSelectionRequest", "tlvBlobList", "", "", "handleAuthRequest", "tlvBlob", "callbackInterface", "Lcom/stripe/core/hardware/emv/CombinedKernelInterface;", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "handleFinalData", "handleResult", "result", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult$Result;", "reset", "selectApplication", "index", "", "Companion", "hardware_release"})
public final class TraditionalKernelAutomator
extends KernelAutomator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KernelAuthResponseDelegate kernelAuthDelegate;
    @NotNull
    private static final String TAG = "TraditnlKernelAutomator";

    @Inject
    public TraditionalKernelAutomator(@NotNull KernelController kernelController, @NotNull EmvTransactionListener transactionListener, @NotNull Provider<Reader> connectedReaderProvider, @NotNull KernelAuthResponseDelegate kernelAuthDelegate) {
        Intrinsics.checkNotNullParameter((Object)kernelController, (String)"kernelController");
        Intrinsics.checkNotNullParameter((Object)transactionListener, (String)"transactionListener");
        Intrinsics.checkNotNullParameter(connectedReaderProvider, (String)"connectedReaderProvider");
        Intrinsics.checkNotNullParameter((Object)kernelAuthDelegate, (String)"kernelAuthDelegate");
        super(kernelController, transactionListener, connectedReaderProvider);
        this.kernelAuthDelegate = kernelAuthDelegate;
    }

    @Override
    public void selectApplication(int index) {
        Object object = (String)CollectionsKt.getOrNull(this.getApplicationTlvBlobs(), (int)index);
        if (object == null || (object = TlvMap.Companion.toTlvMap((String)object)) == null) {
            return;
        }
        Object tlvMap = object;
        List<String> list = ((TlvMap)tlvMap).getLanguagePreferences();
        if (list != null) {
            List<String> it = list;
            boolean bl = false;
            this.getApplicationConfirmations().add(new Confirmation.LanguageSelection(it));
        }
        if (((TlvMap)tlvMap).getSourceType() == SourceType.INTERAC_PRESENT) {
            this.getApplicationConfirmations().add(Confirmation.AccountSelection.Companion.getINTERAC_ACCOUNT_SELECTION());
        }
        this.setSelectedApplicationIndex(index);
        if (this.getApplicationConfirmations().isEmpty()) {
            this.selectApplicationOnController(index);
            this.getTransactionListener$hardware_release().handleConfirmationRequest(Optional.Companion.absent());
        } else {
            EmvTransactionListener emvTransactionListener = this.getTransactionListener$hardware_release();
            Confirmation confirmation = this.getApplicationConfirmations().remove();
            Intrinsics.checkNotNullExpressionValue((Object)confirmation, (String)"applicationConfirmations.remove()");
            emvTransactionListener.handleConfirmationRequest((Optional<Confirmation>)Optional.Companion.of(confirmation));
        }
    }

    @Override
    public void handleApplicationSelectionRequest(@NotNull List<String> tlvBlobList) {
        boolean shouldHandleSelection;
        Intrinsics.checkNotNullParameter(tlvBlobList, (String)"tlvBlobList");
        super.handleApplicationSelectionRequest(tlvBlobList);
        this.setApplicationTlvBlobs(CollectionsKt.toMutableList((Collection)tlvBlobList));
        Map appList = new HashMap();
        Iterator<String> iterator = this.getApplicationTlvBlobs().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Unit unit;
            int index = n2++;
            String tlvBlob = iterator.next();
            if (TlvMap.Companion.toTlvMap(tlvBlob) != null) {
                TlvMap it;
                boolean bl = false;
                Integer n3 = index;
                appList.put(n3, it.getApplicationName());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) continue;
            TraditionalKernelAutomator $this$handleApplicationSelectionRequest_u24lambda_u242 = this;
            boolean bl = false;
            AndroidLog.INSTANCE.w(TAG, "Unable to parse TLV blob received in application selection");
        }
        Reader reader = (Reader)this.getConnectedReaderProvider$hardware_release().get();
        boolean bl = shouldHandleSelection = !(reader != null ? reader.getFirmwareCanHandleSelection() : false);
        if (shouldHandleSelection) {
            switch (appList.size()) {
                case 0: {
                    AndroidLog.INSTANCE.w(TAG, "No valid applications were received during selection, canceling out");
                    this.getKernelController$hardware_release().cancel(Phase.APPLICATION_SELECTION);
                    break;
                }
                case 1: {
                    this.selectApplication(((Number)appList.entrySet().iterator().next().getKey()).intValue());
                    break;
                }
                default: {
                    this.getTransactionListener$hardware_release().handleConfirmationRequest((Optional<Confirmation>)Optional.Companion.of(new Confirmation.ApplicationSelection(appList)));
                }
            }
        }
    }

    @Override
    public void handleAccountTypeSelectionRequest() {
        boolean shouldHandleSelection;
        super.handleAccountTypeSelectionRequest();
        AndroidLog.INSTANCE.w(TAG, "Received a request for account type, but no account selected; using DEFAULT");
        Reader reader = (Reader)this.getConnectedReaderProvider$hardware_release().get();
        boolean bl = shouldHandleSelection = !(reader != null ? reader.getFirmwareCanHandleSelection() : false);
        if (shouldHandleSelection) {
            this.getKernelController$hardware_release().selectAccountType(AccountType.DEFAULT);
        }
    }

    @Override
    public void handleAuthRequest(@NotNull String tlvBlob, @NotNull CombinedKernelInterface callbackInterface) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        Intrinsics.checkNotNullParameter((Object)callbackInterface, (String)"callbackInterface");
        this.kernelAuthDelegate.handleAuthRequest(this, tlvBlob, callbackInterface, TransactionType.TRADITIONAL, TAG);
    }

    @Override
    @NotNull
    public Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        return this.kernelAuthDelegate.handleAuthResponse(this, tlvBlob);
    }

    @Override
    public void handleFinalData(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        this.kernelAuthDelegate.handleFinalData(tlvBlob);
    }

    @Override
    public void handleResult(@NotNull TransactionResult.Result result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        this.kernelAuthDelegate.handleResult(this, result2);
    }

    @Override
    public void reset() {
        super.reset();
        this.kernelAuthDelegate.reset();
    }

    @Override
    public void cancel() {
        super.cancel();
        this.kernelAuthDelegate.cancel();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/hardware/emv/TraditionalKernelAutomator$Companion;", "", "()V", "TAG", "", "hardware_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

