/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.hardware.reactive.emv;

import android.graphics.Bitmap;
import androidx.annotation.VisibleForTesting;
import com.google.common.util.concurrent.SettableFuture;
import com.squareup.wire.Message;
import com.stripe.core.hardware.reactive.RxJavaHelper;
import com.stripe.core.hardware.reactive.emv.ConfigurationHandler;
import com.stripe.core.hardware.reactive.emv.ConfigurationHandlerKt;
import com.stripe.core.hardware.reactive.emv.DesiredSettings;
import com.stripe.core.hardware.reactive.emv.MerchantNameData;
import com.stripe.core.hardware.reactive.emv.ReactiveConfigurationListener;
import com.stripe.core.hardware.updates.ReaderConfigurationUpdateController;
import com.stripe.jvmcore.dagger.IO;
import com.stripe.jvmcore.device.DeviceInfoRepository;
import com.stripe.jvmcore.hardware.emv.ReaderSettings;
import com.stripe.jvmcore.hardware.emv.TlvMap;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.storage.SharedPrefs;
import com.stripe.proto.model.config.ContactApplicationParameters;
import com.stripe.proto.model.config.ContactlessCombination;
import com.stripe.proto.model.config.DiscoverParameters;
import com.stripe.proto.model.config.ExpressPayParameters;
import com.stripe.proto.model.config.InteracParameters;
import com.stripe.proto.model.config.JcbParameters;
import com.stripe.proto.model.config.MobileClientConfig;
import com.stripe.proto.model.config.PayPassParameters;
import com.stripe.proto.model.config.PayWaveParameters;
import com.stripe.proto.model.config.Tlv;
import com.stripe.proto.model.config.VectorRegionalConfiguration;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000 :2\u00020\u0001:\u0001:B1\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cJ\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u0004\u0018\u00010\u001eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\n\u0010!\u001a\u0004\u0018\u00010\u001eH\u0002J0\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0016\u0010(\u001a\u0012\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020#0)j\u0002`+J\u001e\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010-\u001a\u00020\u0012H\u0007J0\u0010.\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010/\u001a\u00020\u00162\b\b\u0002\u00100\u001a\u00020\u00162\b\b\u0002\u00101\u001a\u00020\u00162\b\b\u0002\u00102\u001a\u00020\u0016J\"\u00103\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\b\u00104\u001a\u0004\u0018\u00010\u001e2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u001c\u00105\u001a\u00020\u00162\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0007J\u001c\u00107\u001a\u00020\u00162\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u0011H\u0007J\u000e\u00109\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006;"}, d2={"Lcom/stripe/core/hardware/reactive/emv/ConfigurationHandler;", "", "scheduler", "Lio/reactivex/rxjava3/core/Scheduler;", "configurationUpdateController", "Lcom/stripe/core/hardware/updates/ReaderConfigurationUpdateController;", "deviceInfoRepository", "Lcom/stripe/jvmcore/device/DeviceInfoRepository;", "sharedPrefs", "Lcom/stripe/jvmcore/storage/SharedPrefs;", "configListener", "Lcom/stripe/core/hardware/reactive/emv/ReactiveConfigurationListener;", "(Lio/reactivex/rxjava3/core/Scheduler;Lcom/stripe/core/hardware/updates/ReaderConfigurationUpdateController;Lcom/stripe/jvmcore/device/DeviceInfoRepository;Lcom/stripe/jvmcore/storage/SharedPrefs;Lcom/stripe/core/hardware/reactive/emv/ReactiveConfigurationListener;)V", "compositeDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "readAidFuture", "Lcom/google/common/util/concurrent/SettableFuture;", "", "", "readTerminalSettingFuture", "Lcom/stripe/jvmcore/hardware/emv/ReaderSettings;", "updateAidFuture", "", "updateDisplayFuture", "updateTerminalSettingFuture", "configureTerminalSetting", "desiredSetting", "Lcom/stripe/core/hardware/reactive/emv/DesiredSettings;", "configureTerminalSetting$hardware_reactive_release", "getMerchantNameData", "Lcom/stripe/core/hardware/reactive/emv/MerchantNameData;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMerchantNameDataFromEmvTag", "getMerchantNameDataFromSharedPref", "installConfig", "", "config", "Lcom/stripe/proto/model/config/MobileClientConfig;", "image", "Landroid/graphics/Bitmap;", "updater", "Lkotlin/Function1;", "", "Lcom/stripe/core/hardware/reactive/emv/ProgressUpdater;", "readAid", "index", "readTerminalSetting", "merchantName", "buzzerSoundEnabled", "countryCode", "domesticDebitAidList", "recordNewSetting", "currentSettings", "updateAid", "aidData", "updateDisplaySettings", "displayData", "updateTerminalSetting", "Companion", "hardware-reactive_release"})
public final class ConfigurationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final ReaderConfigurationUpdateController configurationUpdateController;
    @NotNull
    private final DeviceInfoRepository deviceInfoRepository;
    @NotNull
    private final SharedPrefs sharedPrefs;
    @NotNull
    private final ReactiveConfigurationListener configListener;
    @NotNull
    private final CompositeDisposable compositeDisposable;
    @Nullable
    private SettableFuture<Map<String, String>> readAidFuture;
    @Nullable
    private SettableFuture<Boolean> updateAidFuture;
    @Nullable
    private SettableFuture<Boolean> updateDisplayFuture;
    @Nullable
    private SettableFuture<ReaderSettings> readTerminalSettingFuture;
    @Nullable
    private SettableFuture<Boolean> updateTerminalSettingFuture;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(ConfigurationHandler.class);
    private static final long TIMEOUT_DELAY_MS = 3000L;
    @NotNull
    private static final String AID_DISABLED = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    @NotNull
    private static final String DEFAULT_BACKGROUND_COLOR = "FFFF";
    @NotNull
    private static final String DEFAULT_FOREGROUND_COLOR = "E618";
    private static final long GET_MERCHANT_NAME_DATA_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(3L);

    @Inject
    public ConfigurationHandler(@IO @NotNull Scheduler scheduler, @NotNull ReaderConfigurationUpdateController configurationUpdateController, @NotNull DeviceInfoRepository deviceInfoRepository, @NotNull SharedPrefs sharedPrefs, @NotNull ReactiveConfigurationListener configListener) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)configurationUpdateController, (String)"configurationUpdateController");
        Intrinsics.checkNotNullParameter((Object)deviceInfoRepository, (String)"deviceInfoRepository");
        Intrinsics.checkNotNullParameter((Object)sharedPrefs, (String)"sharedPrefs");
        Intrinsics.checkNotNullParameter((Object)configListener, (String)"configListener");
        this.scheduler = scheduler;
        this.configurationUpdateController = configurationUpdateController;
        this.deviceInfoRepository = deviceInfoRepository;
        this.sharedPrefs = sharedPrefs;
        this.configListener = configListener;
        this.compositeDisposable = new CompositeDisposable();
        Disposable[] disposableArray = new Disposable[]{this.configListener.getReaderAidObservable().observeOn(this.scheduler).subscribe(new Consumer(){

            /*
             * WARNING - void declaration
             */
            public final void accept(@NotNull Map<String, ? extends Object> result2) {
                block2: {
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    Map $this$filterValues$iv;
                    Intrinsics.checkNotNullParameter(result2, (String)"result");
                    SettableFuture settableFuture = readAidFuture;
                    if (settableFuture == null) break block2;
                    Map<String, ? extends Object> map2 = result2;
                    SettableFuture settableFuture2 = settableFuture;
                    boolean $i$f$filterValues = false;
                    LinkedHashMap result$iv = new LinkedHashMap();
                    for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                        Object it = entry$iv.getValue();
                        boolean bl = false;
                        if (!(it instanceof String)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    $this$filterValues$iv = result$iv;
                    boolean $i$f$mapValues = false;
                    result$iv = $this$mapValues$iv;
                    Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it;
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map3 = destination$iv$iv;
                        boolean bl = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        Object k2 = it$iv$iv.getKey();
                        Map map4 = map3;
                        boolean bl2 = false;
                        String string = it.getValue().toString();
                        map4.put(k2, string);
                    }
                    settableFuture2.set((Object)destination$iv$iv);
                }
            }
        }), this.configListener.getReaderDisplayObservable().observeOn(this.scheduler).subscribe(new Consumer(){

            public final void accept(boolean it) {
                block0: {
                    SettableFuture settableFuture = updateDisplayFuture;
                    if (settableFuture == null) break block0;
                    settableFuture.set((Object)it);
                }
            }
        }), this.configListener.getReaderSettingsObservable().observeOn(this.scheduler).subscribe(new Consumer(){

            public final void accept(@NotNull ReaderSettings result2) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    SettableFuture settableFuture = readTerminalSettingFuture;
                    if (settableFuture == null) break block0;
                    settableFuture.set((Object)result2);
                }
            }
        }), this.configListener.getReaderUpdateAidObservable().observeOn(this.scheduler).subscribe(new Consumer(){

            public final void accept(boolean it) {
                block0: {
                    SettableFuture settableFuture = updateAidFuture;
                    if (settableFuture == null) break block0;
                    settableFuture.set((Object)it);
                }
            }
        }), this.configListener.getReaderUpdateSettingsObservable().observeOn(this.scheduler).subscribe(new Consumer(){

            public final void accept(boolean it) {
                block0: {
                    SettableFuture settableFuture = updateTerminalSettingFuture;
                    if (settableFuture == null) break block0;
                    settableFuture.set((Object)it);
                }
            }
        })};
        this.compositeDisposable.addAll(disposableArray);
    }

    public final synchronized void installConfig(@NotNull MobileClientConfig config, @Nullable Bitmap image2, @NotNull Function1<? super Float, Unit> updater) {
        MerchantNameData currentSettings;
        MerchantNameData downloadedSettings;
        block18: {
            Object object;
            Bitmap bitmap;
            block20: {
                block19: {
                    MerchantNameData merchantNameData;
                    Message message;
                    Unit unit;
                    Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
                    Intrinsics.checkNotNullParameter(updater, (String)"updater");
                    Object object2 = config.bbpos_config;
                    int settingsSteps = object2 != null && (object2 = object2.aid_order) != null && (object2 = object2.aid_order) != null ? object2.size() : 1;
                    int currentStep = 0;
                    Object object3 = config.bbpos_config;
                    if (object3 != null && (object3 = object3.aid_order) != null && (object3 = object3.aid_order) != null) {
                        Unit unit2;
                        Message aidMap = object3;
                        boolean bl = false;
                        Object object4 = config.client_checkout_options;
                        if (object4 != null && (object4 = object4.vector_config) != null && (object4 = Companion.toAidData((VectorRegionalConfiguration)((Object)object4), (Map<String, String>)aidMap)) != null) {
                            Message updateMap = object4;
                            boolean bl2 = false;
                            for (Map.Entry entry : aidMap.entrySet()) {
                                Map map2;
                                String key = (String)entry.getKey();
                                String value = (String)entry.getValue();
                                String index = StringsKt.padStart((String)value, (int)8, (char)'0');
                                Map readResult = this.readAid(index);
                                Map updates2 = (Map)updateMap.get(key);
                                Map map3 = readResult;
                                if (map3 == null || (map3 = MapsKt.toMutableMap(map3)) == null) {
                                    map3 = new LinkedHashMap();
                                }
                                Map $this$installConfig_u24lambda_u243_u24lambda_u242_u24lambda_u241 = map2 = map3;
                                boolean bl3 = false;
                                if (updates2 != null) {
                                    Map it;
                                    boolean bl4 = false;
                                    $this$installConfig_u24lambda_u243_u24lambda_u242_u24lambda_u241.putAll(it);
                                }
                                $this$installConfig_u24lambda_u243_u24lambda_u242_u24lambda_u241.put("appIndex", index);
                                Map settings = map2;
                                if (!Intrinsics.areEqual((Object)settings, (Object)readResult)) {
                                    this.updateAid(settings);
                                }
                                updater.invoke((Object)Float.valueOf((float)(++currentStep) / (float)settingsSteps));
                            }
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        if (unit2 == null) {
                            LOGGER.w("MobileClientConfig missing vectorConfig", new Pair[0]);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        LOGGER.w("MobileClientConfig missing aidOrderMap", new Pair[0]);
                    }
                    downloadedSettings = new MerchantNameData(config.client_config_version, (message = config.bbpos_config) != null && (message = message.pinpad_image_assets) != null && (message = message.splash_screen) != null ? message.image_id : null);
                    ReaderSettings readerSettings = ConfigurationHandler.readTerminalSetting$default(this, true, false, false, false, 14, null);
                    if (readerSettings != null) {
                        ReaderSettings it = readerSettings;
                        boolean bl = false;
                        String string = it.getMerchantNameAndLocation();
                        if (string == null) {
                            string = "";
                        }
                        merchantNameData = MerchantNameData.Companion.parseMerchantName(string);
                    } else {
                        merchantNameData = null;
                    }
                    currentSettings = merchantNameData;
                    MerchantNameData merchantNameData2 = currentSettings;
                    MerchantNameData merchantNameData3 = currentSettings;
                    LOGGER.i("currentSettings is " + (merchantNameData2 != null ? merchantNameData2.getConfigHash() : null) + ' ' + (merchantNameData3 != null ? merchantNameData3.getImageId() : null), new Pair[0]);
                    Bitmap bitmap2 = image2;
                    if (bitmap2 == null) break block18;
                    bitmap = bitmap2;
                    boolean bl = false;
                    if (downloadedSettings.getImageId() == null) break block18;
                    MerchantNameData merchantNameData4 = currentSettings;
                    if (Intrinsics.areEqual((Object)downloadedSettings.getImageId(), (Object)(merchantNameData4 != null ? merchantNameData4.getImageId() : null))) break block18;
                    object = config.bbpos_config;
                    if (object == null || (object = object.pinpad_image_assets) == null || (object = object.splash_screen) == null || (object = object.image_color) == null) break block19;
                    Object color = object;
                    boolean bl5 = false;
                    String string = ((CharSequence)color).length() == 0 ? DEFAULT_FOREGROUND_COLOR : color;
                    object = string;
                    if (string != null) break block20;
                }
                object = DEFAULT_FOREGROUND_COLOR;
            }
            Object foregroundColor = object;
            String backgroundSetting = "010000000000400100FFFFFF0000";
            String foregroundSetting = "010000000000400100FF" + (String)foregroundColor + "0000";
            String statusSetting = DEFAULT_BACKGROUND_COLOR + (String)foregroundColor;
            Pair[] pairArray = new Pair[2];
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"data", (Object)bitmap), TuplesKt.to((Object)"backgroundColor", (Object)backgroundSetting), TuplesKt.to((Object)"foregroundColor", (Object)foregroundSetting)};
            pairArray[0] = TuplesKt.to((Object)"image", new Hashtable(MapsKt.mapOf((Pair[])pairArray2)));
            pairArray[1] = TuplesKt.to((Object)"theme", new Hashtable(MapsKt.mapOf((Pair)TuplesKt.to((Object)"statusBarColor", (Object)statusSetting))));
            Map data = MapsKt.mapOf((Pair[])pairArray);
            this.updateDisplaySettings(data);
        }
        DesiredSettings settings = this.recordNewSetting(config, currentSettings, downloadedSettings.toMerchantName());
        LOGGER.i("new settings are is " + settings, new Pair[0]);
        if (!this.configureTerminalSetting$hardware_reactive_release(settings)) {
            String shortenedMerchantName = MerchantNameData.copy$default(downloadedSettings, null, null, 1, null).toMerchantName();
            DesiredSettings settings2 = this.recordNewSetting(config, currentSettings, shortenedMerchantName);
            this.configureTerminalSetting$hardware_reactive_release(settings2);
        }
        updater.invoke((Object)Float.valueOf(1.0f));
    }

    @VisibleForTesting
    public final boolean configureTerminalSetting$hardware_reactive_release(@NotNull DesiredSettings desiredSetting) {
        Intrinsics.checkNotNullParameter((Object)desiredSetting, (String)"desiredSetting");
        boolean bl = desiredSetting.getMerchantName() != null;
        boolean bl2 = desiredSetting.getCountryCode() != null;
        boolean bl3 = desiredSetting.getBuzzerEnabled() != null;
        ReaderSettings readerSettings = ConfigurationHandler.readTerminalSetting$default(this, bl, bl3, bl2, false, 8, null);
        if (readerSettings != null) {
            ReaderSettings readerSettings2 = readerSettings;
            boolean bl4 = false;
            DesiredSettings currentSettings = new DesiredSettings(readerSettings2.getMerchantNameAndLocation(), readerSettings2.getTerminalCountryCode(), readerSettings2.getBuzzerSoundEnabled());
            if (!Intrinsics.areEqual((Object)desiredSetting, (Object)currentSettings)) {
                boolean bl5;
                if (this.updateTerminalSetting(desiredSetting)) {
                    LOGGER.i("Successfully updated terminal setting", new Pair[0]);
                    bl5 = true;
                } else {
                    LOGGER.w("Unable to update terminal setting. Check logs for onError() response", new Pair[0]);
                    bl5 = false;
                }
                return bl5;
            }
            LOGGER.i("configureTerminalSetting: No need to change.", new Pair[0]);
            return true;
        }
        ConfigurationHandler $this$configureTerminalSetting_u24lambda_u248 = this;
        boolean bl6 = false;
        LOGGER.w("Unable to read terminal setting. Check logs for onError() response", new Pair[0]);
        return false;
    }

    @VisibleForTesting
    @Nullable
    public final Map<String, String> readAid(@NotNull String index) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        this.readAidFuture = SettableFuture.create();
        this.configurationUpdateController.readAid(index);
        SettableFuture<Map<String, String>> settableFuture = this.readAidFuture;
        if (settableFuture != null) {
            Map map3;
            SettableFuture<Map<String, String>> it = settableFuture;
            boolean bl = false;
            try {
                map3 = (Map)it.get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e2) {
                LOGGER.w(e2, "Failed to read AID", new Pair[0]);
                map3 = null;
            }
            map2 = map3;
        } else {
            map2 = null;
        }
        Map ret = map2;
        this.readAidFuture = null;
        return ret;
    }

    @VisibleForTesting
    public final boolean updateAid(@NotNull Map<String, String> aidData) {
        Object object;
        block5: {
            block4: {
                Boolean bl;
                Intrinsics.checkNotNullParameter(aidData, (String)"aidData");
                this.updateAidFuture = SettableFuture.create();
                this.configurationUpdateController.updateAid(aidData);
                object = this.updateAidFuture;
                if (object == null) break block4;
                SettableFuture<Boolean> it = object;
                boolean bl2 = false;
                try {
                    bl = (Boolean)it.get(3000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    LOGGER.w(e2, "Failed to update AID", new Pair[0]);
                    bl = false;
                }
                Boolean bl3 = bl;
                object = bl3;
                if (bl3 != null) break block5;
            }
            object = false;
        }
        boolean ret = (Boolean)object;
        this.updateAidFuture = null;
        return ret;
    }

    @VisibleForTesting
    public final boolean updateDisplaySettings(@NotNull Map<String, ? extends Object> displayData) {
        Object object;
        block5: {
            block4: {
                Boolean bl;
                Intrinsics.checkNotNullParameter(displayData, (String)"displayData");
                this.updateDisplayFuture = SettableFuture.create();
                this.configurationUpdateController.updateDisplay(displayData);
                object = this.updateDisplayFuture;
                if (object == null) break block4;
                SettableFuture<Boolean> it = object;
                boolean bl2 = false;
                try {
                    bl = (Boolean)it.get(60000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    LOGGER.w("Failed to update display", new Pair[0]);
                    bl = false;
                }
                Boolean bl3 = bl;
                object = bl3;
                if (bl3 != null) break block5;
            }
            object = false;
        }
        boolean ret = (Boolean)object;
        this.updateDisplayFuture = null;
        return ret;
    }

    @Nullable
    public final synchronized ReaderSettings readTerminalSetting(boolean merchantName, boolean buzzerSoundEnabled, boolean countryCode, boolean domesticDebitAidList) {
        ReaderSettings readerSettings;
        this.readTerminalSettingFuture = SettableFuture.create();
        this.configurationUpdateController.readSettings(merchantName, countryCode, domesticDebitAidList, buzzerSoundEnabled);
        SettableFuture<ReaderSettings> settableFuture = this.readTerminalSettingFuture;
        if (settableFuture != null) {
            ReaderSettings readerSettings2;
            SettableFuture<ReaderSettings> it = settableFuture;
            boolean bl = false;
            try {
                readerSettings2 = (ReaderSettings)it.get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e2) {
                LOGGER.w(e2, "Failed to read terminal setting", new Pair[0]);
                readerSettings2 = null;
            }
            readerSettings = readerSettings2;
        } else {
            readerSettings = null;
        }
        ReaderSettings ret = readerSettings;
        this.readTerminalSettingFuture = null;
        return ret;
    }

    public static /* synthetic */ ReaderSettings readTerminalSetting$default(ConfigurationHandler configurationHandler, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        if ((n2 & 4) != 0) {
            bl3 = false;
        }
        if ((n2 & 8) != 0) {
            bl4 = false;
        }
        return configurationHandler.readTerminalSetting(bl, bl2, bl3, bl4);
    }

    public final synchronized boolean updateTerminalSetting(@NotNull DesiredSettings desiredSetting) {
        Object object;
        block5: {
            block4: {
                Boolean bl;
                Intrinsics.checkNotNullParameter((Object)desiredSetting, (String)"desiredSetting");
                this.updateTerminalSettingFuture = SettableFuture.create();
                this.configurationUpdateController.updateSettings(new TlvMap(desiredSetting.toTlvMap$hardware_reactive_release()));
                object = this.updateTerminalSettingFuture;
                if (object == null) break block4;
                SettableFuture<Boolean> it = object;
                boolean bl2 = false;
                try {
                    bl = (Boolean)it.get(3000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    LOGGER.w(e2, "Failed to update terminal setting", new Pair[0]);
                    bl = false;
                }
                Boolean bl3 = bl;
                object = bl3;
                if (bl3 != null) break block5;
            }
            object = false;
        }
        boolean ret = (Boolean)object;
        this.updateTerminalSettingFuture = null;
        return ret;
    }

    @Nullable
    public final Object getMerchantNameData(@NotNull Continuation<? super MerchantNameData> $completion) {
        if (ConfigurationHandlerKt.getStoreConfigIntoMerchantNameTag(this.deviceInfoRepository)) {
            return this.getMerchantNameDataFromEmvTag($completion);
        }
        return this.getMerchantNameDataFromSharedPref();
    }

    /*
     * Unable to fully structure code
     */
    private final Object getMerchantNameDataFromEmvTag(Continuation<? super MerchantNameData> var1_1) {
        if (!(var1_1 instanceof getMerchantNameDataFromEmvTag.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ ConfigurationHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigurationHandler.access$getMerchantNameDataFromEmvTag(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this;
                $this$getMerchantNameDataFromEmvTag_u24lambda_u2414 = var2_5;
                $i$a$-runCatching-ConfigurationHandler$getMerchantNameDataFromEmvTag$2 = false;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeout((long)ConfigurationHandler.GET_MERCHANT_NAME_DATA_TIMEOUT_MILLIS, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MerchantNameData>, Object>($this$getMerchantNameDataFromEmvTag_u24lambda_u2414, null){
                    int label;
                    final /* synthetic */ ConfigurationHandler $this_runCatching;
                    {
                        this.$this_runCatching = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = RxJavaHelper.INSTANCE.awaitFirstWithBlock(ConfigurationHandler.access$getConfigListener$p(this.$this_runCatching).getReaderSettingsObservable(), ConfigurationHandler.access$getScheduler$p(this.$this_runCatching), (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.$this_runCatching, null){
                                    int label;
                                    final /* synthetic */ ConfigurationHandler $this_runCatching;
                                    {
                                        this.$this_runCatching = $receiver;
                                        super(1, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                ReaderConfigurationUpdateController.readSettings$default(ConfigurationHandler.access$getConfigurationUpdateController$p(this.$this_runCatching), true, false, false, false, 14, null);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)this);
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                return (var2_3 = ((ReaderSettings)v0).getMerchantNameAndLocation()) != null ? MerchantNameData.Companion.parseMerchantName(var2_3) : null;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super MerchantNameData> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var7_4) goto lbl22
lbl21:
                // 1 sources

                return var7_4;
lbl22:
                // 1 sources

                ** GOTO lbl29
            }
            case 1: {
                $i$a$-runCatching-ConfigurationHandler$getMerchantNameDataFromEmvTag$2 = false;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    return v0;
                }
                catch (Throwable var4_9) {
                    var2_5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var4_9));
                    return Result.isFailure-impl((Object)var2_5) != false ? null : var2_5;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final MerchantNameData getMerchantNameDataFromSharedPref() {
        String string = this.sharedPrefs.getMobilePosConfig();
        return string != null ? MerchantNameData.Companion.parseMerchantName(string) : null;
    }

    private final DesiredSettings recordNewSetting(MobileClientConfig config, MerchantNameData currentSettings, String merchantName) {
        DesiredSettings settings;
        block3: {
            Object object;
            settings = null;
            settings = DesiredSettings.Companion.create$default(DesiredSettings.Companion, null, null, null, 7, null);
            if (ConfigurationHandlerKt.getStoreConfigIntoMerchantNameTag(this.deviceInfoRepository)) {
                settings = DesiredSettings.copy$default(settings, merchantName, null, null, 6, null);
            } else {
                this.sharedPrefs.putMobilePosConfig(merchantName);
                MerchantNameData merchantNameData = currentSettings;
                if ((merchantNameData != null ? merchantNameData.getConfigHash() : null) != null && ((CharSequence)currentSettings.getConfigHash()).length() > 0) {
                    settings = DesiredSettings.copy$default(settings, "", null, null, 6, null);
                }
            }
            if ((object = config.client_checkout_options) == null || (object = object.vector_config) == null || (object = ReaderConfigurationUpdateController.Companion.toCountryCode((VectorRegionalConfiguration)((Object)object))) == null) break block3;
            Object it = object;
            boolean bl = false;
            settings = DesiredSettings.copy$default(settings, null, (String)it, null, 5, null);
        }
        return settings;
    }

    public static final /* synthetic */ Object access$getMerchantNameDataFromEmvTag(ConfigurationHandler $this, Continuation $completion) {
        return $this.getMerchantNameDataFromEmvTag((Continuation<? super MerchantNameData>)$completion);
    }

    public static final /* synthetic */ ReactiveConfigurationListener access$getConfigListener$p(ConfigurationHandler $this) {
        return $this.configListener;
    }

    public static final /* synthetic */ Scheduler access$getScheduler$p(ConfigurationHandler $this) {
        return $this.scheduler;
    }

    public static final /* synthetic */ ReaderConfigurationUpdateController access$getConfigurationUpdateController$p(ConfigurationHandler $this) {
        return $this.configurationUpdateController;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00100\u0010*\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0010J\f\u0010\u0013\u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stripe/core/hardware/reactive/emv/ConfigurationHandler$Companion;", "", "()V", "AID_DISABLED", "", "DEFAULT_BACKGROUND_COLOR", "DEFAULT_FOREGROUND_COLOR", "GET_MERCHANT_NAME_DATA_TIMEOUT_MILLIS", "", "getGET_MERCHANT_NAME_DATA_TIMEOUT_MILLIS$annotations", "getGET_MERCHANT_NAME_DATA_TIMEOUT_MILLIS", "()J", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "TIMEOUT_DELAY_MS", "toAidData", "", "Lcom/stripe/proto/model/config/VectorRegionalConfiguration;", "aidMapping", "toLimit", "hardware-reactive_release"})
    @SourceDebugExtension(value={"SMAP\nConfigurationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationHandler.kt\ncom/stripe/core/hardware/reactive/emv/ConfigurationHandler$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,536:1\n125#2:537\n152#2,3:538\n*S KotlinDebug\n*F\n+ 1 ConfigurationHandler.kt\ncom/stripe/core/hardware/reactive/emv/ConfigurationHandler$Companion\n*L\n359#1:537\n359#1:538,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long getGET_MERCHANT_NAME_DATA_TIMEOUT_MILLIS() {
            return GET_MERCHANT_NAME_DATA_TIMEOUT_MILLIS;
        }

        @VisibleForTesting
        public static /* synthetic */ void getGET_MERCHANT_NAME_DATA_TIMEOUT_MILLIS$annotations() {
        }

        private final String toLimit(String $this$toLimit) {
            return ((CharSequence)$this$toLimit).length() > 0 ? $this$toLimit : "999999999999";
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, Map<String, String>> toAidData(@NotNull VectorRegionalConfiguration $this$toAidData, @NotNull Map<String, String> aidMapping) {
            Map it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)$this$toAidData), (String)"<this>");
            Intrinsics.checkNotNullParameter(aidMapping, (String)"aidMapping");
            Map<String, String> $this$map$iv = aidMapping;
            boolean $i$f$map = false;
            Map<String, String> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Iterator<Tlv> it2;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = new Pair[]{TuplesKt.to((Object)"appIndex", it2.getValue()), TuplesKt.to((Object)"aid", (Object)ConfigurationHandler.AID_DISABLED)};
                Map ht = MapsKt.mutableMapOf((Pair[])object);
                collection.add(new Pair(it2.getKey(), (Object)ht));
            }
            Map ret = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            Object object = $this$toAidData.contact_parameters;
            if (object == null || (object = object.parameters) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Unit unit;
                ContactApplicationParameters parameters;
                block37: {
                    block35: {
                        parameters = (ContactApplicationParameters)((Object)iterator2.next());
                        if ((Map)ret.get(parameters.aid) == null) break block35;
                        boolean bl = false;
                        it.put("aid", parameters.aid);
                        it.put("contactTACDefault", parameters.tac_default);
                        it.put("contactTACDenial", parameters.tac_denial);
                        it.put("contactTACOnline", parameters.tac_online);
                        it.put("terminalFloorLimit", "00000000");
                        for (Tlv tlv : parameters.tlvs) {
                            switch (tlv.tag) {
                                case "9F09": {
                                    it.put("appVersion", tlv.value_);
                                    break;
                                }
                                case "97": {
                                    it.put("defaultTDOL", tlv.value_);
                                    break;
                                }
                                case "9F49": {
                                    it.put("defaultDDOL", tlv.value_);
                                }
                            }
                        }
                        unit = Unit.INSTANCE;
                        break block37;
                    }
                    unit = null;
                }
                if (unit != null) continue;
                VectorRegionalConfiguration $this$toAidData_u24lambda_u242 = $this$toAidData;
                boolean bl = false;
                LOGGER.w("Index not found for CT AID " + parameters.aid, new Pair[0]);
            }
            Object object2 = $this$toAidData.contactless_combinations;
            if (object2 == null || (object2 = object2.combinations) == null) {
                object2 = CollectionsKt.emptyList();
            }
            iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Unit unit;
                ContactlessCombination combination;
                block48: {
                    block38: {
                        block46: {
                            block40: {
                                InteracParameters interacParameters;
                                block45: {
                                    block44: {
                                        DiscoverParameters discoverParameters;
                                        block43: {
                                            JcbParameters jcbParameters;
                                            block42: {
                                                ExpressPayParameters expressPayParameters;
                                                block41: {
                                                    PayWaveParameters payWaveParameters;
                                                    block39: {
                                                        combination = (ContactlessCombination)((Object)iterator2.next());
                                                        if ((Map)ret.get(combination.aid) == null) break block38;
                                                        boolean bl = false;
                                                        it.put("aid", combination.aid);
                                                        PayPassParameters payPassParameters = combination.pay_pass_parameters;
                                                        payWaveParameters = combination.pay_wave_parameters;
                                                        expressPayParameters = combination.express_pay_parameters;
                                                        jcbParameters = combination.jcb_parameters;
                                                        discoverParameters = combination.discover_parameters;
                                                        interacParameters = combination.interac_parameters;
                                                        if (payPassParameters == null) break block39;
                                                        if (combination.is_signature_supported) {
                                                            it.put("contactlessTACDefault", "F45084800C");
                                                            it.put("contactlessTACDenial", "0000000000");
                                                            it.put("contactlessTACOnline", "F45084800C");
                                                        } else {
                                                            it.put("contactlessTACDefault", "F45080800C");
                                                            it.put("contactlessTACDenial", "0000000000");
                                                            it.put("contactlessTACOnline", "F45080800C");
                                                        }
                                                        it.put("contactlessCVMRequiredLimit", payPassParameters.contactless_cvm_required_limit);
                                                        it.put("contactlessFloorLimit", payPassParameters.contactless_floor_limit);
                                                        break block40;
                                                    }
                                                    if (payWaveParameters == null) break block41;
                                                    it.put("contactlessTransactionLimit", Companion.toLimit(payWaveParameters.contactless_transaction_limit));
                                                    it.put("contactlessCVMRequiredLimit", Companion.toLimit(payWaveParameters.contactless_cvm_required_limit));
                                                    it.put("contactlessFloorLimit", Companion.toLimit(payWaveParameters.contactless_floor_limit));
                                                    break block40;
                                                }
                                                if (expressPayParameters == null) break block42;
                                                it.put("contactlessTransactionLimit", Companion.toLimit(expressPayParameters.contactless_transaction_limit));
                                                it.put("contactlessCVMRequiredLimit", Companion.toLimit(expressPayParameters.contactless_cvm_required_limit));
                                                it.put("contactlessFloorLimit", Companion.toLimit(expressPayParameters.contactless_floor_limit));
                                                it.put("contactlessTACDefault", expressPayParameters.tac_default);
                                                it.put("contactlessTACDenial", expressPayParameters.tac_denial);
                                                it.put("contactlessTACOnline", expressPayParameters.tac_online);
                                                break block40;
                                            }
                                            if (jcbParameters == null) break block43;
                                            it.put("contactlessTransactionLimit", Companion.toLimit(jcbParameters.contactless_transaction_limit));
                                            it.put("contactlessCVMRequiredLimit", Companion.toLimit(jcbParameters.contactless_cvm_required_limit));
                                            it.put("contactlessFloorLimit", Companion.toLimit(jcbParameters.contactless_floor_limit));
                                            it.put("contactlessTACDefault", jcbParameters.tac_default);
                                            it.put("contactlessTACDenial", jcbParameters.tac_denial);
                                            it.put("contactlessTACOnline", jcbParameters.tac_online);
                                            break block40;
                                        }
                                        if (discoverParameters == null) break block44;
                                        it.put("contactlessTransactionLimit", Companion.toLimit(discoverParameters.contactless_transaction_limit));
                                        it.put("contactlessCVMRequiredLimit", Companion.toLimit(discoverParameters.contactless_cvm_required_limit));
                                        it.put("contactlessFloorLimit", Companion.toLimit(discoverParameters.contactless_floor_limit));
                                        break block40;
                                    }
                                    if (interacParameters != null) break block45;
                                    LOGGER.w("No CTLS message for " + combination.aid + ", so skipping", new Pair[0]);
                                    break block46;
                                }
                                it.put("contactlessTransactionLimit", Companion.toLimit(interacParameters.contactless_transaction_limit));
                                it.put("contactlessCVMRequiredLimit", Companion.toLimit(interacParameters.contactless_cvm_required_limit));
                                it.put("contactlessTACDefault", interacParameters.tac_default);
                                it.put("contactlessTACDenial", interacParameters.tac_denial);
                                it.put("contactlessTACOnline", interacParameters.tac_online);
                            }
                            for (Tlv tlv : combination.tlvs) {
                                switch (tlv.tag) {
                                    case "9F09": {
                                        it.put("appVersion", tlv.value_);
                                        break;
                                    }
                                    case "97": {
                                        it.put("defaultTDOL", tlv.value_);
                                        break;
                                    }
                                    case "9F49": {
                                        it.put("defaultDDOL", tlv.value_);
                                    }
                                }
                            }
                        }
                        unit = Unit.INSTANCE;
                        break block48;
                    }
                    unit = null;
                }
                if (unit != null) continue;
                VectorRegionalConfiguration $this$toAidData_u24lambda_u244 = $this$toAidData;
                boolean bl = false;
                LOGGER.w("Index not found for CTLS AID " + combination.aid, new Pair[0]);
            }
            return ret;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

