/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.hardware.reactive.management;

import com.google.common.util.concurrent.SettableFuture;
import com.stripe.core.hardware.Optional;
import com.stripe.core.hardware.ReaderEncryptionController;
import com.stripe.core.hardware.ReaderManagementController;
import com.stripe.core.hardware.management.SignedDataListener;
import com.stripe.core.hardware.reactive.management.ReactiveReaderManagementListener;
import com.stripe.core.hardware.reactive.management.ReaderManagementHandler;
import com.stripe.jvmcore.dagger.IO;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.HealthLoggerBuilder;
import com.stripe.jvmcore.logging.PendingTimer;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.bbpos.BbposDomain;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.bbpos.ReaderScope;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.kotlin.DisposableKt;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B)\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/core/hardware/reactive/management/ReaderManagementHandler;", "", "scheduler", "Lio/reactivex/rxjava3/core/Scheduler;", "reactiveReaderManagementListener", "Lcom/stripe/core/hardware/reactive/management/ReactiveReaderManagementListener;", "readerManagementController", "Lcom/stripe/core/hardware/ReaderManagementController;", "healthLoggerBuilder", "Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;", "(Lio/reactivex/rxjava3/core/Scheduler;Lcom/stripe/core/hardware/reactive/management/ReactiveReaderManagementListener;Lcom/stripe/core/hardware/ReaderManagementController;Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;)V", "compositeDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "healthLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/BbposDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/BbposDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/ReaderScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/bbpos/ReaderScope$Builder;", "signedDataFuture", "Lcom/google/common/util/concurrent/SettableFuture;", "Lcom/stripe/core/hardware/management/SignedDataListener$SignedData;", "signData", "data", "", "Companion", "hardware-reactive_release"})
@SourceDebugExtension(value={"SMAP\nReaderManagementHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReaderManagementHandler.kt\ncom/stripe/core/hardware/reactive/management/ReaderManagementHandler\n+ 2 HealthLogger.kt\ncom/stripe/jvmcore/logging/HealthLoggerBuilder\n+ 3 HealthLogger.kt\ncom/stripe/jvmcore/logging/HealthLoggerBuilder$DomainedBuilder\n*L\n1#1,88:1\n436#2,4:89\n457#3,4:93\n*S KotlinDebug\n*F\n+ 1 ReaderManagementHandler.kt\ncom/stripe/core/hardware/reactive/management/ReaderManagementHandler\n*L\n35#1:89,4\n36#1:93,4\n*E\n"})
public final class ReaderManagementHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final ReaderManagementController readerManagementController;
    @NotNull
    private final HealthLogger<BbposDomain, BbposDomain.Builder, ReaderScope, ReaderScope.Builder> healthLogger;
    @Nullable
    private SettableFuture<SignedDataListener.SignedData> signedDataFuture;
    @NotNull
    private final CompositeDisposable compositeDisposable;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(ReaderManagementHandler.class);

    @Inject
    public ReaderManagementHandler(@IO @NotNull Scheduler scheduler, @NotNull ReactiveReaderManagementListener reactiveReaderManagementListener, @NotNull ReaderManagementController readerManagementController, @NotNull HealthLoggerBuilder healthLoggerBuilder) {
        HealthLoggerBuilder.DomainedBuilder<BbposDomain, BbposDomain.Builder> this_$iv;
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)reactiveReaderManagementListener, (String)"reactiveReaderManagementListener");
        Intrinsics.checkNotNullParameter((Object)readerManagementController, (String)"readerManagementController");
        Intrinsics.checkNotNullParameter((Object)healthLoggerBuilder, (String)"healthLoggerBuilder");
        this.scheduler = scheduler;
        this.readerManagementController = readerManagementController;
        HealthLoggerBuilder healthLoggerBuilder2 = healthLoggerBuilder;
        Function2 domainSetter$iv = healthLogger.1.INSTANCE;
        boolean $i$f$withDomain = false;
        this_$iv = new HealthLoggerBuilder.DomainedBuilder<BbposDomain, BbposDomain.Builder>((HealthLoggerBuilder)((Object)this_$iv), BbposDomain.class, BbposDomain.Builder.class, domainSetter$iv);
        Function2 scopeSetter$iv = healthLogger.2.INSTANCE;
        boolean $i$f$withScope = false;
        this.healthLogger = new HealthLoggerBuilder.DomainedBuilder.ScopedBuilder<ReaderScope, ReaderScope.Builder>(this_$iv, ReaderScope.class, ReaderScope.Builder.class, scopeSetter$iv).build();
        this.compositeDisposable = new CompositeDisposable();
        Disposable disposable = reactiveReaderManagementListener.getSignedDataObservable().observeOn(this.scheduler).subscribe(new Consumer(){

            public final void accept(@NotNull Optional<SignedDataListener.SignedData> it) {
                block4: {
                    SignedDataListener.SignedData signedData;
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    SettableFuture settableFuture = signedDataFuture;
                    if (settableFuture == null) break block4;
                    Optional<SignedDataListener.SignedData> optional = it;
                    if (optional instanceof Optional.Present) {
                        signedData = (SignedDataListener.SignedData)((Optional.Present)it).getValue();
                    } else if (optional instanceof Optional.Absent) {
                        signedData = null;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    settableFuture.set((Object)signedData);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"reactiveReaderManagement\u2026          )\n            }");
        DisposableKt.addTo((Disposable)disposable, (CompositeDisposable)this.compositeDisposable);
    }

    @Nullable
    public final synchronized SignedDataListener.SignedData signData(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        PendingTimer signDataTimer2 = HealthLogger.startTimer$default(this.healthLogger, null, signData.signDataTimer.1.INSTANCE, 1, null);
        for (ReaderEncryptionController.EncryptionMethod encryptionMethod : this.readerManagementController.getEncryptionMethodsToTry()) {
            SignedDataListener.SignedData signedData;
            SignedDataListener.SignedData signedData2;
            LOGGER.i("Sign data with " + (Object)((Object)encryptionMethod), new Pair[0]);
            this.signedDataFuture = SettableFuture.create();
            this.readerManagementController.signData(data, encryptionMethod);
            if (this.signedDataFuture != null) {
                SignedDataListener.SignedData signedData3;
                boolean bl = false;
                try {
                    SettableFuture<SignedDataListener.SignedData> it;
                    signedData3 = (SignedDataListener.SignedData)it.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    LOGGER.w(e2, "Unable to sign data with " + (Object)((Object)encryptionMethod) + " because " + e2.getMessage(), new Pair[0]);
                    signedData3 = null;
                }
                signedData2 = signedData3;
            } else {
                signedData2 = null;
            }
            if ((signedData = signedData2) == null) continue;
            LOGGER.i("Signing completed", new Pair[0]);
            this.signedDataFuture = null;
            HealthLogger.endTimer$default(this.healthLogger, signDataTimer2, null, null, null, 14, null);
            return SignedDataListener.SignedData.copy$default(signedData, null, null, encryptionMethod, 3, null);
        }
        HealthLogger.endTimer$default(this.healthLogger, signDataTimer2, Outcome.GenericError.INSTANCE, null, null, 12, null);
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/hardware/reactive/management/ReaderManagementHandler$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "hardware-reactive_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

