/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.hardware.tipping;

import com.neovisionaries.i18n.CurrencyCode;
import com.stripe.core.hardware.tipping.FixedAmountTips;
import com.stripe.core.hardware.tipping.InvalidTipConfig;
import com.stripe.core.hardware.tipping.PercentageTips;
import com.stripe.core.hardware.tipping.TipConfigValidationResult;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.proto.terminal.terminal.pub.message.config.TippingConfigPb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a0\u0010\u0006\u001a\u00020\u00012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a0\u0010\u000e\u001a\u00020\u00012\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"generateValidatedConfig", "Lcom/stripe/core/hardware/tipping/TipConfigValidationResult;", "localizedTippingConfig", "Lcom/stripe/proto/terminal/terminal/pub/message/config/TippingConfigPb$LocalizedTippingConfig;", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "processFixedAmountTipOption", "fixedAmountTips", "", "", "currency", "Lcom/neovisionaries/i18n/CurrencyCode;", "isSmartTip", "", "processPercentageTipOption", "percentageTips", "hardware_release"})
@SourceDebugExtension(value={"SMAP\nTipConfigValidationResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TipConfigValidationResult.kt\ncom/stripe/core/hardware/tipping/TipConfigValidationResultKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1855#2,2:130\n1549#2:132\n1620#2,3:133\n1855#2,2:136\n*S KotlinDebug\n*F\n+ 1 TipConfigValidationResult.kt\ncom/stripe/core/hardware/tipping/TipConfigValidationResultKt\n*L\n86#1:130,2\n97#1:132\n97#1:133,3\n116#1:136,2\n*E\n"})
public final class TipConfigValidationResultKt {
    @NotNull
    public static final TipConfigValidationResult generateValidatedConfig(@NotNull TippingConfigPb.LocalizedTippingConfig localizedTippingConfig, @NotNull Amount amount) {
        Integer smartTipThreshold;
        Intrinsics.checkNotNullParameter((Object)((Object)localizedTippingConfig), (String)"localizedTippingConfig");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        CurrencyCode currencyCode = amount.getCurrency();
        if (currencyCode == null) {
            return new InvalidTipConfig(InvalidTipConfig.Reason.NULL_TIP_CONFIG);
        }
        CurrencyCode currency = currencyCode;
        TippingConfigPb.Percentages fixedPercentage = localizedTippingConfig.fixed_percentage;
        TippingConfigPb.FixedAmounts fixedAmount = localizedTippingConfig.fixed_amount;
        TippingConfigPb.SmartTip smartTip = localizedTippingConfig.smart_tip;
        TipConfigValidationResult tipConfigValidationResult = fixedPercentage != null ? TipConfigValidationResultKt.processPercentageTipOption(fixedPercentage.percentages, amount, currency, false) : (fixedAmount != null ? TipConfigValidationResultKt.processFixedAmountTipOption(fixedAmount.fixed_amounts, amount, currency, false) : (smartTip != null ? ((smartTipThreshold = smartTip.smart_tip_threshold) != null && amount.getValue() >= (long)smartTipThreshold.intValue() ? TipConfigValidationResultKt.processPercentageTipOption(smartTip.percentages, amount, currency, true) : TipConfigValidationResultKt.processFixedAmountTipOption(smartTip.fixed_amounts, amount, currency, true)) : (TipConfigValidationResult)new InvalidTipConfig(InvalidTipConfig.Reason.NULL_TIP_CONFIG)));
        return tipConfigValidationResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final TipConfigValidationResult processFixedAmountTipOption(List<Integer> fixedAmountTips, Amount amount, CurrencyCode currency, boolean isSmartTip) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        List amountTipsNotNull = CollectionsKt.filterNotNull((Iterable)fixedAmountTips);
        Iterable $this$forEach$iv = amountTipsNotNull;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            int it = ((Number)element$iv2).intValue();
            boolean bl = false;
            if (it >= 1) continue;
            return new InvalidTipConfig(InvalidTipConfig.Reason.TIP_OUT_OF_BOUNDS);
        }
        if (amountTipsNotNull.size() != 3) {
            return new InvalidTipConfig(InvalidTipConfig.Reason.THREE_TIP_OPTIONS_EXPECTED);
        }
        Iterable $this$map$iv = amountTipsNotNull;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n2 = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((long)it);
        }
        List list = (List)destination$iv$iv;
        long l2 = amount.getValue();
        return new FixedAmountTips(currency, l2, list, isSmartTip);
    }

    private static final TipConfigValidationResult processPercentageTipOption(List<Integer> percentageTips, Amount amount, CurrencyCode currency, boolean isSmartTip) {
        List percentageTipsNotNull = CollectionsKt.filterNotNull((Iterable)percentageTips);
        if (percentageTipsNotNull.size() != 3) {
            return new InvalidTipConfig(InvalidTipConfig.Reason.THREE_TIP_OPTIONS_EXPECTED);
        }
        Iterable $this$forEach$iv = percentageTipsNotNull;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            if (it <= 100 && it >= 1) continue;
            return new InvalidTipConfig(InvalidTipConfig.Reason.TIP_OUT_OF_BOUNDS);
        }
        long l2 = amount.getValue();
        return new PercentageTips(currency, l2, percentageTipsNotNull, isSmartTip);
    }
}

