/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.logging;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Build;
import android.os.DeadSystemException;
import com.stripe.core.logging.NoisyExceptionFilter;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002J\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0003J\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/stripe/core/logging/NoisyExceptionFilterAndroidImpl;", "Lcom/stripe/core/logging/NoisyExceptionFilter;", "()V", "isNoisy", "", "", "(Ljava/lang/Throwable;)Z", "shouldFilterOutNoisyException", "e", "dejaVu", "", "shouldFilterOutNoisyExceptionPostN", "source", "shouldFilterOutNoisyExceptionPreN", "logging_release"})
@SourceDebugExtension(value={"SMAP\nNoisyExceptionFilterAndroidImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoisyExceptionFilterAndroidImpl.kt\ncom/stripe/core/logging/NoisyExceptionFilterAndroidImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,56:1\n12744#2,2:57\n*S KotlinDebug\n*F\n+ 1 NoisyExceptionFilterAndroidImpl.kt\ncom/stripe/core/logging/NoisyExceptionFilterAndroidImpl\n*L\n46#1:57,2\n*E\n"})
public final class NoisyExceptionFilterAndroidImpl
implements NoisyExceptionFilter {
    @Override
    public boolean isNoisy(@NotNull Throwable $this$isNoisy) {
        Intrinsics.checkNotNullParameter((Object)$this$isNoisy, (String)"<this>");
        return this.shouldFilterOutNoisyException($this$isNoisy, new LinkedHashSet());
    }

    private final boolean shouldFilterOutNoisyException(Throwable e2, Set<Throwable> dejaVu) {
        return Build.VERSION.SDK_INT >= 24 && this.shouldFilterOutNoisyExceptionPostN(e2, dejaVu) || this.shouldFilterOutNoisyExceptionPreN(e2, dejaVu);
    }

    private final boolean shouldFilterOutNoisyExceptionPreN(Throwable e2, Set<Throwable> dejaVu) {
        return false;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    @TargetApi(value=24)
    private final boolean shouldFilterOutNoisyExceptionPostN(Throwable source, Set<Throwable> dejaVu) {
        for (Throwable e2 = source; e2 != null; e2 = e2.getCause()) {
            boolean bl;
            block4: {
                if (e2 instanceof DeadSystemException) {
                    return true;
                }
                if (!dejaVu.add(e2)) {
                    return false;
                }
                Throwable[] throwableArray = e2.getSuppressed();
                Intrinsics.checkNotNullExpressionValue((Object)throwableArray, (String)"e.suppressed");
                Object[] $this$any$iv = throwableArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Throwable it = (Throwable)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!this.shouldFilterOutNoisyException(it, dejaVu)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }
}

