/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.logginginterceptors;

import androidx.annotation.VisibleForTesting;
import com.stripe.core.logginginterceptors.CrpcLogLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/stripe/core/logginginterceptors/CrpcMethod;", "", "service", "", "method", "logLevel", "Lcom/stripe/core/logginginterceptors/CrpcLogLevel;", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/core/logginginterceptors/CrpcLogLevel;)V", "getLogLevel", "()Lcom/stripe/core/logginginterceptors/CrpcLogLevel;", "getMethod", "()Ljava/lang/String;", "getService", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "logging-interceptors_release"})
@VisibleForTesting
public final class CrpcMethod {
    @NotNull
    private final String service;
    @NotNull
    private final String method;
    @NotNull
    private final CrpcLogLevel logLevel;

    public CrpcMethod(@NotNull String service, @NotNull String method, @NotNull CrpcLogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        this.service = service;
        this.method = method;
        this.logLevel = logLevel;
    }

    public /* synthetic */ CrpcMethod(String string, String string2, CrpcLogLevel crpcLogLevel, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            crpcLogLevel = CrpcLogLevel.VERBOSE;
        }
        this(string, string2, crpcLogLevel);
    }

    @NotNull
    public final String getService() {
        return this.service;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final CrpcLogLevel getLogLevel() {
        return this.logLevel;
    }

    @NotNull
    public final String component1() {
        return this.service;
    }

    @NotNull
    public final String component2() {
        return this.method;
    }

    @NotNull
    public final CrpcLogLevel component3() {
        return this.logLevel;
    }

    @NotNull
    public final CrpcMethod copy(@NotNull String service, @NotNull String method, @NotNull CrpcLogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        return new CrpcMethod(service, method, logLevel);
    }

    public static /* synthetic */ CrpcMethod copy$default(CrpcMethod crpcMethod, String string, String string2, CrpcLogLevel crpcLogLevel, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = crpcMethod.service;
        }
        if ((n2 & 2) != 0) {
            string2 = crpcMethod.method;
        }
        if ((n2 & 4) != 0) {
            crpcLogLevel = crpcMethod.logLevel;
        }
        return crpcMethod.copy(string, string2, crpcLogLevel);
    }

    @NotNull
    public String toString() {
        return "CrpcMethod(service=" + this.service + ", method=" + this.method + ", logLevel=" + (Object)((Object)this.logLevel) + ')';
    }

    public int hashCode() {
        int result2 = this.service.hashCode();
        result2 = result2 * 31 + this.method.hashCode();
        result2 = result2 * 31 + this.logLevel.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CrpcMethod)) {
            return false;
        }
        CrpcMethod crpcMethod = (CrpcMethod)other;
        if (!Intrinsics.areEqual((Object)this.service, (Object)crpcMethod.service)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.method, (Object)crpcMethod.method)) {
            return false;
        }
        return this.logLevel == crpcMethod.logLevel;
    }
}

