/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.AccountTypeSelectionModel;
import com.stripe.core.paymentcollection.AccountSelectionStatus;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionScreenInputStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.PresentAccountTypeSelectionEvent;
import com.stripe.core.paymentcollection.SelectAccountTypeEvent;
import com.stripe.core.paymentcollection.metrics.StageEventLogger;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.emv.AccountType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u001a\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/stripe/core/paymentcollection/AccountSelectionHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionScreenInputStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "generateAccountTypeSelectionEvent", "", "accountType", "Lcom/stripe/jvmcore/hardware/emv/AccountType;", "generateUserInteractionEvent", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "language", "", "onEnter", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onExit", "to", "onImplicitSelection", "data", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class AccountSelectionHandler
extends PaymentCollectionScreenInputStateHandler {
    public AccountSelectionHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.ACCOUNT_SELECTION, coroutineScope);
    }

    @Override
    public void onImplicitSelection(@NotNull PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.updateDataWithoutCallback(PaymentCollectionData.copy$default(data, null, null, null, null, false, 0, null, false, false, null, null, null, null, new AccountSelectionStatus.AccountSelected(null), null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -8193, 1048575, null));
        this.transitionTo(PaymentCollectionState.PROCESSING, "Account Type selected with unknown value");
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block2: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block2;
            PaymentCollectionData data = paymentCollectionData;
            boolean bl = false;
            this.getStageEventLogger().openAccountSelectionLog();
            if (data.getSelectedApplicationIndex() == null) {
                PaymentCollectionStatesKt.access$getLOGGER$p().e("Attempt to select language without prior application selection.", new Pair[0]);
                return;
            }
            if (data.getShouldAutoSelectAccount()) {
                this.transitionTo(PaymentCollectionState.PROCESSING, "Account Type selection not required.");
                return;
            }
            this.onPaymentCollectionDataUpdate(data, data);
        }
    }

    @Override
    public void onExit(@NotNull PaymentCollectionState to) {
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        super.onExit(to);
        StageEventLogger stageEventLogger = this.getStageEventLogger();
        Object d2 = this.getData();
        Intrinsics.checkNotNull(d2);
        stageEventLogger.closeAccountSelectionLog((PaymentCollectionData)d2, to);
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        if (this.transitionOnImplicitSelectionIfNeeded(paymentCollectionData)) {
            return;
        }
        AccountType accountType = paymentCollectionData.getSelectedAccount();
        if (accountType != null) {
            AccountType it = accountType;
            boolean bl = false;
            this.generateAccountTypeSelectionEvent(it);
            this.transitionTo(PaymentCollectionState.PROCESSING, "Account Type selected");
            return;
        }
        if (this.checkForPrematureTransactionCompletionAndTransitionIfNeeded(paymentCollectionData)) {
            return;
        }
        this.generateUserInteractionEvent(paymentCollectionData.getAmount(), paymentCollectionData.getSelectedLanguage());
    }

    private final void generateAccountTypeSelectionEvent(AccountType accountType) {
        this.yieldEvent(new SelectAccountTypeEvent(accountType));
    }

    private final void generateUserInteractionEvent(Amount amount, String language) {
        AccountType[] accountTypeArray = new AccountType[]{AccountType.CHECKING, AccountType.SAVINGS};
        AccountTypeSelectionModel model2 = new AccountTypeSelectionModel(SetsKt.linkedSetOf((Object[])accountTypeArray), amount, language);
        this.yieldEvent(new PresentAccountTypeSelectionEvent(model2));
    }
}

