/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.ApplicationSelectionModel;
import com.stripe.core.paymentcollection.AutoSelectApplicationEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionScreenInputStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.PresentApplicationSelectionEvent;
import com.stripe.core.paymentcollection.SelectApplicationEvent;
import com.stripe.core.paymentcollection.metrics.StageEventLogger;
import com.stripe.jvmcore.hardware.emv.TlvMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/stripe/core/paymentcollection/ApplicationSelectionHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionScreenInputStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "generateAutoSelectApplicationEvent", "", "generateSelectApplicationEvent", "index", "", "generateUserInteractionEvent", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "onEnter", "current", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onExit", "to", "onImplicitSelection", "onPaymentCollectionDataUpdate", "new", "old", "parseApplicationTlv", "Lcom/stripe/core/hardware/paymentcollection/ApplicationSelectionModel$Application;", "blob", "", "Companion", "paymentcollection_release"})
@SourceDebugExtension(value={"SMAP\nPaymentCollectionStates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentCollectionStates.kt\ncom/stripe/core/paymentcollection/ApplicationSelectionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2480:1\n1603#2,9:2481\n1855#2:2490\n1856#2:2492\n1612#2:2493\n1#3:2491\n*S KotlinDebug\n*F\n+ 1 PaymentCollectionStates.kt\ncom/stripe/core/paymentcollection/ApplicationSelectionHandler\n*L\n1402#1:2481,9\n1402#1:2490\n1402#1:2492\n1402#1:2493\n1402#1:2491\n*E\n"})
public final class ApplicationSelectionHandler
extends PaymentCollectionScreenInputStateHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int UNKNOWN_SELECTED_APPLICATION_INDEX = -1;
    private static final int AUTO_SELECTED_APPLICATION_INDEX = 0;

    public ApplicationSelectionHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.APPLICATION_SELECTION, coroutineScope);
    }

    @Override
    public void onImplicitSelection(@NotNull PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.updateDataWithoutCallback(PaymentCollectionData.copy$default(data, null, null, null, null, false, 0, null, false, false, null, null, -1, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -2049, 1048575, null));
        this.transitionTo(PaymentCollectionState.PROCESSING, "Application selected with unknown value.");
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block1: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData data = paymentCollectionData;
            boolean bl = false;
            this.getStageEventLogger().openApplicationSelectionLog();
            if (data.getShouldAutoSelectApplication()) {
                this.generateAutoSelectApplicationEvent();
            }
            this.onPaymentCollectionDataUpdate(data, data);
        }
    }

    @Override
    public void onExit(@NotNull PaymentCollectionState to) {
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        super.onExit(to);
        StageEventLogger stageEventLogger = this.getStageEventLogger();
        Object d2 = this.getData();
        Intrinsics.checkNotNull(d2);
        stageEventLogger.closeApplicationSelectionLog((PaymentCollectionData)d2, to);
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        if (this.transitionOnImplicitSelectionIfNeeded(paymentCollectionData)) {
            return;
        }
        Integer n2 = paymentCollectionData.getSelectedApplicationIndex();
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            this.generateSelectApplicationEvent(it);
            this.transitionTo(PaymentCollectionState.LANGUAGE_SELECTION, "Application index recorded.");
            return;
        }
        if (this.checkForPrematureTransactionCompletionAndTransitionIfNeeded(paymentCollectionData)) {
            return;
        }
        if (!paymentCollectionData.getShouldAutoSelectApplication()) {
            this.generateUserInteractionEvent(paymentCollectionData);
        }
    }

    private final void generateSelectApplicationEvent(int index) {
        this.yieldEvent(new SelectApplicationEvent(index));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateUserInteractionEvent(PaymentCollectionData data) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = data.getApplicationList();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ApplicationSelectionModel.Application it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.parseApplicationTlv(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List applications = (List)destination$iv$iv;
        if (((Collection)applications).size() == ((Collection)data.getApplicationList()).size()) {
            ApplicationSelectionModel applicationSelectionModel = new ApplicationSelectionModel(applications, data.getAmount());
            this.yieldEvent(new PresentApplicationSelectionEvent(applicationSelectionModel));
        }
    }

    private final void generateAutoSelectApplicationEvent() {
        this.yieldEvent(new AutoSelectApplicationEvent(0));
    }

    private final ApplicationSelectionModel.Application parseApplicationTlv(String blob) {
        TlvMap tlvMap = TlvMap.Companion.toTlvMap(blob);
        if (tlvMap == null) {
            ApplicationSelectionHandler $this$parseApplicationTlv_u24lambda_u243 = this;
            boolean bl = false;
            PaymentCollectionStatesKt.access$getLOGGER$p().w("Unable to parse TLV blob received in application selection", new Pair[0]);
            return null;
        }
        TlvMap map2 = tlvMap;
        return new ApplicationSelectionModel.Application(map2.getApplicationName(), map2.getDedicatedFileName(), blob);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/core/paymentcollection/ApplicationSelectionHandler$Companion;", "", "()V", "AUTO_SELECTED_APPLICATION_INDEX", "", "UNKNOWN_SELECTED_APPLICATION_INDEX", "paymentcollection_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

