/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.paymentcollection.AccountSelectionStatus;
import com.stripe.core.paymentcollection.CollectionCancelledEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.StopReaderEvent;
import com.stripe.core.statemachine.StateMachine;
import com.stripe.jvmcore.hardware.emv.CancellationPhase;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/stripe/core/paymentcollection/CancelHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "onEnter", "", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class CancelHandler
extends PaymentCollectionStateHandler {
    public CancelHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.CANCEL, coroutineScope, 30000L);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block0: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateDataWithoutCallback(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, from, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -1, 1048574, null));
            this.onPaymentCollectionDataUpdate(it, it);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        if (paymentCollectionData.getKernelConfirmedCancel() || paymentCollectionData.getHardwareTransactionResult() != null) {
            this.yieldEvent(CollectionCancelledEvent.INSTANCE);
            this.getStageEventLogger().onCancel(paymentCollectionData);
            if (paymentCollectionData.getCardSlotState() == ContactCardSlotState.EMPTY) {
                this.transitionTo(PaymentCollectionState.FINISHED, "Transaction cancelled.");
                return;
            }
            StateMachine.StateHandler.transitionTo$default(this, (Object)PaymentCollectionState.COLLECTION_COMPLETE, null, 2, null);
            return;
        }
        if (paymentCollectionData.getOnlineAuthorizationData() != null) {
            PaymentCollectionData paymentCollectionData2 = old;
            if ((paymentCollectionData2 != null ? paymentCollectionData2.getOnlineAuthorizationData() : null) == null) {
                PaymentCollectionStatesKt.access$getLOGGER$p().d("online request after a cancel, calling StopReaderEvent", new Pair[0]);
                this.yieldEvent(new StopReaderEvent(CancellationPhase.AUTH));
                return;
            }
        }
        if (paymentCollectionData.getPinEntryStatus() == PinEntryStatus.REQUESTED) {
            PaymentCollectionData paymentCollectionData3 = old;
            if ((paymentCollectionData3 != null ? paymentCollectionData3.getPinEntryStatus() : null) == PinEntryStatus.NOT_REQUESTED) {
                PaymentCollectionStatesKt.access$getLOGGER$p().d("pin entry request after a cancel, calling StopReaderEvent", new Pair[0]);
                this.yieldEvent(new StopReaderEvent(CancellationPhase.PIN));
                return;
            }
        }
        if (Intrinsics.areEqual((Object)paymentCollectionData.getAccountSelectionStatus(), (Object)AccountSelectionStatus.Requested.INSTANCE)) {
            PaymentCollectionData paymentCollectionData4 = old;
            if (Intrinsics.areEqual((Object)(paymentCollectionData4 != null ? paymentCollectionData4.getAccountSelectionStatus() : null), (Object)AccountSelectionStatus.NotRequested.INSTANCE)) {
                PaymentCollectionStatesKt.access$getLOGGER$p().d("account selection request after a cancel, calling StopReaderEvent", new Pair[0]);
                this.yieldEvent(new StopReaderEvent(CancellationPhase.ACCOUNT_TYPE_SELECTION));
                return;
            }
        }
        if (!((Collection)paymentCollectionData.getApplicationList()).isEmpty()) {
            Object object = old;
            boolean bl = object != null && (object = ((PaymentCollectionData)object).getApplicationList()) != null ? object.isEmpty() : false;
            if (bl) {
                PaymentCollectionStatesKt.access$getLOGGER$p().d("app selection request after a cancel, calling StopReaderEvent", new Pair[0]);
                this.yieldEvent(new StopReaderEvent(CancellationPhase.APPLICATION_SELECTION));
                return;
            }
        }
        if (paymentCollectionData.getEarlyTransactionAbortReason() != null) return;
        this.generateStopReaderEvent();
    }
}

