/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.CollectionModel;
import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.hardware.paymentcollection.RecoverableError;
import com.stripe.core.paymentcollection.AcknowledgeInterfaceResetEvent;
import com.stripe.core.paymentcollection.ClearMagStripeStateEvent;
import com.stripe.core.paymentcollection.ConfigureReaderEvent;
import com.stripe.core.paymentcollection.MagStripePinStatus;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionStateMachineKt;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.PresentPaymentMethodEvent;
import com.stripe.core.paymentcollection.RequestPinEntryEvent;
import com.stripe.core.paymentcollection.TippingState;
import com.stripe.core.paymentcollection.UtilsKt;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.currency.AmountKt;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadFailure;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadSuccess;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0006H\u0002J\b\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u001a\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/stripe/core/paymentcollection/CollectionHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "clearLastCollectionResultEvent", "", "clearNumberOfFailedInsertionsEvent", "()Lkotlin/Unit;", "generateAcknowledgeInterfaceResetEvent", "generateClearMagStripeDataEvent", "generateCollectionModel", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "generateConfigureReaderEvent", "generateUserInteractionEvent", "incrementNumberOfFailedInsertionsEvent", "isAuthorizationDataCollected", "", "isSuitableMagStripeDataAvailable", "onEnter", "current", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onExit", "to", "onPaymentCollectionDataUpdate", "new", "old", "Companion", "paymentcollection_release"})
public final class CollectionHandler
extends PaymentCollectionStateHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int TECHNICAL_FALLBACK_FAILED_INSERTION_THRESHOLD = 3;

    public CollectionHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.COLLECTION, coroutineScope, null, 4, null);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block1: {
            boolean isScaResume;
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData data = paymentCollectionData;
            boolean bl = false;
            boolean bl2 = isScaResume = data.getTransactionType() == com.stripe.core.hardware.paymentcollection.TransactionType.STRONG_CUSTOMER_AUTHENTICATION && data.getEmvTransactionType() == TransactionType.TRADITIONAL && from == PaymentCollectionState.ONLINE_AUTHORIZATION;
            if (!isScaResume) {
                this.generateConfigureReaderEvent(data);
            }
            this.onPaymentCollectionDataUpdate(data, data);
        }
    }

    @Override
    public void onExit(@NotNull PaymentCollectionState to) {
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        super.onExit(to);
        this.getStageEventLogger().closeWaitForCardPresentLog((PaymentCollectionData)this.getData());
        Object d2 = this.getData();
        Intrinsics.checkNotNull(d2);
        if (!this.isSuitableMagStripeDataAvailable((PaymentCollectionData)d2)) {
            this.generateClearMagStripeDataEvent();
        }
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        if (!(paymentCollectionData != null ? paymentCollectionData.getBadCardRead() : false)) {
            Object d3 = this.getData();
            Intrinsics.checkNotNull(d3);
            if (!this.isSuitableMagStripeDataAvailable((PaymentCollectionData)d3)) {
                this.clearNumberOfFailedInsertionsEvent();
            }
        }
        Object d4 = this.getData();
        Intrinsics.checkNotNull(d4);
        if (!this.isSuitableMagStripeDataAvailable((PaymentCollectionData)d4) && to != PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN) {
            this.clearLastCollectionResultEvent();
        }
        if (to == PaymentCollectionState.TIPPING_SELECTION) {
            this.generateStopReaderEvent();
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        if (this.startCollectionIfNeeded(paymentCollectionData)) {
            return;
        }
        boolean isAuthorizationDataCollected = this.isAuthorizationDataCollected(paymentCollectionData);
        boolean isCardInsertedCorrectly = paymentCollectionData.getCardSlotState() == ContactCardSlotState.CARD_INSERTED_CORRECTLY;
        boolean hasTransactionError = paymentCollectionData.getBadCardRead() || paymentCollectionData.isDeclined() || paymentCollectionData.getHardwareTransactionResult() == TransactionResult.Result.CHECK_MOBILE_DEVICE || paymentCollectionData.getHardwareTransactionResult() == TransactionResult.Result.CONTACTLESS_LIMIT_EXCEEDED || paymentCollectionData.getHardwareTransactionResult() == TransactionResult.Result.INSERT_OR_SWIPE_REQUIRED || paymentCollectionData.getHardwareTransactionResult() == TransactionResult.Result.MULTIPLE_CARDS_DETECTED || paymentCollectionData.getHardwareTransactionResult() == TransactionResult.Result.EMPTY_CANDIDATE_LIST || paymentCollectionData.getHardwareTransactionResult() == TransactionResult.Result.TERMINATED || paymentCollectionData.getHardwareTransactionResult() == TransactionResult.Result.CARD_STILL_INSERTED;
        boolean isMagStripePinNeeded = Intrinsics.areEqual((Object)paymentCollectionData.getMagStripePinStatus(), (Object)MagStripePinStatus.ToCollect.INSTANCE);
        boolean isSuitableMagStripeDataAvailable = this.isSuitableMagStripeDataAvailable(paymentCollectionData);
        boolean isFatalError = PaymentCollectionStateMachineKt.isFatalError(paymentCollectionData.getHardwareTransactionResult());
        boolean isPinEntryRequested = paymentCollectionData.getPinEntryStatus() == PinEntryStatus.REQUESTED;
        if (isFatalError) {
            this.transitionTo(PaymentCollectionState.FINISHED, "Fatal error, abort.");
        } else if (isAuthorizationDataCollected) {
            this.transitionTo(PaymentCollectionState.PROCESSING, "Contactless card presented.");
        } else if (isSuitableMagStripeDataAvailable) {
            if (isMagStripePinNeeded) {
                this.yieldEvent(RequestPinEntryEvent.INSTANCE);
            }
            this.transitionTo(PaymentCollectionState.PROCESSING, "Magnetic stripe read.");
        } else if (hasTransactionError) {
            if (paymentCollectionData.getBadCardRead()) {
                PaymentCollectionStatesKt.access$getLOGGER$p().i("badCardRead", new Pair[0]);
                this.incrementNumberOfFailedInsertionsEvent();
            }
            this.transitionTo(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, "Error in collection. Prepare to collect again.");
        } else {
            PaymentCollectionData paymentCollectionData2 = old;
            boolean bl = paymentCollectionData2 != null ? !paymentCollectionData2.getShowThankYouReceived() : false;
            if (bl && paymentCollectionData.getShowThankYouReceived()) {
                this.transitionTo(PaymentCollectionState.RECOVERABLE_ERROR_SUMMARY, "Received Thank You event. Attempt recovery");
            } else if (isCardInsertedCorrectly) {
                this.transitionTo(PaymentCollectionState.PROCESSING, "Card inserted.");
            } else if (isPinEntryRequested) {
                this.transitionTo(PaymentCollectionState.PROCESSING, "Collect card PIN.");
            } else {
                if (paymentCollectionData.getInterfaceResetRequired()) {
                    this.generateAcknowledgeInterfaceResetEvent();
                    this.generateConfigureReaderEvent(paymentCollectionData);
                }
                this.generateUserInteractionEvent(paymentCollectionData);
            }
        }
    }

    private final Unit incrementNumberOfFailedInsertionsEvent() {
        Unit unit;
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        if (paymentCollectionData != null) {
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateDataWithoutCallback(PaymentCollectionData.copy$default(it, null, null, null, null, false, it.getNumberOfFailedInsertions() + 1, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -33, 1048575, null));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void generateUserInteractionEvent(PaymentCollectionData data) {
        if (!data.getConfirmedCollection() && data.getCartToDisplay() != null) {
            this.generateDisplayCartEvent(data);
        } else {
            this.generateCollectionModel(data);
        }
    }

    private final void generateCollectionModel(PaymentCollectionData data) {
        RecoverableError callToAction = data.getCardSlotState() == ContactCardSlotState.CARD_INSERTED_INCORRECTLY ? RecoverableError.CHIP_CARD_INSERTED_INCORRECTLY : (data.getMagStripeReadResult() instanceof MagStripeReadFailure ? RecoverableError.Companion.fromMagStripeReadFailure(((MagStripeReadFailure)data.getMagStripeReadResult()).getFailureType()) : (data.getMagStripeReadResult() instanceof MagStripeReadSuccess && ((MagStripeReadSuccess)data.getMagStripeReadResult()).getIccCapable() ? RecoverableError.CHIP_CARD_SWIPED : (data.getTransactionType() == com.stripe.core.hardware.paymentcollection.TransactionType.STRONG_CUSTOMER_AUTHENTICATION ? RecoverableError.CHIP_CARD_MUST_BE_INSERTED_FOR_SCA : (data.getIntermediateTransactionError() != null ? RecoverableError.Companion.fromIntermediateTransactionError(data.getIntermediateTransactionError()) : null))));
        EnumSet<ReaderConfiguration.ReaderType> activeInterfacesForDisplay = EnumSet.copyOf(data.getActiveReaderInterfacesForDisplay());
        if (callToAction == RecoverableError.CHIP_CARD_SWIPED) {
            activeInterfacesForDisplay.remove((Object)ReaderConfiguration.ReaderType.MAGSTRIPE);
        } else if (callToAction == RecoverableError.CONTACTLESS_LIMIT_EXCEEDED) {
            activeInterfacesForDisplay.remove((Object)ReaderConfiguration.ReaderType.NFC);
        } else if (callToAction == RecoverableError.CHIP_CARD_MUST_BE_INSERTED_FOR_SCA) {
            activeInterfacesForDisplay = ReaderConfiguration.Companion.getINSERT();
        }
        com.stripe.core.hardware.paymentcollection.TransactionType transactionType = data.getTransactionType();
        Amount amount = data.getAmount();
        EnumSet<ReaderConfiguration.ReaderType> enumSet = activeInterfacesForDisplay;
        ContactCardSlotState contactCardSlotState = data.getCardSlotState();
        boolean bl = data.getTippingState() instanceof TippingState.Completed;
        Amount amount2 = data.getBaseAmount();
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"activeInterfacesForDisplay");
        CollectionModel collectionModel = new CollectionModel(transactionType, amount, amount2, callToAction, enumSet, contactCardSlotState, bl);
        this.yieldEvent(new PresentPaymentMethodEvent(collectionModel));
    }

    private final void generateConfigureReaderEvent(PaymentCollectionData data) {
        Amount amount = data.getEmvTransactionType() == TransactionType.QUICK && data.getTransactionType() == com.stripe.core.hardware.paymentcollection.TransactionType.CHARGE && data.getAmount().getValue() == 0L ? AmountKt.getQUICK_EMV_AMOUNT() : data.getAmount();
        ReaderConfiguration readerConfiguration = UtilsKt.generateConfigureReaderEvent(data.getDesiredReaderInterfaces(), amount, data.getTransactionType(), data.getEmvTransactionType(), data.isOffline(), data.isDeferredAuthorizationCountry(), data.getDeviceType(), data.getDomesticDebitPriority(), data.getDomesticDebitAids());
        this.yieldEvent(new ConfigureReaderEvent(readerConfiguration));
    }

    private final boolean isSuitableMagStripeDataAvailable(PaymentCollectionData data) {
        return data.getMagStripePaymentCollectionAuthority() != null;
    }

    private final boolean isAuthorizationDataCollected(PaymentCollectionData data) {
        CharSequence charSequence = data.getOnlineAuthorizationData();
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final Unit clearNumberOfFailedInsertionsEvent() {
        Unit unit;
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        if (paymentCollectionData != null) {
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateDataWithoutCallback(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -33, 1048575, null));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void generateClearMagStripeDataEvent() {
        this.yieldEvent(ClearMagStripeStateEvent.INSTANCE);
    }

    private final void clearLastCollectionResultEvent() {
        block1: {
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData data = paymentCollectionData;
            boolean bl = false;
            if (data.getLastCollectionResult() != null || data.getIntermediateTransactionError() != null) {
                this.updateDataWithoutCallback(PaymentCollectionData.copy$default(data, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -1610612737, 1048575, null));
            }
        }
    }

    private final void generateAcknowledgeInterfaceResetEvent() {
        this.yieldEvent(AcknowledgeInterfaceResetEvent.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/paymentcollection/CollectionHandler$Companion;", "", "()V", "TECHNICAL_FALLBACK_FAILED_INSERTION_THRESHOLD", "", "paymentcollection_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

