/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.CollectionCompletedModel;
import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.hardware.paymentcollection.PaymentCollectionResultType;
import com.stripe.core.paymentcollection.CardStateUpdateEvent;
import com.stripe.core.paymentcollection.CollectionCompleteEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.statemachine.StateMachine;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/stripe/core/paymentcollection/FinishedHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "generateCollectionCompleteEvent", "", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "onEnter", "current", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "paymentcollection_release"})
public final class FinishedHandler
extends PaymentCollectionStateHandler {
    public FinishedHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.FINISHED, coroutineScope, null, 4, null);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block0: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData data = paymentCollectionData;
            boolean bl = false;
            this.getCollectionEventLogger().end(data, (PaymentCollectionState)((Object)this.getState()));
            this.generateCollectionCompleteEvent(data);
        }
    }

    private final void generateCollectionCompleteEvent(PaymentCollectionData data) {
        PaymentCollectionResultType collectionResult = data.getCollectionResultType();
        if (collectionResult == PaymentCollectionResultType.NOT_FINISHED) {
            PaymentCollectionStatesKt.access$getLOGGER$p().e("Finished but can't decide the result.", new Pair[0]);
        }
        if (!data.isCollectionEndedWithFailure() && !data.getConfirmedCollection()) {
            StateMachine.StateHandler.transitionTo$default(this, (Object)PaymentCollectionState.DISPLAY_CART_POST_COLLECTION, null, 2, null);
        } else {
            if (data.getCardSlotState() != ContactCardSlotState.EMPTY) {
                PaymentCollectionStatesKt.access$getLOGGER$p().e("Update card slot to EMPTY. Transaction is likely failed with device failure or timed out.", new Pair[0]);
                this.yieldEvent(new CardStateUpdateEvent(ContactCardSlotState.EMPTY));
            }
            this.yieldEvent(new CollectionCompleteEvent(new CollectionCompletedModel(collectionResult, data.getAmount())));
        }
    }
}

